/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.project;

import com.goide.i18n.GoBundle;
import com.goide.vgo.project.VgoDependency;
import com.goide.vgo.project.VgoDependencyImpl;
import com.goide.vgo.project.VgoLibraryRootsProvider;
import com.goide.vgo.project.VgoModule;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.NodeSortOrder;
import com.intellij.ide.projectView.NodeSortSettings;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.SyntheticLibraryElementNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VgoTreeStructureProvider
implements TreeStructureProvider {
    @NotNull
    public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<AbstractTreeNode<?>> children, ViewSettings settings) {
        if (parent == null) {
            VgoTreeStructureProvider.$$$reportNull$$$0(0);
        }
        if (children == null) {
            VgoTreeStructureProvider.$$$reportNull$$$0(1);
        }
        if (parent instanceof SyntheticLibraryElementNode && parent.getValue() instanceof VgoLibraryRootsProvider.VgoDependenciesLibrary) {
            Map<VirtualFile, VgoDependency> dependencies2 = ((VgoLibraryRootsProvider.VgoDependenciesLibrary)((Object)parent.getValue())).getDependencies();
            Project project = parent.getProject();
            if (project == null) {
                Collection<AbstractTreeNode<?>> collection = children;
                if (collection == null) {
                    VgoTreeStructureProvider.$$$reportNull$$$0(2);
                }
                return collection;
            }
            List wrappedChildren = ContainerUtil.map(children, child -> {
                PsiDirectory directory = (PsiDirectory)ObjectUtils.doIfCast((Object)child, PsiDirectoryNode.class, AbstractTreeNode::getValue);
                VgoDependency dependency = directory != null ? (VgoDependency)dependencies2.get(directory.getVirtualFile()) : null;
                return dependency != null ? new VgoDependencyNode(project, directory, dependency, settings) : child;
            });
            SmartList workspaceModuleNodes = new SmartList();
            if (parent.getValue() instanceof VgoLibraryRootsProvider.VgoWorkspaceDependenciesLibrary) {
                for (VgoModule module : ((VgoLibraryRootsProvider.VgoWorkspaceDependenciesLibrary)((Object)parent.getValue())).getMainModules()) {
                    PsiDirectory rootDirectory;
                    VirtualFile moduleRoot = module.getRoot();
                    if (!moduleRoot.isValid() || (rootDirectory = PsiManager.getInstance((Project)project).findDirectory(moduleRoot)) == null) continue;
                    workspaceModuleNodes.add(new VgoWorkspaceModuleNode(project, rootDirectory, module.getImportPath(), settings));
                }
            }
            List list = ContainerUtil.concat((List)wrappedChildren, (List)workspaceModuleNodes);
            if (list == null) {
                VgoTreeStructureProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        Collection<AbstractTreeNode<?>> collection = children;
        if (collection == null) {
            VgoTreeStructureProvider.$$$reportNull$$$0(4);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/vgo/project/VgoTreeStructureProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/vgo/project/VgoTreeStructureProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "modify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    private static class VgoWorkspaceModuleNode
    extends BasePsiNode<PsiDirectory> {
        @NotNull
        private final String myModuleName;

        VgoWorkspaceModuleNode(Project project, @NotNull PsiDirectory value2, @NotNull String moduleName, ViewSettings viewSettings) {
            if (value2 == null) {
                VgoWorkspaceModuleNode.$$$reportNull$$$0(0);
            }
            if (moduleName == null) {
                VgoWorkspaceModuleNode.$$$reportNull$$$0(1);
            }
            super(project, (PsiElement)value2, viewSettings);
            this.myModuleName = moduleName;
        }

        @Nullable
        protected Collection<AbstractTreeNode<?>> getChildrenImpl() {
            return null;
        }

        protected void updateImpl(@NotNull PresentationData data) {
            if (data == null) {
                VgoWorkspaceModuleNode.$$$reportNull$$$0(2);
            }
            data.setIcon(AllIcons.Nodes.PpLib);
            data.setPresentableText("Go Module <" + this.myModuleName + ">");
        }

        @NotNull
        public NodeSortOrder getSortOrder(@NotNull NodeSortSettings settings) {
            if (settings == null) {
                VgoWorkspaceModuleNode.$$$reportNull$$$0(3);
            }
            NodeSortOrder nodeSortOrder = NodeSortOrder.MODULE_ROOT;
            if (nodeSortOrder == null) {
                VgoWorkspaceModuleNode.$$$reportNull$$$0(4);
            }
            return nodeSortOrder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/vgo/project/VgoTreeStructureProvider$VgoWorkspaceModuleNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/vgo/project/VgoTreeStructureProvider$VgoWorkspaceModuleNode";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSortOrder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "updateImpl";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getSortOrder";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class VgoDependencyNode
    extends PsiDirectoryNode {
        @NotNull
        private final VgoDependency myDependency;

        VgoDependencyNode(Project project, @NotNull PsiDirectory directory, @NotNull VgoDependency dependency, ViewSettings settings) {
            if (directory == null) {
                VgoDependencyNode.$$$reportNull$$$0(0);
            }
            if (dependency == null) {
                VgoDependencyNode.$$$reportNull$$$0(1);
            }
            super(project, directory, settings);
            this.myDependency = dependency;
        }

        protected void updateImpl(@NotNull PresentationData data) {
            VgoDependencyImpl replace;
            if (data == null) {
                VgoDependencyNode.$$$reportNull$$$0(2);
            }
            super.updateImpl(data);
            data.setPresentableText(this.myDependency.getImportPath());
            VgoDependencyImpl dependency = (VgoDependencyImpl)ObjectUtils.tryCast((Object)this.myDependency, VgoDependencyImpl.class);
            VgoDependencyImpl vgoDependencyImpl = replace = dependency != null ? dependency.getReplace() : null;
            if (replace == null) {
                data.setLocationString(this.myDependency.getVersion());
                return;
            }
            String originalVersion = dependency.getOriginalVersion();
            String replacedVersion = replace.getOriginalVersion();
            StringBuilder suffix = new StringBuilder();
            if (StringUtil.isNotEmpty((String)originalVersion) && StringUtil.isNotEmpty((String)replacedVersion) && !originalVersion.equals(replacedVersion)) {
                suffix.append(originalVersion).append(" => ").append(replacedVersion).append(" ");
            } else if (StringUtil.isNotEmpty((String)originalVersion)) {
                suffix.append(originalVersion).append(" ");
            }
            suffix.append(GoBundle.message((String)"go.modules.tree.structure.replaced", (Object[])new Object[0]));
            data.setLocationString(suffix.toString());
            StringBuilder tooltip = new StringBuilder(replace.getImportPath());
            if (!tooltip.isEmpty()) {
                if (StringUtil.isNotEmpty((String)replacedVersion)) {
                    tooltip.append(" ").append(replacedVersion);
                }
                data.setTooltip(GoBundle.message((String)"go.modules.tree.structure.replacement", (Object[])new Object[]{tooltip.toString()}));
            }
        }

        public String getTestPresentation() {
            return this.getPresentation().getPresentableText() + " " + this.getPresentation().getLocationString() + " " + this.getPresentation().getTooltip();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependency";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            objectArray2[1] = "com/goide/vgo/project/VgoTreeStructureProvider$VgoDependencyNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateImpl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

