/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.sdk;

import com.goide.playground.GoPlaygroundRunOption;
import com.goide.playground.ui.GoPlaygroundFileEditorWithPreview;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkVersion;
import com.goide.sdk.GoTargetSdkVersionProvider;
import com.goide.util.GoUtil;
import com.goide.vgo.VgoUtil;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.goide.vgo.mod.psi.VgoFile;
import com.goide.vgo.project.VgoModule;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/goide/vgo/sdk/VgoTargetSdkVersionProvider;", "Lcom/goide/sdk/GoTargetSdkVersionProvider;", "<init>", "()V", "isApplicable", "", "file", "Lcom/intellij/psi/PsiFile;", "getTargetSdkVersion", "", "intellij.go.impl"})
public final class VgoTargetSdkVersionProvider
implements GoTargetSdkVersionProvider {
    @Override
    public boolean isApplicable(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!VgoProjectSettings.getInstance(file.getProject()).isIntegrationEnabled()) {
            return false;
        }
        if (ScratchUtil.isScratch((VirtualFile)file.getVirtualFile())) {
            GoPlaygroundFileEditorWithPreview editor;
            FileEditorManager manager = FileEditorManager.getInstance((Project)file.getProject());
            FileEditor fileEditor = manager.getSelectedEditor();
            GoPlaygroundFileEditorWithPreview goPlaygroundFileEditorWithPreview = editor = fileEditor instanceof GoPlaygroundFileEditorWithPreview ? (GoPlaygroundFileEditorWithPreview)fileEditor : null;
            return (goPlaygroundFileEditorWithPreview != null ? goPlaygroundFileEditorWithPreview.getRunLocation() : null) == GoPlaygroundRunOption.LocalSDK;
        }
        return true;
    }

    @Override
    @Nullable
    public String getTargetSdkVersion(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null || (virtualFile = VirtualFileUtil.originalFileOrSelf((VirtualFile)virtualFile)) == null) {
            return null;
        }
        VirtualFile originalVirtualFile = virtualFile;
        Object object = VgoUtil.findModuleAndDependencyOfFile(project2, originalVirtualFile);
        if (object == null || (object = (VgoModule)((Pair.NonNull)object).first) == null) {
            return null;
        }
        Object vgoModule = object;
        VirtualFile virtualFile2 = ((VgoModule)vgoModule).getRoot().findChild("go.mod");
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile goModVirtualFile = virtualFile2;
        Object object2 = PsiManager.getInstance((Project)project2).findFile(goModVirtualFile);
        VgoFile vgoFile = object2 instanceof VgoFile ? (VgoFile)((Object)object2) : null;
        if (vgoFile == null) {
            return null;
        }
        VgoFile goMod = vgoFile;
        String version = goMod.getGoVersion();
        object2 = version;
        if (!(object2 == null || object2.length() == 0)) {
            return version;
        }
        GoSdkVersion goSdkVersion = GoSdkService.getInstance(project2).getSdk(GoUtil.module((PsiElement)file)).getMajorVersion();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)goSdkVersion), (String)"getMajorVersion(...)");
        GoSdkVersion sdkVersion = goSdkVersion;
        return sdkVersion.isAtLeast(GoSdkVersion.GO_1_17) ? "1.16" : sdkVersion.toString();
    }
}

