/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.database.marker;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.database.dataSource.DataSourceFun;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.go.database.marker.ConfigExistingDatasourceLineMarkerInfo;
import com.intellij.go.database.marker.ConfigNewDatasourceLineMarkerInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\n"}, d2={"createLineMarkerInfo", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "Lcom/intellij/psi/PsiElement;", "element", "driverId", "", "findDataSource", "Lcom/intellij/database/psi/DbDataSource;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.go.database"})
@SourceDebugExtension(value={"SMAP\nDatasourceLineMarkerInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatasourceLineMarkerInfo.kt\ncom/intellij/go/database/marker/DatasourceLineMarkerInfoKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public final class DatasourceLineMarkerInfoKt {
    @NotNull
    public static final LineMarkerInfo<PsiElement> createLineMarkerInfo(@NotNull PsiElement element, @NotNull String driverId) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)driverId, (String)"driverId");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DbDataSource dbDataSource = DatasourceLineMarkerInfoKt.findDataSource(project, driverId);
        if (dbDataSource != null) {
            DbDataSource dataSource = dbDataSource;
            boolean bl = false;
            return new ConfigExistingDatasourceLineMarkerInfo(element, dataSource);
        }
        return new ConfigNewDatasourceLineMarkerInfo(element, driverId);
    }

    private static final DbDataSource findDataSource(Project project, String driverId) {
        Object v2;
        block1: {
            List list = DbPsiFacade.getInstance((Project)project).getDataSources();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                DbDataSource dataSource = (DbDataSource)t;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)dataSource);
                LocalDataSource localDataSource = DataSourceFun.getLocalDataSource((DasDataSource)((DasDataSource)dataSource));
                if (!Intrinsics.areEqual((Object)(localDataSource != null && (localDataSource = localDataSource.getDatabaseDriver()) != null ? localDataSource.getId() : null), (Object)driverId)) continue;
                v2 = t;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }
}

