/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.debug;

import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.debug.KubectlDebugUtilsKt;
import com.intellij.kubernetes.debug.KubectlDebugWithCustomParamsActionKt;
import com.intellij.kubernetes.debug.KubectlDebugWithCustomParamsDialog;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObject;
import com.intellij.kubernetes.view.ui.actions.KubernetesModelBasedDumbAwareAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1Pod;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J*\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/kubernetes/debug/KubectlDebugWithCustomParamsAction;", "Lcom/intellij/kubernetes/view/ui/actions/KubernetesModelBasedDumbAwareAction;", "<init>", "()V", "update", "", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "showAttachCustomDialog", "project", "Lcom/intellij/openapi/project/Project;", "selectedPod", "Lio/kubernetes/client/openapi/models/V1Pod;", "selectedContainer", "Lio/kubernetes/client/openapi/models/V1Container;", "intellij.clouds.kubernetes.backend"})
public final class KubectlDebugWithCustomParamsAction
extends KubernetesModelBasedDumbAwareAction {
    protected void update(@NotNull KubernetesApiModelInterface apiModel2, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!KubectlDebugUtilsKt.isKubectlDebugSupportEnabled()) {
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Pair<V1Pod, KubernetesContainerObject> pair = KubectlDebugUtilsKt.getSelectedPodAndContainer(event);
        V1Pod selectedPod2 = (V1Pod)pair.component1();
        KubernetesContainerObject selectedContainer = (KubernetesContainerObject)pair.component2();
        event.getPresentation().setVisible(selectedPod2 != null && selectedContainer == null || selectedPod2 != null && selectedContainer != null && !KubectlDebugUtilsKt.isEphemeral(selectedContainer));
    }

    protected void actionPerformed(@NotNull KubernetesApiModelInterface apiModel2, @NotNull AnActionEvent event) {
        V1Container v1Container;
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Pair<V1Pod, KubernetesContainerObject> pair = KubectlDebugUtilsKt.getSelectedPodAndContainer(event);
        V1Pod selectedPod2 = (V1Pod)pair.component1();
        KubernetesContainerObject selectedContainer = (KubernetesContainerObject)pair.component2();
        if (selectedPod2 == null) {
            KubectlDebugWithCustomParamsActionKt.access$getLOG$p().error("Pod is not presented in the dataContext");
            return;
        }
        if (selectedContainer != null) {
            v1Container = selectedContainer.getContainerSpec();
            if (v1Container == null) {
                KubectlDebugWithCustomParamsAction $this$actionPerformed_u24lambda_u240 = this;
                boolean bl = false;
                KubectlDebugWithCustomParamsActionKt.access$getLOG$p().error("no V1Container object in the selected KubernetesContainerObject: " + selectedContainer);
                return;
            }
        } else {
            v1Container = null;
        }
        V1Container container = v1Container;
        this.showAttachCustomDialog(project2, apiModel2, selectedPod2, container);
    }

    private final void showAttachCustomDialog(Project project, KubernetesApiModelInterface apiModel2, V1Pod selectedPod2, V1Container selectedContainer) {
        KubectlDebugWithCustomParamsDialog dialog2 = new KubectlDebugWithCustomParamsDialog(project, apiModel2, selectedPod2, selectedContainer);
        dialog2.show();
    }
}

