/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.install;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.api.settings.KubernetesApiGlobalSettings;
import com.intellij.kubernetes.api.settings.KubernetesApiGlobalSettingsKt;
import com.intellij.kubernetes.helm.install.HelmDistributionUtilsKt;
import com.intellij.kubernetes.install.BinaryInstaller;
import com.intellij.kubernetes.install.InstallationResult;
import com.intellij.kubernetes.install.SuccessfulInstallation;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.NioPathUtil;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a2\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u001a\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\b\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"installHelm", "", "project", "Lcom/intellij/openapi/project/Project;", "resultHandler", "Lkotlin/Function1;", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "clearHelmPathIfNotInstalled", "installedPath", "Ljava/nio/file/Path;", "getBinaryName", "", "intellij.clouds.kubernetes.backend"})
public final class InstallHelmActionKt {
    public static final void installHelm(@NotNull Project project, @NotNull Function1<? super Boolean, Unit> resultHandler, @Nullable ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        KubernetesUsageTriggerCollector.INSTANCE.getACTION_TRIGGERED_EVENT().log(project, (Object)"install-kubectl");
        Pair<String, String> pair = HelmDistributionUtilsKt.getHelmDownloadUrlAndChecksum();
        if (pair == null) {
            return;
        }
        Pair<String, String> pair2 = pair;
        String downloadUrl = (String)pair2.component1();
        String checksum = (String)pair2.component2();
        BinaryInstaller.Companion.create(project).withBinaryName((Function0<String>)((Function0)InstallHelmActionKt::installHelm$lambda$1)).withDownloadUrl((Function1<? super BinaryInstaller.Configuration, String>)((Function1)arg_0 -> InstallHelmActionKt.installHelm$lambda$2(downloadUrl, arg_0))).withChecksum((Function1<? super BinaryInstaller.Configuration, String>)((Function1)arg_0 -> InstallHelmActionKt.installHelm$lambda$3(checksum, arg_0))).withFileToVerifyFilter((Function1<? super BinaryInstaller.Configuration, ? extends Function1<? super Path, Boolean>>)((Function1)arg_0 -> InstallHelmActionKt.installHelm$lambda$5(downloadUrl, arg_0))).withProgressIndicator(progressIndicator).withResultHandler((Function1<? super InstallationResult, Unit>)((Function1)arg_0 -> InstallHelmActionKt.installHelm$lambda$6(resultHandler, arg_0))).install();
    }

    public static /* synthetic */ void installHelm$default(Project project, Function1 function1, ProgressIndicator progressIndicator, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = InstallHelmActionKt::installHelm$lambda$0;
        }
        if ((n & 4) != 0) {
            progressIndicator = null;
        }
        InstallHelmActionKt.installHelm(project, (Function1<? super Boolean, Unit>)function1, progressIndicator);
    }

    private static final void clearHelmPathIfNotInstalled(Path installedPath) {
        try {
            Path path;
            String string = KubernetesApiGlobalSettings.Companion.getInstance().getHelmPathString();
            if (!Intrinsics.areEqual(string != null && (path = NioPathUtil.toNioPathOrNull((String)string)) != null ? path.toAbsolutePath() : null, (Object)installedPath)) {
                KubernetesApiGlobalSettings.Companion.getInstance().setHelmPathString(null);
            }
        }
        catch (Exception exception) {
            KubernetesApiGlobalSettings.Companion.getInstance().setHelmPathString(null);
        }
    }

    private static final String getBinaryName() {
        return SystemInfoRt.isWindows ? "helm.exe" : "helm";
    }

    private static final Unit installHelm$lambda$0(boolean it) {
        return Unit.INSTANCE;
    }

    private static final String installHelm$lambda$1() {
        return InstallHelmActionKt.getBinaryName();
    }

    private static final String installHelm$lambda$2(String $downloadUrl, BinaryInstaller.Configuration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $downloadUrl;
    }

    private static final String installHelm$lambda$3(String $checksum, BinaryInstaller.Configuration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $checksum;
    }

    private static final boolean installHelm$lambda$5$lambda$4(String $downloadUrl, Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return Intrinsics.areEqual((Object)((Object)path.getFileName()).toString(), (Object)StringsKt.substringAfterLast$default((String)$downloadUrl, (char)'/', null, (int)2, null));
    }

    private static final Function1 installHelm$lambda$5(String $downloadUrl, BinaryInstaller.Configuration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return arg_0 -> InstallHelmActionKt.installHelm$lambda$5$lambda$4($downloadUrl, arg_0);
    }

    private static final Unit installHelm$lambda$6(Function1 $resultHandler, InstallationResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        if (result2 instanceof SuccessfulInstallation) {
            Path absolutePath = ((SuccessfulInstallation)result2).getBinary().toAbsolutePath();
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)propertiesComponent, (String)"getInstance(...)");
            KubernetesApiGlobalSettingsKt.setHelmPath((PropertiesComponent)propertiesComponent, (String)((Object)absolutePath).toString());
            Intrinsics.checkNotNull((Object)absolutePath);
            InstallHelmActionKt.clearHelmPathIfNotInstalled(absolutePath);
        }
        $resultHandler.invoke((Object)(result2 instanceof SuccessfulInstallation));
        return Unit.INSTANCE;
    }
}

