/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.model;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.kubernetes.MiscUtilKt;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.ChartManager;
import com.intellij.kubernetes.helm.model.DependenciesMetaClass;
import com.intellij.kubernetes.helm.model.DependenciesV1MetaClass;
import com.intellij.kubernetes.helm.model.spec.Definition;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/kubernetes/helm/model/DependenciesV1MetaClass;", "Lcom/intellij/kubernetes/helm/model/DependenciesMetaClass;", "def", "Lcom/intellij/kubernetes/helm/model/spec/Definition;", "<init>", "(Lcom/intellij/kubernetes/helm/model/spec/Definition;)V", "validateKey", "", "keyValue", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nHelmMetaClassDefinitions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmMetaClassDefinitions.kt\ncom/intellij/kubernetes/helm/model/DependenciesV1MetaClass\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,586:1\n30#2,2:587\n*S KotlinDebug\n*F\n+ 1 HelmMetaClassDefinitions.kt\ncom/intellij/kubernetes/helm/model/DependenciesV1MetaClass\n*L\n106#1:587,2\n*E\n"})
public final class DependenciesV1MetaClass
extends DependenciesMetaClass {
    public DependenciesV1MetaClass(@NotNull Definition def) {
        Intrinsics.checkNotNullParameter((Object)def, (String)"def");
        super(def);
    }

    public void validateKey(@NotNull YAMLKeyValue keyValue, @NotNull ProblemsHolder problemsHolder) {
        Intrinsics.checkNotNullParameter((Object)keyValue, (String)"keyValue");
        Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
        Project project = keyValue.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<ChartManager> serviceClass$iv = ChartManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        VirtualFile virtualFile = YamlUtilKt.getVfsFile((PsiElement)((PsiElement)keyValue));
        if (virtualFile == null) {
            return;
        }
        Chart chart = ((ChartManager)object).findChartByRelatedFile(virtualFile);
        if (chart == null) {
            return;
        }
        Chart chart2 = chart;
        if (!Intrinsics.areEqual((Object)chart2.getModel().getApiVersion(), (Object)"v1")) {
            PsiElement psiElement = keyValue.getKey();
            Intrinsics.checkNotNull((Object)psiElement);
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new IntentionAndQuickFixAction(){

                public String getName() {
                    String string = KubernetesBundle.message((String)"HelmChartUnknownValuesInspection.move.dependencies.to.chart.yaml.quickfix.name", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    return string;
                }

                public String getFamilyName() {
                    return this.getName();
                }

                public IntentionPreviewInfo generatePreview(Project project, Editor editor, PsiFile psiFile) {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                    IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
                    Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
                    return intentionPreviewInfo;
                }

                public void applyFix(Project project, PsiFile psiFile, Editor editor) {
                    block11: {
                        YAMLMapping targetTopLevelMapping;
                        VirtualFile virtualFile;
                        YAMLSequence dependencySequence;
                        YAMLMapping sourceDependenciesKeyVal;
                        YAMLFile reqYaml;
                        block10: {
                            block9: {
                                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                                ComponentManager $this$service$iv = (ComponentManager)project;
                                boolean $i$f$service = false;
                                Class<ChartManager> serviceClass$iv = ChartManager.class;
                                Object object = $this$service$iv.getService(serviceClass$iv);
                                if (object == null) {
                                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                                }
                                PsiFile psiFile2 = psiFile;
                                if (psiFile2 == null || (psiFile2 = YamlUtilKt.getVfsFile((PsiElement)((PsiElement)psiFile2))) == null) {
                                    return;
                                }
                                Chart chart = ((ChartManager)object).findChartByRelatedFile((VirtualFile)psiFile2);
                                if (chart == null) {
                                    return;
                                }
                                Chart actualChart = chart;
                                YAMLFile yAMLFile = psiFile instanceof YAMLFile ? (YAMLFile)psiFile : null;
                                if (yAMLFile == null) {
                                    return;
                                }
                                reqYaml = yAMLFile;
                                YAMLMapping yAMLMapping = YamlUtilKt.getTopLevelMapping((YAMLFile)reqYaml);
                                if (yAMLMapping == null || (yAMLMapping = YamlUtilKt.getKeyValueByKeyIgnoreSpaces((YAMLMapping)yAMLMapping, (String)"dependencies")) == null) {
                                    return;
                                }
                                sourceDependenciesKeyVal = yAMLMapping;
                                YAMLValue yAMLValue = sourceDependenciesKeyVal.getValue();
                                YAMLSequence yAMLSequence = yAMLValue instanceof YAMLSequence ? (YAMLSequence)yAMLValue : null;
                                if (yAMLSequence == null) {
                                    return;
                                }
                                dependencySequence = yAMLSequence;
                                virtualFile = actualChart.getChartFile();
                                if (virtualFile == null) break block9;
                                VirtualFile it = virtualFile;
                                boolean bl = false;
                                PsiFile psiFile3 = PsiManager.getInstance((Project)project).findFile(it);
                                YAMLFile yAMLFile2 = psiFile3 instanceof YAMLFile ? (YAMLFile)psiFile3 : null;
                                virtualFile = yAMLFile2;
                                if (yAMLFile2 != null) break block10;
                            }
                            return;
                        }
                        VirtualFile chartYaml = virtualFile;
                        YAMLMapping yAMLMapping = targetTopLevelMapping = YamlUtilKt.getTopLevelMapping((YAMLFile)chartYaml);
                        YAMLKeyValue targetDependenciesKeyVal = yAMLMapping != null ? YamlUtilKt.getKeyValueByKeyIgnoreSpaces((YAMLMapping)yAMLMapping, (String)"dependencies") : null;
                        YAMLElementGenerator generator = YAMLElementGenerator.getInstance((Project)project);
                        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
                        WriteCommandAction.writeCommandAction((Project)project).withName(this.getName()).compute(() -> validateKey.1.applyFix$lambda$8(codeStyleManager, targetDependenciesKeyVal, targetTopLevelMapping, (YAMLFile)chartYaml, dependencySequence, generator, (YAMLKeyValue)sourceDependenciesKeyVal, reqYaml));
                        YAMLMapping yAMLMapping2 = YamlUtilKt.getTopLevelMapping((YAMLFile)chartYaml);
                        if (yAMLMapping2 == null || (yAMLMapping2 = YamlUtilKt.getKeyValueByKeyIgnoreSpaces((YAMLMapping)yAMLMapping2, (String)"dependencies")) == null) break block11;
                        PsiElement p0 = (PsiElement)yAMLMapping2;
                        boolean bl = false;
                        MiscUtilKt.openInEditor((PsiElement)p0);
                    }
                }

                private static final void applyFix$addEolIfNeeded(PsiElement $this$applyFix_u24addEolIfNeeded, YAMLElementGenerator generator) {
                    PsiElement it = $this$applyFix_u24addEolIfNeeded.getLastChild();
                    boolean bl = false;
                    boolean bl2 = it != null && !Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)YAMLTokenTypes.EOL);
                    if (bl2) {
                        $this$applyFix_u24addEolIfNeeded.add(generator.createEol());
                    }
                }

                private static final PsiElement applyFix$lambda$8$lambda$5(YAMLKeyValue $targetDependenciesKeyVal, YAMLMapping $targetTopLevelMapping, YAMLFile $chartYaml, YAMLSequence $dependencySequence, YAMLElementGenerator $generator, YAMLKeyValue $sourceDependenciesKeyVal) {
                    PsiElement psiElement;
                    YAMLKeyValue yAMLKeyValue = $targetDependenciesKeyVal;
                    if (yAMLKeyValue != null) {
                        YAMLKeyValue $this$applyFix_u24lambda_u248_u24lambda_u245_u24lambda_u242 = yAMLKeyValue;
                        boolean bl = false;
                        validateKey.1.applyFix$addEolIfNeeded((PsiElement)$this$applyFix_u24lambda_u248_u24lambda_u245_u24lambda_u242, $generator);
                        psiElement = $this$applyFix_u24lambda_u248_u24lambda_u245_u24lambda_u242.add((PsiElement)$dependencySequence);
                    } else {
                        YAMLMapping yAMLMapping = $targetTopLevelMapping;
                        if (yAMLMapping != null) {
                            YAMLMapping $this$applyFix_u24lambda_u248_u24lambda_u245_u24lambda_u243 = yAMLMapping;
                            boolean bl = false;
                            validateKey.1.applyFix$addEolIfNeeded((PsiElement)$this$applyFix_u24lambda_u248_u24lambda_u245_u24lambda_u243, $generator);
                            psiElement = $this$applyFix_u24lambda_u248_u24lambda_u245_u24lambda_u243.add((PsiElement)$sourceDependenciesKeyVal);
                        } else {
                            YAMLDocument yAMLDocument;
                            List list = $chartYaml.getDocuments();
                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDocuments(...)");
                            YAMLDocument yAMLDocument2 = (YAMLDocument)CollectionsKt.firstOrNull((List)list);
                            if (yAMLDocument2 != null) {
                                YAMLDocument yAMLDocument3;
                                YAMLDocument $this$applyFix_u24lambda_u248_u24lambda_u245_u24lambda_u244 = yAMLDocument3 = yAMLDocument2;
                                boolean bl = false;
                                validateKey.1.applyFix$addEolIfNeeded((PsiElement)$this$applyFix_u24lambda_u248_u24lambda_u245_u24lambda_u244, $generator);
                                $this$applyFix_u24lambda_u248_u24lambda_u245_u24lambda_u244.add((PsiElement)$sourceDependenciesKeyVal);
                                yAMLDocument = yAMLDocument3;
                            } else {
                                yAMLDocument = null;
                            }
                            psiElement = (PsiElement)yAMLDocument;
                        }
                    }
                    return psiElement;
                }

                private static final PsiElement applyFix$lambda$8(CodeStyleManager $codeStyleManager, YAMLKeyValue $targetDependenciesKeyVal, YAMLMapping $targetTopLevelMapping, YAMLFile $chartYaml, YAMLSequence $dependencySequence, YAMLElementGenerator $generator, YAMLKeyValue $sourceDependenciesKeyVal, YAMLFile $reqYaml) {
                    Object object = $codeStyleManager.performActionWithFormatterDisabled(() -> validateKey.1.applyFix$lambda$8$lambda$5($targetDependenciesKeyVal, $targetTopLevelMapping, $chartYaml, $dependencySequence, $generator, $sourceDependenciesKeyVal));
                    PsiElement addedElement = (PsiElement)object;
                    boolean bl = false;
                    if (addedElement != null) {
                        YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)YamlUtilKt.getTypedAncestorOrSelf((PsiElement)addedElement, YAMLKeyValue.class);
                        if (yAMLKeyValue != null) {
                            YAMLKeyValue it = yAMLKeyValue;
                            boolean bl2 = false;
                            $codeStyleManager.reformat((PsiElement)it, true);
                        }
                    }
                    $reqYaml.delete();
                    return (PsiElement)object;
                }
            }};
            problemsHolder.registerProblem(psiElement, KubernetesBundle.message((String)"HelmChartUnknownValuesInspection.requirements.no.longer.used.message", (Object[])new Object[0]), ProblemHighlightType.WARNING, localQuickFixArray);
        }
    }
}

