/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.install;

import com.google.common.hash.Hashing;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.install.BinaryInstaller;
import com.intellij.kubernetes.install.BinaryInstallerKt;
import com.intellij.kubernetes.install.FailedInstallation;
import com.intellij.kubernetes.install.InstallationResult;
import com.intellij.kubernetes.install.SuccessfulInstallation;
import com.intellij.kubernetes.ui.NotificationsKt;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.io.Decompressor;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000k\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004*\u00019\b\u0000\u0018\u0000 A2\u00020\u0001:\u0003?@AB\u009b\u0001\b\u0002\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0006\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0006\u0012\u001e\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u00060\u0006\u0012\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0006\u0012\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0006\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u000eH\u0086@\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0003J\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0003J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J&\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\u0004H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001d\u001a\u00020\nH\u0002J \u0010#\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\nH\u0002J\u0018\u0010&\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\n2\u0006\u0010'\u001a\u00020\nH\u0002J\u0010\u0010(\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\nH\u0002J\u001c\u0010)\u001a\u00020\u000f2\b\u0010\u001d\u001a\u0004\u0018\u00010\n2\b\u0010*\u001a\u0004\u0018\u00010\nH\u0002J\n\u0010+\u001a\u0004\u0018\u00010\u0004H\u0002J\u001a\u0010,\u001a\u0004\u0018\u00010\u00042\u0006\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u0004H\u0002J\u0010\u0010/\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u0004H\u0002J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0004H\u0002J>\u00104\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000e0\u00062\u0018\u00106\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000f07H\u0002JC\u00108\u001a\u0002092\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000e0\u00062\u0018\u00106\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000f07H\u0002\u00a2\u0006\u0002\u0010:J\"\u0010;\u001a\u00020\u000f2\b\b\u0001\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020>2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/intellij/kubernetes/install/BinaryInstaller;", "", "binaryNameProvider", "Lkotlin/Function0;", "", "downloadUrlProvider", "Lkotlin/Function1;", "Lcom/intellij/kubernetes/install/BinaryInstaller$Configuration;", "checksumProvider", "fileFilterProvider", "Ljava/nio/file/Path;", "", "installDirProvider", "resultHandler", "Lcom/intellij/kubernetes/install/InstallationResult;", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "configuration", "install", "project", "Lcom/intellij/openapi/project/Project;", "installSuspend", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "installInternal", "handleResult", "result", "download", "findBinary", "Lkotlin/Pair;", "file", "binaryName", "unpackArchiveIfNeeded", "verifyDownload", "binary", "makeExecutable", "moveToInstallationDir", "installationDir", "addInstallationDirToPath", "cleanup", "folder", "readPathFromRegistry", "appendToPath", "oldPath", "newEntry", "updatePathInRegistry", "value", "createRequest", "Lcom/intellij/util/io/RequestBuilder;", "url", "runInstallationInBackground", "installation", "afterInstallation", "Lkotlin/Function2;", "createInstallationTask", "com/intellij/kubernetes/install/BinaryInstaller$createInstallationTask$1", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)Lcom/intellij/kubernetes/install/BinaryInstaller$createInstallationTask$1;", "showK8sNotification", "content", "type", "Lcom/intellij/notification/NotificationType;", "Configurer", "Configuration", "Companion", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nBinaryInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BinaryInstaller.kt\ncom/intellij/kubernetes/install/BinaryInstaller\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,508:1\n1#2:509\n2746#3,3:510\n230#3,2:513\n1761#3,3:515\n774#3:518\n865#3,2:519\n*S KotlinDebug\n*F\n+ 1 BinaryInstaller.kt\ncom/intellij/kubernetes/install/BinaryInstaller\n*L\n189#1:510,3\n214#1:513,2\n325#1:515,3\n330#1:518\n330#1:519,2\n*E\n"})
public final class BinaryInstaller {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<String> binaryNameProvider;
    @NotNull
    private final Function1<Configuration, String> downloadUrlProvider;
    @NotNull
    private final Function1<Configuration, String> checksumProvider;
    @NotNull
    private final Function1<Configuration, Function1<Path, Boolean>> fileFilterProvider;
    @NotNull
    private final Function1<Configuration, Path> installDirProvider;
    @Nullable
    private final Function1<InstallationResult, Unit> resultHandler;
    @Nullable
    private final ProgressIndicator progressIndicator;
    @NotNull
    private Configuration configuration;

    private BinaryInstaller(Function0<String> binaryNameProvider, Function1<? super Configuration, String> downloadUrlProvider, Function1<? super Configuration, String> checksumProvider, Function1<? super Configuration, ? extends Function1<? super Path, Boolean>> fileFilterProvider, Function1<? super Configuration, ? extends Path> installDirProvider, Function1<? super InstallationResult, Unit> resultHandler, ProgressIndicator progressIndicator) {
        this.binaryNameProvider = binaryNameProvider;
        this.downloadUrlProvider = downloadUrlProvider;
        this.checksumProvider = checksumProvider;
        this.fileFilterProvider = fileFilterProvider;
        this.installDirProvider = installDirProvider;
        this.resultHandler = resultHandler;
        this.progressIndicator = progressIndicator;
        this.configuration = new Configuration(null, null);
    }

    private final void install(Project project) {
        this.runInstallationInBackground(project, (Function1<? super ProgressIndicator, ? extends InstallationResult>)((Function1)new Function1<ProgressIndicator, InstallationResult>((Object)this){

            public final InstallationResult invoke(ProgressIndicator p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return BinaryInstaller.access$installInternal((BinaryInstaller)this.receiver, p0);
            }
        }), (Function2<? super InstallationResult, ? super Project, Unit>)((Function2)new Function2<InstallationResult, Project, Unit>((Object)this){

            public final void invoke(InstallationResult p0, Project p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                BinaryInstaller.access$handleResult((BinaryInstaller)this.receiver, p0, p1);
            }
        }));
    }

    @Nullable
    public final Object installSuspend(@NotNull Continuation<? super InstallationResult> $completion) {
        boolean bl;
        boolean bl2 = bl = this.progressIndicator == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super InstallationResult>, Object>(this, null){
            int label;
            final /* synthetic */ BinaryInstaller this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = CoroutinesKt.coroutineToIndicator(arg_0 -> installSuspend.2.invokeSuspend$lambda$0(this.this$0, arg_0), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super InstallationResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final InstallationResult invokeSuspend$lambda$0(BinaryInstaller this$0, ProgressIndicator it) {
                ProgressIndicator progressIndicator = ProgressManager.getGlobalProgressIndicator();
                Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"getGlobalProgressIndicator(...)");
                return BinaryInstaller.access$installInternal(this$0, progressIndicator);
            }
        }), $completion);
    }

    @RequiresBackgroundThread
    private final InstallationResult installInternal(ProgressIndicator progressIndicator) {
        Object object = this.binaryNameProvider.invoke();
        String it = (String)object;
        boolean bl2 = false;
        this.configuration = Configuration.copy$default(this.configuration, it, null, 2, null);
        String binaryName = (String)object;
        if ((object = (CharSequence)binaryName) == null || object.length() == 0) {
            BinaryInstallerKt.access$getLOG$p().error("No binary name provided");
            Supplier supplier = KubernetesBundle.messagePointer((String)"binary.installation.failed", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"messagePointer(...)");
            return new FailedInstallation(supplier);
        }
        Path download = this.download(progressIndicator);
        if (download == null) {
            Object[] bl2 = new Object[]{binaryName};
            Supplier supplier = KubernetesBundle.messagePointer((String)"binary.installation.download.failed", (Object[])bl2);
            Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"messagePointer(...)");
            return new FailedInstallation(supplier);
        }
        Pair<Path, Path> pair = this.findBinary(download, binaryName);
        if (pair == null) {
            Object[] objectArray = new Object[]{binaryName};
            Supplier supplier = KubernetesBundle.messagePointer((String)"binary.installation.search.failed", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"messagePointer(...)");
            return new FailedInstallation(supplier);
        }
        Pair<Path, Path> pair2 = pair;
        Path folder = (Path)pair2.component1();
        Path binary = (Path)pair2.component2();
        if (!Intrinsics.areEqual((Object)PathsKt.getName((Path)binary), (Object)binaryName)) {
            Path normalizedBinaryPath = binary.getParent().resolve(binaryName);
            if (Files.exists(normalizedBinaryPath, new LinkOption[0])) {
                BinaryInstallerKt.access$getLOG$p().trace("file with name " + normalizedBinaryPath + " already exists. Deleting it.");
                Files.delete(normalizedBinaryPath);
            }
            Files.move(binary, normalizedBinaryPath, new CopyOption[0]);
            Intrinsics.checkNotNull((Object)normalizedBinaryPath);
            binary = normalizedBinaryPath;
        }
        if (!this.verifyDownload(download, binary, progressIndicator)) {
            this.cleanup(download, folder);
            Supplier supplier = KubernetesBundle.messagePointer((String)"binary.installation.verification.failed", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"messagePointer(...)");
            return new FailedInstallation(supplier);
        }
        if (!SystemInfoRt.isWindows && !this.makeExecutable(binary)) {
            this.cleanup(download, folder);
            Object[] objectArray = new Object[]{binaryName};
            Supplier supplier = KubernetesBundle.messagePointer((String)"binary.installation.make.executable.failed", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"messagePointer(...)");
            return new FailedInstallation(supplier);
        }
        Path installationDir = (Path)this.installDirProvider.invoke((Object)this.configuration);
        if (installationDir == null) {
            this.cleanup(download, folder);
            BinaryInstallerKt.access$getLOG$p().error("No binary installation dir provided");
            Supplier supplier = KubernetesBundle.messagePointer((String)"binary.installation.failed", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"messagePointer(...)");
            return new FailedInstallation(supplier);
        }
        if (!this.moveToInstallationDir(binary, installationDir)) {
            this.cleanup(download, folder);
            Object[] objectArray = new Object[]{installationDir};
            Supplier supplier = KubernetesBundle.messagePointer((String)"binary.installation.move.to.installation.dir.failed", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"messagePointer(...)");
            return new FailedInstallation(supplier);
        }
        this.cleanup(download, folder);
        String[] stringArray = new String[]{binaryName};
        Path path = Paths.get(((Object)installationDir.toAbsolutePath()).toString(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return new SuccessfulInstallation(path);
    }

    @RequiresEdt
    private final void handleResult(InstallationResult result2, Project project) {
        block3: {
            if (Intrinsics.areEqual((Object)ModalityState.current(), (Object)ModalityState.nonModal())) {
                if (result2 instanceof FailedInstallation) {
                    String string = ((FailedInstallation)result2).getErrorMsg().get();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
                    this.showK8sNotification(string, NotificationType.ERROR, project);
                } else {
                    Object[] objectArray = new Object[2];
                    Intrinsics.checkNotNull((Object)this.configuration.getBinaryName());
                    objectArray[1] = String.valueOf(result2.getBinary());
                    String string = KubernetesBundle.message((String)"binary.installation.succeeded", (Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.showK8sNotification(string, NotificationType.INFORMATION, project);
                }
            }
            Function1<InstallationResult, Unit> function1 = this.resultHandler;
            if (function1 == null) break block3;
            function1.invoke((Object)result2);
        }
    }

    private final Path download(ProgressIndicator progressIndicator) {
        Object object = this.downloadUrlProvider.invoke((Object)this.configuration);
        Object[] it = (String[])object;
        boolean bl = false;
        this.configuration = Configuration.copy$default(this.configuration, null, (String)it, 1, null);
        String downloadUrl = (String)object;
        if ((object = (CharSequence)downloadUrl) == null || object.length() == 0) {
            BinaryInstallerKt.access$getLOG$p().error("No binary download URL provided");
            return null;
        }
        it = new String[]{StringsKt.substringAfterLast$default((String)downloadUrl, (char)'/', null, (int)2, null)};
        Path file = Paths.get(PathManager.getTempPath(), (String[])it);
        try {
            it = new Object[]{downloadUrl};
            progressIndicator.setText2(KubernetesBundle.message((String)"binary.installation.downloading.binary.progress.title", (Object[])it));
            this.createRequest(downloadUrl).saveToFile(file, progressIndicator);
        }
        catch (Exception e) {
            BinaryInstallerKt.access$getLOG$p().error("Failed to download binary from: " + downloadUrl, (Throwable)e);
            return null;
        }
        return file;
    }

    private final Pair<Path, Path> findBinary(Path file, String binaryName) {
        Pair pair;
        if (Intrinsics.areEqual((Object)PathsKt.getName((Path)file), (Object)binaryName)) {
            return TuplesKt.to((Object)file, (Object)file);
        }
        Path path = this.unpackArchiveIfNeeded(file);
        if (path == null) {
            return null;
        }
        Path folder = path;
        if (Files.isRegularFile(folder, new LinkOption[0])) {
            return TuplesKt.to((Object)folder, (Object)folder);
        }
        Optional<Object> optional = Files.walk(folder, new FileVisitOption[0]).filter(arg_0 -> BinaryInstaller.findBinary$lambda$3(arg_0 -> BinaryInstaller.findBinary$lambda$2(binaryName, arg_0), arg_0)).findFirst();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"findFirst(...)");
        Path path2 = (Path)OptionalsKt.getOrNull(optional);
        if (path2 != null) {
            Path it = path2;
            boolean bl = false;
            pair = TuplesKt.to((Object)folder, (Object)it);
        } else {
            pair = null;
        }
        return pair;
    }

    private final Path unpackArchiveIfNeeded(Path download) {
        Path archiveContent;
        boolean bl;
        String downloadFileName;
        block6: {
            downloadFileName = PathsKt.getName((Path)download);
            Iterable $this$none$iv = BinaryInstallerKt.access$getSUPPORTED_ARCHIVE_TYPES$p();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.endsWith$default((String)downloadFileName, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (bl) {
            return download;
        }
        if (StringsKt.endsWith$default((String)downloadFileName, (String)".zip", (boolean)false, (int)2, null)) {
            String[] stringArray = new String[]{StringsKt.removeSuffix((String)downloadFileName, (CharSequence)".zip")};
            archiveContent = Paths.get(((Object)download.getParent()).toString(), stringArray);
            new Decompressor.Zip(download).withZipExtensions().extract(archiveContent);
            return archiveContent;
        }
        if (StringsKt.endsWith$default((String)downloadFileName, (String)".tar.gz", (boolean)false, (int)2, null)) {
            String[] stringArray = new String[]{StringsKt.removeSuffix((String)downloadFileName, (CharSequence)".tar.gz")};
            archiveContent = Paths.get(((Object)download.getParent()).toString(), stringArray);
            new Decompressor.Tar(download).extract(archiveContent);
            return archiveContent;
        }
        BinaryInstallerKt.access$getLOG$p().error("Unsupported archive type: " + downloadFileName);
        return null;
    }

    private final boolean verifyDownload(Path download, Path binary, ProgressIndicator progressIndicator) {
        String string;
        Object element$iv2;
        String checksum;
        block4: {
            String string2 = (String)this.checksumProvider.invoke((Object)this.configuration);
            if (string2 == null) {
                return true;
            }
            checksum = string2;
            Function1 fileFilter = (Function1)this.fileFilterProvider.invoke((Object)this.configuration);
            Object[] objectArray = new Path[]{download, binary};
            Iterable $this$first$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                if (!((Boolean)fileFilter.invoke(element$iv2)).booleanValue()) continue;
                break block4;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Path fileToVerify = (Path)element$iv2;
        try {
            progressIndicator.setText2(KubernetesBundle.message((String)"binary.installation.calculating.hash.progress.title", (Object[])new Object[0]));
            string = com.google.common.io.Files.asByteSource((File)fileToVerify.toFile()).hash(Hashing.sha256()).toString();
        }
        catch (Exception e) {
            BinaryInstallerKt.access$getLOG$p().error("Failed to calculate hashcode for binary");
            return false;
        }
        Object object = string;
        Intrinsics.checkNotNull((Object)object);
        Object actualChecksum = object;
        return StringsKt.equals((String)actualChecksum, (String)checksum, (boolean)true);
    }

    private final boolean makeExecutable(Path binary) {
        try {
            Path path = binary;
            PosixFilePermission[] posixFilePermissionArray = new PosixFilePermission[]{PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OWNER_EXECUTE};
            Intrinsics.checkNotNullExpressionValue((Object)Files.setPosixFilePermissions(path, SetsKt.setOf((Object[])posixFilePermissionArray)), (String)"setPosixFilePermissions(...)");
        }
        catch (Exception e) {
            BinaryInstallerKt.access$getLOG$p().error("Failed to make '" + ((Object)binary.toAbsolutePath()).toString() + "' executable", (Throwable)e);
        }
        return Files.isExecutable(binary);
    }

    private final boolean moveToInstallationDir(Path binary, Path installationDir) {
        try {
            GeneralCommandLine generalCommandLine;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(installationDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Files.createDirectories(installationDir, new FileAttribute[0]);
            }
            if (SystemInfoRt.isWindows) {
                var4_3 = new String[]{"cmd.exe", "/c", "move", ((Object)binary.toAbsolutePath()).toString(), ((Object)installationDir.toAbsolutePath()).toString()};
                GeneralCommandLine generalCommandLine2 = new GeneralCommandLine(var4_3);
                generalCommandLine = generalCommandLine2;
            } else {
                var4_3 = new String[]{"mv", ((Object)binary.toAbsolutePath()).toString(), ((Object)installationDir.toAbsolutePath()).toString()};
                GeneralCommandLine generalCommandLine3 = new GeneralCommandLine(var4_3);
                Object[] objectArray = new Object[]{installationDir};
                String string = KubernetesBundle.message((String)"binary.installation.move.to.installation.dir", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                generalCommandLine = ExecUtil.sudoCommand((GeneralCommandLine)generalCommandLine3, (String)string);
            }
            GeneralCommandLine commandLine = generalCommandLine;
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine);
            if (!output.checkSuccess(BinaryInstallerKt.access$getLOG$p())) {
                BinaryInstallerKt.access$getLOG$p().error(output.getStderr());
                return false;
            }
        }
        catch (Exception e) {
            BinaryInstallerKt.access$getLOG$p().error((Throwable)e);
            return false;
        }
        return !SystemInfoRt.isWindows || this.addInstallationDirToPath(installationDir);
    }

    private final boolean addInstallationDirToPath(Path installationDir) {
        String userPath;
        String newUserPath;
        String locationToAdd = ((Object)installationDir.toAbsolutePath()).toString();
        String string = this.readPathFromRegistry();
        if (string == null) {
            string = "";
        }
        if ((newUserPath = this.appendToPath(userPath = string, locationToAdd)) == null) {
            BinaryInstallerKt.access$getLOG$p().debug("The '" + locationToAdd + "' location is already in the user PATH (`" + userPath + "`)");
            return true;
        }
        if (!this.updatePathInRegistry(newUserPath)) {
            return false;
        }
        BinaryInstallerKt.access$getLOG$p().debug("The '" + locationToAdd + "' location is added to the user PATH (`" + userPath + "`)");
        return true;
    }

    private final void cleanup(Path download, Path folder) {
        try {
            if (download != null) {
                FileUtil.delete((Path)download);
            }
            if (folder != null) {
                FileUtil.delete((Path)folder);
            }
        }
        catch (IOException e) {
            BinaryInstallerKt.access$getLOG$p().error("An exception thrown during cleanup after binary installation", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String readPathFromRegistry() {
        try {
            WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
            int rc = Advapi32.INSTANCE.RegOpenKeyEx(WinReg.HKEY_CURRENT_USER, "Environment", 0, 131609, phkKey);
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
            try {
                Object object = Advapi32Util.registryGetValue((WinReg.HKEY)phkKey.getValue(), (String)"", (String)"Path");
                String string = object != null ? object.toString() : null;
                return string;
            }
            finally {
                Advapi32Util.registryCloseKey((WinReg.HKEY)phkKey.getValue());
            }
        }
        catch (Win32Exception t) {
            BinaryInstallerKt.access$getLOG$p().error("Unable to read registry key 'WinReg.HKEY_CURRENT_USER\\Environment' valueName 'Path': " + t.getMessage());
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String appendToPath(String oldPath, String newEntry) {
        void $this$filterTo$iv$iv;
        boolean alreadyAdded;
        List pathElements;
        String pathSeparator;
        block5: {
            pathSeparator = File.pathSeparator;
            CharSequence charSequence = oldPath;
            String[] stringArray = new String[1];
            Intrinsics.checkNotNull((Object)pathSeparator);
            stringArray[0] = pathSeparator;
            pathElements = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            Iterable $this$any$iv = pathElements;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.equals((String)it, (String)newEntry, (boolean)true)) continue;
                    v1 = true;
                    break block5;
                }
                v1 = alreadyAdded = false;
            }
        }
        if (alreadyAdded) {
            return null;
        }
        Iterable $this$filter$iv = CollectionsKt.plus((Collection)pathElements, (Object)newEntry);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String p0 = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)p0).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, arg_0 -> BinaryInstaller.appendToPath$lambda$7(pathSeparator, arg_0), (int)30, null);
    }

    private final boolean updatePathInRegistry(String value) {
        try {
            int branch = 512;
            Advapi32Util.registryCreateKey((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)"Environment", (int)branch);
            Advapi32Util.registrySetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)"Environment", (String)"Path", (String)value, (int)branch);
            return true;
        }
        catch (Win32Exception t) {
            BinaryInstallerKt.access$getLOG$p().error("Unable to write registry key 'HKEY_CURRENT_USER\\Environment' valueName 'Path': " + t.getMessage());
            return false;
        }
    }

    private final RequestBuilder createRequest(String url) {
        RequestBuilder requestBuilder = HttpRequests.request((String)url).productNameAsUserAgent();
        Intrinsics.checkNotNullExpressionValue((Object)requestBuilder, (String)"productNameAsUserAgent(...)");
        return requestBuilder;
    }

    private final void runInstallationInBackground(Project project, Function1<? super ProgressIndicator, ? extends InstallationResult> installation, Function2<? super InstallationResult, ? super Project, Unit> afterInstallation) {
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"getInstance(...)");
        ProgressManager progressManager2 = progressManager;
        createInstallationTask.1 task = this.createInstallationTask(project, installation, afterInstallation);
        ProgressIndicator progressIndicator = this.progressIndicator;
        if (progressIndicator == null) {
            progressIndicator = (ProgressIndicator)new BackgroundableProcessIndicator((Task.Backgroundable)task);
        }
        ProgressIndicator indicator = progressIndicator;
        progressManager2.runProcessWithProgressAsynchronously((Task.Backgroundable)task, indicator);
    }

    private final createInstallationTask.1 createInstallationTask(Project project, Function1<? super ProgressIndicator, ? extends InstallationResult> installation, Function2<? super InstallationResult, ? super Project, Unit> afterInstallation) {
        String string = KubernetesBundle.message((String)"binary.installation.progress.title", (Object[])new Object[0]);
        return new Task.Backgroundable(project, installation, afterInstallation, string){
            private InstallationResult installationResult;
            final /* synthetic */ Project $project;
            final /* synthetic */ Function1<ProgressIndicator, InstallationResult> $installation;
            final /* synthetic */ Function2<InstallationResult, Project, Unit> $afterInstallation;
            {
                this.$project = $project;
                this.$installation = $installation;
                this.$afterInstallation = $afterInstallation;
                super($project, $super_call_param$1, true);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                this.installationResult = (InstallationResult)this.$installation.invoke((Object)indicator);
            }

            public void onSuccess() {
                if (this.installationResult != null) {
                    InstallationResult installationResult = this.installationResult;
                    Intrinsics.checkNotNull((Object)installationResult);
                    this.$afterInstallation.invoke((Object)installationResult, (Object)this.$project);
                }
            }
        };
    }

    private final void showK8sNotification(@NlsContexts.NotificationContent String content, NotificationType type, Project project) {
        NotificationGroup notificationGroup = NotificationsKt.getKubernetesNotificationGroup();
        String string = KubernetesBundle.message((String)"KubernetesNotification.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        notificationGroup.createNotification(string, content, type).notify(project);
    }

    private static final boolean findBinary$lambda$2(String $binaryName, Path it) {
        return Intrinsics.areEqual((Object)((Object)it.getFileName()).toString(), (Object)$binaryName);
    }

    private static final boolean findBinary$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final CharSequence appendToPath$lambda$7(String $pathSeparator, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it + $pathSeparator;
    }

    public static final /* synthetic */ InstallationResult access$installInternal(BinaryInstaller $this, ProgressIndicator progressIndicator) {
        return $this.installInternal(progressIndicator);
    }

    public static final /* synthetic */ void access$handleResult(BinaryInstaller $this, InstallationResult result2, Project project) {
        $this.handleResult(result2, project);
    }

    public /* synthetic */ BinaryInstaller(Function0 binaryNameProvider, Function1 downloadUrlProvider, Function1 checksumProvider, Function1 fileFilterProvider, Function1 installDirProvider, Function1 resultHandler, ProgressIndicator progressIndicator, DefaultConstructorMarker $constructor_marker) {
        this((Function0<String>)binaryNameProvider, (Function1<? super Configuration, String>)downloadUrlProvider, (Function1<? super Configuration, String>)checksumProvider, (Function1<? super Configuration, ? extends Function1<? super Path, Boolean>>)fileFilterProvider, (Function1<? super Configuration, ? extends Path>)installDirProvider, (Function1<? super InstallationResult, Unit>)resultHandler, progressIndicator);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/kubernetes/install/BinaryInstaller$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/kubernetes/install/BinaryInstaller$Configurer;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clouds.kubernetes.backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Configurer create(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return new Configurer(project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J!\u0010\f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/kubernetes/install/BinaryInstaller$Configuration;", "", "binaryName", "", "downloadUrl", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getBinaryName", "()Ljava/lang/String;", "getDownloadUrl", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.clouds.kubernetes.backend"})
    public static final class Configuration {
        @Nullable
        private final String binaryName;
        @Nullable
        private final String downloadUrl;

        public Configuration(@Nullable String binaryName, @Nullable String downloadUrl) {
            this.binaryName = binaryName;
            this.downloadUrl = downloadUrl;
        }

        @Nullable
        public final String getBinaryName() {
            return this.binaryName;
        }

        @Nullable
        public final String getDownloadUrl() {
            return this.downloadUrl;
        }

        @Nullable
        public final String component1() {
            return this.binaryName;
        }

        @Nullable
        public final String component2() {
            return this.downloadUrl;
        }

        @NotNull
        public final Configuration copy(@Nullable String binaryName, @Nullable String downloadUrl) {
            return new Configuration(binaryName, downloadUrl);
        }

        public static /* synthetic */ Configuration copy$default(Configuration configuration, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = configuration.binaryName;
            }
            if ((n & 2) != 0) {
                string2 = configuration.downloadUrl;
            }
            return configuration.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Configuration(binaryName=" + this.binaryName + ", downloadUrl=" + this.downloadUrl + ")";
        }

        public int hashCode() {
            int result2 = this.binaryName == null ? 0 : this.binaryName.hashCode();
            result2 = result2 * 31 + (this.downloadUrl == null ? 0 : this.downloadUrl.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Configuration)) {
                return false;
            }
            Configuration configuration = (Configuration)other;
            if (!Intrinsics.areEqual((Object)this.binaryName, (Object)configuration.binaryName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.downloadUrl, (Object)configuration.downloadUrl);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0016\u001a\u00020\u00002\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007J\u001c\u0010\u0018\u001a\u00020\u00002\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\b0\nJ\u001c\u0010\u001a\u001a\u00020\u00002\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\b0\nJ&\u0010\u001b\u001a\u00020\u00002\u001e\u0010\u001c\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\n0\nJ\u001c\u0010\u001d\u001a\u00020\u00002\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\nJ\u001c\u0010\u001f\u001a\u00020\u00002\u0014\b\u0001\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\nJ\u0010\u0010 \u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\b\u0010!\u001a\u00020\"H\u0002J\u0006\u0010#\u001a\u00020\u0013J\u000e\u0010$\u001a\u00020\u0012H\u0086@\u00a2\u0006\u0002\u0010%J\u001c\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\n2\u0006\u0010'\u001a\u00020\u000bH\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\u000e2\u0006\u0010'\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\r\u001a\u001c\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\n\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/kubernetes/install/BinaryInstaller$Configurer;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "binaryNameProvider", "Lkotlin/Function0;", "", "downloadUrlProvider", "Lkotlin/Function1;", "Lcom/intellij/kubernetes/install/BinaryInstaller$Configuration;", "checksumProvider", "fileToVerifyFilter", "Ljava/nio/file/Path;", "", "installDirProvider", "resultHandler", "Lcom/intellij/kubernetes/install/InstallationResult;", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "withBinaryName", "nameProvider", "withDownloadUrl", "urlProvider", "withChecksum", "withFileToVerifyFilter", "fileToVerifyFilterProvider", "withInstallationDir", "dirProvider", "withResultHandler", "withProgressIndicator", "prepareBinaryInstaller", "Lcom/intellij/kubernetes/install/BinaryInstaller;", "install", "installSuspend", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDefaultFileFilter", "configuration", "getDefaultInstallationDirProvider", "intellij.clouds.kubernetes.backend"})
    @SourceDebugExtension(value={"SMAP\nBinaryInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BinaryInstaller.kt\ncom/intellij/kubernetes/install/BinaryInstaller$Configurer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,508:1\n1#2:509\n*E\n"})
    public static final class Configurer {
        @NotNull
        private final Project project;
        @Nullable
        private Function0<String> binaryNameProvider;
        @Nullable
        private Function1<? super Configuration, String> downloadUrlProvider;
        @Nullable
        private Function1<? super Configuration, String> checksumProvider;
        @Nullable
        private Function1<? super Configuration, ? extends Function1<? super Path, Boolean>> fileToVerifyFilter;
        @Nullable
        private Function1<? super Configuration, ? extends Path> installDirProvider;
        @Nullable
        private Function1<? super InstallationResult, Unit> resultHandler;
        @Nullable
        private ProgressIndicator progressIndicator;

        public Configurer(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public final Configurer withBinaryName(@NotNull Function0<String> nameProvider) {
            Intrinsics.checkNotNullParameter(nameProvider, (String)"nameProvider");
            this.binaryNameProvider = nameProvider;
            return this;
        }

        @NotNull
        public final Configurer withDownloadUrl(@NotNull Function1<? super Configuration, String> urlProvider) {
            Intrinsics.checkNotNullParameter(urlProvider, (String)"urlProvider");
            this.downloadUrlProvider = urlProvider;
            return this;
        }

        @NotNull
        public final Configurer withChecksum(@NotNull Function1<? super Configuration, String> checksumProvider) {
            Intrinsics.checkNotNullParameter(checksumProvider, (String)"checksumProvider");
            this.checksumProvider = checksumProvider;
            return this;
        }

        @NotNull
        public final Configurer withFileToVerifyFilter(@NotNull Function1<? super Configuration, ? extends Function1<? super Path, Boolean>> fileToVerifyFilterProvider) {
            Intrinsics.checkNotNullParameter(fileToVerifyFilterProvider, (String)"fileToVerifyFilterProvider");
            this.fileToVerifyFilter = fileToVerifyFilterProvider;
            return this;
        }

        @NotNull
        public final Configurer withInstallationDir(@NotNull Function1<? super Configuration, ? extends Path> dirProvider) {
            Intrinsics.checkNotNullParameter(dirProvider, (String)"dirProvider");
            this.installDirProvider = dirProvider;
            return this;
        }

        @NotNull
        public final Configurer withResultHandler(@RequiresEdt @NotNull Function1<? super InstallationResult, Unit> resultHandler) {
            Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
            this.resultHandler = resultHandler;
            return this;
        }

        @NotNull
        public final Configurer withProgressIndicator(@Nullable ProgressIndicator progressIndicator) {
            this.progressIndicator = progressIndicator;
            return this;
        }

        private final BinaryInstaller prepareBinaryInstaller() {
            Function1 function1;
            Function1 function12;
            boolean bl;
            boolean bl2 = bl = this.binaryNameProvider != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            boolean bl3 = bl = this.downloadUrlProvider != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Function0<String> function0 = this.binaryNameProvider;
            Intrinsics.checkNotNull(function0);
            Function1<? super Configuration, String> function13 = this.downloadUrlProvider;
            Intrinsics.checkNotNull(function13);
            Function1 function14 = this.checksumProvider;
            if (function14 == null) {
                function14 = Configurer::prepareBinaryInstaller$lambda$0;
            }
            if ((function12 = this.fileToVerifyFilter) == null) {
                function12 = (Function1)new Function1<Configuration, Function1<? super Path, ? extends Boolean>>((Object)this){

                    public final Function1<Path, Boolean> invoke(Configuration p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return Configurer.access$getDefaultFileFilter((Configurer)this.receiver, p0);
                    }
                };
            }
            if ((function1 = this.installDirProvider) == null) {
                function1 = (Function1)new Function1<Configuration, Path>((Object)this){

                    public final Path invoke(Configuration p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return Configurer.access$getDefaultInstallationDirProvider((Configurer)this.receiver, p0);
                    }
                };
            }
            BinaryInstaller binaryInstaller2 = new BinaryInstaller(function0, function13, function14, function12, function1, this.resultHandler, this.progressIndicator, null);
            return binaryInstaller2;
        }

        public final void install() {
            this.prepareBinaryInstaller().install(this.project);
        }

        @Nullable
        public final Object installSuspend(@NotNull Continuation<? super InstallationResult> $completion) {
            return this.prepareBinaryInstaller().installSuspend($completion);
        }

        private final Function1<Path, Boolean> getDefaultFileFilter(Configuration configuration) {
            return arg_0 -> Configurer.getDefaultFileFilter$lambda$1(configuration, arg_0);
        }

        private final Path getDefaultInstallationDirProvider(Configuration configuration) {
            Path path;
            if (SystemInfoRt.isWindows) {
                String string;
                String string2 = configuration.getBinaryName();
                String it = string = string2 != null ? StringsKt.substringBefore$default((String)string2, (char)'.', null, (int)2, null) : null;
                boolean bl = false;
                CharSequence charSequence = it;
                String string3 = !(charSequence == null || charSequence.length() == 0) ? string : null;
                if (string3 == null) {
                    return null;
                }
                String binaryFolderName = string3;
                Object p0 = System.getProperty("user.home") + "/.jetbrains/" + binaryFolderName + "/";
                boolean bl2 = false;
                p0 = FileUtil.toSystemIndependentName((String)p0);
                boolean bl3 = false;
                path = Paths.get((String)p0, new String[0]);
            } else {
                path = Paths.get("/usr/local/bin/", new String[0]);
            }
            return path;
        }

        private static final String prepareBinaryInstaller$lambda$0(Configuration it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return null;
        }

        private static final boolean getDefaultFileFilter$lambda$1(Configuration $configuration, Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return Intrinsics.areEqual((Object)((Object)path.getFileName()).toString(), (Object)$configuration.getBinaryName());
        }

        public static final /* synthetic */ Function1 access$getDefaultFileFilter(Configurer $this, Configuration configuration) {
            return $this.getDefaultFileFilter(configuration);
        }

        public static final /* synthetic */ Path access$getDefaultInstallationDirProvider(Configurer $this, Configuration configuration) {
            return $this.getDefaultInstallationDirProvider(configuration);
        }
    }
}

