/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.model;

import com.intellij.kubernetes.K8sSpecVersion;
import com.intellij.kubernetes.model.ModelData;
import com.intellij.kubernetes.model.openapi.OpenApiSpec;
import com.intellij.kubernetes.model.openapi.SchemaObject;
import com.intellij.openapi.util.io.FileUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 '2\u00020\u0001:\u0001'B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ0\u0010\b\u001a\u00020\t2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u00112\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J'\u0010\u0017\u001a\u00020\t\"\b\b\u0000\u0010\u0018*\u00020\u00012\u0006\u0010\u0019\u001a\u0002H\u00182\u0006\u0010\u001a\u001a\u0002H\u0018H\u0002\u00a2\u0006\u0002\u0010\u001bJ\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000e2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0002J\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\b\b\u0002\u0010!\u001a\u00020\u0005H\u0002J\u001a\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u00052\b\b\u0002\u0010!\u001a\u00020\u0005H\u0002J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0002J\u0010\u0010&\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/kubernetes/model/RefinementApplier;", "", "classLoader", "Ljava/lang/ClassLoader;", "mainSpecVersion", "", "<init>", "(Ljava/lang/ClassLoader;Ljava/lang/String;)V", "apply", "", "mainSpec", "Lcom/intellij/kubernetes/model/openapi/OpenApiSpec;", "crdApply", "definitions", "", "Lcom/intellij/kubernetes/model/ModelData$DefinitionInfo;", "originalDefinitions", "", "Lcom/intellij/kubernetes/model/openapi/SchemaObject;", "refiningDefinitions", "applyRefinement", "originalDefinition", "refiningDefinition", "patchFields", "T", "original", "refining", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getAllFields", "Ljava/lang/reflect/Field;", "type", "Ljava/lang/Class;", "readAvailableRefinementSpecNames", "specFolder", "readRefinementSpec", "specFileName", "filterAndSortApplicableRefinementSpecs", "allRefinementSpecs", "extractSpecVersion", "Companion", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nRefinementApplier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RefinementApplier.kt\ncom/intellij/kubernetes/model/RefinementApplier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1869#2,2:105\n1193#2,2:107\n1267#2,4:109\n1869#2,2:113\n1563#2:115\n1634#2,3:116\n1869#2:119\n1869#2,2:120\n1870#2:122\n1563#2:124\n1634#2,3:125\n774#2:128\n865#2,2:129\n1056#2:131\n1563#2:132\n1634#2,3:133\n1#3:123\n*S KotlinDebug\n*F\n+ 1 RefinementApplier.kt\ncom/intellij/kubernetes/model/RefinementApplier\n*L\n19#1:105,2\n25#1:107,2\n25#1:109,4\n26#1:113,2\n79#1:115\n79#1:116,3\n87#1:119\n88#1:120,2\n87#1:122\n96#1:124\n96#1:125,3\n97#1:128\n97#1:129,2\n98#1:131\n99#1:132\n99#1:133,3\n*E\n"})
public final class RefinementApplier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClassLoader classLoader;
    @Nullable
    private final String mainSpecVersion;
    @NotNull
    private static final String refinementSpecFolder = "api-spec/refine";
    @NotNull
    private static final String crdRefinementSpecFolder = "api-spec/crd-refine";

    public RefinementApplier(@NotNull ClassLoader classLoader, @Nullable String mainSpecVersion) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        this.classLoader = classLoader;
        this.mainSpecVersion = mainSpecVersion;
    }

    public final void apply(@NotNull OpenApiSpec mainSpec) {
        Intrinsics.checkNotNullParameter((Object)mainSpec, (String)"mainSpec");
        Iterable $this$forEach$iv = this.filterAndSortApplicableRefinementSpecs(RefinementApplier.readAvailableRefinementSpecNames$default(this, null, 1, null));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.apply(mainSpec.getDefinitions(), RefinementApplier.readRefinementSpec$default(this, it, null, 2, null).getDefinitions());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void crdApply(@NotNull List<ModelData.DefinitionInfo> definitions) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(definitions, (String)"definitions");
        Iterable $this$associate$iv = definitions;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            ModelData.DefinitionInfo it = (ModelData.DefinitionInfo)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getId(), (Object)it.getDefinition());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map originalDefinitions = destination$iv$iv;
        Iterable $this$forEach$iv = this.readAvailableRefinementSpecNames(crdRefinementSpecFolder);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.apply(originalDefinitions, this.readRefinementSpec(it, crdRefinementSpecFolder).getDefinitions());
        }
    }

    private final void apply(Map<String, SchemaObject> originalDefinitions, Map<String, SchemaObject> refiningDefinitions) {
        for (Map.Entry<String, SchemaObject> entry : refiningDefinitions.entrySet()) {
            SchemaObject originalDefinition;
            String definitionId = entry.getKey();
            SchemaObject refiningDefinition = entry.getValue();
            if (originalDefinitions.get(definitionId) == null) continue;
            this.applyRefinement(originalDefinition, refiningDefinition);
        }
    }

    private final void applyRefinement(SchemaObject originalDefinition, SchemaObject refiningDefinition) {
        originalDefinition.setMetatypeName(refiningDefinition.getMetatypeName());
        originalDefinition.setMetatypeSupplierName(refiningDefinition.getMetatypeSupplierName());
        if (refiningDefinition.getReadOnly() != null) {
            originalDefinition.setReadOnly(refiningDefinition.getReadOnly());
        }
        refiningDefinition.getProperties().forEach((arg_0, arg_1) -> RefinementApplier.applyRefinement$lambda$6((arg_0, arg_1) -> RefinementApplier.applyRefinement$lambda$5(originalDefinition, this, arg_0, arg_1), arg_0, arg_1));
    }

    private final <T> void patchFields(T original, T refining) {
        try {
            for (Field field2 : this.getAllFields(original.getClass())) {
                field2.setAccessible(true);
                Object value2 = field2.get(refining);
                if (value2 == null) continue;
                field2.set(original, value2);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private final List<Field> getAllFields(Class<?> type) {
        List list;
        Field[] fieldArray = type.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
        List thisFields = ArraysKt.asList((Object[])fieldArray);
        if (type.getSuperclass() != null) {
            Class<?> clazz = type.getSuperclass();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"getSuperclass(...)");
            list = CollectionsKt.toList((Iterable)CollectionsKt.union((Iterable)this.getAllFields(clazz), (Iterable)thisFields));
        } else {
            list = thisFields;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> readAvailableRefinementSpecNames(String specFolder) {
        void $this$mapTo$iv$iv;
        InputStream inputStream = this.classLoader.getResourceAsStream(specFolder + "/reflist.txt");
        Intrinsics.checkNotNull((Object)inputStream);
        List list = FileUtil.loadLines((BufferedReader)new BufferedReader(new InputStreamReader(inputStream)));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"loadLines(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("refine-" + (String)it + ".json");
        }
        return (List)destination$iv$iv;
    }

    static /* synthetic */ List readAvailableRefinementSpecNames$default(RefinementApplier refinementApplier, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = refinementSpecFolder;
        }
        return refinementApplier.readAvailableRefinementSpecNames(string);
    }

    private final OpenApiSpec readRefinementSpec(String specFileName, String specFolder) {
        OpenApiSpec openApiSpec;
        InputStream inputStream = this.classLoader.getResourceAsStream(specFolder + "/" + specFileName);
        Intrinsics.checkNotNull((Object)inputStream);
        OpenApiSpec openApiSpec2 = OpenApiSpec.Companion.loadFrom(new InputStreamReader(inputStream, Charsets.UTF_8));
        Intrinsics.checkNotNull((Object)openApiSpec2);
        OpenApiSpec spec = openApiSpec = openApiSpec2;
        boolean bl = false;
        Iterable $this$forEach$iv = new ArrayList<SchemaObject>(spec.getDefinitions().values());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SchemaObject def = (SchemaObject)element$iv;
            boolean bl2 = false;
            List<String> list = def.getOtherTypeIds();
            if (list == null) continue;
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl3 = false;
                spec.getDefinitions().put(it, def);
            }
        }
        return openApiSpec;
    }

    static /* synthetic */ OpenApiSpec readRefinementSpec$default(RefinementApplier refinementApplier, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = refinementSpecFolder;
        }
        return refinementApplier.readRefinementSpec(string, string2);
    }

    private final List<String> filterAndSortApplicableRefinementSpecs(List<String> allRefinementSpecs) {
        Iterable $this$filterTo$iv$iv;
        Pair it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Object object;
        block6: {
            block5: {
                object = this.mainSpecVersion;
                if (object == null) break block5;
                String it2 = object;
                boolean bl = false;
                K8sSpecVersion k8sSpecVersion = K8sSpecVersion.Companion.fromString(it2);
                object = k8sSpecVersion;
                if (k8sSpecVersion != null) break block6;
            }
            object = K8sSpecVersion.Companion.getMAX_VERSION();
        }
        Object mainVersion = object;
        Iterable $this$map$iv = allRefinementSpecs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)it, (Object)K8sSpecVersion.Companion.fromString(this.extractSpecVersion((String)it))));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(((K8sSpecVersion)it.getSecond()).compareTo((K8sSpecVersion)mainVersion) <= 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (K8sSpecVersion)it.getSecond();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((K8sSpecVersion)it.getSecond()));
            }
        });
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getFirst());
        }
        return (List)destination$iv$iv;
    }

    private final String extractSpecVersion(String specFileName) {
        return StringsKt.substringAfterLast$default((String)StringsKt.substringBeforeLast$default((String)specFileName, (char)'.', null, (int)2, null), (char)'-', null, (int)2, null);
    }

    private static final Unit applyRefinement$lambda$5(SchemaObject $originalDefinition, RefinementApplier this$0, String propName, SchemaObject refinePropertySchemaObject) {
        block1: {
            SchemaObject originalPropertySchemaObject;
            block0: {
                Intrinsics.checkNotNullParameter((Object)propName, (String)"propName");
                originalPropertySchemaObject = $originalDefinition.getProperties().get(propName);
                SchemaObject schemaObject = refinePropertySchemaObject;
                Map<String, SchemaObject> map2 = schemaObject != null ? schemaObject.getProperties() : null;
                if (map2 == null || map2.isEmpty()) break block0;
                SchemaObject schemaObject2 = originalPropertySchemaObject;
                if (schemaObject2 == null) break block1;
                SchemaObject it = schemaObject2;
                boolean bl = false;
                this$0.applyRefinement(it, refinePropertySchemaObject);
                break block1;
            }
            SchemaObject schemaObject = originalPropertySchemaObject;
            if (schemaObject == null) break block1;
            SchemaObject it = schemaObject;
            boolean bl = false;
            SchemaObject schemaObject3 = refinePropertySchemaObject;
            Intrinsics.checkNotNull((Object)schemaObject3);
            this$0.patchFields(it, schemaObject3);
        }
        return Unit.INSTANCE;
    }

    private static final void applyRefinement$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/kubernetes/model/RefinementApplier$Companion;", "", "<init>", "()V", "refinementSpecFolder", "", "crdRefinementSpecFolder", "intellij.clouds.kubernetes.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

