/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.linter;

import com.goide.psi.GoFile;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.codeInsight.daemon.impl.TrafficLightRendererContributor;
import com.intellij.go.linter.GoLinterBundle;
import com.intellij.go.linter.MergingLinterExecutor;
import com.intellij.go.linter.platform.PlatformKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.AnalyzerStatus;
import com.intellij.openapi.editor.markup.PassWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001c\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/go/linter/GoLinterTrafficLightRendererContributor;", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRendererContributor;", "<init>", "()V", "isBusy", "", "file", "Lcom/intellij/psi/PsiFile;", "createRenderer", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.go.linter"})
@SourceDebugExtension(value={"SMAP\nGoLinterTrafficLightRendererContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoLinterTrafficLightRendererContributor.kt\ncom/intellij/go/linter/GoLinterTrafficLightRendererContributor\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,41:1\n30#2,2:42\n*S KotlinDebug\n*F\n+ 1 GoLinterTrafficLightRendererContributor.kt\ncom/intellij/go/linter/GoLinterTrafficLightRendererContributor\n*L\n17#1:42,2\n*E\n"})
public final class GoLinterTrafficLightRendererContributor
implements TrafficLightRendererContributor {
    private final boolean isBusy(PsiFile file2) {
        Path pkgPath = file2.getViewProvider().getVirtualFile().toNioPath().getParent();
        Project project = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<MergingLinterExecutor> serviceClass$iv = MergingLinterExecutor.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        MergingLinterExecutor mergingLinterExecutor = (MergingLinterExecutor)object;
        Intrinsics.checkNotNull((Object)pkgPath);
        return mergingLinterExecutor.isPending(PlatformKt.toRunningOSPath(pkgPath));
    }

    @Nullable
    public TrafficLightRenderer createRenderer(@NotNull Editor editor, @Nullable PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!(file2 instanceof GoFile)) {
            return null;
        }
        Project project = ((GoFile)file2).getProject();
        return new TrafficLightRenderer(editor, this, file2, project){
            final /* synthetic */ GoLinterTrafficLightRendererContributor this$0;
            final /* synthetic */ PsiFile $file;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($super_call_param$1, $editor);
            }

            public AnalyzerStatus getStatus() {
                AnalyzerStatus status = super.getStatus();
                if (GoLinterTrafficLightRendererContributor.access$isBusy(this.this$0, this.$file)) {
                    status = status.withPasses(CollectionsKt.plus((Collection)status.getPasses(), (Iterable)CollectionsKt.listOf((Object)new PassWrapper(GoLinterBundle.message("traffic.light.golangci.lint.running.progress", new Object[0]), 100))));
                }
                return status;
            }

            protected TrafficLightRenderer.DaemonCodeAnalyzerStatus getDaemonCodeAnalyzerStatus(SeverityRegistrar severityRegistrar) {
                Intrinsics.checkNotNullParameter((Object)severityRegistrar, (String)"severityRegistrar");
                TrafficLightRenderer.DaemonCodeAnalyzerStatus status = super.getDaemonCodeAnalyzerStatus(severityRegistrar);
                if (GoLinterTrafficLightRendererContributor.access$isBusy(this.this$0, this.$file)) {
                    status.errorAnalyzingFinished = false;
                }
                return status;
            }
        };
    }

    public static final /* synthetic */ boolean access$isBusy(GoLinterTrafficLightRendererContributor $this, PsiFile file2) {
        return $this.isBusy(file2);
    }
}

