/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.linter.form;

import com.intellij.execution.wsl.WslPath;
import com.intellij.go.linter.GoLinterBundle;
import com.intellij.go.linter.form.VersionedLinter;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.nio.file.Path;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileExistCellRender
extends ColoredListCellRenderer<VersionedLinter> {
    FileExistCellRender() {
    }

    protected void customizeCellRenderer(@NotNull @NotNull JList<? extends @NotNull VersionedLinter> list, @Nullable VersionedLinter value, int index, boolean selected, boolean hasFocus) {
        if (list == null) {
            FileExistCellRender.$$$reportNull$$$0(0);
        }
        if (value == null) {
            return;
        }
        Path path = value.getPath();
        if (path == null || path.toString().isEmpty()) {
            this.append(GoLinterBundle.message("settings.executable.list.empty.item", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            return;
        }
        @NlsSafe String pathDisplayText = path.toString();
        if (SystemInfo.isWindows && WslPath.isWslUncPath((String)pathDisplayText)) {
            this.setIcon(AllIcons.RunConfigurations.Wsl);
        }
        SimpleTextAttributes attributes = path.toFile().canExecute() ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.ERROR_ATTRIBUTES;
        this.append(pathDisplayText, attributes);
        @NlsSafe String version2 = value.getVersion();
        this.append(" " + version2, SimpleTextAttributes.GRAYED_ATTRIBUTES, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/go/linter/form/FileExistCellRender", "customizeCellRenderer"));
    }
}

