/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.linter.handler;

import com.goide.psi.GoCallExpr;
import com.goide.psi.GoConditionalExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoShortVarDeclaration;
import com.goide.psi.GoSwitchStart;
import com.goide.psi.GoSwitchStatement;
import com.goide.psi.GoTypeAssertionExpr;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.go.linter.handler.ProblemHandler;
import com.intellij.go.linter.model.LintIssue;
import com.intellij.go.linter.quickfix.GoBringToExplanationFix;
import com.intellij.go.linter.quickfix.GoErrorTypeAssertionFix;
import com.intellij.go.linter.quickfix.GoReplaceWithErrorsIsFix;
import com.intellij.go.linter.quickfix.GoWrapErrorFormatFix;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J<\u0010\u0011\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/go/linter/handler/ErrorLintHandler;", "Lcom/intellij/go/linter/handler/ProblemHandler;", "<init>", "()V", "fixErrorfVerb", "Lkotlin/Pair;", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/openapi/util/TextRange;", "file", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "issue", "Lcom/intellij/go/linter/model/LintIssue;", "overrideLine", "", "doSuggestFix", "intellij.go.linter"})
@SourceDebugExtension(value={"SMAP\nErrorLintHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ErrorLintHandler.kt\ncom/intellij/go/linter/handler/ErrorLintHandler\n+ 2 ProblemHandler.kt\ncom/intellij/go/linter/handler/ProblemHandler\n*L\n1#1,59:1\n32#2,7:60\n32#2,7:67\n32#2,7:74\n32#2,7:81\n*S KotlinDebug\n*F\n+ 1 ErrorLintHandler.kt\ncom/intellij/go/linter/handler/ErrorLintHandler\n*L\n35#1:60,7\n43#1:67,7\n47#1:74,7\n51#1:81,7\n*E\n"})
public final class ErrorLintHandler
extends ProblemHandler {
    @NotNull
    public static final ErrorLintHandler INSTANCE = new ErrorLintHandler();

    private ErrorLintHandler() {
    }

    private final Pair<IntentionAction[], TextRange> fixErrorfVerb(PsiFile file2, Document document, LintIssue issue, int overrideLine) {
        int pos = this.calcPos(document, issue, overrideLine);
        PsiElement element = file2.findElementAt(pos);
        while (true) {
            PsiElement psiElement;
            if ((psiElement = element) instanceof GoCallExpr) {
                String string = ((GoCallExpr)element).getExpression().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (StringsKt.startsWith$default((String)string, (String)"fmt.Errorf", (boolean)false, (int)2, null)) {
                    IntentionAction[] intentionActionArray = new IntentionAction[]{new GoWrapErrorFormatFix((GoCallExpr)element, pos)};
                    List list = ((GoCallExpr)element).getArgumentList().getExpressionList();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExpressionList(...)");
                    return TuplesKt.to((Object)intentionActionArray, (Object)((GoExpression)CollectionsKt.first((List)list)).getTextRange());
                }
            } else if (psiElement instanceof GoFile || psiElement == null) {
                return ProblemHandler.Companion.getNonAvailableFix();
            }
            PsiElement psiElement2 = element;
            Intrinsics.checkNotNull((Object)psiElement2);
            element = psiElement2.getParent();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Pair<IntentionAction[], TextRange> doSuggestFix(@NotNull PsiFile file2, @NotNull Document document, @NotNull LintIssue issue, int overrideLine) {
        Pair pair;
        block20: {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
            if (Intrinsics.areEqual((Object)issue.getText(), (Object)"non-wrapping format verb for fmt.Errorf. Use `%w` to format errors")) {
                pair = this.fixErrorfVerb(file2, document, issue, overrideLine);
            } else {
                if (Intrinsics.areEqual((Object)issue.getText(), (Object)"type assertion on error will fail on wrapped errors. Use errors.As to check for specific errors")) {
                    void issue$iv;
                    void document$iv;
                    void this_$iv;
                    void file$iv;
                    ProblemHandler problemHandler = this;
                    PsiFile psiFile = file2;
                    Document document2 = document;
                    LintIssue lintIssue = issue;
                    int overrideLine$iv = overrideLine;
                    boolean $i$f$chainFindAndHandle = false;
                    PsiElement element$iv = file$iv.findElementAt(ProblemHandler.access$calcPos((ProblemHandler)this_$iv, (Document)document$iv, (LintIssue)issue$iv, overrideLine$iv));
                    while (true) {
                        PsiElement psiElement;
                        if ((psiElement = element$iv) instanceof GoTypeAssertionExpr) {
                            GoTypeAssertionExpr element = (GoTypeAssertionExpr)element$iv;
                            boolean bl = false;
                            PsiElement parent = element.getParent();
                            if (parent instanceof GoShortVarDeclaration && ((GoShortVarDeclaration)parent).getVarDefinitionList().size() == 2) {
                                IntentionAction[] intentionActionArray = new IntentionAction[]{new GoErrorTypeAssertionFix(element, document.getLineStartOffset(overrideLine))};
                                pair = TuplesKt.to((Object)intentionActionArray, (Object)element.getTextRange());
                            } else {
                                pair = ProblemHandler.Companion.getNonAvailableFix();
                            }
                            break block20;
                        }
                        if (psiElement instanceof GoFile || psiElement == null) {
                            pair = ProblemHandler.Companion.getNonAvailableFix();
                            break block20;
                        }
                        element$iv = element$iv.getParent();
                    }
                }
                if (Intrinsics.areEqual((Object)issue.getText(), (Object)"switch on an error will fail on wrapped errors. Use errors.Is to check for specific errors")) {
                    ProblemHandler this_$iv = this;
                    PsiFile file$iv = file2;
                    Document document$iv = document;
                    LintIssue issue$iv = issue;
                    int overrideLine$iv = overrideLine;
                    boolean $i$f$chainFindAndHandle = false;
                    PsiElement element$iv = file$iv.findElementAt(ProblemHandler.access$calcPos(this_$iv, document$iv, issue$iv, overrideLine$iv));
                    while (true) {
                        PsiElement psiElement;
                        if ((psiElement = element$iv) instanceof GoSwitchStatement) {
                            GoSwitchStatement element = (GoSwitchStatement)element$iv;
                            boolean bl = false;
                            IntentionAction[] intentionActionArray = new IntentionAction[]{new GoBringToExplanationFix("https://golang.org/pkg/errors/#Is", "Example & Best practice")};
                            GoSwitchStart goSwitchStart = element.getSwitchStart();
                            pair = TuplesKt.to((Object)intentionActionArray, (Object)(goSwitchStart != null ? goSwitchStart.getTextRange() : null));
                            break block20;
                        }
                        if (psiElement instanceof GoFile || psiElement == null) {
                            pair = ProblemHandler.Companion.getNonAvailableFix();
                            break block20;
                        }
                        element$iv = element$iv.getParent();
                    }
                }
                if (Intrinsics.areEqual((Object)issue.getText(), (Object)"type switch on error will fail on wrapped errors. Use errors.As to check for specific errors")) {
                    ProblemHandler this_$iv = this;
                    PsiFile file$iv = file2;
                    Document document$iv = document;
                    LintIssue issue$iv = issue;
                    int overrideLine$iv = overrideLine;
                    boolean $i$f$chainFindAndHandle = false;
                    PsiElement element$iv = file$iv.findElementAt(ProblemHandler.access$calcPos(this_$iv, document$iv, issue$iv, overrideLine$iv));
                    while (true) {
                        PsiElement psiElement;
                        if ((psiElement = element$iv) instanceof GoSwitchStatement) {
                            GoSwitchStatement element = (GoSwitchStatement)element$iv;
                            boolean bl = false;
                            IntentionAction[] intentionActionArray = new IntentionAction[]{new GoBringToExplanationFix("https://golang.org/pkg/errors/#As", "Example & Best practice")};
                            GoSwitchStart goSwitchStart = element.getSwitchStart();
                            pair = TuplesKt.to((Object)intentionActionArray, (Object)(goSwitchStart != null ? goSwitchStart.getTextRange() : null));
                            break block20;
                        }
                        if (psiElement instanceof GoFile || psiElement == null) {
                            pair = ProblemHandler.Companion.getNonAvailableFix();
                            break block20;
                        }
                        element$iv = element$iv.getParent();
                    }
                }
                if (StringsKt.startsWith$default((String)issue.getText(), (String)"comparing with", (boolean)false, (int)2, null)) {
                    ProblemHandler this_$iv = this;
                    PsiFile file$iv = file2;
                    Document document$iv = document;
                    LintIssue issue$iv = issue;
                    int overrideLine$iv = overrideLine;
                    boolean $i$f$chainFindAndHandle = false;
                    PsiElement element$iv = file$iv.findElementAt(ProblemHandler.access$calcPos(this_$iv, document$iv, issue$iv, overrideLine$iv));
                    while (true) {
                        PsiElement psiElement;
                        if ((psiElement = element$iv) instanceof GoConditionalExpr) {
                            GoConditionalExpr element = (GoConditionalExpr)element$iv;
                            boolean bl = false;
                            IntentionAction[] intentionActionArray = new IntentionAction[]{new GoReplaceWithErrorsIsFix(element)};
                            pair = TuplesKt.to((Object)intentionActionArray, (Object)element.getTextRange());
                            break block20;
                        }
                        if (psiElement instanceof GoFile || psiElement == null) {
                            pair = ProblemHandler.Companion.getNonAvailableFix();
                            break block20;
                        }
                        element$iv = element$iv.getParent();
                    }
                }
                pair = ProblemHandler.Companion.getNonAvailableFix();
            }
        }
        return pair;
    }
}

