INSERT
into my_temporary_table (id, value_1, value_2, value_3, value_4)
values (26, 42+1, 42+2, 12345, 67890)
/


INSERT
into my_wide_table
values (get_last_id(),
        complex_expression_1 + complex_expression_2,
        long_expression_1 * long_expression_2 - long_expression_3)
/        


UPDATE my_staff_size
set id = id + 1,
    name = name || '.duplicate',
    note = note || ' (another one)',
    additional_note = 'Processed.',
    status = -1
where year between 1996 and 2017
  and (q1 > 0 or q4 = 20)
  and exists(select * from my_permission)
  and exists (select *
              from my_applicable_entry x
              where my_staff_size.id = x.id)
  and actual is not null
/


SELECT max(q4)
from my_staff_size
/

SELECT *
from my_staff_size
/


SELECT 2 * 2     -- the first expression
     , 42 - 26   -- the second expression
     , 26 + 42   -- one more expression
     , 999 + 888 -- the last one
  from dual
/  

SELECT 2 * 2,    -- the first expression
       42 - 26,  -- the second expression
       26 + 42,  -- one more expression
       999 + 888 -- the last one
  from dual
/  


SELECT d.dep_id, p.per_id,
       count(*) as per_cnt, max(m.actual) as has_actual_template
from department d join manager m on d.dep_id = m.dep_id
                  left join person p on m.per_id = p.per_id,
     message m left outer join mark mk on m.id = mk.msg_id
               left join template tp on m.template_id = tp.id
where d.dep_id = m.dep_1
group by d.dep_id, p.per_id
having count(*) >= 2
order by per_cnt desc
/


SELECT A.*
from Small_Table_1 A natural join Small_Table_2 B
                     natural join Small_Table_3 C
                     join Medium_Table_4 D using (Id)
                     left outer join Medium_Table_5 E on D.X = E.X
                     left outer join Medium_Table_6 F on E.Y = F.Y
                     inner join Medium_Table_7 G on F.Z = G.Z
/                     


SELECT A.*, D.*, H.*
from Small_Table_1 A natural join Small_Table_2 B natural join Small_Table_3 C,
     Medium_Table_4 D left outer join Medium_Table_5 E using (X)
                      left outer join Medium_Table_6 F using (Y)
                      inner join Medium_Table_7 G using (Z),
     Big_Table_8 H cross join (select 42 from dual) Z0
                   join another_table using (first_common_column, second_common_column)
/                   


SELECT (select 1 from dual where 1 is not null) x
from (select 1 from dual where 1 is not null) y
where (select true from dual where 1 is not null)
  and (select 1 from dual) in (select 1 from dual);


WITH O as (select id as org_id, name, description, another_field
           from all_organizations natural join all_names
           where status >= 1),
     P as (select id as per_id, name_0, name_1, name_2, name_3
           from all_personnel natural join all_names
           where status >= 1),
     C as (select org_id, per_id, note
           from all_contacts
           where status >= 1)
select O.*, P.*
from O, P, C
where O.org_id = C.org_id
  and P.per_id = C.per_id
order by P.name_0 asc, P.name_1 asc, P.name_2 asc, P.name_3 asc, P.per_id desc, O.org_id desc
/


WITH cte as (select 11 as a, 22 as b, 33 as c from dual)
select a as x
    from cte
    where 1 is not null
union
select b as x
    from cte
    where 2 is not null
union
select c as x
    from cte
    where 3 is not null
order by x
/


DELETE
from message
where dep_id not in (select dep_id from department where actual is not null)
/


CREATE VIEW tiny_view as SELECT id, name, note from dual
/

CREATE VIEW another_view 
as 
SELECT id, name, note 
from another_table
with check option
/

