/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.arsc;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.arsc.FlagsOffset;
import java.util.logging.Logger;

public class ARSCData {
    private static final Logger LOGGER = Logger.getLogger(ARSCData.class.getName());
    private final ResPackage[] mPackages;
    private final FlagsOffset[] mFlagsOffsets;

    public ARSCData(ResPackage[] pkgs, FlagsOffset[] flagsOffsets) {
        this.mPackages = pkgs;
        this.mFlagsOffsets = flagsOffsets;
    }

    public FlagsOffset[] getFlagsOffsets() {
        return this.mFlagsOffsets;
    }

    public ResPackage[] getPackages() {
        return this.mPackages;
    }

    public ResPackage getOnePackage() throws AndrolibException {
        if (this.mPackages.length == 0) {
            throw new AndrolibException("Arsc file contains zero packages");
        }
        if (this.mPackages.length != 1) {
            int id = this.findPackageWithMostResSpecs();
            LOGGER.info("Arsc file contains multiple packages. Using package " + this.mPackages[id].getName() + " as default.");
            return this.mPackages[id];
        }
        return this.mPackages[0];
    }

    public int findPackageWithMostResSpecs() {
        int count = this.mPackages[0].getResSpecCount();
        int id = 0;
        for (int i = 0; i < this.mPackages.length; ++i) {
            if (this.mPackages[i].getResSpecCount() < count) continue;
            count = this.mPackages[i].getResSpecCount();
            id = i;
        }
        return id;
    }
}

