/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.baksmali.Adaptors.Format;

import com.android.tools.smali.baksmali.Adaptors.Format.InstructionMethodItem;
import com.android.tools.smali.baksmali.Adaptors.LabelMethodItem;
import com.android.tools.smali.baksmali.Adaptors.MethodDefinition;
import com.android.tools.smali.baksmali.formatter.BaksmaliWriter;
import com.android.tools.smali.dexlib2.iface.instruction.SwitchElement;
import com.android.tools.smali.dexlib2.iface.instruction.formats.PackedSwitchPayload;
import com.android.tools.smali.dexlib2.immutable.value.ImmutableIntEncodedValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PackedSwitchMethodItem
extends InstructionMethodItem<PackedSwitchPayload> {
    private final List<PackedSwitchTarget> targets;
    private final int firstKey;
    private boolean commentedOut;

    public PackedSwitchMethodItem(MethodDefinition methodDef, int codeAddress, PackedSwitchPayload instruction) {
        super(methodDef, codeAddress, instruction);
        int baseCodeAddress = methodDef.getPackedSwitchBaseAddress(codeAddress);
        this.targets = new ArrayList<PackedSwitchTarget>();
        boolean first = true;
        int firstKey = 0;
        if (baseCodeAddress >= 0) {
            for (SwitchElement switchElement : instruction.getSwitchElements()) {
                if (first) {
                    firstKey = switchElement.getKey();
                    first = false;
                }
                LabelMethodItem label = methodDef.getLabelCache().internLabel(new LabelMethodItem(methodDef.classDef.options, baseCodeAddress + switchElement.getOffset(), "pswitch_"));
                this.targets.add(new PackedSwitchLabelTarget(label));
            }
        } else {
            this.commentedOut = true;
            for (SwitchElement switchElement : instruction.getSwitchElements()) {
                if (first) {
                    firstKey = switchElement.getKey();
                    first = false;
                }
                this.targets.add(new PackedSwitchOffsetTarget(switchElement.getOffset()));
            }
        }
        this.firstKey = firstKey;
    }

    @Override
    public boolean writeTo(BaksmaliWriter writer) throws IOException {
        if (this.commentedOut) {
            writer = this.methodDef.classDef.getCommentingWriter(writer);
        }
        writer.write(".packed-switch ");
        writer.writeEncodedValue(new ImmutableIntEncodedValue(this.firstKey));
        writer.indent(4);
        writer.write(10);
        int key = this.firstKey;
        for (PackedSwitchTarget target : this.targets) {
            target.writeTargetTo(writer);
            this.writeCommentIfResourceId(writer, key);
            writer.write(10);
            ++key;
        }
        writer.deindent(4);
        writer.write(".end packed-switch");
        return true;
    }

    private static class PackedSwitchOffsetTarget
    extends PackedSwitchTarget {
        private final int target;

        public PackedSwitchOffsetTarget(int target) {
            this.target = target;
        }

        @Override
        public void writeTargetTo(BaksmaliWriter writer) throws IOException {
            if (this.target >= 0) {
                writer.write(43);
            }
            writer.writeSignedIntAsDec(this.target);
        }
    }

    private static class PackedSwitchLabelTarget
    extends PackedSwitchTarget {
        private final LabelMethodItem target;

        public PackedSwitchLabelTarget(LabelMethodItem target) {
            this.target = target;
        }

        @Override
        public void writeTargetTo(BaksmaliWriter writer) throws IOException {
            this.target.writeTo(writer);
        }
    }

    private static abstract class PackedSwitchTarget {
        private PackedSwitchTarget() {
        }

        public abstract void writeTargetTo(BaksmaliWriter var1) throws IOException;
    }
}

