/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import brut.androlib.Config;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.meta.ApkInfo;
import brut.androlib.meta.SdkInfo;
import brut.androlib.res.AaptInvoker;
import brut.androlib.res.AaptManager;
import brut.androlib.res.data.ResChunkHeader;
import brut.androlib.res.xml.ResXmlUtils;
import brut.androlib.smali.SmaliBuilder;
import brut.common.BrutException;
import brut.common.Log;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import brut.directory.FileDirectory;
import brut.directory.ZipRODirectory;
import brut.util.BackgroundWorker;
import brut.util.BinaryDataInputStream;
import brut.util.BrutIO;
import brut.util.OS;
import brut.util.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipOutputStream;

public class ApkBuilder {
    private static final String TAG = ApkBuilder.class.getName();
    private final ExtFile mApkDir;
    private final Config mConfig;
    private final AtomicReference<AndrolibException> mFirstError;
    private ApkInfo mApkInfo;
    private SmaliBuilder mSmaliBuilder;
    private AaptInvoker mAaptInvoker;
    private BackgroundWorker mWorker;

    public ApkBuilder(File apkDir, Config config) {
        this.mApkDir = new ExtFile(apkDir);
        this.mConfig = config;
        this.mFirstError = new AtomicReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(File outApk) throws AndrolibException {
        if (this.mConfig.getJobs() > 1) {
            this.mWorker = new BackgroundWorker(this.mConfig.getJobs() - 1);
        }
        try {
            this.mApkInfo = ApkInfo.load(this.mApkDir);
            String minSdkVersion = this.mApkInfo.getSdkInfo().getMinSdkVersion();
            this.mSmaliBuilder = new SmaliBuilder(minSdkVersion != null ? SdkInfo.parseSdkInt(minSdkVersion) : 0);
            this.mAaptInvoker = new AaptInvoker(this.mApkInfo, this.mConfig);
            String apkName = this.mApkInfo.getApkFileName();
            if (apkName == null) {
                apkName = "out.apk";
            }
            if (this.mConfig.isNoApk()) {
                outApk = null;
            } else if (outApk == null) {
                outApk = new File(this.mApkDir, "dist/" + apkName);
            }
            File outDir = new File(this.mApkDir, "build/apk");
            OS.mkdir(outDir);
            Log.i(TAG, "Using Apktool " + this.mConfig.getVersion() + " on " + apkName + (this.mWorker != null ? " with " + this.mConfig.getJobs() + " threads" : ""));
            this.buildSources(outDir);
            this.buildResources(outDir);
            if (this.mWorker != null) {
                this.mWorker.waitForFinish();
                if (this.mFirstError.get() != null) {
                    throw this.mFirstError.get();
                }
            }
            this.copyOriginalFiles(outDir);
            if (outApk != null) {
                this.buildApkFile(outDir, outApk);
            }
        }
        finally {
            if (this.mWorker != null) {
                this.mWorker.shutdownNow();
            }
        }
    }

    private void buildSources(File outDir) throws AndrolibException {
        try {
            Directory in = this.mApkDir.getDirectory();
            HashSet<String> dexFiles = new HashSet<String>();
            for (String fileName : in.getFiles()) {
                if (!fileName.endsWith(".dex")) continue;
                this.copySourcesRaw(outDir, fileName);
                dexFiles.add(fileName);
            }
            for (String dirName : in.getDirs().keySet()) {
                String fileName;
                if (dirName.equals("smali")) {
                    fileName = "classes.dex";
                } else {
                    if (!dirName.startsWith("smali_")) continue;
                    fileName = dirName.substring(dirName.indexOf(95) + 1).replace('@', File.separatorChar) + ".dex";
                }
                if (dexFiles.contains(fileName)) continue;
                this.buildSourcesSmali(outDir, dirName, fileName);
            }
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void copySourcesRaw(File outDir, String fileName) throws AndrolibException {
        File inFile = new File(this.mApkDir, fileName);
        File outFile = new File(outDir, fileName);
        if (!this.mConfig.isForced() && !this.isFileNewer(inFile, outFile)) {
            Log.i(TAG, fileName + " has not changed.");
            return;
        }
        Log.i(TAG, "Copying raw " + fileName + "...");
        try {
            BrutIO.copyAndClose(Files.newInputStream(inFile.toPath(), new OpenOption[0]), Files.newOutputStream(outFile.toPath(), new OpenOption[0]));
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void buildSourcesSmali(File outDir, String dirName, String fileName) throws AndrolibException {
        if (this.mWorker != null) {
            this.mWorker.submit(() -> {
                if (this.mFirstError.get() == null) {
                    try {
                        this.buildSourcesSmaliJob(outDir, dirName, fileName);
                    }
                    catch (AndrolibException ex) {
                        this.mFirstError.compareAndSet(null, ex);
                    }
                }
            });
        } else {
            this.buildSourcesSmaliJob(outDir, dirName, fileName);
        }
    }

    private void buildSourcesSmaliJob(File outDir, String dirName, String fileName) throws AndrolibException {
        File smaliDir = new File(this.mApkDir, dirName);
        File dexFile = new File(outDir, fileName);
        if (!this.mConfig.isForced() && !this.isFileNewer(smaliDir, dexFile)) {
            Log.i(TAG, dirName + " has not changed.");
            return;
        }
        Log.i(TAG, "Smaling " + dirName + " folder into " + fileName + "...");
        this.mSmaliBuilder.build(smaliDir, dexFile);
    }

    private void buildResources(File outDir) throws AndrolibException {
        File arscFile;
        boolean isBinaryManifest;
        File manifest = new File(this.mApkDir, "AndroidManifest.xml");
        if (!manifest.isFile()) {
            return;
        }
        try (BinaryDataInputStream in = new BinaryDataInputStream(Files.newInputStream(manifest.toPath(), new OpenOption[0]));){
            isBinaryManifest = ResChunkHeader.read((BinaryDataInputStream)in).type == 3;
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
        if (isBinaryManifest) {
            this.copyManifestRaw(outDir, manifest);
        }
        if ((arscFile = new File(this.mApkDir, "resources.arsc")).isFile()) {
            this.copyResourcesRaw(outDir, arscFile);
            return;
        }
        if (isBinaryManifest) {
            return;
        }
        File resDir = new File(this.mApkDir, "res");
        if (!resDir.isDirectory()) {
            this.buildManifestOnly(outDir, manifest);
            return;
        }
        this.buildResourcesFully(outDir, manifest, resDir);
    }

    private void copyManifestRaw(File outDir, File manifest) throws AndrolibException {
        if (!this.mConfig.isForced() && !this.isFileNewer(manifest, new File(outDir, "AndroidManifest.xml"))) {
            Log.i(TAG, "AndroidManifest.xml has not changed.");
            return;
        }
        Log.i(TAG, "Copying raw AndroidManifest.xml...");
        try {
            Directory in = this.mApkDir.getDirectory();
            in.copyToDir(outDir, "AndroidManifest.xml");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void copyResourcesRaw(File outDir, File arscFile) throws AndrolibException {
        if (!this.mConfig.isForced() && !this.isFileNewer(arscFile, new File(outDir, "resources.arsc"))) {
            Log.i(TAG, "resources.arsc has not changed.");
            return;
        }
        Log.i(TAG, "Copying raw resources.arsc...");
        try {
            Directory in = this.mApkDir.getDirectory();
            in.copyToDir(outDir, "resources.arsc");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void buildManifestOnly(File outDir, File manifest) throws AndrolibException {
        File tmpFile;
        if (!this.mConfig.isForced() && !this.isFileNewer(manifest, new File(outDir, "AndroidManifest.xml"))) {
            Log.i(TAG, "AndroidManifest.xml has not changed.");
            return;
        }
        File manifestOrig = new File(manifest.getPath() + ".orig");
        try {
            OS.cpfile(manifest, manifestOrig);
        }
        catch (BrutException ex) {
            throw new AndrolibException(ex);
        }
        ResXmlUtils.fixingPublicAttrsInProviderAttributes(manifest);
        if (this.mConfig.isDebuggable()) {
            Log.i(TAG, "Setting 'debuggable' attribute to 'true' in AndroidManifest.xml...");
            ResXmlUtils.setApplicationDebugTagTrue(manifest);
        }
        try {
            tmpFile = File.createTempFile("APKTOOL", null);
            OS.rmfile(tmpFile);
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
        Log.i(TAG, "Building AndroidManifest.xml with " + AaptManager.getBinaryName() + "...");
        this.mAaptInvoker.invoke(tmpFile, manifest, null);
        try (ZipRODirectory tmpDir = new ZipRODirectory(tmpFile);){
            tmpDir.copyToDir(outDir, "AndroidManifest.xml");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
        finally {
            OS.rmfile(tmpFile);
        }
        try {
            OS.mvfile(manifestOrig, manifest);
        }
        catch (BrutException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void buildResourcesFully(File outDir, File manifest, File resDir) throws AndrolibException {
        File tmpFile;
        if (!(this.mConfig.isForced() || this.isFileNewer(manifest, new File(outDir, "AndroidManifest.xml")) || this.isFileNewer(resDir, new File(outDir, "res")))) {
            Log.i(TAG, "AndroidManifest.xml and resources have not changed.");
            return;
        }
        File manifestOrig = new File(manifest.getPath() + ".orig");
        try {
            OS.cpfile(manifest, manifestOrig);
        }
        catch (BrutException ex) {
            throw new AndrolibException(ex);
        }
        ResXmlUtils.fixingPublicAttrsInProviderAttributes(manifest);
        if (this.mConfig.isDebuggable()) {
            Log.i(TAG, "Setting 'debuggable' attribute to 'true' in AndroidManifest.xml...");
            ResXmlUtils.setApplicationDebugTagTrue(manifest);
        }
        if (this.mConfig.isNetSecConf()) {
            Log.i(TAG, "Adding permissive network security config in manifest...");
            File netSecConfOrig = new File(this.mApkDir, "res/xml/network_security_config.xml");
            OS.mkdir(netSecConfOrig.getParentFile());
            ResXmlUtils.modNetworkSecurityConfig(netSecConfOrig);
            ResXmlUtils.setNetworkSecurityConfig(manifest);
            String targetSdkVersion = this.mApkInfo.getSdkInfo().getTargetSdkVersion();
            if (targetSdkVersion != null && SdkInfo.parseSdkInt(targetSdkVersion) < 24) {
                Log.w(TAG, "Target SDK version is lower than 24, Network Security Configuration might be ignored!");
            }
        }
        try {
            tmpFile = File.createTempFile("APKTOOL", null);
            OS.rmfile(tmpFile);
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
        Log.i(TAG, "Building resources with " + AaptManager.getBinaryName() + "...");
        this.mAaptInvoker.invoke(tmpFile, manifest, resDir);
        try (ZipRODirectory tmpDir = new ZipRODirectory(tmpFile);){
            tmpDir.copyToDir(outDir, "AndroidManifest.xml", "resources.arsc", "res");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
        finally {
            OS.rmfile(tmpFile);
        }
        try {
            OS.mvfile(manifestOrig, manifest);
        }
        catch (BrutException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void copyOriginalFiles(File outDir) throws AndrolibException {
        if (!this.mConfig.isCopyOriginal()) {
            return;
        }
        File originalDir = new File(this.mApkDir, "original");
        if (!originalDir.isDirectory()) {
            return;
        }
        Log.i(TAG, "Copying original files...");
        try {
            FileDirectory in = new FileDirectory(originalDir);
            for (String fileName : in.getFiles(true)) {
                if (!ApkInfo.ORIGINAL_FILES_PATTERN.matcher(fileName).matches()) continue;
                in.copyToDir(outDir, fileName);
            }
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void buildApkFile(File outDir, File outApk) throws AndrolibException {
        if (outApk.exists()) {
            OS.rmfile(outApk);
        } else {
            File parentDir = outApk.getParentFile();
            if (parentDir != null) {
                OS.mkdir(parentDir);
            }
        }
        HashSet<String> doNotCompress = new HashSet<String>(this.mApkInfo.getDoNotCompress());
        Log.i(TAG, "Building apk file...");
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(outApk.toPath(), new OpenOption[0]));){
            ZipUtils.zipDir(outDir, out, doNotCompress);
            for (String dirName : ApkInfo.RAW_DIRS) {
                File rawDir = new File(this.mApkDir, dirName);
                if (!rawDir.isDirectory()) continue;
                Log.i(TAG, "Importing " + dirName + "...");
                ZipUtils.zipDir(this.mApkDir, dirName, out, doNotCompress);
            }
            File unknownDir = new File(this.mApkDir, "unknown");
            if (unknownDir.isDirectory()) {
                Log.i(TAG, "Importing unknown files...");
                ZipUtils.zipDir(unknownDir, out, doNotCompress);
            }
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
        Log.i(TAG, "Built apk into: " + outApk.getPath());
    }

    private boolean isFileNewer(File file, File reference) {
        return !reference.exists() || BrutIO.recursiveModifiedTime(file) > BrutIO.recursiveModifiedTime(reference);
    }
}

