/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.meta;

import brut.yaml.YamlLine;
import brut.yaml.YamlReader;
import brut.yaml.YamlSerializable;
import brut.yaml.YamlWriter;

public class ResourcesInfo
implements YamlSerializable {
    private Integer mPackageId;
    private String mPackageName;
    private Boolean mSparseEntries;
    private Boolean mCompactEntries;
    private Boolean mKeepRawValues;

    public ResourcesInfo() {
        this.clear();
    }

    public void clear() {
        this.mPackageId = null;
        this.mPackageName = null;
        this.mSparseEntries = null;
        this.mCompactEntries = null;
        this.mKeepRawValues = null;
    }

    public boolean isEmpty() {
        return this.mPackageId == null && this.mPackageName == null && this.mSparseEntries == null && this.mCompactEntries == null && this.mKeepRawValues == null;
    }

    @Override
    public void readItem(YamlReader reader) {
        YamlLine line = reader.getLine();
        switch (line.getKey()) {
            case "packageId": {
                this.mPackageId = line.getValueInt();
                break;
            }
            case "packageName": {
                this.mPackageName = line.getValue();
                break;
            }
            case "sparseEntries": {
                this.mSparseEntries = line.getValueBool();
                break;
            }
            case "compactEntries": {
                this.mCompactEntries = line.getValueBool();
                break;
            }
            case "keepRawValues": {
                this.mKeepRawValues = line.getValueBool();
            }
        }
    }

    @Override
    public void write(YamlWriter writer) {
        if (this.mPackageId != null) {
            writer.writeInt("packageId", this.mPackageId);
        }
        if (this.mPackageName != null) {
            writer.writeString("packageName", this.mPackageName);
        }
        if (this.mSparseEntries != null) {
            writer.writeBool("sparseEntries", this.mSparseEntries);
        }
        if (this.mCompactEntries != null) {
            writer.writeBool("compactEntries", this.mCompactEntries);
        }
        if (this.mKeepRawValues != null) {
            writer.writeBool("keepRawValues", this.mKeepRawValues);
        }
    }

    public int getPackageId() {
        return this.mPackageId != null ? this.mPackageId : -1;
    }

    public void setPackageId(int packageId) {
        this.mPackageId = packageId;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public void setPackageName(String packageName) {
        this.mPackageName = packageName;
    }

    public boolean isSparseEntries() {
        return this.mSparseEntries != null ? this.mSparseEntries : false;
    }

    public void setSparseEntries(boolean sparseEntries) {
        this.mSparseEntries = sparseEntries;
    }

    public boolean isCompactEntries() {
        return this.mCompactEntries != null ? this.mCompactEntries : false;
    }

    public void setCompactEntries(boolean compactEntries) {
        this.mCompactEntries = compactEntries;
    }

    public boolean isKeepRawValues() {
        return this.mKeepRawValues != null ? this.mKeepRawValues : false;
    }

    public void setKeepRawValues(boolean keepRawValues) {
        this.mKeepRawValues = keepRawValues;
    }
}

