/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.res.data.StyledString;
import brut.androlib.res.decoder.ResChunkPullParser;
import brut.common.Log;
import brut.util.BinaryDataInputStream;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class ResStringPool {
    private static final String TAG = ResStringPool.class.getName();
    private static final CharsetDecoder UTF16LE_DECODER = StandardCharsets.UTF_16LE.newDecoder();
    private static final CharsetDecoder UTF8_DECODER = StandardCharsets.UTF_8.newDecoder();
    private static final CharsetDecoder CESU8_DECODER = Charset.forName("CESU8").newDecoder();
    private static final int UTF8_FLAG = 256;
    private static final int HEADER_SIZE = 28;
    private final int[] mStringOffsets;
    private final byte[] mStrings;
    private final int[] mStyleOffsets;
    private final int[] mStyles;
    private final boolean mIsUtf8;

    private ResStringPool(int[] stringOffsets, byte[] strings, int[] styleOffsets, int[] styles, boolean isUtf8) {
        this.mStringOffsets = stringOffsets;
        this.mStrings = strings;
        this.mStyleOffsets = styleOffsets;
        this.mStyles = styles;
        this.mIsUtf8 = isUtf8;
    }

    @VisibleForTesting
    ResStringPool(byte[] strings, boolean isUtf8) {
        this(new int[0], strings, new int[0], new int[0], isUtf8);
    }

    public static ResStringPool parse(ResChunkPullParser parser) throws IOException {
        int[] styles;
        BinaryDataInputStream in = parser.stream();
        int stringCount = in.readInt();
        int styleCount = in.readInt();
        int flags = in.readInt();
        int stringsOffset = in.readInt();
        int stylesOffset = in.readInt();
        int skipped = parser.skipHeader();
        if (skipped > 0) {
            Log.d(TAG, "Skipped unknown %s bytes at end of %s chunk header.", skipped, parser.chunkName());
        }
        int[] stringOffsets = ResStringPool.readIntArraySafe(in, stringCount, parser.chunkStart() + (long)stringsOffset);
        int[] styleOffsets = ResStringPool.readIntArraySafe(in, styleCount, parser.chunkStart() + (long)stylesOffset);
        int size = parser.chunkSize() - stringsOffset;
        if (styleCount > 0) {
            size = stylesOffset - stringsOffset;
        }
        byte[] strings = in.readBytes(size);
        if (stylesOffset > 0 && styleCount > 0) {
            size = parser.chunkSize() - stylesOffset;
            styles = in.readIntArray(size / 4);
        } else {
            styles = new int[]{};
        }
        in.skipBytes(size % 4);
        boolean isUtf8 = (flags & 0x100) != 0;
        return new ResStringPool(stringOffsets, strings, styleOffsets, styles, isUtf8);
    }

    private static int[] readIntArraySafe(BinaryDataInputStream in, int len, long maxPosition) throws IOException {
        int[] arr = new int[len];
        for (int i = 0; i < len; ++i) {
            if (in.position() >= maxPosition) {
                Log.d(TAG, "Bad string block: string entry is at %s, past end at %s", in.position(), maxPosition);
                return arr;
            }
            arr[i] = in.readInt();
        }
        return arr;
    }

    public CharSequence getText(int index) {
        String string = this.getString(index);
        if (string == null) {
            return null;
        }
        int[] style = this.getStyle(index);
        if (style == null) {
            return string;
        }
        int len = string.length();
        StyledString.Span[] spans = new StyledString.Span[style.length / 3];
        int spansCount = 0;
        for (int i = 0; i < style.length; i += 3) {
            String tag = this.getString(style[i]);
            int firstChar = style[i + 1];
            int lastChar = style[i + 2];
            if (firstChar < 0 || firstChar > len || lastChar > len) continue;
            spans[spansCount++] = new StyledString.Span(tag, firstChar, lastChar);
        }
        if (spansCount < spans.length) {
            spans = Arrays.copyOf(spans, spansCount);
        }
        return new StyledString(string, spans);
    }

    public String getString(int index) {
        int[] val;
        if (index < 0 || index >= this.mStringOffsets.length || this.mStrings.length == 0) {
            return null;
        }
        int offset = this.mStringOffsets[index];
        if (this.mIsUtf8) {
            val = ResStringPool.getUtf8(this.mStrings, offset);
            offset = val[0];
        } else {
            val = ResStringPool.getUtf16(this.mStrings, offset);
            offset += val[0];
        }
        int length = val[1];
        return this.decodeString(offset, length);
    }

    @VisibleForTesting
    String decodeString(int offset, int length) {
        block6: {
            try {
                ByteBuffer buffer = ByteBuffer.wrap(this.mStrings, offset, length);
                return (this.mIsUtf8 ? UTF8_DECODER : UTF16LE_DECODER).decode(buffer).toString();
            }
            catch (CharacterCodingException ignored) {
                if (!this.mIsUtf8) {
                    Log.w(TAG, "Failed to decode a string at offset %s of length %s", offset, length);
                    return null;
                }
            }
            catch (IndexOutOfBoundsException ignored) {
                if (this.mIsUtf8) break block6;
                Log.w(TAG, "String extends outside of pool at %s of length %s", offset, length);
                return null;
            }
        }
        try {
            ByteBuffer buffer = ByteBuffer.wrap(this.mStrings, offset, length);
            return CESU8_DECODER.decode(buffer).toString();
        }
        catch (CharacterCodingException ignored) {
            Log.w(TAG, "Failed to decode a string with CESU-8 decoder.");
            return null;
        }
    }

    public int findString(String string) {
        if (string == null || this.mStringOffsets.length == 0 || this.mStrings.length == 0) {
            return -1;
        }
        int len = string.length();
        for (int i = 0; i < this.mStringOffsets.length; ++i) {
            int j;
            int offset = this.mStringOffsets[i];
            int length = ResStringPool.getShort(this.mStrings, offset);
            if (length != len) continue;
            for (j = 0; j < length && string.charAt(j) == ResStringPool.getShort(this.mStrings, offset += 2); ++j) {
            }
            if (j != length) continue;
            return i;
        }
        return -1;
    }

    private int[] getStyle(int index) {
        if (index < 0 || index >= this.mStyleOffsets.length || this.mStyles.length == 0) {
            return null;
        }
        int offset = this.mStyleOffsets[index] / 4;
        int count = 0;
        int i = offset;
        while (i + 2 < this.mStyles.length && this.mStyles[i] >= 0) {
            ++count;
            i += 3;
        }
        if (count == 0) {
            return null;
        }
        int[] style = new int[count * 3];
        System.arraycopy(this.mStyles, offset, style, 0, style.length);
        return style;
    }

    private static int getShort(byte[] array, int offset) {
        return (array[offset + 1] & 0xFF) << 8 | array[offset] & 0xFF;
    }

    private static int[] getUtf8(byte[] array, int offset) {
        int length;
        int val = array[offset];
        offset = (val & 0x80) != 0 ? (offset += 2) : ++offset;
        val = array[offset];
        ++offset;
        if ((val & 0x80) != 0) {
            int low = array[offset] & 0xFF;
            length = ((val & 0x7F) << 8) + low;
        } else {
            length = val;
        }
        return new int[]{++offset, length};
    }

    private static int[] getUtf16(byte[] array, int offset) {
        int val = (array[offset + 1] & 0xFF) << 8 | array[offset] & 0xFF;
        if ((val & 0x8000) != 0) {
            int high = (array[offset + 3] & 0xFF) << 8;
            int low = array[offset + 2] & 0xFF;
            int len_value = ((val & Short.MAX_VALUE) << 16) + high + low;
            return new int[]{4, len_value * 2};
        }
        return new int[]{2, val * 2};
    }
}

