/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.meta.ApkInfo;
import brut.androlib.meta.ResourcesInfo;
import brut.androlib.meta.SdkInfo;
import brut.androlib.meta.VersionInfo;
import brut.xmlpull.XmlPullUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class ManifestPullEventHandler
implements XmlPullUtils.EventHandler {
    private final ApkInfo mApkInfo;
    private final boolean mHideSdkInfo;

    public ManifestPullEventHandler(ApkInfo apkInfo, boolean hideSdkInfo) {
        this.mApkInfo = apkInfo;
        this.mHideSdkInfo = hideSdkInfo;
    }

    @Override
    public boolean onEvent(XmlPullParser in, XmlSerializer out) throws XmlPullParserException {
        String name;
        int type = in.getEventType();
        if (type == 2) {
            String name2 = in.getName();
            if (name2.equals("manifest")) {
                this.parseManifest(in);
            } else if (name2.equals("uses-sdk")) {
                this.parseUsesSdk(in);
                if (this.mHideSdkInfo) {
                    return true;
                }
            }
        } else if (type == 3 && (name = in.getName()).equals("uses-sdk") && this.mHideSdkInfo) {
            return true;
        }
        return false;
    }

    private void parseManifest(XmlPullParser in) {
        ResourcesInfo resourcesInfo = this.mApkInfo.getResourcesInfo();
        VersionInfo versionInfo = this.mApkInfo.getVersionInfo();
        block8: for (int i = 0; i < in.getAttributeCount(); ++i) {
            String ns = in.getAttributeNamespace(i);
            String name = in.getAttributeName(i);
            String value = in.getAttributeValue(i);
            if (value.isEmpty()) continue;
            if (ns.isEmpty()) {
                if (!name.equals("package")) continue;
                resourcesInfo.setPackageName(value);
                continue;
            }
            if (!ns.equals("http://schemas.android.com/apk/res/android")) continue;
            switch (name) {
                case "versionCode": {
                    versionInfo.setVersionCode(Integer.parseInt(value));
                    continue block8;
                }
                case "versionName": {
                    versionInfo.setVersionName(value);
                }
            }
        }
    }

    private void parseUsesSdk(XmlPullParser in) {
        SdkInfo sdkInfo = this.mApkInfo.getSdkInfo();
        block10: for (int i = 0; i < in.getAttributeCount(); ++i) {
            String ns = in.getAttributeNamespace(i);
            String name = in.getAttributeName(i);
            String value = in.getAttributeValue(i);
            if (value.isEmpty() || !ns.equals("http://schemas.android.com/apk/res/android")) continue;
            switch (name) {
                case "minSdkVersion": {
                    sdkInfo.setMinSdkVersion(value);
                    continue block10;
                }
                case "targetSdkVersion": {
                    sdkInfo.setTargetSdkVersion(value);
                    continue block10;
                }
                case "maxSdkVersion": {
                    sdkInfo.setMaxSdkVersion(value);
                }
            }
        }
    }
}

