/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.RawXmlEncounteredException;
import brut.androlib.res.decoder.BinaryXmlResourceParser;
import brut.androlib.res.decoder.ResStreamDecoder;
import brut.androlib.res.xml.ResXmlSerializer;
import brut.xmlpull.XmlPullUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xmlpull.v1.XmlPullParserException;

public class ResXmlPullStreamDecoder
implements ResStreamDecoder {
    private final BinaryXmlResourceParser mParser;
    private final ResXmlSerializer mSerial;
    private final XmlPullUtils.EventHandler mHandler;

    public ResXmlPullStreamDecoder(BinaryXmlResourceParser parser, ResXmlSerializer serial) {
        this(parser, serial, null);
    }

    public ResXmlPullStreamDecoder(BinaryXmlResourceParser parser, ResXmlSerializer serial, XmlPullUtils.EventHandler handler) {
        this.mParser = parser;
        this.mSerial = serial;
        this.mHandler = handler;
    }

    @Override
    public void decode(InputStream in, OutputStream out) throws AndrolibException {
        try {
            this.mParser.setInput(in, null);
            this.mSerial.setOutput(out, null);
            XmlPullUtils.copy(this.mParser, this.mSerial, this.mHandler);
        }
        catch (XmlPullParserException ex) {
            throw new RawXmlEncounteredException(ex);
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
    }
}

