/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.table;

import java.util.HashMap;
import java.util.Map;

public class ResId
extends Number
implements Comparable<ResId> {
    public static final ResId NULL = new ResId(0);
    private static final Map<Integer, ResId> sCache = new HashMap<Integer, ResId>();
    private final int mId;

    private ResId(int id) {
        this.mId = id;
    }

    public static ResId of(int id) {
        return id != 0 ? sCache.computeIfAbsent(id, ResId::new) : NULL;
    }

    public static ResId of(int pkgId, int typeId, int entryId) {
        assert ((pkgId & 0xFF) == pkgId && (typeId & 0xFF) == typeId && (entryId & 0xFFFF) == entryId);
        return ResId.of(pkgId << 24 | typeId << 16 | entryId);
    }

    public int pkgId() {
        return this.mId >>> 24 & 0xFF;
    }

    public int typeId() {
        return this.mId >>> 16 & 0xFF;
    }

    public int entryId() {
        return this.mId & 0xFFFF;
    }

    @Override
    public int intValue() {
        return this.mId;
    }

    @Override
    public long longValue() {
        return this.mId;
    }

    @Override
    public float floatValue() {
        return this.mId;
    }

    @Override
    public double doubleValue() {
        return this.mId;
    }

    public String toString() {
        return String.format("0x%08x", this.mId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResId) {
            ResId other = (ResId)obj;
            return this.mId == other.mId;
        }
        return false;
    }

    public int hashCode() {
        return Integer.hashCode(this.mId);
    }

    @Override
    public int compareTo(ResId other) {
        return Integer.compare(this.mId, other.mId);
    }
}

