/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.table;

import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.res.table.ResConfig;
import brut.androlib.res.table.ResEntry;
import brut.androlib.res.table.ResEntrySpec;
import brut.androlib.res.table.ResPackage;
import brut.androlib.res.table.ResTable;
import brut.androlib.res.table.ResType;
import brut.androlib.res.table.ResTypeSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

public class ResPackageGroup {
    private final ResTable mTable;
    private final int mId;
    private final String mName;
    private final List<ResPackage> mPackages;

    public ResPackageGroup(ResTable table, int id, String name) {
        assert (table != null && id >= 0 && name != null);
        this.mTable = table;
        this.mId = id;
        this.mName = name;
        this.mPackages = new ArrayList<ResPackage>();
        this.mPackages.add(new ResPackage(this, 0));
    }

    public ResTable getTable() {
        return this.mTable;
    }

    public int getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public int getPackageCount() {
        return this.mPackages.size();
    }

    public Collection<ResPackage> listPackages() {
        return this.mPackages;
    }

    public ResPackage getBasePackage() {
        return this.mPackages.get(0);
    }

    public Collection<ResPackage> listSubPackages() {
        return this.mPackages.subList(1, this.mPackages.size());
    }

    public ResPackage addSubPackage() {
        ResPackage pkg = new ResPackage(this, this.mPackages.size());
        this.mPackages.add(pkg);
        return pkg;
    }

    public boolean hasTypeSpec(int typeId) {
        for (ResPackage pkg : this.mPackages) {
            if (!pkg.hasTypeSpec(typeId)) continue;
            return true;
        }
        return false;
    }

    public ResTypeSpec getTypeSpec(int typeId) throws UndefinedResObjectException {
        for (ResPackage pkg : this.mPackages) {
            try {
                return pkg.getTypeSpec(typeId);
            }
            catch (UndefinedResObjectException undefinedResObjectException) {
            }
        }
        throw new UndefinedResObjectException(String.format("type spec: pkgId=0x%02x, typeId=0x%02x", this.mId, typeId));
    }

    public boolean hasType(int typeId) {
        return this.hasType(typeId, ResConfig.DEFAULT);
    }

    public boolean hasType(int typeId, ResConfig config) {
        for (ResPackage pkg : this.mPackages) {
            if (!pkg.hasType(typeId, config)) continue;
            return true;
        }
        return false;
    }

    public ResType getType(int typeId) throws UndefinedResObjectException {
        return this.getType(typeId, ResConfig.DEFAULT);
    }

    public ResType getType(int typeId, ResConfig config) throws UndefinedResObjectException {
        for (ResPackage pkg : this.mPackages) {
            try {
                return pkg.getType(typeId, config);
            }
            catch (UndefinedResObjectException undefinedResObjectException) {
            }
        }
        throw new UndefinedResObjectException(String.format("type: pkgId=0x%02x, typeId=0x%02x, config=%s", this.mId, typeId, config));
    }

    public boolean hasEntrySpec(int typeId, int entryId) {
        for (ResPackage pkg : this.mPackages) {
            if (!pkg.hasEntrySpec(typeId, entryId)) continue;
            return true;
        }
        return false;
    }

    public ResEntrySpec getEntrySpec(int typeId, int entryId) throws UndefinedResObjectException {
        for (ResPackage pkg : this.mPackages) {
            try {
                return pkg.getEntrySpec(typeId, entryId);
            }
            catch (UndefinedResObjectException undefinedResObjectException) {
            }
        }
        throw new UndefinedResObjectException(String.format("entry spec: pkgId=0x%02x, typeId=0x%02x, entryId=0x%04x", this.mId, typeId, entryId));
    }

    public Iterable<ResEntrySpec> listEntrySpecs() {
        return () -> new Iterator<ResEntrySpec>(){
            private Iterator<ResEntrySpec> current = Collections.emptyIterator();
            private int index = 0;

            @Override
            public boolean hasNext() {
                while (!this.current.hasNext() && this.index < ResPackageGroup.this.mPackages.size()) {
                    this.current = ((ResPackage)ResPackageGroup.this.mPackages.get(this.index++)).listEntrySpecs().iterator();
                }
                return this.current.hasNext();
            }

            @Override
            public ResEntrySpec next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.current.next();
            }
        };
    }

    public boolean hasEntry(int typeId, int entryId) {
        return this.hasEntry(typeId, entryId, ResConfig.DEFAULT);
    }

    public boolean hasEntry(int typeId, int entryId, ResConfig config) {
        for (ResPackage pkg : this.mPackages) {
            if (!pkg.hasEntry(typeId, entryId, config)) continue;
            return true;
        }
        return false;
    }

    public ResEntry getEntry(int typeId, int entryId) throws UndefinedResObjectException {
        return this.getEntry(typeId, entryId, ResConfig.DEFAULT);
    }

    public ResEntry getEntry(int typeId, int entryId, ResConfig config) throws UndefinedResObjectException {
        for (ResPackage pkg : this.mPackages) {
            try {
                return pkg.getEntry(typeId, entryId, config);
            }
            catch (UndefinedResObjectException undefinedResObjectException) {
            }
        }
        throw new UndefinedResObjectException(String.format("entry: pkgId=0x%02x, typeId=0x%02x, entryId=0x%04x, config=%s", this.mId, typeId, entryId, config));
    }

    public Iterable<ResEntry> listEntries() {
        return () -> new Iterator<ResEntry>(){
            private Iterator<ResEntry> current = Collections.emptyIterator();
            private int index = 0;

            @Override
            public boolean hasNext() {
                while (!this.current.hasNext() && this.index < ResPackageGroup.this.mPackages.size()) {
                    this.current = ((ResPackage)ResPackageGroup.this.mPackages.get(this.index++)).listEntries().iterator();
                }
                return this.current.hasNext();
            }

            @Override
            public ResEntry next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.current.next();
            }
        };
    }

    public String toString() {
        return String.format("ResPackageGroup{id=0x%02x, name=%s}", this.mId, this.mName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResPackageGroup) {
            ResPackageGroup other = (ResPackageGroup)obj;
            return this.mId == other.mId && this.mName.equals(other.mName);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mId, this.mName);
    }
}

