/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.table;

import brut.androlib.Config;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.meta.ApkInfo;
import brut.androlib.res.Framework;
import brut.androlib.res.decoder.BinaryResourceParser;
import brut.androlib.res.table.ResEntry;
import brut.androlib.res.table.ResEntrySpec;
import brut.androlib.res.table.ResId;
import brut.androlib.res.table.ResPackage;
import brut.androlib.res.table.ResPackageGroup;
import brut.common.Log;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import brut.directory.ZipRODirectory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ResTable {
    private static final String TAG = ResTable.class.getName();
    public static final int SYS_PACKAGE_ID = 1;
    public static final int APP_PACKAGE_ID = 127;
    private final ApkInfo mApkInfo;
    private final Config mConfig;
    private final Map<Integer, ResPackageGroup> mPackageGroups;
    private final List<Integer> mLibPackageIds;
    private final List<Integer> mFramePackageIds;
    private final Map<Integer, String> mDynamicRefTable;
    private int mNextPackageId;
    private ResPackage mMainPackage;

    public ResTable(ApkInfo apkInfo, Config config) {
        assert (apkInfo != null && config != null);
        this.mApkInfo = apkInfo;
        this.mConfig = config;
        this.mPackageGroups = new LinkedHashMap<Integer, ResPackageGroup>();
        this.mLibPackageIds = new ArrayList<Integer>();
        this.mFramePackageIds = new ArrayList<Integer>();
        this.mDynamicRefTable = new LinkedHashMap<Integer, String>();
        this.mNextPackageId = 2;
    }

    public ApkInfo getApkInfo() {
        return this.mApkInfo;
    }

    public Config getConfig() {
        return this.mConfig;
    }

    public ResPackage getMainPackage() {
        return this.mMainPackage;
    }

    public Collection<Integer> getLibPackageIds() {
        return this.mLibPackageIds;
    }

    public Collection<Integer> getFramePackageIds() {
        return this.mFramePackageIds;
    }

    public void load() throws AndrolibException {
        ResPackageGroup pkgGroup;
        ZipRODirectory zipDir;
        if (this.mMainPackage != null) {
            return;
        }
        Log.i(TAG, "Loading resource table...");
        ExtFile apkFile = this.mApkInfo.getApkFile();
        try {
            zipDir = (ZipRODirectory)apkFile.getDirectory();
        }
        catch (DirectoryException ex) {
            throw new AndrolibException("Could not open apk file: " + apkFile, ex);
        }
        this.loadPackagesFromApk(apkFile, zipDir, true);
        if (this.mPackageGroups.isEmpty()) {
            pkgGroup = new ResPackageGroup(this, 0, "");
            this.mPackageGroups.put(0, pkgGroup);
        } else {
            pkgGroup = this.mPackageGroups.containsKey(127) ? this.mPackageGroups.get(127) : this.mPackageGroups.values().iterator().next();
        }
        this.mMainPackage = pkgGroup.getBasePackage();
    }

    private void loadPackagesFromApk(File apkFile, ZipRODirectory zipDir, boolean isMainPackage) throws AndrolibException {
        try {
            if (!zipDir.containsFile("resources.arsc")) {
                throw new AndrolibException("Could not find resources.arsc in file: " + apkFile);
            }
            try (InputStream in = zipDir.getFileInput("resources.arsc");){
                BinaryResourceParser parser = isMainPackage ? new BinaryResourceParser(this, this.mConfig.isKeepBrokenResources(), this.mConfig.isDecodeResolveGreedy()) : new BinaryResourceParser(this, true, true);
                parser.parse(in);
                if (isMainPackage) {
                    if (parser.isSparseEntries()) {
                        this.mApkInfo.getResourcesInfo().setSparseEntries(true);
                    }
                    if (parser.isCompactEntries()) {
                        this.mApkInfo.getResourcesInfo().setCompactEntries(true);
                    }
                }
            }
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException("Could not load resources.arsc from file: " + apkFile, ex);
        }
    }

    public boolean hasPackageGroup(int id) {
        return this.mPackageGroups.containsKey(id);
    }

    public ResPackageGroup getPackageGroup(int id) throws UndefinedResObjectException {
        ResPackageGroup pkgGroup = this.mPackageGroups.get(id);
        if (pkgGroup == null) {
            throw new UndefinedResObjectException(String.format("package group: id=0x%02x", id));
        }
        return pkgGroup;
    }

    public ResPackageGroup addPackageGroup(int id, String name) throws AndrolibException {
        ResPackageGroup pkgGroup = this.mPackageGroups.get(id);
        if (pkgGroup != null) {
            throw new AndrolibException(String.format("Repeated package group: id=0x%02x, name=%s", id, name));
        }
        if (id == 0 && this.mMainPackage != null && (id = this.getDynamicRefPackageId(name)) == 0) {
            id = this.mNextPackageId++;
        }
        pkgGroup = new ResPackageGroup(this, id, name);
        this.mPackageGroups.put(id, pkgGroup);
        return pkgGroup;
    }

    public int getPackageGroupCount() {
        return this.mPackageGroups.size();
    }

    public Collection<ResPackageGroup> listPackageGroups() {
        return this.mPackageGroups.values();
    }

    public ResPackageGroup resolvePackageGroup(int id) throws AndrolibException {
        ResPackageGroup pkgGroup = this.mPackageGroups.get(id);
        if (pkgGroup == null && (pkgGroup = this.loadLibraryById(id)) == null) {
            pkgGroup = this.loadFrameworkById(id);
        }
        return pkgGroup;
    }

    private ResPackageGroup loadLibraryById(int id) throws AndrolibException {
        String name = this.mDynamicRefTable.get(id);
        String[] libFiles = this.mConfig.getLibraryFiles();
        if (name == null || libFiles == null) {
            return null;
        }
        File apkFile = null;
        for (String libEntry : libFiles) {
            String[] parts = libEntry.split(":", 2);
            if (parts.length != 2 || !name.equals(parts[0])) continue;
            apkFile = new File(parts[1]);
            break;
        }
        if (apkFile == null) {
            return null;
        }
        this.loadPackagesFromApk(apkFile);
        ResPackageGroup pkgGroup = this.mPackageGroups.get(id);
        if (pkgGroup == null) {
            throw new AndrolibException(String.format("Library package not found: id=0x%02x", id));
        }
        this.mLibPackageIds.add(id);
        return pkgGroup;
    }

    private ResPackageGroup loadFrameworkById(int id) throws AndrolibException {
        File apkFile = new Framework(this.mConfig).getApkFile(id);
        this.loadPackagesFromApk(apkFile);
        ResPackageGroup pkgGroup = this.mPackageGroups.get(id);
        if (pkgGroup == null) {
            throw new AndrolibException(String.format("Framework package not found: id=0x%02x", id));
        }
        this.mFramePackageIds.add(id);
        return pkgGroup;
    }

    private void loadPackagesFromApk(File apkFile) throws AndrolibException {
        Log.i(TAG, "Loading resource table from file: " + apkFile);
        try (ZipRODirectory zipDir = new ZipRODirectory(apkFile);){
            this.loadPackagesFromApk(apkFile, zipDir, false);
        }
        catch (DirectoryException ex) {
            throw new AndrolibException("Could not open apk file: " + apkFile, ex);
        }
    }

    public ResEntrySpec resolve(ResId resId) throws AndrolibException {
        return this.resolvePackageGroup(resId.pkgId()).getEntrySpec(resId.typeId(), resId.entryId());
    }

    public ResEntry resolveEntry(ResId resId) throws AndrolibException {
        return this.resolvePackageGroup(resId.pkgId()).getEntry(resId.typeId(), resId.entryId());
    }

    public String getDynamicRefPackageName(int id) {
        String name = this.mDynamicRefTable.get(id);
        if (name == null) {
            Log.w(TAG, "Dynamic ref package name not defined for package ID: 0x02x", id);
        }
        return name;
    }

    public int getDynamicRefPackageId(String name) {
        for (Map.Entry<Integer, String> entry : this.mDynamicRefTable.entrySet()) {
            if (!name.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        Log.w(TAG, "Dynamic ref package ID not defined for package: " + name);
        return 0;
    }

    public void addDynamicRefPackage(int id, String name) {
        String existing = this.mDynamicRefTable.get(id);
        if (existing != null) {
            if (!existing.equals(name)) {
                Log.w(TAG, "Repeated dynamic ref package ID: %s (assigned to name: %s)", id, existing);
                return;
            }
            return;
        }
        for (Map.Entry<Integer, String> entry : this.mDynamicRefTable.entrySet()) {
            if (!name.equals(entry.getValue())) continue;
            Log.w(TAG, "Repeated dynamic ref package name: %s (assigned to ID: %s)", name, entry.getKey());
            return;
        }
        this.mDynamicRefTable.put(id, name);
    }
}

