/*
 * Decompiled with CFR 0.152.
 */
package brut.common;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Log {
    private static final ConcurrentMap<String, Logger> sCache = new ConcurrentHashMap<String, Logger>();

    private Log() {
    }

    private static void log(Level level, String tag, String message) {
        Logger logger = sCache.computeIfAbsent(tag, Logger::getLogger);
        if (logger.isLoggable(level)) {
            logger.log(level, message);
        }
    }

    private static void log(Level level, String tag, String message, Object ... args) {
        Logger logger = sCache.computeIfAbsent(tag, Logger::getLogger);
        if (logger.isLoggable(level)) {
            logger.log(level, String.format(message, args));
        }
    }

    public static void d(String tag, String message) {
        Log.log(Level.FINE, tag, message);
    }

    public static void d(String tag, String message, Object ... args) {
        Log.log(Level.FINE, tag, message, args);
    }

    public static void i(String tag, String message) {
        Log.log(Level.INFO, tag, message);
    }

    public static void i(String tag, String message, Object ... args) {
        Log.log(Level.INFO, tag, message, args);
    }

    public static void w(String tag, String message) {
        Log.log(Level.WARNING, tag, message);
    }

    public static void w(String tag, String message, Object ... args) {
        Log.log(Level.WARNING, tag, message, args);
    }

    public static void e(String tag, String message) {
        Log.log(Level.SEVERE, tag, message);
    }

    public static void e(String tag, String message, Object ... args) {
        Log.log(Level.SEVERE, tag, message, args);
    }
}

