/*
 * Decompiled with CFR 0.152.
 */
package brut.directory;

import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.directory.FileDirectory;
import brut.directory.ZipRODirectory;
import java.io.File;
import java.net.URI;

public class ExtFile
extends File
implements AutoCloseable {
    private Directory mDirectory;

    public ExtFile(File file) {
        super(file.getPath());
    }

    public ExtFile(URI uri) {
        super(uri);
    }

    public ExtFile(File parent, String child) {
        super(parent, child);
    }

    public ExtFile(String parent, String child) {
        super(parent, child);
    }

    public ExtFile(String pathname) {
        super(pathname);
    }

    public Directory getDirectory() throws DirectoryException {
        if (this.mDirectory == null) {
            this.mDirectory = this.isDirectory() ? new FileDirectory(this) : new ZipRODirectory(this);
        }
        return this.mDirectory;
    }

    @Override
    public void close() throws DirectoryException {
        if (this.mDirectory != null) {
            this.mDirectory.close();
            this.mDirectory = null;
        }
    }

    @Override
    public boolean delete() {
        try {
            this.close();
        }
        catch (DirectoryException ignored) {
            return false;
        }
        return super.delete();
    }
}

