/*
 * Decompiled with CFR 0.152.
 */
package brut.directory;

import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.directory.PathNotExist;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipRODirectory
extends Directory {
    private final ZipFile mZipFile;
    private final String mPath;

    public ZipRODirectory(String fileName) throws DirectoryException {
        this(fileName, "");
    }

    public ZipRODirectory(File file) throws DirectoryException {
        this(file, "");
    }

    public ZipRODirectory(String fileName, String path) throws DirectoryException {
        this(new File(fileName), path);
    }

    public ZipRODirectory(File file, String path) throws DirectoryException {
        try {
            this.mZipFile = new ZipFile(file);
        }
        catch (IOException ex) {
            throw new DirectoryException(ex);
        }
        this.mPath = path;
    }

    private ZipRODirectory(ZipFile zipFile, String path) {
        this.mZipFile = zipFile;
        this.mPath = path;
    }

    @Override
    protected void load() {
        this.mFiles = new LinkedHashSet();
        this.mDirs = new LinkedHashMap();
        int prefixLen = this.mPath.length();
        Enumeration<? extends ZipEntry> entries = this.mZipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (name.equals(this.mPath) || !name.startsWith(this.mPath) || name.contains("../")) continue;
            String subname = name.substring(prefixLen);
            int pos = subname.indexOf(47);
            if (pos == -1) {
                if (!entry.isDirectory()) {
                    this.mFiles.add(subname);
                    continue;
                }
            } else {
                subname = subname.substring(0, pos);
            }
            if (this.mDirs.containsKey(subname)) continue;
            this.mDirs.put(subname, new ZipRODirectory(this.mZipFile, this.mPath + subname + "/"));
        }
    }

    private ZipEntry getZipFileEntry(String name) throws DirectoryException {
        ZipEntry entry = this.mZipFile.getEntry(name);
        if (entry == null) {
            throw new PathNotExist("Entry not found: " + name);
        }
        return entry;
    }

    @Override
    protected InputStream getFileInputImpl(String name) throws DirectoryException {
        try {
            return this.mZipFile.getInputStream(new ZipEntry(this.mPath + name));
        }
        catch (IOException ex) {
            throw new PathNotExist(name, ex);
        }
    }

    @Override
    public long getSize(String name) throws DirectoryException {
        ZipEntry entry = this.getZipFileEntry(name);
        return entry.getSize();
    }

    @Override
    public long getCompressedSize(String name) throws DirectoryException {
        ZipEntry entry = this.getZipFileEntry(name);
        return entry.getCompressedSize();
    }

    @Override
    public int getCompressionLevel(String name) throws DirectoryException {
        ZipEntry entry = this.getZipFileEntry(name);
        return entry.getMethod();
    }

    @Override
    public void close() throws DirectoryException {
        try {
            this.mZipFile.close();
        }
        catch (IOException ex) {
            throw new DirectoryException(ex);
        }
    }
}

