/*
 * Decompiled with CFR 0.152.
 */
package brut.util;

import brut.common.Log;
import brut.util.BrutIO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public final class ZipUtils {
    private static final String TAG = "";

    private ZipUtils() {
    }

    public static void zipDir(File dir, ZipOutputStream out, Collection<String> doNotCompress) throws IOException {
        ZipUtils.zipDir(dir, null, out, doNotCompress);
    }

    public static void zipDir(File baseDir, String dirName, ZipOutputStream out, Collection<String> doNotCompress) throws IOException {
        File dir = dirName != null && !dirName.isEmpty() ? new File(baseDir, dirName) : baseDir;
        if (!dir.isDirectory()) {
            return;
        }
        for (File file : dir.listFiles()) {
            String fileName = baseDir.toPath().relativize(file.toPath()).toString();
            if (file.isDirectory()) {
                ZipUtils.zipDir(baseDir, fileName, out, doNotCompress);
                continue;
            }
            if (!file.isFile()) continue;
            ZipUtils.zipFile(baseDir, fileName, out, doNotCompress != null && !doNotCompress.isEmpty() ? entryName -> doNotCompress.contains(entryName) || doNotCompress.contains(FilenameUtils.getExtension(entryName)) : entryName -> false);
        }
    }

    public static void zipFile(File baseDir, String fileName, ZipOutputStream out, boolean doNotCompress) throws IOException {
        ZipUtils.zipFile(baseDir, fileName, out, entryName -> doNotCompress);
    }

    private static void zipFile(File baseDir, String fileName, ZipOutputStream out, Predicate<String> doNotCompress) throws IOException {
        try {
            InputStream in;
            fileName = BrutIO.sanitizePath(baseDir, fileName);
            if (fileName.isEmpty()) {
                return;
            }
            File file = new File(baseDir, fileName);
            if (!file.isFile()) {
                return;
            }
            String entryName = FilenameUtils.separatorsToUnix(fileName);
            ZipEntry zipEntry = new ZipEntry(entryName);
            if (doNotCompress.test(entryName)) {
                zipEntry.setMethod(0);
                zipEntry.setSize(file.length());
                in = Files.newInputStream(file.toPath(), new OpenOption[0]);
                try {
                    CRC32 crc = BrutIO.calculateCrc(in);
                    zipEntry.setCrc(crc.getValue());
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            } else {
                zipEntry.setMethod(8);
            }
            out.putNextEntry(zipEntry);
            in = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                IOUtils.copy(in, (OutputStream)out);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            out.closeEntry();
        }
        catch (InvalidPathException ex) {
            Log.w(TAG, "Skipping file %s (%s)", fileName, ex.getMessage());
        }
    }
}

