/*
 * Decompiled with CFR 0.152.
 */
package brut.yaml;

import brut.yaml.YamlLine;
import brut.yaml.YamlSerializable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

public class YamlReader {
    private List<YamlLine> mLines = new ArrayList<YamlLine>();
    private int mCurrent;

    public YamlReader(InputStream in) {
        this.mLines.add(new YamlLine(null));
        this.read(in);
    }

    public void pushLine() {
        if (this.mCurrent > 0) {
            --this.mCurrent;
        }
    }

    public void read(InputStream in) {
        Scanner scanner = new Scanner(in);
        this.mLines = new ArrayList<YamlLine>();
        while (scanner.hasNextLine()) {
            this.mLines.add(new YamlLine(scanner.nextLine()));
        }
        this.mLines.add(new YamlLine(null));
    }

    public YamlLine getLine() {
        return this.mLines.get(this.mCurrent);
    }

    public int getIndent() {
        return this.getLine().indent;
    }

    public boolean isEnd() {
        return this.getLine().isNull;
    }

    public boolean isCommentOrEmpty() {
        YamlLine line = this.getLine();
        return line.isEmpty || line.isComment;
    }

    public void skipInsignificant() {
        if (this.isEnd()) {
            return;
        }
        while (this.isCommentOrEmpty()) {
            ++this.mCurrent;
            if (!this.isEnd()) continue;
            break;
        }
    }

    public boolean nextLine() {
        if (this.isEnd()) {
            return false;
        }
        do {
            ++this.mCurrent;
        } while (this.isCommentOrEmpty());
        return !this.isEnd();
    }

    public <T extends YamlSerializable> void readRoot(T obj) {
        if (this.isEnd()) {
            return;
        }
        int objIndent = 0;
        this.skipInsignificant();
        while (!this.isEnd()) {
            YamlLine line = this.getLine();
            if (objIndent != line.indent || !line.hasColon) {
                this.nextLine();
                continue;
            }
            obj.readItem(this);
            this.nextLine();
        }
        return;
    }

    protected <T> void readObject(T obj, Checker check, Updater<T> updater) {
        if (this.isEnd()) {
            return;
        }
        int prevIndent = this.getIndent();
        this.nextLine();
        YamlLine line = this.getLine();
        int objIndent = line.indent;
        if (objIndent <= prevIndent || !check.check(line)) {
            this.pushLine();
            return;
        }
        updater.update(obj, this);
        while (this.nextLine()) {
            if (this.isEnd()) {
                return;
            }
            line = this.getLine();
            if (objIndent != line.indent || !check.check(line)) {
                this.pushLine();
                return;
            }
            updater.update(obj, this);
        }
    }

    public <T extends YamlSerializable> void readObject(T obj) {
        this.readObject(obj, line -> line.hasColon, YamlSerializable::readItem);
    }

    protected <T> void readList(List<T> list, Updater<List<T>> updater) {
        if (this.isEnd()) {
            return;
        }
        int listIndent = this.getIndent();
        this.nextLine();
        int dataIndent = this.getIndent();
        while (!this.isEnd()) {
            if (dataIndent < listIndent) {
                this.pushLine();
                return;
            }
            YamlLine line = this.getLine();
            if (dataIndent != line.indent || !line.isItem) {
                this.pushLine();
                return;
            }
            updater.update(list, this);
            this.nextLine();
        }
        return;
    }

    public void readStringList(List<String> list) {
        this.readList(list, (items, reader) -> items.add(reader.getLine().getValue()));
    }

    public void readIntList(List<Integer> list) {
        this.readList(list, (items, reader) -> items.add(reader.getLine().getValueInt()));
    }

    public void readStringMap(Map<String, String> map) {
        this.readObject(map, line -> line.hasColon, (items, reader) -> {
            YamlLine line = reader.getLine();
            items.put(line.getKey(), line.getValue());
        });
    }

    public void readIntMap(Map<String, Integer> map) {
        this.readObject(map, line -> line.hasColon, (items, reader) -> {
            YamlLine line = reader.getLine();
            items.put(line.getKey(), line.getValueInt());
        });
    }

    public void readBoolMap(Map<String, Boolean> map) {
        this.readObject(map, line -> line.hasColon, (items, reader) -> {
            YamlLine line = reader.getLine();
            items.put(line.getKey(), line.getValueBool());
        });
    }

    protected static interface Checker {
        public boolean check(YamlLine var1);
    }

    protected static interface Updater<T> {
        public void update(T var1, YamlReader var2);
    }
}

