/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.ILayoutLog;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceRepositoryUtil;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceUrl;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ResourceItemResolver
extends RenderResources {
    private final FolderConfiguration myConfiguration;
    private final ILayoutLog myLogger;
    private final ResourceProvider myResourceProvider;
    private ResourceResolver myResolver;
    private List<ResourceValue> myLookupChain;

    public ResourceItemResolver(FolderConfiguration configuration, ResourceProvider resourceProvider, ILayoutLog logger) {
        this.myConfiguration = configuration;
        this.myResourceProvider = resourceProvider;
        this.myLogger = logger;
        this.myResolver = resourceProvider.getResolver(false);
    }

    public ResourceItemResolver(FolderConfiguration configuration, final ResourceRepository frameworkResources, final ResourceRepository appResources, ILayoutLog logger) {
        this(configuration, new ResourceProvider(){

            @Override
            public ResourceResolver getResolver(boolean createIfNecessary) {
                return null;
            }

            @Override
            @NotNull
            public ResourceRepository getFrameworkResources() {
                return frameworkResources;
            }

            @Override
            @NotNull
            public ResourceRepository getAppResources() {
                return appResources;
            }
        }, logger);
    }

    @Contract(value="!null -> !null")
    public ResourceValue resolveResValue(ResourceValue resValue) {
        if (this.myResolver != null) {
            return this.myResolver.resolveResValue(resValue);
        }
        if (resValue == null) {
            return null;
        }
        boolean referenceToItself = false;
        for (int depth = 0; depth < 50; ++depth) {
            if (this.myLookupChain != null) {
                this.myLookupChain.add(resValue);
            }
            if (resValue instanceof ArrayResourceValue) {
                return resValue;
            }
            ResourceValue resolvedResValue = this.dereference(resValue);
            if (resolvedResValue == null) {
                return resValue;
            }
            if (resolvedResValue.equals((Object)resValue)) {
                referenceToItself = true;
                break;
            }
            resValue = resolvedResValue;
        }
        if (this.myLogger != null) {
            String msg = referenceToItself ? "Infinite cycle trying to resolve '%s': Render may not be accurate." : "Potential infinite cycle trying to resolve '%s': Render may not be accurate.";
            this.myLogger.error("broken", String.format(msg, resValue.getValue()), null, null, null);
        }
        return resValue;
    }

    public ResourceValue dereference(ResourceValue value) {
        String valueText;
        if (this.myResolver != null) {
            return this.myResolver.dereference(value);
        }
        if (this.myLookupChain != null && !this.myLookupChain.isEmpty() && !this.myLookupChain.get(this.myLookupChain.size() - 1).equals((Object)value)) {
            this.myLookupChain.add(value);
        }
        if ((valueText = value.getValue()) == null) {
            return null;
        }
        ResourceUrl url = ResourceUrl.parse((String)valueText);
        if (url != null && url.hasValidName()) {
            if (url.isTheme()) {
                ResourceResolver resolver = this.getFullResolver();
                if (resolver != null) {
                    return resolver.dereference(value);
                }
                return null;
            }
            return this.findResValue(url);
        }
        return null;
    }

    private ResourceValue findResValue(ResourceUrl url) {
        if (!url.isFramework()) {
            ResourceRepository appResources = this.myResourceProvider.getAppResources();
            if (appResources == null) {
                return null;
            }
            ResourceValue item = ResourceRepositoryUtil.getConfiguredValue(appResources, url.type, url.name, this.myConfiguration);
            if (item != null) {
                if (this.myLookupChain != null) {
                    this.myLookupChain.add(item);
                }
                return item;
            }
        } else {
            ResourceRepository frameworkResources = this.myResourceProvider.getFrameworkResources();
            if (frameworkResources == null) {
                return null;
            }
            List<ResourceItem> items = frameworkResources.getResources(ResourceNamespace.ANDROID, url.type, url.name);
            if (!items.isEmpty()) {
                ResourceValue value = items.get(0).getResourceValue();
                if (value != null && this.myLookupChain != null) {
                    this.myLookupChain.add(value);
                }
                return value;
            }
        }
        if (this.myLogger != null) {
            this.myLogger.warning("resources.resolve", "Couldn't resolve resource " + String.valueOf(url), null, (Object)url);
        }
        return null;
    }

    public StyleResourceValue getDefaultTheme() {
        ResourceResolver resolver = this.getFullResolver();
        if (resolver != null) {
            return resolver.getDefaultTheme();
        }
        return null;
    }

    public ResourceValue findItemInTheme(ResourceReference attr) {
        ResourceResolver resolver = this.getFullResolver();
        return resolver != null ? resolver.findItemInTheme(attr) : null;
    }

    public StyleItemResourceValue findItemInStyle(StyleResourceValue style, ResourceReference attr) {
        ResourceResolver resolver = this.getFullResolver();
        return resolver != null ? resolver.findItemInStyle(style, attr) : null;
    }

    public StyleResourceValue getParent(StyleResourceValue style) {
        ResourceResolver resolver = this.getFullResolver();
        return resolver != null ? resolver.getParent(style) : null;
    }

    private ResourceResolver getFullResolver() {
        if (this.myResolver == null) {
            if (this.myResourceProvider == null) {
                return null;
            }
            this.myResolver = this.myResourceProvider.getResolver(true);
            if (this.myResolver != null && this.myLookupChain != null) {
                this.myResolver = this.myResolver.createRecorder(this.myLookupChain);
            }
        }
        return this.myResolver;
    }

    public ResourceValue getUnresolvedResource(@NotNull ResourceReference reference) {
        ResourceResolver fullResolver = this.getFullResolver();
        if (fullResolver == null) {
            return null;
        }
        return fullResolver.getUnresolvedResource(reference);
    }

    public void setLookupChainList(List<ResourceValue> lookupChain) {
        this.myLookupChain = lookupChain;
    }

    public List<ResourceValue> getLookupChain() {
        return this.myLookupChain;
    }

    public static String getDisplayString(String url, List<ResourceValue> lookupChain) {
        StringBuilder sb = new StringBuilder();
        sb.append(url);
        String prev = url;
        for (ResourceValue element : lookupChain) {
            int end;
            String text;
            String value;
            if (element == null || (value = element.getValue()) == null || (text = value).equals(prev)) continue;
            sb.append(" => ");
            if (!text.startsWith("?") && !text.startsWith("@") && (end = Math.max(text.lastIndexOf(47), text.lastIndexOf(92))) != -1) {
                text = text.substring(end + 1);
            }
            sb.append(text);
            prev = value;
        }
        return sb.toString();
    }

    public static interface ResourceProvider {
        public ResourceResolver getResolver(boolean var1);

        public ResourceRepository getFrameworkResources();

        public ResourceRepository getAppResources();
    }
}

