/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.xml;

import com.android.resources.Keyboard;
import com.android.resources.Navigation;
import com.android.resources.TouchScreen;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;

public final class ManifestData {
    public static final int MIN_SDK_CODENAME = 0;
    public static final int GL_ES_VERSION_NOT_SET = -1;
    String mPackage;
    Integer mVersionCode = null;
    String mVersionName = null;
    String mDefaultProcess;
    final ArrayList<Activity> mActivities = new ArrayList();
    final ArrayList<KeepClass> mKeepClasses = new ArrayList();
    Activity mLauncherActivity = null;
    Set<String> mProcesses = null;
    Boolean mDebuggable = null;
    Boolean mExtractNativeLibs = null;
    private String mMinSdkVersionString = null;
    private int mMinSdkVersion = 1;
    private int mTargetSdkVersion = 0;
    final ArrayList<Instrumentation> mInstrumentations = new ArrayList();
    final ArrayList<UsesLibrary> mLibraries = new ArrayList();
    final ArrayList<UsesFeature> mFeatures = new ArrayList();
    final ArrayList<String> mCustomPermissions = new ArrayList();
    SupportsScreens mSupportsScreensFromManifest;
    SupportsScreens mSupportsScreensValues;
    UsesConfiguration mUsesConfiguration;

    public String getPackage() {
        return this.mPackage;
    }

    public Integer getVersionCode() {
        return this.mVersionCode;
    }

    public String getVersionName() {
        return this.mVersionName;
    }

    public Activity[] getActivities() {
        return this.mActivities.toArray(new Activity[0]);
    }

    public KeepClass[] getKeepClasses() {
        return this.mKeepClasses.toArray(new KeepClass[0]);
    }

    public Activity getLauncherActivity() {
        return this.mLauncherActivity;
    }

    public String[] getProcesses() {
        if (this.mProcesses != null) {
            return this.mProcesses.toArray(new String[0]);
        }
        return new String[0];
    }

    public String getDefaultProcess() {
        return this.mDefaultProcess;
    }

    public Boolean getDebuggable() {
        return this.mDebuggable;
    }

    public Boolean getExtractNativeLibs() {
        return this.mExtractNativeLibs;
    }

    public String getMinSdkVersionString() {
        return this.mMinSdkVersionString;
    }

    public void setMinSdkVersionString(String minSdkVersion) {
        this.mMinSdkVersionString = minSdkVersion;
        if (this.mMinSdkVersionString != null) {
            try {
                this.mMinSdkVersion = Integer.parseInt(this.mMinSdkVersionString);
            }
            catch (NumberFormatException e) {
                this.mMinSdkVersion = 0;
            }
        }
    }

    public int getMinSdkVersion() {
        return this.mMinSdkVersion;
    }

    public void setTargetSdkVersionString(String targetSdkVersion) {
        if (targetSdkVersion != null) {
            try {
                this.mTargetSdkVersion = Integer.parseInt(targetSdkVersion);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public int getTargetSdkVersion() {
        if (this.mTargetSdkVersion == 0) {
            return this.getMinSdkVersion();
        }
        return this.mTargetSdkVersion;
    }

    public Instrumentation[] getInstrumentations() {
        return this.mInstrumentations.toArray(new Instrumentation[0]);
    }

    public UsesLibrary[] getUsesLibraries() {
        return this.mLibraries.toArray(new UsesLibrary[0]);
    }

    public UsesFeature[] getUsesFeatures() {
        return this.mFeatures.toArray(new UsesFeature[0]);
    }

    public ImmutableList<String> getCustomPermissions() {
        return ImmutableList.copyOf(this.mCustomPermissions);
    }

    public int getGlEsVersion() {
        for (UsesFeature feature : this.mFeatures) {
            if (feature.mGlEsVersion <= 0) continue;
            return feature.mGlEsVersion;
        }
        return -1;
    }

    public SupportsScreens getSupportsScreensFromManifest() {
        return this.mSupportsScreensFromManifest;
    }

    public synchronized SupportsScreens getSupportsScreensValues() {
        if (this.mSupportsScreensValues == null) {
            this.mSupportsScreensValues = this.mSupportsScreensFromManifest == null ? SupportsScreens.getDefaultValues(this.getTargetSdkVersion()) : this.mSupportsScreensFromManifest.resolveSupportsScreensValues(this.getTargetSdkVersion());
        }
        return this.mSupportsScreensValues;
    }

    public UsesConfiguration getUsesConfiguration() {
        return this.mUsesConfiguration;
    }

    void addProcessName(String processName) {
        if (this.mProcesses == null) {
            this.mProcesses = new TreeSet<String>();
        }
        if (processName.startsWith(":")) {
            this.mProcesses.add(this.mPackage + processName);
        } else {
            this.mProcesses.add(processName);
        }
    }

    public static final class Activity {
        private final String mName;
        private final boolean mIsExported;
        private boolean mHasAction = false;
        private boolean mHasMainAction = false;
        private boolean mHasLauncherCategory = false;

        public Activity(String name, boolean exported) {
            this.mName = name;
            this.mIsExported = exported;
        }

        public String getName() {
            return this.mName;
        }

        public boolean isExported() {
            return this.mIsExported;
        }

        public boolean hasAction() {
            return this.mHasAction;
        }

        public boolean isHomeActivity() {
            return this.mHasMainAction && this.mHasLauncherCategory;
        }

        void setHasAction(boolean hasAction) {
            this.mHasAction = hasAction;
        }

        void resetIntentFilter() {
            if (!this.isHomeActivity()) {
                this.mHasLauncherCategory = false;
                this.mHasMainAction = false;
            }
        }

        void setHasMainAction(boolean hasMainAction) {
            this.mHasMainAction = hasMainAction;
        }

        void setHasLauncherCategory(boolean hasLauncherCategory) {
            this.mHasLauncherCategory = hasLauncherCategory;
        }
    }

    public static final class KeepClass {
        private final String name;
        private final String process;
        private final String type;

        public KeepClass(String name, String process, String type) {
            this.name = name;
            this.process = process;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getProcess() {
            return this.process;
        }

        public String getType() {
            return this.type;
        }
    }

    public static final class Instrumentation {
        private final String mName;
        private final String mTargetPackage;

        Instrumentation(String name, String targetPackage) {
            this.mName = name;
            this.mTargetPackage = targetPackage;
        }

        public String getName() {
            return this.mName;
        }

        public String getTargetPackage() {
            return this.mTargetPackage;
        }
    }

    public static final class UsesLibrary {
        String mName;
        Boolean mRequired = Boolean.TRUE;

        public String getName() {
            return this.mName;
        }

        public Boolean getRequired() {
            return this.mRequired;
        }
    }

    public static final class UsesFeature {
        String mName;
        int mGlEsVersion = 0;
        Boolean mRequired = Boolean.TRUE;

        public String getName() {
            return this.mName;
        }

        public int getGlEsVersion() {
            return this.mGlEsVersion;
        }

        public Boolean getRequired() {
            return this.mRequired;
        }
    }

    public static final class SupportsScreens {
        private Boolean mResizeable;
        private Boolean mAnyDensity;
        private Boolean mSmallScreens;
        private Boolean mNormalScreens;
        private Boolean mLargeScreens;

        public SupportsScreens() {
        }

        public SupportsScreens(String value) {
            String[] values = value.split("\\|");
            this.mAnyDensity = Boolean.valueOf(values[0]);
            this.mResizeable = Boolean.valueOf(values[1]);
            this.mSmallScreens = Boolean.valueOf(values[2]);
            this.mNormalScreens = Boolean.valueOf(values[3]);
            this.mLargeScreens = Boolean.valueOf(values[4]);
        }

        public static SupportsScreens getDefaultValues(int targetSdkVersion) {
            SupportsScreens result2 = new SupportsScreens();
            result2.mNormalScreens = Boolean.TRUE;
            result2.mLargeScreens = targetSdkVersion <= 3 ? Boolean.FALSE : Boolean.TRUE;
            result2.mSmallScreens = result2.mLargeScreens;
            result2.mAnyDensity = result2.mLargeScreens;
            result2.mResizeable = result2.mLargeScreens;
            return result2;
        }

        public SupportsScreens resolveSupportsScreensValues(int targetSdkVersion) {
            SupportsScreens result2 = SupportsScreens.getDefaultValues(targetSdkVersion);
            if (this.mResizeable != null) {
                result2.mResizeable = this.mResizeable;
            }
            if (this.mAnyDensity != null) {
                result2.mAnyDensity = this.mAnyDensity;
            }
            if (this.mSmallScreens != null) {
                result2.mSmallScreens = this.mSmallScreens;
            }
            if (this.mNormalScreens != null) {
                result2.mNormalScreens = this.mNormalScreens;
            }
            if (this.mLargeScreens != null) {
                result2.mLargeScreens = this.mLargeScreens;
            }
            return result2;
        }

        public Boolean getResizeable() {
            return this.mResizeable;
        }

        void setResizeable(Boolean resizeable) {
            this.mResizeable = this.getConstantBoolean(resizeable);
        }

        public Boolean getAnyDensity() {
            return this.mAnyDensity;
        }

        void setAnyDensity(Boolean anyDensity) {
            this.mAnyDensity = this.getConstantBoolean(anyDensity);
        }

        public Boolean getSmallScreens() {
            return this.mSmallScreens;
        }

        void setSmallScreens(Boolean smallScreens) {
            this.mSmallScreens = this.getConstantBoolean(smallScreens);
        }

        public Boolean getNormalScreens() {
            return this.mNormalScreens;
        }

        void setNormalScreens(Boolean normalScreens) {
            this.mNormalScreens = this.getConstantBoolean(normalScreens);
        }

        public Boolean getLargeScreens() {
            return this.mLargeScreens;
        }

        void setLargeScreens(Boolean largeScreens) {
            this.mLargeScreens = this.getConstantBoolean(largeScreens);
        }

        private Boolean getConstantBoolean(Boolean v) {
            if (v != null) {
                if (v.equals(Boolean.TRUE)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SupportsScreens) {
                SupportsScreens support = (SupportsScreens)obj;
                return this.mResizeable == support.mResizeable && this.mAnyDensity == support.mAnyDensity && this.mSmallScreens == support.mSmallScreens && this.mNormalScreens == support.mNormalScreens && this.mLargeScreens == support.mLargeScreens;
            }
            return false;
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + (this.mAnyDensity == null ? 0 : this.mAnyDensity.hashCode());
            result2 = 31 * result2 + (this.mLargeScreens == null ? 0 : this.mLargeScreens.hashCode());
            result2 = 31 * result2 + (this.mNormalScreens == null ? 0 : this.mNormalScreens.hashCode());
            result2 = 31 * result2 + (this.mResizeable == null ? 0 : this.mResizeable.hashCode());
            result2 = 31 * result2 + (this.mSmallScreens == null ? 0 : this.mSmallScreens.hashCode());
            return result2;
        }

        public boolean hasSameScreenSupportAs(SupportsScreens support) {
            return this.mSmallScreens == support.mSmallScreens && this.mNormalScreens == support.mNormalScreens && this.mLargeScreens == support.mLargeScreens;
        }

        public boolean hasStrictlyDifferentScreenSupportAs(SupportsScreens support) {
            return !(this.mSmallScreens == Boolean.TRUE && support.mSmallScreens == Boolean.TRUE || this.mNormalScreens == Boolean.TRUE && support.mNormalScreens == Boolean.TRUE || this.mLargeScreens == Boolean.TRUE && support.mLargeScreens == Boolean.TRUE);
        }

        public int compareScreenSizesWith(SupportsScreens o) {
            if (!this.hasStrictlyDifferentScreenSupportAs(o)) {
                throw new IllegalArgumentException("The two instances are not strictly different.");
            }
            if (this.overlapWith(o)) {
                throw new IllegalArgumentException("The two instances overlap each other.");
            }
            int comp = this.mLargeScreens.compareTo(o.mLargeScreens);
            if (comp != 0) {
                return comp;
            }
            comp = this.mNormalScreens.compareTo(o.mNormalScreens);
            if (comp != 0) {
                return comp;
            }
            comp = this.mSmallScreens.compareTo(o.mSmallScreens);
            if (comp != 0) {
                return comp;
            }
            return 0;
        }

        public String getEncodedValues() {
            return String.format("%1$s|%2$s|%3$s|%4$s|%5$s", this.mAnyDensity, this.mResizeable, this.mSmallScreens, this.mNormalScreens, this.mLargeScreens);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            boolean alreadyOutputSomething = false;
            if (Boolean.TRUE.equals(this.mSmallScreens)) {
                alreadyOutputSomething = true;
                sb.append("small");
            }
            if (Boolean.TRUE.equals(this.mNormalScreens)) {
                if (alreadyOutputSomething) {
                    sb.append(", ");
                }
                alreadyOutputSomething = true;
                sb.append("normal");
            }
            if (Boolean.TRUE.equals(this.mLargeScreens)) {
                if (alreadyOutputSomething) {
                    sb.append(", ");
                }
                alreadyOutputSomething = true;
                sb.append("large");
            }
            if (!alreadyOutputSomething) {
                sb.append("<none>");
            }
            return sb.toString();
        }

        public boolean overlapWith(SupportsScreens otherSS) {
            if (this.mSmallScreens == null || this.mNormalScreens == null || this.mLargeScreens == null || otherSS.mSmallScreens == null || otherSS.mNormalScreens == null || otherSS.mLargeScreens == null) {
                throw new IllegalArgumentException("Some screen sizes Boolean are not initialized");
            }
            if (this.mSmallScreens == Boolean.TRUE && this.mNormalScreens == Boolean.FALSE && this.mLargeScreens == Boolean.TRUE) {
                return otherSS.mNormalScreens == Boolean.TRUE;
            }
            if (otherSS.mSmallScreens == Boolean.TRUE && otherSS.mNormalScreens == Boolean.FALSE && otherSS.mLargeScreens == Boolean.TRUE) {
                return this.mNormalScreens == Boolean.TRUE;
            }
            return false;
        }
    }

    public static final class UsesConfiguration {
        Boolean mReqFiveWayNav;
        Boolean mReqHardKeyboard;
        Keyboard mReqKeyboardType;
        TouchScreen mReqTouchScreen;
        Navigation mReqNavigation;

        public Boolean getReqFiveWayNav() {
            return this.mReqFiveWayNav;
        }

        public Navigation getReqNavigation() {
            return this.mReqNavigation;
        }

        public Boolean getReqHardKeyboard() {
            return this.mReqHardKeyboard;
        }

        public Keyboard getReqKeyboardType() {
            return this.mReqKeyboardType;
        }

        public TouchScreen getReqTouchScreen() {
            return this.mReqTouchScreen;
        }
    }
}

