/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.DataFlowAnalyzer;
import com.android.tools.lint.checks.DataFlowAnalyzerKt;
import com.android.tools.lint.checks.TargetMethodDataFlowAnalyzer;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.lang.Language;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UDoWhileExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UWhileExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J \u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J9\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00072\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0017\"\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0018J \u0010\u0019\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J0\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J \u0010 \u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J\u0018\u0010!\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\"\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010#\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006%"}, d2={"Lcom/android/tools/lint/checks/CleanupDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableMethodNames", "", "", "getApplicableConstructorTypes", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "visitConstructor", "constructor", "checkResourceRecycled", "checkRecycled", "originalRecycleType", "recycleNames", "", "(Lcom/android/tools/lint/detector/api/JavaContext;Lorg/jetbrains/uast/UCallExpression;Ljava/lang/String;[Ljava/lang/String;)V", "checkTransactionCommits", "calledMethod", "isMethodOnFragmentClass", "", "fragmentClass", "platformFragmentClass", "v4FragmentClass", "checkEditorApplied", "isSharedEditorCreation", "suggestApplyIfApplicable", "isBeginTransaction", "Companion", "lint-checks"})
public final class CleanupDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(CleanupDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue RECYCLE_RESOURCE;
    @JvmField
    @NotNull
    public static final Issue COMMIT_FRAGMENT;
    @JvmField
    @NotNull
    public static final Issue SHARED_PREF;
    @JvmField
    @NotNull
    public static final Issue APPLY_SHARED_PREF;
    @NotNull
    private static final String OF_INT = "ofInt";
    @NotNull
    private static final String OF_ARGB = "ofArgb";
    @NotNull
    private static final String OF_FLOAT = "ofFloat";
    @NotNull
    private static final String OF_OBJECT = "ofObject";
    @NotNull
    private static final String OF_PROPERTY_VALUES_HOLDER = "ofPropertyValuesHolder";
    @NotNull
    private static final String START = "start";
    @NotNull
    private static final String RECYCLE = "recycle";
    @NotNull
    private static final String RELEASE = "release";
    @NotNull
    private static final String OBTAIN = "obtain";
    @NotNull
    private static final String SHOW = "show";
    @NotNull
    private static final String ACQUIRE_CPC = "acquireContentProviderClient";
    @NotNull
    private static final String ACQUIRE_UNSTABLE_CPC = "acquireUnstableContentProviderClient";
    @NotNull
    private static final String OBTAIN_NO_HISTORY = "obtainNoHistory";
    @NotNull
    private static final String OBTAIN_ATTRIBUTES = "obtainAttributes";
    @NotNull
    private static final String OBTAIN_TYPED_ARRAY = "obtainTypedArray";
    @NotNull
    private static final String OBTAIN_STYLED_ATTRIBUTES = "obtainStyledAttributes";
    @NotNull
    private static final String BEGIN_TRANSACTION = "beginTransaction";
    @NotNull
    private static final String COMMIT = "commit";
    @NotNull
    private static final String COMMIT_NOW = "commitNow";
    @NotNull
    private static final String APPLY = "apply";
    @NotNull
    private static final String COMMIT_ALLOWING_LOSS = "commitAllowingStateLoss";
    @NotNull
    private static final String COMMIT_NOW_ALLOWING_LOSS = "commitNowAllowingStateLoss";
    @NotNull
    private static final String QUERY = "query";
    @NotNull
    private static final String RAW_QUERY = "rawQuery";
    @NotNull
    private static final String QUERY_WITH_FACTORY = "queryWithFactory";
    @NotNull
    private static final String RAW_QUERY_WITH_FACTORY = "rawQueryWithFactory";
    @NotNull
    private static final String CLOSE = "close";
    @NotNull
    private static final String CLOSE_WITH_ERROR = "closeWithError";
    @NotNull
    private static final String EDIT = "edit";
    @NotNull
    private static final String OPEN_ASSET_FILE = "openAssetFile";
    @NotNull
    private static final String OPEN_ASSET_FILE_DESCRIPTOR = "openAssetFileDescriptor";
    @NotNull
    private static final String OPEN_FILE = "openFile";
    @NotNull
    private static final String OPEN_FILE_DESCRIPTOR = "openFileDescriptor";
    @NotNull
    private static final String OPEN_INPUT_STREAM = "openInputStream";
    @NotNull
    private static final String OPEN_OUTPUT_STREAM = "openOutputStream";
    @NotNull
    private static final String OPEN_TYPED_ASSET_FILE = "openTypedAssetFile";
    @NotNull
    private static final String OPEN_TYPED_ASSET_FILE_DESCRIPTOR = "openTypedAssetFileDescriptor";
    @NotNull
    public static final String MOTION_EVENT_CLS = "android.view.MotionEvent";
    @NotNull
    private static final String PARCEL_CLS = "android.os.Parcel";
    @NotNull
    private static final String VELOCITY_TRACKER_CLS = "android.view.VelocityTracker";
    @NotNull
    private static final String DIALOG_FRAGMENT = "android.app.DialogFragment";
    @NotNull
    private static final String DIALOG_V4_FRAGMENT = "android.support.v4.app.DialogFragment";
    @NotNull
    private static final String DIALOG_ANDROIDX_FRAGMENT = "androidx.fragment.app.DialogFragment";
    @NotNull
    private static final String FRAGMENT_MANAGER_CLS = "android.app.FragmentManager";
    @NotNull
    private static final String FRAGMENT_MANAGER_V4_CLS = "android.support.v4.app.FragmentManager";
    @NotNull
    private static final String FRAGMENT_MANAGER_ANDROIDX_CLS = "androidx.fragment.app.FragmentManager";
    @NotNull
    private static final String FRAGMENT_TRANSACTION_CLS = "android.app.FragmentTransaction";
    @NotNull
    private static final String FRAGMENT_TRANSACTION_V4_CLS = "android.support.v4.app.FragmentTransaction";
    @NotNull
    private static final String FRAGMENT_TRANSACTION_ANDROIDX_CLS = "androidx.fragment.app.FragmentTransaction";
    @NotNull
    private static final String ANIMATOR_CLS = "android.animation.Animator";
    @NotNull
    private static final String VALUE_ANIMATOR_CLS = "android.animation.ValueAnimator";
    @NotNull
    private static final String OBJECT_ANIMATOR_CLS = "android.animation.ObjectAnimator";
    @NotNull
    private static final String ANIMATOR_SET_CLS = "android.animation.AnimatorSet";
    @NotNull
    public static final String SURFACE_CLS = "android.view.Surface";
    @NotNull
    public static final String SURFACE_TEXTURE_CLS = "android.graphics.SurfaceTexture";
    @NotNull
    public static final String CONTENT_PROVIDER_CLIENT_CLS = "android.content.ContentProviderClient";
    @NotNull
    public static final String CONTENT_RESOLVER_CLS = "android.content.ContentResolver";
    @NotNull
    public static final String SQLITE_DATABASE_CLS = "android.database.sqlite.SQLiteDatabase";
    @NotNull
    public static final String CURSOR_CLS = "android.database.Cursor";
    @NotNull
    public static final String ANDROID_CONTENT_SHARED_PREFERENCES = "android.content.SharedPreferences";
    @NotNull
    private static final String ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR = "android.content.SharedPreferences.Editor";
    @NotNull
    private static final String ASSET_FILE_DESCRIPTOR_CLS = "android.content.res.AssetFileDescriptor";
    @NotNull
    private static final String CLOSEABLE_CLS = "java.io.Closeable";
    @NotNull
    private static final String FILE_INPUT_STREAM_CLS = "java.io.FileInputStream";
    @NotNull
    private static final String FILE_OUTPUT_STREAM_CLS = "java.io.FileOutputStream";
    @NotNull
    private static final String FILE_DESCRIPTOR_CLS = "java.io.FileDescriptor";
    @NotNull
    private static final String PARCEL_FILE_DESCRIPTOR_CLS = "android.os.ParcelFileDescriptor";

    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{BEGIN_TRANSACTION, OBTAIN, OBTAIN_NO_HISTORY, OBTAIN_STYLED_ATTRIBUTES, OBTAIN_ATTRIBUTES, OBTAIN_TYPED_ARRAY, ACQUIRE_CPC, ACQUIRE_UNSTABLE_CPC, QUERY, RAW_QUERY, QUERY_WITH_FACTORY, RAW_QUERY_WITH_FACTORY, OPEN_ASSET_FILE, OPEN_ASSET_FILE_DESCRIPTOR, OPEN_TYPED_ASSET_FILE, OPEN_TYPED_ASSET_FILE_DESCRIPTOR, OPEN_INPUT_STREAM, OPEN_OUTPUT_STREAM, OPEN_FILE, OPEN_FILE_DESCRIPTOR, EDIT, OF_INT, OF_ARGB, OF_FLOAT, OF_OBJECT, OF_PROPERTY_VALUES_HOLDER};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<String> getApplicableConstructorTypes() {
        Object[] objectArray = new String[]{SURFACE_TEXTURE_CLS, SURFACE_CLS, VALUE_ANIMATOR_CLS, OBJECT_ANIMATOR_CLS, ANIMATOR_SET_CLS};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        switch (method.getName()) {
            case "beginTransaction": {
                this.checkTransactionCommits(context, node, method);
                break;
            }
            case "edit": {
                this.checkEditorApplied(context, node, method);
                break;
            }
            default: {
                this.checkResourceRecycled(context, node, method);
            }
        }
    }

    public void visitConstructor(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod constructor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        Object object = constructor.getContainingClass();
        if (object == null || (object = object.getQualifiedName()) == null) {
            return;
        }
        Object type = object;
        if (UastLintUtilsKt.isThisOrSuperConstructorCall((UCallExpression)node)) {
            return;
        }
        if (Intrinsics.areEqual((Object)type, (Object)SURFACE_TEXTURE_CLS) || Intrinsics.areEqual((Object)type, (Object)SURFACE_CLS)) {
            String[] stringArray = new String[]{RELEASE};
            this.checkRecycled(context, node, (String)type, stringArray);
        } else {
            String[] stringArray = new String[]{START};
            this.checkRecycled(context, node, (String)type, stringArray);
        }
    }

    private final void checkResourceRecycled(JavaContext context, UCallExpression node, PsiMethod method) {
        String string2 = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String name = string2;
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiClass containingClass = psiClass;
        JavaEvaluator evaluator = context.getEvaluator();
        block26 : switch (name) {
            case "obtain": 
            case "obtainNoHistory": {
                if (evaluator.extendsClass(containingClass, MOTION_EVENT_CLS, false)) {
                    String[] stringArray = new String[]{RECYCLE};
                    this.checkRecycled(context, node, MOTION_EVENT_CLS, stringArray);
                    break;
                }
                if (evaluator.extendsClass(containingClass, PARCEL_CLS, false)) {
                    String[] stringArray = new String[]{RECYCLE};
                    this.checkRecycled(context, node, PARCEL_CLS, stringArray);
                    break;
                }
                if (!evaluator.extendsClass(containingClass, VELOCITY_TRACKER_CLS, false)) break;
                String[] stringArray = new String[]{RECYCLE};
                this.checkRecycled(context, node, VELOCITY_TRACKER_CLS, stringArray);
                break;
            }
            case "obtainTypedArray": 
            case "obtainStyledAttributes": 
            case "obtainAttributes": {
                PsiClass cls;
                PsiType returnType;
                if (!evaluator.extendsClass(containingClass, "android.content.Context", false) && !evaluator.extendsClass(containingClass, "android.content.res.Resources", false) || !((returnType = method.getReturnType()) instanceof PsiClassType) || (cls = ((PsiClassType)returnType).resolve()) == null || !Intrinsics.areEqual((Object)"android.content.res.TypedArray", (Object)cls.getQualifiedName())) break;
                String[] stringArray = new String[]{RECYCLE};
                this.checkRecycled(context, node, "android.content.res.TypedArray", stringArray);
                break;
            }
            case "acquireContentProviderClient": 
            case "acquireUnstableContentProviderClient": {
                if (!evaluator.extendsClass(containingClass, CONTENT_RESOLVER_CLS, false)) break;
                String[] returnType = new String[]{RELEASE, CLOSE};
                this.checkRecycled(context, node, CONTENT_PROVIDER_CLIENT_CLS, returnType);
                break;
            }
            case "query": 
            case "queryWithFactory": 
            case "rawQueryWithFactory": 
            case "rawQuery": {
                if (!evaluator.extendsClass(containingClass, SQLITE_DATABASE_CLS, false) && !evaluator.extendsClass(containingClass, CONTENT_RESOLVER_CLS, false) && !evaluator.extendsClass(containingClass, "android.content.ContentProvider", false) && !evaluator.extendsClass(containingClass, CONTENT_PROVIDER_CLIENT_CLS, false)) break;
                String[] returnType = new String[]{CLOSE};
                this.checkRecycled(context, node, CURSOR_CLS, returnType);
                break;
            }
            case "openAssetFile": 
            case "openTypedAssetFile": 
            case "openTypedAssetFileDescriptor": 
            case "openAssetFileDescriptor": {
                if (!evaluator.extendsClass(containingClass, CONTENT_RESOLVER_CLS, false) && !evaluator.extendsClass(containingClass, CONTENT_PROVIDER_CLIENT_CLS, false)) break;
                String[] returnType = new String[]{CLOSE, CLOSE_WITH_ERROR};
                this.checkRecycled(context, node, ASSET_FILE_DESCRIPTOR_CLS, returnType);
                break;
            }
            case "openFile": 
            case "openFileDescriptor": {
                if (!evaluator.extendsClass(containingClass, CONTENT_RESOLVER_CLS, false) && !evaluator.extendsClass(containingClass, CONTENT_PROVIDER_CLIENT_CLS, false)) break;
                String[] returnType = new String[]{CLOSE, CLOSE_WITH_ERROR};
                this.checkRecycled(context, node, PARCEL_FILE_DESCRIPTOR_CLS, returnType);
                break;
            }
            case "openInputStream": {
                if (!evaluator.extendsClass(containingClass, CONTENT_RESOLVER_CLS, false)) break;
                String[] returnType = new String[]{CLOSE};
                this.checkRecycled(context, node, CLOSEABLE_CLS, returnType);
                break;
            }
            case "openOutputStream": {
                if (!evaluator.extendsClass(containingClass, CONTENT_RESOLVER_CLS, false)) break;
                String[] returnType = new String[]{CLOSE};
                this.checkRecycled(context, node, CLOSEABLE_CLS, returnType);
                break;
            }
            case "ofArgb": 
            case "ofFloat": 
            case "ofPropertyValuesHolder": 
            case "ofInt": 
            case "ofObject": {
                PsiType returnType = method.getReturnType();
                if (!(returnType instanceof PsiClassType)) break;
                String string3 = ((PsiClassType)returnType).getCanonicalText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getCanonicalText(...)");
                switch (string3) {
                    case "android.animation.AnimatorSet": {
                        String type;
                        String[] stringArray = new String[]{START};
                        this.checkRecycled(context, node, type, stringArray);
                        break block26;
                    }
                    case "android.animation.ObjectAnimator": 
                    case "android.animation.ValueAnimator": {
                        String[] stringArray = new String[]{START};
                        this.checkRecycled(context, node, ANIMATOR_CLS, stringArray);
                    }
                }
            }
        }
    }

    private final void checkRecycled(JavaContext context, UCallExpression node, String originalRecycleType, String ... recycleNames) {
        String recycleName;
        Object className;
        List list;
        Set set2;
        PsiElement psi = node.getSourcePsi();
        if (psi != null && Lint.isJava((Language)node.getLang()) && PsiTreeUtil.getParentOfType((PsiElement)psi, PsiResourceVariable.class) != null) {
            return;
        }
        UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)node), UMethod.class, (boolean)false, (int)2, null);
        if (uMethod == null) {
            return;
        }
        UMethod method = uMethod;
        Object[] objectArray = new String[]{originalRecycleType};
        List recycleTypes = CollectionsKt.mutableListOf((Object[])objectArray);
        TargetMethodDataFlowAnalyzer visitor2 = new TargetMethodDataFlowAnalyzer(recycleNames, recycleTypes, context, originalRecycleType, set2 = SetsKt.setOf((Object)node), list = CollectionsKt.emptyList()){
            final /* synthetic */ String[] $recycleNames;
            final /* synthetic */ List<String> $recycleTypes;
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ String $originalRecycleType;
            {
                this.$recycleNames = $recycleNames;
                this.$recycleTypes = $recycleTypes;
                this.$context = $context;
                this.$originalRecycleType = $originalRecycleType;
                super((Collection<? extends UElement>)$super_call_param$1, (Collection<? extends PsiVariable>)$super_call_param$2);
            }

            public boolean isTargetMethodName(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return Intrinsics.areEqual((Object)name, (Object)"use") || ArraysKt.contains((Object[])this.$recycleNames, (Object)name);
            }

            public boolean isTargetMethod(String name, PsiMethod method, UCallExpression call2, UCallableReferenceExpression methodRef2) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                if (Intrinsics.areEqual((Object)"use", (Object)name)) {
                    PsiType argumentType;
                    if (call2 != null && call2.getValueArgumentCount() == 1 && (argumentType = UastLintUtilsKt.skipLabeledExpression((UExpression)((UExpression)CollectionsKt.first((List)call2.getValueArguments()))).getExpressionType()) != null && LambdaUtil.isFunctionalType((PsiType)argumentType)) {
                        return true;
                    }
                    if (!ArraysKt.contains((Object[])this.$recycleNames, (Object)name)) {
                        return false;
                    }
                }
                if (method == null) {
                    return true;
                }
                PsiClass containingClass = method.getContainingClass();
                Object object = containingClass;
                if (object == null || (object = object.getQualifiedName()) == null) {
                    return true;
                }
                Object targetName = object;
                for (String recycleType : this.$recycleTypes) {
                    if (!Intrinsics.areEqual((Object)targetName, (Object)recycleType)) continue;
                    return true;
                }
                for (String recycleType : this.$recycleTypes) {
                    if (!JavaEvaluator.extendsClass$default((JavaEvaluator)this.$context.getEvaluator(), (PsiClass)containingClass, (String)recycleType, (boolean)false, (int)4, null)) continue;
                    return true;
                }
                return false;
            }

            public boolean visitTryExpression(UTryExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (node.getHasResources() && ArraysKt.contains((Object[])this.$recycleNames, (Object)"close")) {
                    PsiResourceList resourceList;
                    PsiElement psiElement = node.getSourcePsi();
                    PsiTryStatement psiTryStatement = psiElement instanceof PsiTryStatement ? (PsiTryStatement)psiElement : null;
                    Object object = resourceList = psiTryStatement != null ? psiTryStatement.getResourceList() : null;
                    if (resourceList != null) {
                        for (PsiResourceListElement child : resourceList) {
                            PsiReferenceExpression expression;
                            PsiExpression psiExpression;
                            if (!(child instanceof PsiResourceExpression) || ((psiExpression = ((PsiResourceExpression)child).getExpression()) instanceof PsiReferenceExpression ? (PsiReferenceExpression)psiExpression : null) == null) continue;
                            expression = expression;
                            PsiElement resolved = expression.resolve();
                            if (!CollectionsKt.contains((Iterable)this.getReferences(), (Object)resolved)) continue;
                            this.setTargetReached(true);
                            this.setTargetReference((UElement)node);
                            break;
                        }
                    }
                }
                return super.visitTryExpression(node);
            }

            public void argument(UCallExpression call2, UElement reference) {
                PsiMethod psiMethod;
                String methodName;
                PsiMethod resolved;
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                if (this.$recycleTypes.contains("android.graphics.SurfaceTexture") && UastExpressionUtils.isConstructorCall((UElement)((UElement)call2)) && (resolved = call2.resolve()) != null && this.$context.getEvaluator().isMemberInClass((PsiMember)resolved, "android.view.Surface")) {
                    return;
                }
                String string2 = Lint.getMethodName((UCallExpression)call2);
                if (string2 == null) {
                    string2 = "";
                }
                if (Intrinsics.areEqual((Object)(methodName = string2), (Object)"obtain")) {
                    PsiMethod resolved2 = call2.resolve();
                    if (this.$context.getEvaluator().isMemberInClass((PsiMember)resolved2, "android.view.MotionEvent")) {
                        return;
                    }
                } else if ((Intrinsics.areEqual((Object)methodName, (Object)"source") || Intrinsics.areEqual((Object)methodName, (Object)"sink") || Intrinsics.areEqual((Object)methodName, (Object)"buffer") || StringsKt.endsWith$default((String)methodName, (String)"Source", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)methodName, (String)"Sink", (boolean)false, (int)2, null)) && Intrinsics.areEqual((Object)((psiMethod = call2.resolve()) != null && (psiMethod = psiMethod.getContainingClass()) != null ? psiMethod.getQualifiedName() : null), (Object)"okio.Okio")) {
                    return;
                }
                super.argument(call2, reference);
            }

            private final String name(UCallExpression $this$name) {
                String string2 = $this$name.getMethodName();
                if (string2 == null) {
                    UIdentifier uIdentifier = $this$name.getMethodIdentifier();
                    string2 = uIdentifier != null ? uIdentifier.getName() : null;
                }
                return string2;
            }

            private final boolean addRecycleType(String type) {
                if (!this.$recycleTypes.contains(type)) {
                    this.$recycleTypes.add(type);
                }
                return true;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean returnsSelf(UCallExpression call2) {
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                boolean returnsSelf = super.returnsSelf(call2);
                if (returnsSelf) {
                    return true;
                }
                switch (this.$originalRecycleType) {
                    case "android.content.res.AssetFileDescriptor": {
                        String string2 = this.name(call2);
                        if (string2 == null) return false;
                        int n = -1;
                        switch (string2.hashCode()) {
                            case 135710465: {
                                if (string2.equals("getFileDescriptor")) {
                                    n = 1;
                                }
                                break;
                            }
                            case 1907572458: {
                                if (string2.equals("getParcelFileDescriptor")) {
                                    n = 2;
                                }
                                break;
                            }
                            case 1861626621: {
                                if (string2.equals("createOutputStream")) {
                                    n = 3;
                                }
                                break;
                            }
                            case 451011918: {
                                if (string2.equals("createInputStream")) {
                                    n = 4;
                                }
                                break;
                            }
                        }
                        switch (n) {
                            case 2: {
                                boolean bl = this.addRecycleType("android.os.ParcelFileDescriptor");
                                return bl;
                            }
                            case 4: {
                                boolean bl = this.addRecycleType("java.io.FileInputStream");
                                return bl;
                            }
                            case 3: {
                                boolean bl = this.addRecycleType("java.io.FileOutputStream");
                                return bl;
                            }
                            case 1: {
                                boolean bl = this.addRecycleType("java.io.FileDescriptor");
                                return bl;
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                    case "android.os.ParcelFileDescriptor": {
                        String string3 = this.name(call2);
                        if (!Intrinsics.areEqual((Object)string3, (Object)"getFileDescriptor")) {
                            if (!Intrinsics.areEqual((Object)string3, (Object)"detachFd")) return false;
                            return true;
                        }
                        boolean bl = this.addRecycleType("java.io.FileDescriptor");
                        return bl;
                    }
                    case "java.io.Closeable": {
                        PsiMethod psiMethod;
                        String string4 = this.name(call2);
                        if (string4 == null) {
                            return false;
                        }
                        String callName = string4;
                        if (Intrinsics.areEqual((Object)callName, (Object)"source")) return Intrinsics.areEqual((Object)(psiMethod != null && (psiMethod = psiMethod.getContainingClass()) != null ? psiMethod.getQualifiedName() : null), (Object)"okio.Okio");
                        if (!Intrinsics.areEqual((Object)callName, (Object)"sink")) return false;
                        psiMethod = call2.resolve();
                        return Intrinsics.areEqual((Object)(psiMethod != null && (psiMethod = psiMethod.getContainingClass()) != null ? psiMethod.getQualifiedName() : null), (Object)"okio.Okio");
                    }
                }
                return false;
            }
        };
        if (!DataFlowAnalyzerKt.isMissingTarget$default(method, visitor2, false, 2, null)) {
            return;
        }
        Object object = node.getReturnType();
        if (object == null || (object = object.getCanonicalText()) == null || (object = StringsKt.substringAfterLast$default((String)object, (String)".", null, (int)2, null)) == null) {
            object = className = StringsKt.substringAfterLast$default((String)originalRecycleType, (String)".", null, (int)2, null);
        }
        String message2 = Intrinsics.areEqual((Object)(recycleName = (String)ArraysKt.first((Object[])recycleNames)), (Object)RECYCLE) ? "This `" + (String)className + "` should be recycled after use with `#recycle()`" : (Intrinsics.areEqual((Object)recycleName, (Object)START) ? "This animation should be started with `#start()`" : "This `" + (String)className + "` should be freed up after use with `#" + recycleName + "()`");
        UElement locationNode = (UElement)node.getMethodIdentifier();
        if (locationNode == null) {
            locationNode = (UElement)node;
        }
        Location location = context.getLocation(locationNode);
        JavaContext.report$default((JavaContext)context, (Issue)RECYCLE_RESOURCE, (UElement)((UElement)node), (Location)location, (String)message2, null, (int)16, null);
    }

    private final void checkTransactionCommits(JavaContext context, UCallExpression node, PsiMethod calledMethod) {
        if (this.isBeginTransaction(context, calledMethod)) {
            List list;
            UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)node), UMethod.class, (boolean)false, (int)2, null);
            if (uMethod == null) {
                return;
            }
            UMethod method = uMethod;
            Set set2 = SetsKt.setOf((Object)node);
            TargetMethodDataFlowAnalyzer visitor2 = new TargetMethodDataFlowAnalyzer(this, context, set2, list = CollectionsKt.emptyList()){
                final /* synthetic */ CleanupDetector this$0;
                final /* synthetic */ JavaContext $context;
                {
                    this.this$0 = $receiver;
                    this.$context = $context;
                    super((Collection<? extends UElement>)$super_call_param$1, (Collection<? extends PsiVariable>)$super_call_param$2);
                }

                public boolean isTargetMethodName(String name) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    return Intrinsics.areEqual((Object)name, (Object)"show") || StringsKt.startsWith$default((String)name, (String)"commit", (boolean)false, (int)2, null);
                }

                public boolean isTargetMethod(String name, PsiMethod method) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    if (method == null) {
                        return true;
                    }
                    switch (name) {
                        case "commitNow": 
                        case "commitAllowingStateLoss": 
                        case "commit": 
                        case "commitNowAllowingStateLoss": {
                            bl = CleanupDetector.access$isMethodOnFragmentClass(this.this$0, this.$context, method, "androidx.fragment.app.FragmentTransaction", "android.app.FragmentTransaction", "android.support.v4.app.FragmentTransaction");
                            break;
                        }
                        case "show": {
                            bl = CleanupDetector.access$isMethodOnFragmentClass(this.this$0, this.$context, method, "androidx.fragment.app.DialogFragment", "android.app.DialogFragment", "android.support.v4.app.DialogFragment");
                            break;
                        }
                        default: {
                            bl = false;
                        }
                    }
                    return bl;
                }
            };
            if (DataFlowAnalyzerKt.isMissingTarget$default(method, visitor2, false, 2, null)) {
                String message2 = "This transaction should be completed with a `commit()` call";
                JavaContext.report$default((JavaContext)context, (Issue)COMMIT_FRAGMENT, (UElement)((UElement)node), (Location)context.getNameLocation((UElement)node), (String)message2, null, (int)16, null);
            }
        }
    }

    private final boolean isMethodOnFragmentClass(JavaContext context, PsiMethod method, String fragmentClass, String platformFragmentClass, String v4FragmentClass) {
        PsiClass containingClass = method.getContainingClass();
        JavaEvaluator evaluator = context.getEvaluator();
        return evaluator.extendsClass(containingClass, fragmentClass, false) || evaluator.extendsClass(containingClass, platformFragmentClass, false) || evaluator.extendsClass(containingClass, v4FragmentClass, false);
    }

    private final void checkEditorApplied(JavaContext context, UCallExpression node, PsiMethod calledMethod) {
        if (this.isSharedEditorCreation(context, calledMethod)) {
            List list;
            if (!((Collection)node.getValueArguments()).isEmpty()) {
                return;
            }
            UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)node), UMethod.class, (boolean)false, (int)2, null);
            if (uMethod == null) {
                return;
            }
            UMethod method = uMethod;
            Set set2 = SetsKt.setOf((Object)node);
            TargetMethodDataFlowAnalyzer visitor2 = new TargetMethodDataFlowAnalyzer(context, set2, list = CollectionsKt.emptyList()){
                final /* synthetic */ JavaContext $context;
                {
                    this.$context = $context;
                    super((Collection<? extends UElement>)$super_call_param$1, (Collection<? extends PsiVariable>)$super_call_param$2);
                }

                public boolean isTargetMethodName(String name) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    return Intrinsics.areEqual((Object)name, (Object)"apply") || Intrinsics.areEqual((Object)name, (Object)"commit");
                }

                public boolean isTargetMethod(String name, PsiMethod method, UCallExpression call2, UCallableReferenceExpression methodRef2) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    String string2 = name;
                    if (Intrinsics.areEqual((Object)string2, (Object)"apply")) {
                        if (method != null) {
                            PsiClass containingClass = method.getContainingClass();
                            JavaEvaluator evaluator = this.$context.getEvaluator();
                            return evaluator.extendsClass(containingClass, "android.content.SharedPreferences.Editor", false);
                        }
                        return call2 == null || call2.getValueArgumentCount() == 0;
                    }
                    if (Intrinsics.areEqual((Object)string2, (Object)"commit")) {
                        if (method != null) {
                            PsiClass containingClass = method.getContainingClass();
                            JavaEvaluator evaluator = this.$context.getEvaluator();
                            if (evaluator.extendsClass(containingClass, "android.content.SharedPreferences.Editor", false)) {
                                return true;
                            }
                        } else if (call2 == null || call2.getValueArgumentCount() == 0) {
                            return true;
                        }
                    }
                    return false;
                }
            };
            if (DataFlowAnalyzerKt.isMissingTarget$default(method, visitor2, false, 2, null)) {
                String message2 = "`SharedPreferences.edit()` without a corresponding `commit()` or `apply()` call";
                JavaContext.report$default((JavaContext)context, (Issue)SHARED_PREF, (UElement)((UElement)node), (Location)context.getLocation((UElement)node), (String)message2, null, (int)16, null);
            } else {
                UElement targetCall = visitor2.getTargetReference();
                if (targetCall instanceof UCallExpression && Intrinsics.areEqual((Object)((UCallExpression)targetCall).getMethodName(), (Object)COMMIT)) {
                    this.suggestApplyIfApplicable(context, (UCallExpression)targetCall);
                }
            }
        }
    }

    private final boolean isSharedEditorCreation(JavaContext context, PsiMethod method) {
        String string2 = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String methodName = string2;
        if (Intrinsics.areEqual((Object)EDIT, (Object)methodName)) {
            PsiClass psiClass = method.getContainingClass();
            if (psiClass == null) {
                return false;
            }
            PsiClass containingClass = psiClass;
            PsiType psiType = method.getReturnType();
            if (psiType == null) {
                return false;
            }
            PsiType type = psiType;
            JavaEvaluator evaluator = context.getEvaluator();
            return evaluator.implementsInterface(containingClass, ANDROID_CONTENT_SHARED_PREFERENCES, false) && evaluator.typeMatches(type, ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR);
        }
        return false;
    }

    private final void suggestApplyIfApplicable(JavaContext context, UCallExpression node) {
        UExpression condition;
        UElement prev = (UElement)node;
        UElement parent = node.getUastParent();
        while (parent instanceof UReferenceExpression || parent instanceof UParenthesizedExpression) {
            prev = parent;
            parent = ((UExpression)parent).getUastParent();
        }
        boolean returnValueIgnored = true;
        UElement uElement = parent;
        if (uElement instanceof UCallExpression || uElement instanceof UVariable || uElement instanceof UPolyadicExpression || uElement instanceof UUnaryExpression || uElement instanceof UReturnExpression) {
            returnValueIgnored = false;
        } else if (uElement instanceof UIfExpression) {
            condition = ((UIfExpression)parent).getCondition();
            returnValueIgnored = condition != prev;
        } else if (uElement instanceof UWhileExpression) {
            condition = ((UWhileExpression)parent).getCondition();
            returnValueIgnored = condition != prev;
        } else if (uElement instanceof UDoWhileExpression) {
            condition = ((UDoWhileExpression)parent).getCondition();
            boolean bl = returnValueIgnored = condition != prev;
        }
        if (returnValueIgnored) {
            String message2 = "Consider using `apply()` instead; `commit` writes its data to persistent storage immediately, whereas `apply` will handle it in the background";
            Location location = context.getCallLocation(node, false, true);
            LintFix fix2 = LintFix.Companion.create().name("Replace commit() with apply()").replace().pattern("(commit)\\s*\\(").with(APPLY).build();
            context.report(APPLY_SHARED_PREF, (UElement)node, location, message2, fix2);
        }
    }

    private final boolean isBeginTransaction(JavaContext context, PsiMethod method) {
        String string2 = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String methodName = string2;
        if (Intrinsics.areEqual((Object)BEGIN_TRANSACTION, (Object)methodName)) {
            PsiClass containingClass = method.getContainingClass();
            JavaEvaluator evaluator = context.getEvaluator();
            if (evaluator.extendsClass(containingClass, FRAGMENT_MANAGER_ANDROIDX_CLS, false) || evaluator.extendsClass(containingClass, FRAGMENT_MANAGER_CLS, false) || evaluator.extendsClass(containingClass, FRAGMENT_MANAGER_V4_CLS, false)) {
                return true;
            }
        }
        return false;
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final PsiVariable getVariableElement(@NotNull UCallExpression rhs, boolean allowChainedCalls, boolean allowFields) {
        return Companion.getVariableElement(rhs, allowChainedCalls, allowFields);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final PsiVariable getVariableElement(@NotNull UCallExpression rhs, boolean allowChainedCalls) {
        return Companion.getVariableElement(rhs, allowChainedCalls);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final PsiVariable getVariableElement(@NotNull UCallExpression rhs) {
        return Companion.getVariableElement(rhs);
    }

    public static final /* synthetic */ boolean access$isMethodOnFragmentClass(CleanupDetector $this, JavaContext context, PsiMethod method, String fragmentClass, String platformFragmentClass, String v4FragmentClass) {
        return $this.isMethodOnFragmentClass(context, method, fragmentClass, platformFragmentClass, v4FragmentClass);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.PERFORMANCE;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        RECYCLE_RESOURCE = Issue.Companion.create$default((Issue.Companion)companion, (String)"Recycle", (String)"Missing `recycle()` calls", (String)"\n                Many resources, such as TypedArrays, VelocityTrackers, etc., should be recycled \\\n                (with a `recycle()` call) after use. This lint check looks for missing \\\n                `recycle()` calls.", (Implementation)implementation, null, (Category)category, (int)7, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        COMMIT_FRAGMENT = Issue.Companion.create$default((Issue.Companion)companion, (String)"CommitTransaction", (String)"Missing `commit()` calls", (String)"\n                After creating a `FragmentTransaction`, you typically need to commit it as well\n                ", (Implementation)implementation, null, (Category)category, (int)7, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = new Implementation(CleanupDetector.class, Scope.JAVA_FILE_SCOPE);
        SHARED_PREF = Issue.Companion.create$default((Issue.Companion)companion, (String)"CommitPrefEdits", (String)"Missing `commit()` on `SharedPreference` editor", (String)"\n                After calling `edit()` on a `SharedPreference`, you must call `commit()` or \\\n                `apply()` on the editor to save the results.", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = new Implementation(CleanupDetector.class, Scope.JAVA_FILE_SCOPE);
        APPLY_SHARED_PREF = Issue.Companion.create$default((Issue.Companion)companion, (String)"ApplySharedPref", (String)"Use `apply()` on `SharedPreferences`", (String)"\n                Consider using `apply()` instead of `commit` on shared preferences. Whereas \\\n                `commit` blocks and writes its data to persistent storage immediately, `apply` \\\n                will handle it in the background.", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\bC\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010O\u001a\u0004\u0018\u00010P2\u0006\u0010Q\u001a\u00020R2\b\b\u0002\u0010S\u001a\u00020T2\b\b\u0002\u0010U\u001a\u00020TH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010L\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010M\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010N\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lcom/android/tools/lint/checks/CleanupDetector$Companion;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "RECYCLE_RESOURCE", "Lcom/android/tools/lint/detector/api/Issue;", "COMMIT_FRAGMENT", "SHARED_PREF", "APPLY_SHARED_PREF", "OF_INT", "", "OF_ARGB", "OF_FLOAT", "OF_OBJECT", "OF_PROPERTY_VALUES_HOLDER", "START", "RECYCLE", "RELEASE", "OBTAIN", "SHOW", "ACQUIRE_CPC", "ACQUIRE_UNSTABLE_CPC", "OBTAIN_NO_HISTORY", "OBTAIN_ATTRIBUTES", "OBTAIN_TYPED_ARRAY", "OBTAIN_STYLED_ATTRIBUTES", "BEGIN_TRANSACTION", "COMMIT", "COMMIT_NOW", "APPLY", "COMMIT_ALLOWING_LOSS", "COMMIT_NOW_ALLOWING_LOSS", "QUERY", "RAW_QUERY", "QUERY_WITH_FACTORY", "RAW_QUERY_WITH_FACTORY", "CLOSE", "CLOSE_WITH_ERROR", "EDIT", "OPEN_ASSET_FILE", "OPEN_ASSET_FILE_DESCRIPTOR", "OPEN_FILE", "OPEN_FILE_DESCRIPTOR", "OPEN_INPUT_STREAM", "OPEN_OUTPUT_STREAM", "OPEN_TYPED_ASSET_FILE", "OPEN_TYPED_ASSET_FILE_DESCRIPTOR", "MOTION_EVENT_CLS", "PARCEL_CLS", "VELOCITY_TRACKER_CLS", "DIALOG_FRAGMENT", "DIALOG_V4_FRAGMENT", "DIALOG_ANDROIDX_FRAGMENT", "FRAGMENT_MANAGER_CLS", "FRAGMENT_MANAGER_V4_CLS", "FRAGMENT_MANAGER_ANDROIDX_CLS", "FRAGMENT_TRANSACTION_CLS", "FRAGMENT_TRANSACTION_V4_CLS", "FRAGMENT_TRANSACTION_ANDROIDX_CLS", "ANIMATOR_CLS", "VALUE_ANIMATOR_CLS", "OBJECT_ANIMATOR_CLS", "ANIMATOR_SET_CLS", "SURFACE_CLS", "SURFACE_TEXTURE_CLS", "CONTENT_PROVIDER_CLIENT_CLS", "CONTENT_RESOLVER_CLS", "SQLITE_DATABASE_CLS", "CURSOR_CLS", "ANDROID_CONTENT_SHARED_PREFERENCES", "ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR", "ASSET_FILE_DESCRIPTOR_CLS", "CLOSEABLE_CLS", "FILE_INPUT_STREAM_CLS", "FILE_OUTPUT_STREAM_CLS", "FILE_DESCRIPTOR_CLS", "PARCEL_FILE_DESCRIPTOR_CLS", "getVariableElement", "Lcom/intellij/psi/PsiVariable;", "rhs", "Lorg/jetbrains/uast/UCallExpression;", "allowChainedCalls", "", "allowFields", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final PsiVariable getVariableElement(@NotNull UCallExpression rhs, boolean allowChainedCalls, boolean allowFields) {
            Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
            return DataFlowAnalyzer.Companion.getVariableElement(rhs, allowChainedCalls, allowFields);
        }

        public static /* synthetic */ PsiVariable getVariableElement$default(Companion companion, UCallExpression uCallExpression, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            return companion.getVariableElement(uCallExpression, bl, bl2);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final PsiVariable getVariableElement(@NotNull UCallExpression rhs, boolean allowChainedCalls) {
            Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
            return com.android.tools.lint.checks.CleanupDetector$Companion.getVariableElement$default(this, rhs, allowChainedCalls, false, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final PsiVariable getVariableElement(@NotNull UCallExpression rhs) {
            Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
            return com.android.tools.lint.checks.CleanupDetector$Companion.getVariableElement$default(this, rhs, false, false, 6, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

