/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.LintMapUtilsKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UReferenceExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J \u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u0016J\u0010\u0010 \u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0017H\u0016\u00a8\u0006\""}, d2={"Lcom/android/tools/lint/checks/CredentialManagerSignInWithGoogleDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "getApplicableReferenceNames", "visitReference", "reference", "Lorg/jetbrains/uast/UReferenceExpression;", "referenced", "Lcom/intellij/psi/PsiElement;", "checkPartialResults", "Lcom/android/tools/lint/detector/api/Context;", "partialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "sameMessage", "", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "new", "old", "afterCheckRootProject", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nCredentialManagerSignInWithGoogleDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CredentialManagerSignInWithGoogleDetector.kt\ncom/android/tools/lint/checks/CredentialManagerSignInWithGoogleDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1761#2,3:151\n1617#2,9:154\n1869#2:163\n1870#2:165\n1626#2:166\n1387#2:167\n1475#2,5:168\n1#3:164\n*S KotlinDebug\n*F\n+ 1 CredentialManagerSignInWithGoogleDetector.kt\ncom/android/tools/lint/checks/CredentialManagerSignInWithGoogleDetector\n*L\n80#1:151,3\n89#1:154,9\n89#1:163\n89#1:165\n89#1:166\n91#1:167\n91#1:168,5\n89#1:164\n*E\n"})
public final class CredentialManagerSignInWithGoogleDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String MESSAGE_PREFIX = "Use of `:googleid` classes without use of `GoogleIdTokenCredential";
    @NotNull
    private static final String KEY_OPTION_REFS = "OPTION_REFS";
    @NotNull
    private static final String KEY_SAW_CREATE_FROM = "SAW_CREATE_FROM";
    @NotNull
    private static final String GOOGLE_ID_PACKAGE_DOT = "com.google.android.libraries.identity.googleid.";
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(CredentialManagerSignInWithGoogleDetector.class, EnumSet.of((Enum)Scope.ALL_JAVA_FILES));
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"createFrom");
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Object object = method.getContainingClass();
        if (object == null || (object = object.getQualifiedName()) == null) {
            return;
        }
        Object qualifiedName = object;
        if (!StringsKt.startsWith$default((String)qualifiedName, (String)GOOGLE_ID_PACKAGE_DOT, (boolean)false, (int)2, null)) {
            return;
        }
        if (!StringsKt.contains$default((CharSequence)((CharSequence)qualifiedName), (CharSequence)"GoogleIdTokenCredential", (boolean)false, (int)2, null)) {
            return;
        }
        LintMap partialResults = context.getPartialResults(ISSUE).map();
        partialResults.put(KEY_SAW_CREATE_FROM, true);
    }

    @NotNull
    public List<String> getApplicableReferenceNames() {
        Object[] objectArray = new String[]{"GetGoogleIdOption", "GetSignInWithGoogleOption"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitReference(@NotNull JavaContext context, @NotNull UReferenceExpression reference, @NotNull PsiElement referenced) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)referenced, (String)"referenced");
        Object object = referenced instanceof PsiClass ? (PsiClass)referenced : null;
        if (object == null || (object = object.getQualifiedName()) == null) {
            return;
        }
        Object qualifiedName = object;
        if (!StringsKt.startsWith$default((String)qualifiedName, (String)GOOGLE_ID_PACKAGE_DOT, (boolean)false, (int)2, null)) {
            return;
        }
        String className = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)qualifiedName, (CharSequence)GOOGLE_ID_PACKAGE_DOT), (CharSequence)".Companion");
        if (!this.getApplicableReferenceNames().contains(className)) {
            return;
        }
        LintMap partialResults = context.getPartialResults(ISSUE).map();
        if (context.getDriver().isSuppressed(context, ISSUE, (UElement)reference)) {
            return;
        }
        LintMapUtilsKt.appendLocation(LintMapUtilsKt.getOrPutLintMap(partialResults, KEY_OPTION_REFS), context.getLocation((UElement)reference));
    }

    /*
     * WARNING - void declaration
     */
    public void checkPartialResults(@NotNull Context context, @NotNull PartialResult partialResults) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Object element$iv2;
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)partialResults, (String)"partialResults");
            if (context.getProject().isLibrary()) {
                return;
            }
            Iterable $this$any$iv = partialResults.maps();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    LintMap it = (LintMap)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)LintMap.getBoolean$default((LintMap)it, (String)KEY_SAW_CREATE_FROM, null, (int)2, null), (Object)true)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        Iterable $i$f$any = partialResults.maps();
        boolean $i$f$mapNotNull = false;
        element$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            LintMap it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl3 = false;
            LintMap it = (LintMap)element$iv$iv;
            boolean bl4 = false;
            if (it.getMap(KEY_OPTION_REFS) == null) continue;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$flatMapSequence = false;
        $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            LintMap it = (LintMap)element$iv$iv;
            boolean bl6 = false;
            Sequence<Location> list$iv$iv = LintMapUtilsKt.asLocationSequence(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        List locations2 = (List)destination$iv$iv;
        for (Location location : locations2) {
            Context.report$default((Context)context, (Issue)ISSUE, (Location)location, (String)"Use of `:googleid` classes without use of `GoogleIdTokenCredential.createFrom`", null, (int)8, null);
        }
    }

    public boolean sameMessage(@NotNull Issue issue, @NotNull String string2, @NotNull String old) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"new");
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        return true;
    }

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isGlobalAnalysis()) {
            this.checkPartialResults(context, context.getPartialResults(ISSUE));
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"CredentialManagerSignInWithGoogle", (String)"Misuse of Sign in with Google API", (String)"\n          When using `:googleid` classes like `GetGoogleIdOption` and `GetSignInWithGoogleOption`, \\\n          you must handle the response using `GoogleIdTokenCredential.createFrom`.\n\n          This check reports all uses of these `:googleid` classes if there are no \\\n          references to `GoogleIdTokenCredential[.Companion].createFrom`.\n          ", (Implementation)implementation, (String)"https://developer.android.com/identity/sign-in/credential-manager-siwg#create-sign", (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/checks/CredentialManagerSignInWithGoogleDetector$Companion;", "", "<init>", "()V", "MESSAGE_PREFIX", "", "KEY_OPTION_REFS", "KEY_SAW_CREATE_FROM", "GOOGLE_ID_PACKAGE_DOT", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

