/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.DomExtensions;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/checks/FineLocationDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "<init>", "()V", "checkMergedProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "permissionApplies", "", "Lorg/w3c/dom/Element;", "Companion", "lint-checks"})
public final class FineLocationDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String FINE_LOCATION_PERMISSION = "android.permission.ACCESS_FINE_LOCATION";
    @NotNull
    private static final String COARSE_LOCATION_PERMISSION = "android.permission.ACCESS_COARSE_LOCATION";
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    public void checkMergedProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getMainProject().getTargetSdk() < 31) {
            return;
        }
        Element fineElement = null;
        Element coarseElement = null;
        Document document = context.getMainProject().getMergedManifest();
        if (document == null) {
            return;
        }
        Document manifest = document;
        Element element = manifest.getDocumentElement();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getDocumentElement(...)");
        Iterator iterator = DomExtensions.iterator((Element)element);
        while (iterator.hasNext()) {
            Element node = (Element)iterator.next();
            if (!Intrinsics.areEqual((Object)node.getTagName(), (Object)"uses-permission")) continue;
            String string2 = node.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
            if (Intrinsics.areEqual((Object)string2, (Object)FINE_LOCATION_PERMISSION)) {
                if (!this.permissionApplies(node)) continue;
                fineElement = node;
                continue;
            }
            if (!Intrinsics.areEqual((Object)string2, (Object)COARSE_LOCATION_PERMISSION) || !this.permissionApplies(node)) continue;
            coarseElement = node;
        }
        if (fineElement != null && coarseElement == null) {
            context.report(new Incident(ISSUE, Context.getLocation$default((Context)context, fineElement, null, (int)2, null), "If you need access to FINE location, you must request both `ACCESS_FINE_LOCATION` and `ACCESS_COARSE_LOCATION`"));
        }
    }

    private final boolean permissionApplies(Element $this$permissionApplies) {
        String string2 = $this$permissionApplies.getAttributeNS("http://schemas.android.com/apk/res/android", "maxSdkVersion");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAttributeNS(...)");
        Integer n = StringsKt.toIntOrNull((String)string2);
        if (n == null) {
            return true;
        }
        int max = n;
        return max >= 31;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(FineLocationDetector.class, Scope.MANIFEST_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"CoarseFineLocation", (String)"Cannot use `ACCESS_FINE_LOCATION` without `ACCESS_COARSE_LOCATION`", (String)"\n                If your app requires access to FINE location, on Android 12 and higher you must \\\n                now request both FINE and COARSE. Users will have the option to grant only COARSE \\\n                location. Ensure your app can work with just COARSE location.\n            ", (Implementation)implementation, null, (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/FineLocationDetector$Companion;", "", "<init>", "()V", "FINE_LOCATION_PERMISSION", "", "COARSE_LOCATION_PERMISSION", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

