/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ManifestAttributeDetectorKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u00012\u00020\u0002:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/ManifestAttributeDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "<init>", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Companion", "lint-checks"})
public final class ManifestAttributeDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public List<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"activity-alias");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String aliasName = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        Intrinsics.checkNotNull((Object)aliasName);
        if (((CharSequence)aliasName).length() == 0) {
            return;
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap == null) {
            return;
        }
        NamedNodeMap attributes = namedNodeMap;
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String attributeName;
            Attr attr;
            Node node = attributes.item(i);
            Attr attr2 = node instanceof Attr ? (Attr)node : null;
            if (attr2 == null || !Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res/android", (Object)(attr = attr2).getNamespaceURI()) || attr.getLocalName() == null || ((CharSequence)attributeName).length() == 0 || !ManifestAttributeDetectorKt.access$getInvalidAttribute(attributeName)) continue;
            context.report(new Incident(ISSUE, (Object)element, context.getLocation((Node)attr), "Attribute `" + attributeName + "` on `<activity-alias>` `" + aliasName + "` is invalid, and will be silently ignored. This attribute is always ignored on `<activity-alias>`."));
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(ManifestAttributeDetector.class, Scope.MANIFEST_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"InvalidManifestAttribute", (String)"Invalid manifest attribute", (String)"\n          Most manifest attributes can be added to any tag without triggering any build-time \\\n          warnings or errors, but those attributes may be invalid, and will be silently ignored.\n\n          For example, only a very specific subset of `<activity>` attributes are valid on \\\n          an `<activity-alias>`; the rest are ignored, which can be confusing.\n          ", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3408, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/lint/checks/ManifestAttributeDetector$Companion;", "", "<init>", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

