/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.Api;
import com.android.tools.lint.checks.ApiClassBase;
import com.android.tools.lint.checks.Restriction;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u000eJ\u001d\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0010J\u001d\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0014H\u0010\u00a2\u0006\u0002\b\u0015J%\u0010\u0016\u001a\u00020\f2\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0010\u00a2\u0006\u0002\b\u0019J-\u0010\u001a\u001a\u00020\f2\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00142\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0010\u00a2\u0006\u0002\b\u001cR*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/checks/PrivateApiClass;", "Lcom/android/tools/lint/checks/ApiClassBase;", "name", "", "<init>", "(Ljava/lang/String;)V", "fields", "Ljava/util/HashMap;", "Lcom/android/tools/lint/checks/Restriction;", "Lkotlin/collections/HashMap;", "methods", "addField", "", "restriction", "addField$lint_checks", "addMethod", "addMethod$lint_checks", "computeExtraStorageNeeded", "", "info", "Lcom/android/tools/lint/checks/Api;", "computeExtraStorageNeeded$lint_checks", "writeSuperInterfaces", "buffer", "Ljava/nio/ByteBuffer;", "writeSuperInterfaces$lint_checks", "writeMemberData", "member", "writeMemberData$lint_checks", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nPrivateApiClass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrivateApiClass.kt\ncom/android/tools/lint/checks/PrivateApiClass\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public final class PrivateApiClass
extends ApiClassBase {
    @NotNull
    private final HashMap<String, Restriction> fields;
    @NotNull
    private final HashMap<String, Restriction> methods;

    public PrivateApiClass(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name);
        this.fields = new HashMap();
        this.methods = new HashMap();
    }

    public final void addField$lint_checks(@NotNull String name, @NotNull Restriction restriction) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)restriction), (String)"restriction");
        ((Map)this.fields).put(name, restriction);
    }

    public final void addMethod$lint_checks(@NotNull String name, @NotNull Restriction restriction) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)restriction), (String)"restriction");
        ((Map)this.methods).put(name, restriction);
    }

    public int computeExtraStorageNeeded$lint_checks(@NotNull Api<? extends ApiClassBase> info) {
        Intrinsics.checkNotNullParameter(info, (String)"info");
        int estimatedSize = 0;
        this.members = new ArrayList(this.fields.size() + this.methods.size());
        Set<String> set2 = this.fields.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-keys>(...)");
        this.members.addAll((Collection)set2);
        Set<String> set3 = this.methods.keySet();
        Intrinsics.checkNotNullExpressionValue(set3, (String)"<get-keys>(...)");
        this.members.addAll((Collection)set3);
        List list = this.members;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"members");
        CollectionsKt.sort((List)list);
        this.includeNames = true;
        for (String member : this.members) {
            estimatedSize += member.length();
            estimatedSize += 8;
        }
        return estimatedSize;
    }

    public void writeSuperInterfaces$lint_checks(@NotNull Api<? extends ApiClassBase> info, @NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter(info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
    }

    public void writeMemberData$lint_checks(@NotNull Api<? extends ApiClassBase> info, @NotNull String member, @NotNull ByteBuffer buffer) {
        int n;
        Intrinsics.checkNotNullParameter(info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Restriction restriction = StringsKt.indexOf$default((CharSequence)member, (char)'(', (int)0, (boolean)false, (int)6, null) >= 0 ? this.methods.get(member) : this.fields.get(member);
        if (restriction == null) {
            return;
        }
        Restriction payload = restriction;
        String string2 = member;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] signature = byArray;
        int n2 = signature.length;
        for (n = 0; n < n2; ++n) {
            boolean bl;
            byte b = signature[n];
            boolean bl2 = bl = b == (b & 0x7F);
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string3 = member;
                throw new AssertionError((Object)string3);
            }
            buffer.put(b);
            if (b == 41) break;
        }
        buffer.put((byte)0);
        int n3 = n = payload.getEncoding() == (payload.getEncoding() & 0xFFFFFF7F) ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        buffer.put((byte)payload.getEncoding());
    }
}

