/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.model;

import com.android.tools.lint.model.LintModelAndroidLibrary;
import com.android.tools.lint.model.LintModelDependencies;
import com.android.tools.lint.model.LintModelExternalLibrary;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelLibraryResolver;
import com.android.tools.lint.model.LintModelModuleLibrary;
import com.android.tools.lint.model.LintModelSerialization;
import com.android.tools.lint.model.LintModelWriter;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/model/LintModelLibrariesWriter;", "Lcom/android/tools/lint/model/LintModelWriter;", "adapter", "Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;", "variantName", "", "artifactName", "writer", "Ljava/io/Writer;", "<init>", "(Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;Ljava/lang/String;Ljava/lang/String;Ljava/io/Writer;)V", "writeLibraries", "", "resolver", "Lcom/android/tools/lint/model/LintModelLibraryResolver;", "filter", "Lcom/android/tools/lint/model/LintModelDependencies;", "writeLibrary", "library", "Lcom/android/tools/lint/model/LintModelLibrary;", "indent", "", "lint-model"})
@SourceDebugExtension(value={"SMAP\nLintModelSerialization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintModelSerialization.kt\ncom/android/tools/lint/model/LintModelLibrariesWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2012:1\n1#2:2013\n*E\n"})
final class LintModelLibrariesWriter
extends LintModelWriter {
    public LintModelLibrariesWriter(@NotNull LintModelSerialization.LintModelSerializationAdapter adapter, @NotNull String variantName, @NotNull String artifactName, @NotNull Writer writer) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)artifactName, (String)"artifactName");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        super(adapter, new PrintWriter(writer));
    }

    public /* synthetic */ LintModelLibrariesWriter(LintModelSerialization.LintModelSerializationAdapter lintModelSerializationAdapter, String string, String string2, Writer writer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            writer = lintModelSerializationAdapter.getWriter(LintModelSerialization.TargetFile.LIBRARY_TABLE, string, string2);
        }
        this(lintModelSerializationAdapter, string, string2, writer);
    }

    public final void writeLibraries(@NotNull LintModelLibraryResolver resolver, @Nullable LintModelDependencies filter) {
        Sequence sequence;
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        int indent = 0;
        this.indent(indent);
        this.getPrinter().println("<libraries>");
        if (filter != null) {
            Set set = CollectionsKt.toMutableSet((Iterable)filter.getCompileDependencies().getAllLibraries());
            set.addAll((Collection)filter.getPackageDependencies().getAllLibraries());
            sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)resolver.getAllLibraries()), (Function1)((Function1)new Function1<LintModelLibrary, Boolean>((Set<LintModelLibrary>)set){
                final /* synthetic */ Set<LintModelLibrary> $set;
                {
                    this.$set = $set;
                    super(1);
                }

                public final Boolean invoke(LintModelLibrary it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$set.contains(it);
                }
            }));
        } else {
            sequence = CollectionsKt.asSequence((Iterable)resolver.getAllLibraries());
        }
        Sequence libraries2 = sequence;
        for (LintModelLibrary library : libraries2) {
            this.writeLibrary(library, indent + 1);
        }
        this.indent(indent);
        this.getPrinter().println("</libraries>");
        this.getPrinter().close();
    }

    public static /* synthetic */ void writeLibraries$default(LintModelLibrariesWriter lintModelLibrariesWriter, LintModelLibraryResolver lintModelLibraryResolver, LintModelDependencies lintModelDependencies, int n, Object object) {
        if ((n & 2) != 0) {
            lintModelDependencies = null;
        }
        lintModelLibrariesWriter.writeLibraries(lintModelLibraryResolver, lintModelDependencies);
    }

    private final void writeLibrary(LintModelLibrary library, int indent) {
        this.indent(indent);
        this.getPrinter().print("<library");
        this.printName(this.getPrinter(), library.getIdentifier(), indent);
        if (library instanceof LintModelExternalLibrary) {
            LintModelWriter.printFiles$default(this, this.getPrinter(), "jars", ((LintModelExternalLibrary)library).getJarFiles(), indent, null, 8, null);
            this.printAttribute(this.getPrinter(), "resolved", ((LintModelExternalLibrary)library).getResolvedCoordinates().toString(), indent);
            File file = ((LintModelExternalLibrary)library).getPartialResultsDir();
            if (file != null) {
                File it = file;
                boolean bl = false;
                this.printFile(this.getPrinter(), "partialResultsDir", it, indent, null);
            }
        }
        if (library instanceof LintModelModuleLibrary) {
            String it = ((LintModelModuleLibrary)library).getProjectPath();
            boolean bl = false;
            this.printAttribute(this.getPrinter(), "project", it, indent);
        }
        if (library.getProvided()) {
            this.printAttribute(this.getPrinter(), "provided", "true", indent);
        }
        if (library instanceof LintModelAndroidLibrary) {
            LintModelWriter.printFile$default(this, this.getPrinter(), "folder", ((LintModelAndroidLibrary)library).getFolder(), indent, null, 8, null);
            this.printFile(this.getPrinter(), "manifest", ((LintModelAndroidLibrary)library).getManifest(), indent, ((LintModelAndroidLibrary)library).getFolder());
            this.printFile(this.getPrinter(), "resFolder", ((LintModelAndroidLibrary)library).getResFolder(), indent, ((LintModelAndroidLibrary)library).getFolder());
            this.printFile(this.getPrinter(), "assetsFolder", ((LintModelAndroidLibrary)library).getAssetsFolder(), indent, ((LintModelAndroidLibrary)library).getFolder());
            this.printFile(this.getPrinter(), "lintJar", library.getLintJar(), indent, ((LintModelAndroidLibrary)library).getFolder());
            this.printFile(this.getPrinter(), "publicResources", ((LintModelAndroidLibrary)library).getPublicResources(), indent, ((LintModelAndroidLibrary)library).getFolder());
            this.printFile(this.getPrinter(), "symbolFile", ((LintModelAndroidLibrary)library).getSymbolFile(), indent, ((LintModelAndroidLibrary)library).getFolder());
            this.printFile(this.getPrinter(), "externalAnnotations", ((LintModelAndroidLibrary)library).getExternalAnnotations(), indent, ((LintModelAndroidLibrary)library).getFolder());
            this.printFile(this.getPrinter(), "proguardRules", ((LintModelAndroidLibrary)library).getProguardRules(), indent, ((LintModelAndroidLibrary)library).getFolder());
        }
        this.getPrinter().println("/>");
    }
}

