/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

import com.android.resources.Keyboard;
import com.android.resources.Navigation;
import com.android.resources.UiMode;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.devices.ButtonType;
import com.android.sdklib.devices.Camera;
import com.android.sdklib.devices.CameraLocation;
import com.android.sdklib.devices.Hinge;
import com.android.sdklib.devices.Network;
import com.android.sdklib.devices.PowerType;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.Sensor;
import com.android.sdklib.devices.Storage;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class Hardware {
    private Screen mScreen;
    private Hinge mHinge;
    private EnumSet<Network> mNetworking = EnumSet.noneOf(Network.class);
    private EnumSet<Sensor> mSensors = EnumSet.noneOf(Sensor.class);
    private boolean mMic;
    private List<Camera> mCameras = new ArrayList<Camera>(2);
    private Keyboard mKeyboard;
    private Navigation mNav;
    private Storage mRam;
    private ButtonType mButtons;
    private List<Storage> mInternalStorage = new ArrayList<Storage>();
    private List<Storage> mRemovableStorage = new ArrayList<Storage>();
    private String mCpu;
    private String mGpu;
    private List<Abi> mAbis = new ArrayList<Abi>();
    private List<Abi> mTranslatedAbis = new ArrayList<Abi>();
    private EnumSet<UiMode> mUiModes = EnumSet.noneOf(UiMode.class);
    private PowerType mPluggedIn;
    private File mSkinFile;
    private boolean mSdCard = false;

    public void setSkinFile(File skinFile) {
        this.mSkinFile = skinFile;
    }

    public File getSkinFile() {
        return this.mSkinFile;
    }

    public Set<Network> getNetworking() {
        return this.mNetworking;
    }

    public void addNetwork(Network n) {
        this.mNetworking.add(n);
    }

    public void addAllNetworks(Collection<Network> ns) {
        this.mNetworking.addAll(ns);
    }

    public Set<Sensor> getSensors() {
        return this.mSensors;
    }

    public void addSensor(Sensor sensor) {
        this.mSensors.add(sensor);
    }

    public void addAllSensors(Collection<Sensor> sensors) {
        this.mSensors.addAll(sensors);
    }

    public boolean hasMic() {
        return this.mMic;
    }

    public void setHasMic(boolean hasMic) {
        this.mMic = hasMic;
    }

    public List<Camera> getCameras() {
        return this.mCameras;
    }

    public void addCamera(Camera c) {
        this.mCameras.add(c);
    }

    public void addAllCameras(Collection<Camera> cs) {
        this.mCameras.addAll(cs);
    }

    public Camera getCamera(int i) {
        return this.mCameras.get(i);
    }

    public Camera getCamera(CameraLocation location) {
        for (Camera c : this.mCameras) {
            if (location != c.getLocation()) continue;
            return c;
        }
        return null;
    }

    public Keyboard getKeyboard() {
        return this.mKeyboard;
    }

    public void setKeyboard(Keyboard keyboard) {
        this.mKeyboard = keyboard;
    }

    public Navigation getNav() {
        return this.mNav;
    }

    public void setNav(Navigation n) {
        this.mNav = n;
    }

    public Storage getRam() {
        return this.mRam;
    }

    public void setRam(Storage ram) {
        this.mRam = ram;
    }

    public ButtonType getButtonType() {
        return this.mButtons;
    }

    public void setButtonType(ButtonType bt) {
        this.mButtons = bt;
    }

    public List<Storage> getInternalStorage() {
        return this.mInternalStorage;
    }

    public void addInternalStorage(Storage is) {
        this.mInternalStorage.add(is);
    }

    public void addAllInternalStorage(Collection<Storage> is) {
        this.mInternalStorage.addAll(is);
    }

    public boolean hasSdCard() {
        return this.mSdCard;
    }

    public void setSdCard(boolean sdcard) {
        this.mSdCard = sdcard;
    }

    public List<Storage> getRemovableStorage() {
        return this.mRemovableStorage;
    }

    public void addRemovableStorage(Storage rs) {
        this.mRemovableStorage.add(rs);
    }

    public void addAllRemovableStorage(Collection<Storage> rs) {
        this.mRemovableStorage.addAll(rs);
    }

    public String getCpu() {
        return this.mCpu;
    }

    public void setCpu(String cpuName) {
        this.mCpu = cpuName;
    }

    public String getGpu() {
        return this.mGpu;
    }

    public void setGpu(String gpuName) {
        this.mGpu = gpuName;
    }

    public List<Abi> getSupportedAbis() {
        return ImmutableList.copyOf(this.mAbis);
    }

    public void addSupportedAbi(Abi abi) {
        if (!this.mAbis.contains((Object)abi)) {
            this.mAbis.add(abi);
        }
    }

    public void addAllSupportedAbis(Collection<Abi> abis) {
        abis.forEach(this::addSupportedAbi);
    }

    public List<Abi> getTranslatedAbis() {
        return ImmutableList.copyOf(this.mTranslatedAbis);
    }

    public void addTranslatedAbi(Abi abi) {
        this.mTranslatedAbis.add(abi);
    }

    public void addAllTranslatedAbis(Collection<Abi> abis) {
        this.mTranslatedAbis.addAll(abis);
    }

    public Set<UiMode> getSupportedUiModes() {
        return this.mUiModes;
    }

    public void addSupportedUiMode(UiMode uiMode) {
        this.mUiModes.add(uiMode);
    }

    public void addAllSupportedUiModes(Collection<UiMode> uiModes) {
        this.mUiModes.addAll(uiModes);
    }

    public PowerType getChargeType() {
        return this.mPluggedIn;
    }

    public void setChargeType(PowerType chargeType) {
        this.mPluggedIn = chargeType;
    }

    public Screen getScreen() {
        return this.mScreen;
    }

    public void setScreen(Screen s) {
        this.mScreen = s;
    }

    public Hinge getHinge() {
        return this.mHinge;
    }

    public void setHinge(Hinge mHinge) {
        this.mHinge = mHinge;
    }

    public Hardware deepCopy() {
        Hardware hw = new Hardware();
        hw.mScreen = this.mScreen != null ? this.mScreen.deepCopy() : null;
        hw.mHinge = this.mHinge != null ? this.mHinge.deepCopy() : null;
        hw.mNetworking = this.mNetworking.clone();
        hw.mSensors = this.mSensors.clone();
        hw.mMic = this.mMic;
        hw.mCameras = new ArrayList<Camera>();
        for (Camera c : this.mCameras) {
            hw.mCameras.add(c.deepCopy());
        }
        hw.mKeyboard = this.mKeyboard;
        hw.mNav = this.mNav;
        hw.mRam = this.mRam;
        hw.mButtons = this.mButtons;
        hw.mInternalStorage = new ArrayList<Storage>(this.mInternalStorage);
        hw.mRemovableStorage = new ArrayList<Storage>(this.mRemovableStorage);
        hw.mCpu = this.mCpu;
        hw.mGpu = this.mGpu;
        hw.mAbis = new ArrayList<Abi>(this.mAbis);
        hw.mTranslatedAbis = new ArrayList<Abi>(this.mTranslatedAbis);
        hw.mUiModes = this.mUiModes.clone();
        hw.mPluggedIn = this.mPluggedIn;
        hw.mSkinFile = this.mSkinFile;
        hw.mSdCard = this.mSdCard;
        return hw;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Hardware)) {
            return false;
        }
        Hardware hw = (Hardware)o;
        return Objects.equal((Object)this.mScreen, (Object)hw.getScreen()) && Objects.equal(this.mNetworking, hw.getNetworking()) && Objects.equal(this.mSensors, hw.getSensors()) && this.mMic == hw.hasMic() && this.mSdCard == hw.hasSdCard() && Objects.equal(this.mCameras, hw.getCameras()) && Objects.equal((Object)this.mKeyboard, (Object)hw.getKeyboard()) && Objects.equal((Object)this.mNav, (Object)hw.getNav()) && Objects.equal((Object)this.mRam, (Object)hw.getRam()) && Objects.equal((Object)((Object)this.mButtons), (Object)((Object)hw.getButtonType())) && Objects.equal(this.mInternalStorage, hw.getInternalStorage()) && Objects.equal(this.mRemovableStorage, hw.getRemovableStorage()) && Objects.equal((Object)this.mCpu, (Object)hw.getCpu()) && Objects.equal((Object)this.mGpu, (Object)hw.getGpu()) && Objects.equal(this.mAbis, hw.getSupportedAbis()) && Objects.equal(this.mTranslatedAbis, hw.getTranslatedAbis()) && Objects.equal(this.mUiModes, hw.getSupportedUiModes()) && Objects.equal((Object)((Object)this.mPluggedIn), (Object)((Object)hw.getChargeType())) && Objects.equal((Object)this.mSkinFile, (Object)hw.getSkinFile());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mScreen, this.mNetworking, this.mSensors, this.mMic, this.mSdCard, this.mCameras, this.mKeyboard, this.mNav, this.mRam, this.mButtons, this.mInternalStorage, this.mRemovableStorage, this.mCpu, this.mGpu, this.mAbis, this.mTranslatedAbis, this.mUiModes, this.mPluggedIn, this.mSkinFile});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Hardware <mScreen=");
        sb.append(this.mScreen);
        sb.append(", mNetworking=");
        sb.append(this.mNetworking);
        sb.append(", mSensors=");
        sb.append(this.mSensors);
        sb.append(", mMic=");
        sb.append(this.mMic);
        sb.append(", mSdCard=");
        sb.append(this.mSdCard);
        sb.append(", mCameras=");
        sb.append(this.mCameras);
        sb.append(", mKeyboard=");
        sb.append(this.mKeyboard);
        sb.append(", mNav=");
        sb.append(this.mNav);
        sb.append(", mRam=");
        sb.append(this.mRam);
        sb.append(", mButtons=");
        sb.append((Object)this.mButtons);
        sb.append(", mInternalStorage=");
        sb.append(this.mInternalStorage);
        sb.append(", mRemovableStorage=");
        sb.append(this.mRemovableStorage);
        sb.append(", mCpu=");
        sb.append(this.mCpu);
        sb.append(", mGpu=");
        sb.append(this.mGpu);
        sb.append(", mAbis=");
        sb.append(this.mAbis);
        sb.append(", mTranslatedAbis=");
        sb.append(this.mTranslatedAbis);
        sb.append(", mUiModes=");
        sb.append(this.mUiModes);
        sb.append(", mPluggedIn=");
        sb.append((Object)this.mPluggedIn);
        sb.append(", mSkinFile=");
        sb.append(this.mSkinFile);
        sb.append(">");
        return sb.toString();
    }
}

