/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import java.io.Serializable;

public interface ResourceValue
extends Serializable {
    public ResourceType getResourceType();

    public ResourceNamespace getNamespace();

    public String getName();

    public String getLibraryName();

    public boolean isUserDefined();

    default public boolean isFramework() {
        return this.getNamespace().equals(ResourceNamespace.ANDROID);
    }

    public String getValue();

    public ResourceReference asReference();

    default public ResourceUrl getResourceUrl() {
        return this.asReference().getResourceUrl();
    }

    default public ResourceReference getReference() {
        String value = this.getValue();
        if (value == null) {
            return null;
        }
        ResourceUrl url = ResourceUrl.parse(value);
        if (url == null) {
            return null;
        }
        return url.resolve(this.getNamespace(), this.getNamespaceResolver());
    }

    default public String getRawXmlValue() {
        return this.getValue();
    }

    default public String getRenderingValue() {
        return this.getRawXmlValue();
    }

    public ResourceNamespace.Resolver getNamespaceResolver();
}

