/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.ConfigurationHierarchy;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JarFileIssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Option;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\b\b&\u0018\u0000 _2\u00020\u0001:\u0001_B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0007J\u0018\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00102\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010.\u001a\u00020\u00102\u0006\u0010%\u001a\u00020&H\u0016J&\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010%\u001a\u00020&2\b\b\u0002\u00101\u001a\u00020\u00002\b\b\u0002\u00102\u001a\u000200H\u0016J\u001a\u00103\u001a\u0002002\u0006\u0010%\u001a\u00020&2\b\b\u0002\u00102\u001a\u000200H\u0014J\u000e\u00104\u001a\u0002002\u0006\u0010%\u001a\u00020&J&\u00105\u001a\u0004\u0018\u00010*2\u0006\u0010%\u001a\u00020&2\u0006\u00106\u001a\u00020*2\n\b\u0002\u00107\u001a\u0004\u0018\u00010*H\u0016J\u0012\u00105\u001a\u0004\u0018\u00010\u00012\u0006\u00108\u001a\u000209H\u0016J\u001e\u0010:\u001a\u00020;2\u0006\u0010%\u001a\u00020&2\u0006\u00106\u001a\u00020*2\u0006\u00107\u001a\u00020;J\u001e\u0010<\u001a\u00020\u00102\u0006\u0010%\u001a\u00020&2\u0006\u00106\u001a\u00020*2\u0006\u00107\u001a\u00020\u0010J&\u0010=\u001a\u0004\u0018\u00010\u001a2\u0006\u0010%\u001a\u00020&2\u0006\u00106\u001a\u00020*2\n\b\u0002\u00107\u001a\u0004\u0018\u00010\u001aH\u0016J*\u0010>\u001a\u00020?2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H&J\u0018\u0010>\u001a\u00020?2\u0006\u0010%\u001a\u00020&2\u0006\u0010@\u001a\u00020\u001aH&J\u0018\u0010>\u001a\u00020?2\u0006\u0010A\u001a\u00020*2\u0006\u0010@\u001a\u00020\u001aH&J\u001a\u0010B\u001a\u00020?2\u0006\u0010%\u001a\u00020&2\b\u0010C\u001a\u0004\u0018\u000100H&J\b\u0010D\u001a\u00020?H\u0016J\b\u0010E\u001a\u00020?H\u0016J8\u0010F\u001a\u00020?2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010G\u001a\u00020H2\b\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010K\u001a\u00020L2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020*0NH\u0016J\u000e\u0010O\u001a\b\u0012\u0004\u0012\u00020\u001a0PH\u0016J\u000e\u0010Q\u001a\u00020?2\u0006\u0010\f\u001a\u00020\u0000J\"\u0010R\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u0002000S2\u0006\u0010K\u001a\u00020L2\u0006\u0010T\u001a\u00020\u0010J,\u0010V\u001a\u00020?2\u0012\u0010W\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u0002000X2\u0006\u0010K\u001a\u00020L2\u0006\u0010T\u001a\u00020\u0010H&J$\u0010Y\u001a\u0004\u0018\u00010(2\u0006\u0010%\u001a\u00020*2\b\b\u0002\u0010T\u001a\u00020\u00102\b\b\u0002\u0010Z\u001a\u00020\u0010J0\u0010[\u001a\u0004\u0018\u00010(2\u0006\u0010%\u001a\u00020*2\b\b\u0002\u0010T\u001a\u00020\u00102\b\b\u0002\u0010Z\u001a\u00020\u00102\b\b\u0002\u00101\u001a\u00020\u0000H\u0016J4\u0010\\\u001a\u00020?2\u0006\u0010\b\u001a\u00020\t2\b\u0010G\u001a\u0004\u0018\u00010H2\u0006\u0010]\u001a\u00020L2\b\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010^\u001a\u00020*H\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00008DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000eR\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u001aX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u001c\u0010U\u001a\u0010\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u000200\u0018\u00010SX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lcom/android/tools/lint/client/api/Configuration;", "", "configurations", "Lcom/android/tools/lint/client/api/ConfigurationHierarchy;", "<init>", "(Lcom/android/tools/lint/client/api/ConfigurationHierarchy;)V", "getConfigurations", "()Lcom/android/tools/lint/client/api/ConfigurationHierarchy;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "getClient", "()Lcom/android/tools/lint/client/api/LintClient;", "parent", "getParent", "()Lcom/android/tools/lint/client/api/Configuration;", "fileLevel", "", "getFileLevel", "()Z", "setFileLevel", "(Z)V", "isOverriding", "setOverriding", "overrides", "getOverrides", "dir", "Ljava/io/File;", "getDir", "()Ljava/io/File;", "setDir", "(Ljava/io/File;)V", "baselineFile", "getBaselineFile", "setBaselineFile", "isIgnored", "context", "Lcom/android/tools/lint/detector/api/Context;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "isEnabled", "isIncludeInTests", "getDefinedSeverity", "Lcom/android/tools/lint/detector/api/Severity;", "source", "visibleDefault", "getDefaultSeverity", "getSeverity", "getOption", "name", "default", "option", "Lcom/android/tools/lint/detector/api/Option;", "getOptionAsInt", "", "getOptionAsBoolean", "getOptionAsFile", "ignore", "", "file", "issueId", "setSeverity", "severity", "startBulkEditing", "finishBulkEditing", "validateIssueIds", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "project", "Lcom/android/tools/lint/detector/api/Project;", "registry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "allowed", "", "getLintJars", "", "setParent", "getConfiguredIssues", "", "specificOnly", "configuredIssues", "addConfiguredIssues", "targetMap", "", "getIssueConfigLocation", "severityOnly", "getLocalIssueConfigLocation", "reportNonExistingIssueId", "issueRegistry", "id", "Companion", "lint-api"})
public abstract class Configuration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConfigurationHierarchy configurations;
    private boolean fileLevel;
    private boolean isOverriding;
    @Nullable
    private File dir;
    @Nullable
    private Map<String, ? extends Severity> configuredIssues;

    public Configuration(@NotNull ConfigurationHierarchy configurations) {
        Intrinsics.checkNotNullParameter((Object)configurations, (String)"configurations");
        this.configurations = configurations;
        this.fileLevel = true;
    }

    @NotNull
    public final ConfigurationHierarchy getConfigurations() {
        return this.configurations;
    }

    @NotNull
    public final LintClient getClient() {
        return this.configurations.getClient();
    }

    @Nullable
    public final Configuration getParent() {
        return this.configurations.getParentConfiguration(this);
    }

    public boolean getFileLevel() {
        return this.fileLevel;
    }

    public void setFileLevel(boolean bl) {
        this.fileLevel = bl;
    }

    public final boolean isOverriding() {
        return this.isOverriding;
    }

    public final void setOverriding(boolean bl) {
        this.isOverriding = bl;
    }

    @Nullable
    protected final Configuration getOverrides() {
        return this.isOverriding ? null : this.getClient().getConfigurations().getOverrides();
    }

    @Nullable
    public final File getDir() {
        return this.dir;
    }

    public final void setDir(@Nullable File file) {
        this.dir = file;
    }

    @Nullable
    public abstract File getBaselineFile();

    public abstract void setBaselineFile(@Nullable File var1);

    @Deprecated(message="Use the new isIgnored(Context, Incident) method instead", replaceWith=@ReplaceWith(expression="isIgnored(Incident(context, incident))", imports={"com.android.tools.lint.detector.api.Incident"}))
    public final boolean isIgnored(@NotNull Context context2, @NotNull Issue issue, @Nullable Location location2, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Location location3 = location2;
        if (location3 == null) {
            location3 = Location.NONE;
        }
        return this.isIgnored(context2, new Incident(issue, location3, message2));
    }

    public boolean isIgnored(@NotNull Context context2, @NotNull Incident incident) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Configuration configuration = this.getParent();
        return configuration != null ? configuration.isIgnored(context2, incident) : false;
    }

    public boolean isEnabled(@NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        return this.getSeverity(issue) != Severity.IGNORE;
    }

    public boolean isIncludeInTests(@NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Configuration configuration = this.getParent();
        return configuration != null ? configuration.isIncludeInTests(issue) : false;
    }

    @Nullable
    public Severity getDefinedSeverity(@NotNull Issue issue, @NotNull Configuration source, @NotNull Severity visibleDefault) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)((Object)visibleDefault), (String)"visibleDefault");
        if (!this.isOverriding && source == this) {
            Configuration configuration = this.getOverrides();
            if (configuration != null) {
                Configuration it = configuration;
                boolean bl = false;
                Severity severity = it.getDefinedSeverity(issue, source, visibleDefault);
                if (severity != null) {
                    Severity severity2 = severity;
                    boolean bl2 = false;
                    return severity2;
                }
            }
        }
        return null;
    }

    public static /* synthetic */ Severity getDefinedSeverity$default(Configuration configuration, Issue issue, Configuration configuration2, Severity severity, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getDefinedSeverity");
        }
        if ((n & 2) != 0) {
            configuration2 = configuration;
        }
        if ((n & 4) != 0) {
            severity = issue.getDefaultSeverity();
        }
        return configuration.getDefinedSeverity(issue, configuration2, severity);
    }

    @NotNull
    protected Severity getDefaultSeverity(@NotNull Issue issue, @NotNull Severity visibleDefault) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)((Object)visibleDefault), (String)"visibleDefault");
        return !issue.isEnabledByDefault() ? Severity.IGNORE : visibleDefault;
    }

    public static /* synthetic */ Severity getDefaultSeverity$default(Configuration configuration, Issue issue, Severity severity, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getDefaultSeverity");
        }
        if ((n & 2) != 0) {
            severity = issue.getDefaultSeverity();
        }
        return configuration.getDefaultSeverity(issue, severity);
    }

    @NotNull
    public final Severity getSeverity(@NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Object object = this.getOverrides();
        if (object != null && (object = Configuration.getDefinedSeverity$default(object, issue, this, null, 4, null)) != null) {
            Object it = object;
            boolean bl = false;
            return it;
        }
        Severity severity = Configuration.getDefinedSeverity$default(this, issue, null, null, 6, null);
        if (severity == null) {
            severity = Configuration.getDefaultSeverity$default(this, issue, null, 2, null);
        }
        return severity;
    }

    @Nullable
    public String getOption(@NotNull Issue issue, @NotNull String name, @Nullable String string) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = this.getOverrides();
        if (object != null && (object = ((Configuration)object).getOption(issue, name, null)) != null) {
            Object it = object;
            boolean bl = false;
            return it;
        }
        Object object2 = this.getParent();
        if (object2 == null || (object2 = ((Configuration)object2).getOption(issue, name, string)) == null) {
            object2 = string;
        }
        return object2;
    }

    public static /* synthetic */ String getOption$default(Configuration configuration, Issue issue, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getOption");
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        return configuration.getOption(issue, string, string2);
    }

    @Nullable
    public Object getOption(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        Object object = this.getOverrides();
        if (object != null && (object = ((Configuration)object).getOption(option)) != null) {
            Object it = object;
            boolean bl = false;
            return it;
        }
        Configuration configuration = this.getParent();
        return configuration != null ? configuration.getOption(option) : null;
    }

    public final int getOptionAsInt(@NotNull Issue issue, @NotNull String name, int n) {
        int n2;
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            String string = this.getOption(issue, name, null);
            n2 = string != null ? Integer.parseInt(string) : n;
        }
        catch (NumberFormatException e) {
            return n;
        }
        return n2;
    }

    public final boolean getOptionAsBoolean(@NotNull Issue issue, @NotNull String name, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = this.getOption(issue, name, null);
        return string != null ? Boolean.parseBoolean(string) : bl;
    }

    @Nullable
    public File getOptionAsFile(@NotNull Issue issue, @NotNull String name, @Nullable File file) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = this.getParent();
        if (object == null || (object = ((Configuration)object).getOptionAsFile(issue, name, file)) == null) {
            object = file;
        }
        return object;
    }

    public static /* synthetic */ File getOptionAsFile$default(Configuration configuration, Issue issue, String string, File file, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getOptionAsFile");
        }
        if ((n & 4) != 0) {
            file = null;
        }
        return configuration.getOptionAsFile(issue, string, file);
    }

    public abstract void ignore(@NotNull Context var1, @NotNull Issue var2, @Nullable Location var3, @NotNull String var4);

    public abstract void ignore(@NotNull Issue var1, @NotNull File var2);

    public abstract void ignore(@NotNull String var1, @NotNull File var2);

    public abstract void setSeverity(@NotNull Issue var1, @Nullable Severity var2);

    public void startBulkEditing() {
    }

    public void finishBulkEditing() {
    }

    public void validateIssueIds(@NotNull LintClient client, @NotNull LintDriver driver, @Nullable Project project, @NotNull IssueRegistry registry, @NotNull Set<String> allowed) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            Intrinsics.checkNotNullParameter(allowed, (String)"allowed");
            Configuration configuration = this.getParent();
            if (configuration == null) break block0;
            configuration.validateIssueIds(client, driver, project, registry, allowed);
        }
    }

    @NotNull
    public List<File> getLintJars() {
        Object object = this.getParent();
        if (object == null || (object = ((Configuration)object).getLintJars()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public final void setParent(@NotNull Configuration parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.configurations.setParent(this, parent);
    }

    @NotNull
    public final Map<String, Severity> getConfiguredIssues(@NotNull IssueRegistry registry, boolean specificOnly) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Map map = this.configuredIssues;
        if (map == null) {
            Configuration $this$getConfiguredIssues_u24lambda_u240 = this;
            boolean bl = false;
            Map map2 = new LinkedHashMap();
            Configuration configuration = $this$getConfiguredIssues_u24lambda_u240.getOverrides();
            if (configuration != null) {
                configuration.addConfiguredIssues(map2, registry, specificOnly);
            }
            $this$getConfiguredIssues_u24lambda_u240.addConfiguredIssues(map2, registry, specificOnly);
            $this$getConfiguredIssues_u24lambda_u240.configuredIssues = map2;
            map = map2;
        }
        return map;
    }

    public abstract void addConfiguredIssues(@NotNull Map<String, Severity> var1, @NotNull IssueRegistry var2, boolean var3);

    @Nullable
    public final Location getIssueConfigLocation(@NotNull String issue, boolean specificOnly, boolean severityOnly) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Object object = this.getOverrides();
        if (object != null && (object = ((Configuration)object).getLocalIssueConfigLocation(issue, specificOnly, severityOnly, this)) != null) {
            Object it = object;
            boolean bl = false;
            return it;
        }
        return Configuration.getLocalIssueConfigLocation$default(this, issue, specificOnly, severityOnly, null, 8, null);
    }

    public static /* synthetic */ Location getIssueConfigLocation$default(Configuration configuration, String string, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getIssueConfigLocation");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return configuration.getIssueConfigLocation(string, bl, bl2);
    }

    @Nullable
    public Location getLocalIssueConfigLocation(@NotNull String issue, boolean specificOnly, boolean severityOnly, @NotNull Configuration source) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return null;
    }

    public static /* synthetic */ Location getLocalIssueConfigLocation$default(Configuration configuration, String string, boolean bl, boolean bl2, Configuration configuration2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getLocalIssueConfigLocation");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            configuration2 = configuration;
        }
        return configuration.getLocalIssueConfigLocation(string, bl, bl2, configuration2);
    }

    protected final void reportNonExistingIssueId(@NotNull LintClient client, @Nullable LintDriver driver, @NotNull IssueRegistry issueRegistry, @Nullable Project project, @NotNull String id) {
        Severity severity;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)issueRegistry, (String)"issueRegistry");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String newId = IssueRegistry.Companion.getNewId(id);
        if (newId != null) {
            return;
        }
        if (IssueRegistry.Companion.isDeletedIssueId(id)) {
            return;
        }
        if (JarFileIssueRegistry.Factory.isRejectedIssueId(id)) {
            return;
        }
        String message2 = Companion.getUnknownIssueIdErrorMessage(id, issueRegistry);
        if (driver != null && (severity = this.getSeverity(IssueRegistry.UNKNOWN_ISSUE_ID)) != Severity.IGNORE) {
            Location location2 = this.getIssueConfigLocation(id, true, false);
            if (location2 == null) {
                location2 = project != null ? Lint.guessGradleLocation(project) : Location.Companion.create(new File("(unknown location; supplied by command line flags)"));
            }
            Location location3 = location2;
            LintClient.Companion companion = LintClient.Companion;
            Issue issue = IssueRegistry.UNKNOWN_ISSUE_ID;
            LintDriver lintDriver = driver;
            Object[] objectArray = new Object[]{"id", id};
            LintFix lintFix = LintFix.Companion.create().data(objectArray);
            LintClient.Companion.report$default(companion, client, issue, message2, null, null, lintFix, null, null, null, project, null, lintDriver, location3, 1496, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ$\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\r2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/client/api/Configuration$Companion;", "", "<init>", "()V", "getUnknownIssueIdErrorMessage", "", "id", "issueRegistry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "appendIssueDescription", "", "message", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "lint-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getUnknownIssueIdErrorMessage(@NotNull String id, @NotNull IssueRegistry issueRegistry) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)issueRegistry, (String)"issueRegistry");
            StringBuilder message2 = new StringBuilder(30);
            message2.append("Unknown issue id \"").append(id).append("\"");
            List<String> suggestions = issueRegistry.getIdSpellingSuggestions(id);
            if (!((Collection)suggestions).isEmpty()) {
                message2.append(". Did you mean");
                int size = suggestions.size();
                if (size == 1) {
                    message2.append(" ");
                    this.appendIssueDescription(message2, suggestions.get(0), issueRegistry);
                    message2.append(" ");
                } else {
                    message2.append(":\n");
                    for (String suggestion : suggestions) {
                        this.appendIssueDescription(message2, suggestion, issueRegistry);
                        message2.append("\n");
                    }
                }
                message2.append("?");
            }
            String string = message2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final void appendIssueDescription(StringBuilder message2, String id, IssueRegistry issueRegistry) {
            message2.append("'").append(id).append("'");
            Issue issue = issueRegistry.getIssue(id);
            if (issue != null) {
                message2.append(" (");
                message2.append(issue.getBriefDescription(TextFormat.RAW));
                message2.append(")");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

