/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.SdkConstants;
import com.android.tools.lint.client.api.CompositeIssueRegistry;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JarFileIssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintJarApiMigration;
import com.android.tools.lint.client.api.LintJarVerifier;
import com.android.tools.lint.client.api.Vendor;
import com.android.tools.lint.detector.api.ApiKt;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001dR\u0014\u0010 \u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001dR\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0015\u00a8\u0006&"}, d2={"Lcom/android/tools/lint/client/api/JarFileIssueRegistry;", "Lcom/android/tools/lint/client/api/IssueRegistry;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "jarFile", "Ljava/io/File;", "registry", "vendor", "Lcom/android/tools/lint/client/api/Vendor;", "<init>", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;Lcom/android/tools/lint/client/api/IssueRegistry;Lcom/android/tools/lint/client/api/Vendor;)V", "getJarFile", "()Ljava/io/File;", "getVendor", "()Lcom/android/tools/lint/client/api/Vendor;", "cacheable", "", "issues", "", "Lcom/android/tools/lint/detector/api/Issue;", "getIssues", "()Ljava/util/List;", "timestamp", "", "isUpToDate", "()Z", "api", "", "getApi", "()I", "minApi", "getMinApi", "maxApi", "getMaxApi", "deletedIssues", "", "getDeletedIssues", "Factory", "lint-api"})
public final class JarFileIssueRegistry
extends IssueRegistry {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final File jarFile;
    @NotNull
    private final Vendor vendor;
    @NotNull
    private final List<Issue> issues;
    private final long timestamp;
    private final int api;
    private final int minApi;
    private final int maxApi;
    @NotNull
    private final List<String> deletedIssues;
    private static final Pattern ARTIFACT_PATTERN = Pattern.compile(".*[/\\\\].gradle[/\\\\]caches[/\\\\]transforms-[0-9]+[/\\\\][0-9a-f]+[/\\\\]transformed[/\\\\](.+)[/\\\\]jars[/\\\\]lint\\.jar$");
    @NotNull
    private static final String SERVICE_KEY = "META-INF/services/com.android.tools.lint.client.api.IssueRegistry";
    @NotNull
    private static final String MF_LINT_REGISTRY = "Lint-Registry-v2";
    @NotNull
    private static final String MF_LINT_REGISTRY_OLD = "Lint-Registry";
    @NotNull
    private static final String MF_LINT_REVISION = "Lint-Revision";
    @NotNull
    private static final ConcurrentHashMap<File, SoftReference<JarFileIssueRegistry>> cache = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<File, Long> failureCache = new ConcurrentHashMap();
    @NotNull
    private static final CopyOnWriteArraySet<String> rejectedIssueIds = new CopyOnWriteArraySet();

    private JarFileIssueRegistry(LintClient client, File jarFile, IssueRegistry registry, Vendor vendor) {
        this.jarFile = jarFile;
        this.vendor = vendor;
        this.issues = CollectionsKt.toList((Iterable)registry.getIssues());
        this.timestamp = this.jarFile.lastModified();
        ClassLoader loader = registry.getClass().getClassLoader();
        if (loader instanceof URLClassLoader) {
            JarFileIssueRegistry.Factory.loadAndCloseURLClassLoader(client, this.jarFile, (URLClassLoader)loader);
        }
        this.api = registry.getApi();
        this.minApi = registry.getMinApi();
        this.maxApi = registry.getMaxApi();
        this.deletedIssues = registry.getDeletedIssues();
    }

    @NotNull
    public final File getJarFile() {
        return this.jarFile;
    }

    @Override
    @NotNull
    public Vendor getVendor() {
        return this.vendor;
    }

    @Override
    protected boolean cacheable() {
        return LintClient.Companion.isStudio();
    }

    @Override
    @NotNull
    public List<Issue> getIssues() {
        return this.issues;
    }

    @Override
    public boolean isUpToDate() {
        return this.timestamp == this.jarFile.lastModified();
    }

    @Override
    public int getApi() {
        return this.api;
    }

    @Override
    public int getMinApi() {
        return this.minApi;
    }

    @Override
    public int getMaxApi() {
        return this.maxApi;
    }

    @Override
    @NotNull
    public List<String> getDeletedIssues() {
        return this.deletedIssues;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getFailureCache$cp() {
        return failureCache;
    }

    public /* synthetic */ JarFileIssueRegistry(LintClient client, File jarFile, IssueRegistry registry, Vendor vendor, DefaultConstructorMarker $constructor_marker) {
        this(client, jarFile, registry, vendor);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JD\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\b\u0002\u0010\u001f\u001a\u00020 JD\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0006\u0010\"\u001a\u00020#J\u001f\u0010$\u001a\u00020%2\u0012\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020%0'\"\u00020%\u00a2\u0006\u0002\u0010(J\u0018\u0010)\u001a\u00020*2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u000eH\u0002J\u0012\u0010,\u001a\u00020 2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002JF\u0010-\u001a\u0004\u0018\u00010%2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010/\u001a\u00020 H\u0002J\u000e\u00100\u001a\u00020 2\u0006\u00101\u001a\u00020\bJ\u0016\u00102\u001a\u00020#2\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\u0016H\u0002J \u00105\u001a\u0002062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00107\u001a\u00020%2\u0006\u0010+\u001a\u00020\u000eH\u0002J.\u00108\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u0016092\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001aJ.\u0010:\u001a\u00020\b2\u0006\u0010;\u001a\u00020<2\u0006\u0010.\u001a\u00020\b2\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\u00162\u0006\u0010=\u001a\u00020*H\u0002J \u0010>\u001a\u00020#2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010?\u001a\u00020\u000e2\u0006\u0010@\u001a\u00020AH\u0002J\b\u0010B\u001a\u00020 H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/android/tools/lint/client/api/JarFileIssueRegistry$Factory;", "", "<init>", "()V", "ARTIFACT_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "SERVICE_KEY", "", "MF_LINT_REGISTRY", "MF_LINT_REGISTRY_OLD", "MF_LINT_REVISION", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/io/File;", "Ljava/lang/ref/SoftReference;", "Lcom/android/tools/lint/client/api/JarFileIssueRegistry;", "failureCache", "", "rejectedIssueIds", "Ljava/util/concurrent/CopyOnWriteArraySet;", "get", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "jarFiles", "", "currentProject", "Lcom/android/tools/lint/detector/api/Project;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "skipVerification", "", "registryClassName", "clearCache", "", "join", "Lcom/android/tools/lint/client/api/IssueRegistry;", "registries", "", "([Lcom/android/tools/lint/client/api/IssueRegistry;)Lcom/android/tools/lint/client/api/IssueRegistry;", "verify", "Lcom/android/tools/lint/client/api/LintJarVerifier;", "jarFile", "reportErrors", "loadIssueRegistry", "className", "attemptMigration", "isRejectedIssueId", "issueId", "recordRejectedIssues", "issues", "Lcom/android/tools/lint/detector/api/Issue;", "getVendor", "Lcom/android/tools/lint/client/api/Vendor;", "registry", "findRegistries", "", "generateVerifierMessage", "api", "", "verifier", "loadAndCloseURLClassLoader", "file", "loader", "Ljava/net/URLClassLoader;", "logJarProblems", "lint-api"})
    @SourceDebugExtension(value={"SMAP\nJarFileIssueRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JarFileIssueRegistry.kt\ncom/android/tools/lint/client/api/JarFileIssueRegistry$Factory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 ReadWrite.kt\nkotlin/io/TextStreamsKt\n*L\n1#1,861:1\n1563#2:862\n1634#2,3:863\n1563#2:867\n1634#2,3:868\n1252#2,4:889\n1563#2:893\n1634#2,3:894\n1#3:866\n1#3:879\n382#4,7:871\n382#4,7:880\n463#4:887\n413#4:888\n57#5:878\n*S KotlinDebug\n*F\n+ 1 JarFileIssueRegistry.kt\ncom/android/tools/lint/client/api/JarFileIssueRegistry$Factory\n*L\n440#1:862\n440#1:863,3\n520#1:867\n520#1:868,3\n647#1:889,4\n719#1:893\n719#1:894,3\n612#1:879\n599#1:871,7\n622#1:880,7\n647#1:887\n647#1:888\n612#1:878\n*E\n"})
    public static final class Factory {
        private Factory() {
        }

        @NotNull
        public final List<JarFileIssueRegistry> get(@NotNull LintClient client, @NotNull Collection<? extends File> jarFiles, @Nullable Project currentProject, @Nullable LintDriver driver, boolean skipVerification) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(jarFiles, (String)"jarFiles");
            Map<String, List<File>> registryMap = this.findRegistries(client, jarFiles);
            if (registryMap.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            int capacity = jarFiles.size() + 1;
            ArrayList<JarFileIssueRegistry> registries = new ArrayList<JarFileIssueRegistry>(capacity);
            for (Map.Entry<String, List<File>> entry : registryMap.entrySet()) {
                JarFileIssueRegistry registry;
                List<File> jarFiles2;
                String registryClass = entry.getKey();
                if (this.get(client, registryClass, jarFiles2 = entry.getValue(), currentProject, driver, skipVerification) == null) continue;
                registries.add(registry);
            }
            return registries;
        }

        public static /* synthetic */ List get$default(Factory factory, LintClient lintClient, Collection collection, Project project, LintDriver lintDriver, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                project = null;
            }
            if ((n & 8) != 0) {
                lintDriver = null;
            }
            if ((n & 0x10) != 0) {
                bl = false;
            }
            return factory.get(lintClient, collection, project, lintDriver, bl);
        }

        /*
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        private final JarFileIssueRegistry get(LintClient client, String registryClassName, List<? extends File> jarFiles, Project currentProject, LintDriver driver, boolean skipVerification) {
            if (skipVerification) ** GOTO lbl-1000
            v0 = driver;
            v1 = v0 != null ? v0.isIsolated() : false;
            if (v1 && LintClient.Companion.isStudio()) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            useFailureCache = v2;
            for (File jarFile : jarFiles) {
                block10: {
                    reference = (SoftReference)JarFileIssueRegistry.access$getCache$cp().get(jarFile);
                    if (reference != null && (registry = (JarFileIssueRegistry)reference.get()) != null && registry.isUpToDate()) {
                        return registry;
                    }
                    if (useFailureCache) {
                        v3 = (Long)JarFileIssueRegistry.access$getFailureCache$cp().get(jarFile);
                        v4 = v3 != null ? v3.equals(jarFile.lastModified()) : false;
                        if (v4) {
                            if (!this.logJarProblems()) continue;
                            client.log(Severity.WARNING, null, "Skipping loading of " + jarFile + ", as it previously failed to be loaded.", new Object[0]);
                            continue;
                        }
                    }
                    try {
                        IssueRegistry.Companion.reset();
                        userRegistry = this.loadIssueRegistry(client, jarFile, registryClassName, currentProject, driver, skipVerification, true);
                        if (userRegistry != null) {
                            vendor = this.getVendor(client, userRegistry, jarFile);
                            jarIssueRegistry = new JarFileIssueRegistry(client, jarFile, userRegistry, vendor, null);
                            for (Issue issue : userRegistry.getIssues()) {
                                issue.setRegistry(jarIssueRegistry);
                                if (issue.getDefaultSeverity() != Severity.IGNORE || !this.logJarProblems()) continue;
                                client.log(Severity.ERROR, null, "Issue " + issue.getId() + " has defaultSeverity=IGNORE; that's not valid. Use enabledByDefault=false instead.", new Object[0]);
                            }
                            ((Map)JarFileIssueRegistry.access$getCache$cp()).put(jarFile, new SoftReference<JarFileIssueRegistry>(jarIssueRegistry));
                            return jarIssueRegistry;
                        }
                    }
                    catch (Throwable e) {
                        if (!this.logJarProblems()) break block10;
                        var12_13 = new Object[]{jarFile};
                        client.log(e, "Could not load custom lint check jar file %1$s", var12_13);
                    }
                }
                if (!useFailureCache) continue;
                ((Map)JarFileIssueRegistry.access$getFailureCache$cp()).put(jarFile, jarFile.lastModified());
            }
            return null;
        }

        public final void clearCache() {
            cache.clear();
        }

        @NotNull
        public final IssueRegistry join(IssueRegistry ... registries) {
            Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
            return registries.length == 1 ? registries[0] : (IssueRegistry)new CompositeIssueRegistry(ArraysKt.toList((Object[])registries));
        }

        private final LintJarVerifier verify(LintClient client, File jarFile) {
            LintJarVerifier verifier;
            block2: {
                String string = System.getProperty("android.lint.skip.bytecode.verifier");
                if (string == null) {
                    string = System.getenv("ANDROID_LINT_SKIP_BYTECODE_VERIFIER");
                }
                boolean skip = Intrinsics.areEqual((Object)string, (Object)"true");
                verifier = new LintJarVerifier(client, jarFile, skip);
                Throwable throwable = verifier.getVerificationThrowable();
                if (throwable == null) break block2;
                Throwable it = throwable;
                boolean bl = false;
                if (Factory.logJarProblems()) {
                    client.log(it, "Error verifying bytecode in " + jarFile, new Object[0]);
                }
            }
            return verifier;
        }

        private final boolean reportErrors(LintDriver driver) {
            LintDriver lintDriver = driver;
            return (lintDriver != null ? lintDriver.getMode() : null) != LintDriver.DriverMode.ANALYSIS_ONLY;
        }

        /*
         * WARNING - void declaration
         */
        private final IssueRegistry loadIssueRegistry(LintClient client, File jarFile, String className, Project currentProject, LintDriver driver, boolean skipVerification, boolean attemptMigration) {
            IssueRegistry issueRegistry;
            try {
                IssueRegistry registry;
                block30: {
                    List<Issue> list;
                    List list2 = CollectionsKt.listOf((Object)jarFile);
                    ClassLoader classLoader = JarFileIssueRegistry.class.getClassLoader();
                    Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
                    ClassLoader loader = client.createUrlClassLoader(list2, classLoader);
                    Class<?> registryClass = Class.forName(className, true, loader);
                    Object obj = registryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type com.android.tools.lint.client.api.IssueRegistry");
                    registry = (IssueRegistry)obj;
                    try {
                        list = registry.getIssues();
                    }
                    catch (Throwable e) {
                        if (this.reportErrors(driver)) {
                            StringBuilder stacktrace = new StringBuilder();
                            LintDriver.Companion.appendStackTraceSummary$default(LintDriver.Companion, e, stacktrace, 0, 0, 12, null);
                            String message2 = "Lint found one or more custom checks that could not be loaded. The most likely reason for this is that it is using an older, incompatible or unsupported API in lint. Make sure these lint checks are updated to the new APIs. The issue registry class is " + className + ". The class loading issue is " + e.getMessage() + ": " + stacktrace;
                            LintClient.Companion.report$default(LintClient.Companion, client, IssueRegistry.OBSOLETE_LINT_CHECK, message2, jarFile, null, null, null, null, null, currentProject, null, driver, null, 5616, null);
                        }
                        return null;
                    }
                    List<Issue> issues2 = list;
                    if (skipVerification) {
                        return registry;
                    }
                    try {
                        if (registry.getMaxApi() < 16) {
                            return null;
                        }
                        Method apiField = registryClass.getDeclaredMethod("getApi", new Class[0]);
                        Object object = apiField.invoke((Object)registry, new Object[0]);
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                        int api = (Integer)object;
                        if (api < 16) {
                            LintJarVerifier verifier = this.verify(client, jarFile);
                            if (!verifier.isCompatible()) {
                                if (verifier.needsApiMigration() && attemptMigration) {
                                    File newJar = LintJarApiMigration.Companion.getMigratedJar(client, jarFile, className);
                                    return this.loadIssueRegistry(client, newJar, className, currentProject, driver, false, false);
                                }
                                if (this.reportErrors(driver)) {
                                    String message3 = this.generateVerifierMessage(api, className, issues2, verifier);
                                    LintClient.Companion.report$default(LintClient.Companion, client, IssueRegistry.OBSOLETE_LINT_CHECK, message3, jarFile, null, null, null, null, null, currentProject, null, driver, null, 5616, null);
                                }
                                this.recordRejectedIssues(issues2);
                                return null;
                            }
                            break block30;
                        }
                        try {
                            int minApi = registry.getMinApi();
                            if (minApi > 16) {
                                if (this.reportErrors(driver)) {
                                    String message4 = "Lint found an issue registry (`" + className + "`) which requires a newer API level. That means that the custom lint checks are intended for a newer lint version; please upgrade.";
                                    LintClient.Companion.report$default(LintClient.Companion, client, IssueRegistry.OBSOLETE_LINT_CHECK, message4, jarFile, null, null, null, null, null, currentProject, null, driver, null, 5616, null);
                                }
                                this.recordRejectedIssues(issues2);
                                return null;
                            }
                            LintJarVerifier verifier = this.verify(client, jarFile);
                            if (!verifier.isCompatible()) {
                                if (verifier.needsApiMigration() && attemptMigration) {
                                    File newJar = LintJarApiMigration.Companion.getMigratedJar(client, jarFile, className);
                                    return this.loadIssueRegistry(client, newJar, className, currentProject, driver, false, false);
                                }
                                if (this.reportErrors(driver)) {
                                    String message5 = this.generateVerifierMessage(api, className, issues2, verifier);
                                    LintClient.Companion.report$default(LintClient.Companion, client, IssueRegistry.OBSOLETE_LINT_CHECK, message5, jarFile, null, null, null, null, null, currentProject, null, driver, null, 5616, null);
                                }
                                this.recordRejectedIssues(issues2);
                                return null;
                            }
                        }
                        catch (Throwable e) {
                            if (this.logJarProblems()) {
                                client.log(e, null, new Object[0]);
                            }
                        }
                    }
                    catch (Throwable e) {
                        void $this$mapTo$iv$iv;
                        if (StringsKt.startsWith$default((String)className, (String)"androidx.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"android.", (boolean)false, (int)2, null)) {
                            return registry;
                        }
                        if (!this.reportErrors(driver)) break block30;
                        String message6 = "Lint found an issue registry (`" + className + "`)\nwhich did not specify the Lint API version it was compiled with.\n\n**This means that the lint checks are likely not compatible.**\n\nIf you are the author of this lint check, make your lint\n`IssueRegistry` class contain\n\u00a0\u00a0override val api: Int = com.android.tools.lint.detector.api.CURRENT_API\nor from Java,\n\u00a0\u00a0@Override public int getApi() { return com.android.tools.lint.detector.api.ApiKt.CURRENT_API; }";
                        Iterable $this$map$iv = issues2;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            Issue issue = (Issue)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(it.getId());
                        }
                        List issueIds = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
                        if (CollectionsKt.any((Iterable)issueIds)) {
                            message6 = message6 + StringsKt.replace$default((String)("\n\nIf you are just using lint checks from a third party library\nyou have no control over, you can disable these lint checks (if\nthey misbehave) like this:\n\n    android {\n        lintOptions {\n            disable " + CollectionsKt.joinToString$default((Iterable)issueIds, (CharSequence)",\n                    ", null, null, (int)0, null, (Function1)loadIssueRegistry.1.INSTANCE, (int)30, null) + "\n        }\n    }\n"), (String)"    ", (String)"\u00a0\u00a0\u00a0\u00a0", (boolean)false, (int)4, null);
                        }
                        LintClient.Companion.report$default(LintClient.Companion, client, IssueRegistry.OBSOLETE_LINT_CHECK, message6, jarFile, null, null, null, null, null, currentProject, null, driver, null, 5616, null);
                    }
                }
                issueRegistry = registry;
            }
            catch (Throwable e) {
                block32: {
                    Object object;
                    String string;
                    StringBuilder stacktrace;
                    block34: {
                        block33: {
                            void it;
                            block31: {
                                if (!(e instanceof ClassNotFoundException) || !Intrinsics.areEqual((Object)e.getMessage(), (Object)className)) break block31;
                                if (this.logJarProblems()) {
                                    StringBuilder stacktrace2 = new StringBuilder();
                                    LintDriver.Companion.appendStackTraceSummary$default(LintDriver.Companion, e, stacktrace2, 0, 0, 12, null);
                                    Object[] issues2 = new Object[]{jarFile, stacktrace2};
                                    client.log(e, "Could not load custom lint check jar file %1$s: %2$s", issues2);
                                }
                                break block32;
                            }
                            if (!this.reportErrors(driver)) break block32;
                            stacktrace = new StringBuilder();
                            LintDriver.Companion.appendStackTraceSummary$default(LintDriver.Companion, e, stacktrace, 0, 0, 12, null);
                            string = className;
                            object = e.getMessage();
                            if (object == null) break block33;
                            String $this$map$iv = object;
                            String string2 = string;
                            boolean bl = false;
                            String string3 = (String)it + ": ";
                            string = string2;
                            object = string3;
                            if (string3 != null) break block34;
                        }
                        object = "";
                    }
                    String message7 = "Could not load custom lint check jar file. The issue registry class is " + string + ". The initialization problem is " + (String)object + stacktrace;
                    LintClient.Companion.report$default(LintClient.Companion, client, IssueRegistry.LINT_ERROR, message7, jarFile, null, null, null, null, null, currentProject, null, driver, null, 5616, null);
                }
                issueRegistry = null;
            }
            return issueRegistry;
        }

        public final boolean isRejectedIssueId(@NotNull String issueId) {
            Intrinsics.checkNotNullParameter((Object)issueId, (String)"issueId");
            return rejectedIssueIds.contains(issueId);
        }

        /*
         * WARNING - void declaration
         */
        private final void recordRejectedIssues(List<Issue> issues2) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = issues2;
            CopyOnWriteArraySet copyOnWriteArraySet = rejectedIssueIds;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Issue issue = (Issue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId());
            }
            copyOnWriteArraySet.addAll((List)destination$iv$iv);
        }

        private final Vendor getVendor(LintClient client, IssueRegistry registry, File jarFile) {
            Vendor vendor = registry.getVendor();
            if (vendor == null) {
                Vendor inferredVendor;
                Vendor vendor2;
                String string;
                Factory $this$getVendor_u24lambda_u240 = this;
                boolean bl = false;
                String registryClass = registry.getClass().getName();
                Matcher matcher = ARTIFACT_PATTERN.matcher(jarFile.getPath());
                if (matcher.matches()) {
                    string = matcher.group(1);
                } else {
                    Intrinsics.checkNotNull((Object)registryClass);
                    String string2 = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)registryClass, (CharSequence)"IssueRegistry"), (CharSequence)"Registry"), (CharSequence)".My"), (CharSequence)".");
                    Locale locale = Locale.US;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                    String string3 = string2.toLowerCase(locale);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                }
                String identifier = string;
                Intrinsics.checkNotNull((Object)registryClass);
                if (StringsKt.startsWith$default((String)registryClass, (String)"androidx.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)registryClass, (String)"android.", (boolean)false, (int)2, null)) {
                    String string4 = "Android Open Source Project (" + identifier + ")";
                    vendor2 = new Vendor(string4, identifier, "https://issuetracker.google.com/issues/new?component=192731", null, 8, null);
                } else {
                    vendor2 = inferredVendor = StringsKt.startsWith$default((String)registryClass, (String)"com.google.", (boolean)false, (int)2, null) ? new Vendor("Google (" + identifier + ")", identifier, null, null, 12, null) : null;
                }
                if (inferredVendor != null) {
                    vendor = inferredVendor;
                } else {
                    if ($this$getVendor_u24lambda_u240.logJarProblems()) {
                        client.log(Severity.WARNING, null, registryClass + " in " + jarFile + " does not specify a vendor; see IssueRegistry#vendor", new Object[0]);
                    }
                    vendor = new Vendor(null, identifier, null, null, 13, null);
                }
            }
            return vendor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        @NotNull
        public final Map<String, List<File>> findRegistries(@NotNull LintClient client, @NotNull Collection<? extends File> jarFiles) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(jarFiles, (String)"jarFiles");
            registryClassToJarFile = new HashMap<K, V>();
            for (File jarFile : jarFiles) {
                try {
                    var6_7 = new JarFile(jarFile);
                    var7_9 = null;
                    try {
                        file = (JarFile)var6_7;
                        $i$a$-use-JarFileIssueRegistry$Factory$findRegistries$1 = false;
                        manifest = file.getManifest();
                        revision = 0;
                        revision = -1;
                        if (manifest == null) ** GOTO lbl-1000
                        attrs = manifest.getMainAttributes();
                        v0 = attrs.get(new Attributes.Name("Lint-Revision"));
                        revision = v0 != null && (v0 = v0.toString()) != null && (v0 = StringsKt.toIntOrNull((String)v0)) != null ? v0.intValue() : -1;
                        attribute = attrs.get(new Attributes.Name("Lint-Registry-v2"));
                        if (attribute == null && (attribute = attrs.get(new Attributes.Name("Lint-Registry"))) != null) {
                            revision = -2;
                        }
                        if (attribute instanceof String) {
                            className = attribute;
                            var15_23 = registryClassToJarFile;
                            key$iv = className;
                            $i$f$getOrPut = false;
                            value$iv = $this$getOrPut$iv.get(key$iv);
                            if (value$iv == null) {
                                $i$a$-getOrPut-JarFileIssueRegistry$Factory$findRegistries$1$1 = false;
                                answer$iv = new TreeMap<K, V>();
                                $this$getOrPut$iv.put(key$iv, answer$iv);
                                v1 /* !! */  = answer$iv;
                            } else {
                                v1 /* !! */  = value$iv;
                            }
                            $this$getOrPut$iv = (Map)v1 /* !! */ ;
                            $this$getOrPut$iv.put(revision, jarFile);
                        } else lbl-1000:
                        // 2 sources

                        {
                            if ((services = file.getJarEntry("META-INF/services/com.android.tools.lint.client.api.IssueRegistry")) != null) {
                                attribute = file.getInputStream(services);
                                var14_22 = null;
                                try {
                                    it = (InputStream)attribute;
                                    $i$a$-use-JarFileIssueRegistry$Factory$findRegistries$1$2 = false;
                                    reader = new InputStreamReader(it, Charsets.UTF_8);
                                    $this$useLines$iv = reader;
                                    $i$f$useLines = false;
                                    var20_36 /* !! */  = $this$useLines$iv;
                                    var21_38 = 8192;
                                    var20_36 /* !! */  = var20_36 /* !! */  instanceof BufferedReader != false ? (BufferedReader)var20_36 /* !! */  : new BufferedReader(var20_36 /* !! */ , var21_38);
                                    var21_37 = null;
                                    try {
                                        it$iv = (BufferedReader)var20_36 /* !! */ ;
                                        $i$a$-use-TextStreamsKt$useLines$1$iv = false;
                                        lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                                        $i$a$-useLines-JarFileIssueRegistry$Factory$findRegistries$1$2$1 = false;
                                        for (String line : lines) {
                                            comment = StringsKt.indexOf$default((CharSequence)line, (String)"#", (int)0, (boolean)false, (int)6, null);
                                            if (comment >= 0) {
                                                v2 = line.substring(0, comment);
                                                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"substring(...)");
                                                v3 = StringsKt.trim((CharSequence)v2).toString();
                                            } else {
                                                v3 = StringsKt.trim((CharSequence)line).toString();
                                            }
                                            if (!(((CharSequence)(className = v3)).length() > 0)) continue;
                                            var30_49 = registryClassToJarFile;
                                            key$iv = className;
                                            $i$f$getOrPut = false;
                                            value$iv = $this$getOrPut$iv.get(key$iv);
                                            if (value$iv == null) {
                                                $i$a$-getOrPut-JarFileIssueRegistry$Factory$findRegistries$1$2$1$1 = false;
                                                answer$iv = new TreeMap<K, V>();
                                                $this$getOrPut$iv.put(key$iv, answer$iv);
                                                v4 /* !! */  = answer$iv;
                                            } else {
                                                v4 /* !! */  = value$iv;
                                            }
                                            var30_49 = (Map)v4 /* !! */ ;
                                            var30_49.put(revision, jarFile);
                                        }
                                        var22_39 = Unit.INSTANCE;
                                    }
                                    catch (Throwable var23_41) {
                                        var21_37 = var23_41;
                                        throw var23_41;
                                    }
                                    finally {
                                        CloseableKt.closeFinally((Closeable)var20_36 /* !! */ , (Throwable)var21_37);
                                    }
                                    it = Unit.INSTANCE;
                                }
                                catch (Throwable $i$a$-use-JarFileIssueRegistry$Factory$findRegistries$1$2) {
                                    var14_22 = $i$a$-use-JarFileIssueRegistry$Factory$findRegistries$1$2;
                                    throw $i$a$-use-JarFileIssueRegistry$Factory$findRegistries$1$2;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)attribute, (Throwable)var14_22);
                                }
                            }
                            if (JarFileIssueRegistry.Factory.logJarProblems() && Intrinsics.areEqual((Object)jarFile.getName(), (Object)"lint.jar")) {
                                attribute = new Object[2];
                                Intrinsics.checkNotNullExpressionValue((Object)jarFile.getPath(), (String)"getPath(...)");
                                attribute[1] = "Lint-Registry-v2";
                                client.log(Severity.ERROR, null, "Custom lint rule jar %1$s does not contain a valid registry manifest key (%2$s).\nEither the custom jar is invalid, or it uses an outdated API not supported this lint client", attribute);
                            }
                        }
                        file = Unit.INSTANCE;
                    }
                    catch (Throwable $i$a$-use-JarFileIssueRegistry$Factory$findRegistries$1) {
                        var7_9 = $i$a$-use-JarFileIssueRegistry$Factory$findRegistries$1;
                        throw $i$a$-use-JarFileIssueRegistry$Factory$findRegistries$1;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)var6_7, (Throwable)var7_9);
                    }
                }
                catch (IOException e) {
                    if (!this.logJarProblems()) continue;
                    var7_9 = new Object[]{jarFile};
                    client.log(e, "Could not load custom lint check jar file %1$s", var7_9);
                }
            }
            $this$mapValues$iv = registryClassToJarFile;
            $i$f$mapValues = false;
            e = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            $i$f$mapValuesTo = false;
            $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            $i$f$associateByTo = false;
            for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                attribute = (Map.Entry)element$iv$iv$iv;
                var14_22 = destination$iv$iv;
                $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv = false;
                $i$a$-use-JarFileIssueRegistry$Factory$findRegistries$1$2 = (Map.Entry)element$iv$iv$iv;
                var36_56 = it$iv$iv.getKey();
                var35_55 = var14_22;
                $i$a$-mapValues-JarFileIssueRegistry$Factory$findRegistries$2 = false;
                v5 = ((TreeMap)entry.getValue()).values();
                Intrinsics.checkNotNullExpressionValue(v5, (String)"<get-values>(...)");
                var37_57 = CollectionsKt.reversed((Iterable)v5);
                var35_55.put(var36_56, var37_57);
            }
            return destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final String generateVerifierMessage(int api, String className, List<Issue> issues2, LintJarVerifier verifier) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            StringBuilder sb = new StringBuilder();
            StringBuilder stringBuilder = api > 16 ? sb.append("Requires newer lint; ") : (api < 16 ? sb.append("Library lint checks out of date;\n") : sb.append("Library lint checks reference invalid APIs; "));
            sb.append("these checks **will be skipped**!\n\n");
            sb.append("Lint found an issue registry (`" + className + "`)\n");
            StringBuilder stringBuilder2 = api > 16 ? sb.append("which was compiled against a newer version of lint\nthan this one. This is usually fine, but not in this\ncase; some basic verification shows that the lint\ncheck jar references (for example) the following API\nwhich is not valid in the version of lint which is running:") : (api < 16 ? sb.append("which was compiled against an older version of lint\nthan this one. This is usually fine, but not in this\ncase; some basic verification shows that the lint\ncheck jar references (for example) the following API\nwhich is no longer valid in this version of lint:") : sb.append("which contains some references to invalid API:"));
            String reference = LintJarVerifier.describeFirstIncompatibleReference$default(verifier, false, 1, null);
            String referenceClassFile = verifier.getReferenceClassFile();
            sb.append(StringsKt.trimIndent((String)("\n\n                " + reference + "\n                (Referenced from " + referenceClassFile + ")\n\n                Therefore, this lint check library is **not** included\n                in analysis. This affects the following lint checks:\n\n                ")));
            Iterable iterable = issues2;
            StringBuilder stringBuilder3 = sb;
            boolean $i$f$map = false;
            void var10_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                Issue issue = (Issue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.getId());
            }
            stringBuilder3.append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)(issues2.size() > 5 ? "\n" : ","), null, null, (int)0, null, (Function1)generateVerifierMessage.2.INSTANCE, (int)30, null));
            sb.append("\n\n");
            StringBuilder stringBuilder4 = Intrinsics.areEqual((Object)reference, (Object)"org.jetbrains.uast.kotlin.KotlinUClass#getKtClass(): org.jetbrains.kotlin.psi.KtClassOrObject") && Intrinsics.areEqual((Object)className, (Object)"androidx.fragment.lint.FragmentIssueRegistry") && LintClient.Companion.isGradle() ? sb.append("**This is a known bug which is already fixed in\n`androidx.fragment:fragment:1.5.1` and later**; update\nto that version. If you are not directly depending\non this library but picking it up via a transitive\ndependency, explicitly add\n`implementation 'androidx.fragment:fragment:1.5.1'`\n(or later) to your build.gradle dependency block.") : (api > 16 ? sb.append("To use this lint check, upgrade to a more recent version\nof lint.") : (api < 16 ? sb.append("Recompile the checks against the latest version, or if\nthis is a check bundled with a third-party library, see\nif there is a more recent version available.") : sb.append("To use this lint check, upgrade to a more recent version\nof the library.")));
            if (api != 16) {
                sb.append(StringsKt.trimIndent((String)("\n\n\n                    Version of Lint API this lint check is using is " + api + ".\n                    The Lint API version currently running is 16 (" + ApiKt.describeApi(16) + ").\n                    ")));
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void loadAndCloseURLClassLoader(LintClient client, File file, URLClassLoader loader) {
            if (SdkConstants.CURRENT_PLATFORM != 2) {
                return;
            }
            try {
                Closeable closeable = new JarFile(file);
                Throwable throwable = null;
                try {
                    JarFile jar = (JarFile)closeable;
                    boolean bl = false;
                    Enumeration<JarEntry> enumeration = jar.entries();
                    while (enumeration.hasMoreElements()) {
                        JarEntry entry = enumeration.nextElement();
                        String path2 = entry.getName();
                        Intrinsics.checkNotNull((Object)path2);
                        if (!StringsKt.endsWith$default((String)path2, (String)".class", (boolean)false, (int)2, null) || StringsKt.indexOf$default((CharSequence)path2, (char)'$', (int)0, (boolean)false, (int)6, null) != -1) continue;
                        String string = path2.substring(0, path2.length() - 6);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        String name = StringsKt.replace$default((String)string, (char)'/', (char)'.', (boolean)false, (int)4, null);
                        try {
                            Class<?> cls = Class.forName(name, true, loader);
                            if (cls.isAnnotation() || cls.isEnum() || cls.isInterface()) continue;
                            try {
                                Constructor<?> defaultConstructor = cls.getConstructor(new Class[0]);
                                defaultConstructor.setAccessible(true);
                                defaultConstructor.newInstance(new Object[0]);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                            }
                        }
                        catch (Throwable e) {
                            if (!Factory.logJarProblems()) continue;
                            client.log(Severity.ERROR, e, "Failed to prefetch " + name + " from " + file, new Object[0]);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                try {
                    loader.close();
                }
                catch (Throwable throwable) {}
            }
        }

        private final boolean logJarProblems() {
            return !Intrinsics.areEqual((Object)System.getProperty("android.lint.log-jar-problems"), (Object)"false");
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

