/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.ConfigurationHierarchy;
import com.android.tools.lint.client.api.FlagConfiguration;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.model.LintModelLintOptions;
import com.android.tools.lint.model.LintModelSeverity;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ2\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0018H\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\b\u0010\u001b\u001a\u00020\u0007H\u0016J\b\u0010\u001c\u001a\u00020\u0007H\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0010\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0016J\u0010\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u000bH\u0016J\u0010\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u000bH\u0016J\u0010\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u000bH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\b\u0010#\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/lint/client/api/LintOptionsConfiguration;", "Lcom/android/tools/lint/client/api/FlagConfiguration;", "configurations", "Lcom/android/tools/lint/client/api/ConfigurationHierarchy;", "lintOptions", "Lcom/android/tools/lint/model/LintModelLintOptions;", "fatalOnly", "", "<init>", "(Lcom/android/tools/lint/client/api/ConfigurationHierarchy;Lcom/android/tools/lint/model/LintModelLintOptions;Z)V", "disabledIds", "", "", "disabledCategories", "Lcom/android/tools/lint/detector/api/Category;", "enabledIds", "enabledCategories", "exactIds", "exactCategories", "partition", "", "candidates", "", "ids", "", "categories", "isWarningsAsErrors", "isIgnoreWarnings", "isCheckAllWarnings", "exactCheckedIds", "severityOverride", "Lcom/android/tools/lint/detector/api/Severity;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "severityOverrides", "allowSuppress", "lint-api"})
public class LintOptionsConfiguration
extends FlagConfiguration {
    @NotNull
    private final LintModelLintOptions lintOptions;
    private final boolean fatalOnly;
    @NotNull
    private Set<String> disabledIds;
    @NotNull
    private Set<Category> disabledCategories;
    @NotNull
    private Set<String> enabledIds;
    @NotNull
    private Set<Category> enabledCategories;
    @Nullable
    private Set<String> exactIds;
    @Nullable
    private Set<Category> exactCategories;

    public LintOptionsConfiguration(@NotNull ConfigurationHierarchy configurations, @NotNull LintModelLintOptions lintOptions, boolean fatalOnly) {
        Intrinsics.checkNotNullParameter((Object)configurations, (String)"configurations");
        Intrinsics.checkNotNullParameter((Object)lintOptions, (String)"lintOptions");
        super(configurations);
        this.lintOptions = lintOptions;
        this.fatalOnly = fatalOnly;
        Set disable = this.lintOptions.getDisable();
        if (disable.isEmpty()) {
            this.disabledIds = SetsKt.emptySet();
            this.disabledCategories = SetsKt.emptySet();
        } else {
            this.disabledIds = new LinkedHashSet();
            this.disabledCategories = new LinkedHashSet();
            Collection collection = disable;
            Set<String> set = this.disabledIds;
            Intrinsics.checkNotNull(set, (String)"null cannot be cast to non-null type kotlin.collections.MutableSet<kotlin.String>");
            Set set2 = TypeIntrinsics.asMutableSet(set);
            Set<Category> set3 = this.disabledCategories;
            Intrinsics.checkNotNull(set3, (String)"null cannot be cast to non-null type kotlin.collections.MutableSet<com.android.tools.lint.detector.api.Category>");
            this.partition(collection, set2, TypeIntrinsics.asMutableSet(set3));
        }
        Set enable = this.lintOptions.getEnable();
        if (enable.isEmpty()) {
            this.enabledIds = SetsKt.emptySet();
            this.enabledCategories = SetsKt.emptySet();
        } else {
            this.enabledIds = new LinkedHashSet();
            this.enabledCategories = new LinkedHashSet();
            Collection collection = enable;
            Set<String> set = this.enabledIds;
            Intrinsics.checkNotNull(set, (String)"null cannot be cast to non-null type kotlin.collections.MutableSet<kotlin.String>");
            Set set4 = TypeIntrinsics.asMutableSet(set);
            Set<Category> set5 = this.enabledCategories;
            Intrinsics.checkNotNull(set5, (String)"null cannot be cast to non-null type kotlin.collections.MutableSet<com.android.tools.lint.detector.api.Category>");
            this.partition(collection, set4, TypeIntrinsics.asMutableSet(set5));
        }
        Set check = this.lintOptions.getCheck();
        if (check == null || check.isEmpty()) {
            this.exactIds = null;
            this.exactCategories = null;
        } else {
            this.exactIds = new LinkedHashSet();
            this.exactCategories = new LinkedHashSet();
            Collection collection = check;
            Set<String> set = this.exactIds;
            Intrinsics.checkNotNull(set, (String)"null cannot be cast to non-null type kotlin.collections.MutableSet<kotlin.String>");
            Set set6 = TypeIntrinsics.asMutableSet(set);
            Set<Category> set7 = this.exactCategories;
            Intrinsics.checkNotNull(set7, (String)"null cannot be cast to non-null type kotlin.collections.MutableSet<com.android.tools.lint.detector.api.Category>");
            this.partition(collection, set6, TypeIntrinsics.asMutableSet(set7));
        }
    }

    public /* synthetic */ LintOptionsConfiguration(ConfigurationHierarchy configurationHierarchy, LintModelLintOptions lintModelLintOptions, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(configurationHierarchy, lintModelLintOptions, bl);
    }

    private final void partition(Collection<String> candidates, Set<String> ids, Set<Category> categories) {
        for (String id : candidates) {
            Category category = Category.Companion.getCategory(id);
            boolean bl = category != null ? categories.add(category) : ids.add(id);
        }
    }

    @Override
    public boolean fatalOnly() {
        return this.fatalOnly;
    }

    @Override
    public boolean isWarningsAsErrors() {
        return this.lintOptions.getWarningsAsErrors();
    }

    @Override
    public boolean isIgnoreWarnings() {
        return this.lintOptions.getIgnoreWarnings();
    }

    @Override
    public boolean isCheckAllWarnings() {
        return this.lintOptions.getCheckAllWarnings();
    }

    @Override
    @NotNull
    public Set<String> disabledIds() {
        return this.disabledIds;
    }

    @Override
    @NotNull
    public Set<String> enabledIds() {
        return this.enabledIds;
    }

    @Override
    @Nullable
    public Set<String> exactCheckedIds() {
        return this.exactIds;
    }

    @Override
    @Nullable
    public Set<Category> disabledCategories() {
        return this.disabledCategories;
    }

    @Override
    @Nullable
    public Set<Category> enabledCategories() {
        return this.enabledCategories;
    }

    @Override
    @Nullable
    public Set<Category> exactCategories() {
        return this.exactCategories;
    }

    @Override
    @Nullable
    public Severity severityOverride(@NotNull Issue issue) {
        Severity severity;
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Map map = this.lintOptions.getSeverityOverrides();
        LintModelSeverity lintModelSeverity = map != null ? (LintModelSeverity)map.get(issue.getId()) : null;
        switch (lintModelSeverity == null ? -1 : WhenMappings.$EnumSwitchMapping$0[lintModelSeverity.ordinal()]) {
            case 1: {
                severity = Severity.FATAL;
                break;
            }
            case 2: {
                severity = Severity.ERROR;
                break;
            }
            case 3: {
                severity = Severity.WARNING;
                break;
            }
            case 4: {
                severity = Severity.INFORMATIONAL;
                break;
            }
            case 5: {
                severity = Severity.IGNORE;
                break;
            }
            case 6: {
                severity = issue.getDefaultSeverity();
                break;
            }
            default: {
                severity = null;
            }
        }
        return severity;
    }

    @Override
    @NotNull
    public Set<String> severityOverrides() {
        Object object = this.lintOptions.getSeverityOverrides();
        if (object == null || (object = object.keySet()) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    @Override
    public boolean allowSuppress() {
        return false;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LintModelSeverity.values().length];
            try {
                nArray[LintModelSeverity.FATAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LintModelSeverity.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LintModelSeverity.WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LintModelSeverity.INFORMATIONAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LintModelSeverity.IGNORE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LintModelSeverity.DEFAULT_ENABLED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

