/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.SdkConstants;
import com.android.ide.common.util.PathString;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.ConfigurationHierarchy;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.BooleanOption;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.FileOption;
import com.android.tools.lint.detector.api.FloatOption;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.IntOption;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Option;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.StringOption;
import com.android.tools.lint.model.PathVariables;
import com.android.utils.CharSequenceReader;
import com.android.utils.DomExtensions;
import com.android.utils.SdkUtils;
import com.google.common.base.Splitter;
import com.intellij.openapi.util.io.FileUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010 \n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001c\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\b\u0016\u0018\u0000 \u00a2\u00012\u00020\u0001:\u0004\u00a1\u0001\u00a2\u0001B/\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0019\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\rJ$\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020&2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\b0/H\u0002J\u0010\u00100\u001a\u00020\b2\u0006\u00101\u001a\u000202H\u0016J\u0018\u00103\u001a\u00020\b2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J$\u00108\u001a\u0004\u0018\u00010&2\u0006\u00101\u001a\u0002022\u0006\u00109\u001a\u00020&2\b\u0010:\u001a\u0004\u0018\u00010&H\u0002J$\u0010;\u001a\u0004\u0018\u00010&2\u0006\u00101\u001a\u0002022\u0006\u00109\u001a\u00020&2\b\u0010:\u001a\u0004\u0018\u00010&H\u0016J\u0018\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020&H\u0002J\u0012\u0010;\u001a\u0004\u0018\u00010A2\u0006\u0010>\u001a\u00020?H\u0016J$\u0010B\u001a\u0004\u0018\u00010\u00052\u0006\u00101\u001a\u0002022\u0006\u00109\u001a\u00020&2\b\u0010:\u001a\u0004\u0018\u00010\u0005H\u0016J \u0010C\u001a\u00020=2\u0006\u00101\u001a\u0002022\u0006\u00109\u001a\u00020&2\b\u0010D\u001a\u0004\u0018\u00010&J%\u0010E\u001a\u00020=2\u0006\u00101\u001a\u0002022\u0006\u00109\u001a\u00020&2\b\u0010D\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010FJ%\u0010G\u001a\u00020=2\u0006\u00101\u001a\u0002022\u0006\u00109\u001a\u00020&2\b\u0010D\u001a\u0004\u0018\u00010H\u00a2\u0006\u0002\u0010IJ \u0010J\u001a\u00020=2\u0006\u00101\u001a\u0002022\u0006\u00109\u001a\u00020&2\b\u0010D\u001a\u0004\u0018\u00010\u0005J \u0010K\u001a\u00020\b2\u0006\u0010-\u001a\u00020&2\u0006\u0010L\u001a\u00020M2\u0006\u00104\u001a\u000205H\u0002J \u0010K\u001a\u00020\b2\u0006\u0010N\u001a\u00020'2\u0006\u0010L\u001a\u00020M2\u0006\u00104\u001a\u000205H\u0002J\u001e\u0010O\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0%2\b\u0010P\u001a\u0004\u0018\u00010&H\u0002J\u001a\u0010Q\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0)0#H\u0002J\u0014\u0010R\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0%H\u0002J(\u0010S\u001a\u00020\b2\u0006\u0010-\u001a\u00020&2\u0006\u0010@\u001a\u00020&2\u0006\u0010L\u001a\u00020M2\u0006\u00104\u001a\u000205H\u0002J(\u0010S\u001a\u00020\b2\u0006\u0010N\u001a\u00020'2\u0006\u0010@\u001a\u00020&2\u0006\u0010L\u001a\u00020M2\u0006\u00104\u001a\u000205H\u0002J,\u0010T\u001a\u00020=2\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020V0%2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020\bH\u0016J*\u0010Z\u001a\u0004\u0018\u00010M2\u0006\u00101\u001a\u00020&2\u0006\u0010Y\u001a\u00020\b2\u0006\u0010[\u001a\u00020\b2\u0006\u0010\\\u001a\u00020\u0001H\u0016J\"\u0010]\u001a\u0004\u0018\u00010V2\u0006\u00101\u001a\u0002022\u0006\u0010\\\u001a\u00020\u00012\u0006\u0010^\u001a\u00020VH\u0016J\b\u0010_\u001a\u00020=H\u0002J\u0018\u0010`\u001a\u00020M2\u0006\u0010-\u001a\u00020&2\u0006\u0010[\u001a\u00020\bH\u0002J\u001c\u0010a\u001a\u00020M2\u0012\u0010b\u001a\u000e\u0012\u0004\u0012\u00020c\u0012\u0004\u0012\u00020\b0/H\u0002J\u0010\u0010a\u001a\u00020M2\u0006\u0010d\u001a\u00020eH\u0002J\u0010\u0010a\u001a\u00020M2\u0006\u0010f\u001a\u00020gH\u0002J>\u0010h\u001a\u00020=2\u0006\u0010@\u001a\u00020&2\n\b\u0002\u0010d\u001a\u0004\u0018\u00010e2\n\b\u0002\u0010f\u001a\u0004\u0018\u00010g2\n\b\u0002\u0010L\u001a\u0004\u0018\u00010M2\b\b\u0002\u0010i\u001a\u00020VH\u0002J\b\u0010j\u001a\u00020=H\u0002J\u0010\u0010j\u001a\u00020=2\u0006\u0010d\u001a\u00020eH\u0002J&\u0010k\u001a\u00020\b2\b\u0010P\u001a\u0004\u0018\u00010&2\b\b\u0002\u0010l\u001a\u00020\b2\b\b\u0002\u0010m\u001a\u00020\bH\u0002J2\u0010n\u001a\u00020=2\f\u0010o\u001a\b\u0012\u0004\u0012\u00020&0p2\u0006\u0010i\u001a\u00020V2\b\u0010+\u001a\u0004\u0018\u00010&2\b\u0010q\u001a\u0004\u0018\u00010&H\u0002J:\u0010r\u001a\u00020=2\f\u0010s\u001a\b\u0012\u0004\u0012\u00020&0p2\u0006\u0010t\u001a\u00020H2\u0006\u0010u\u001a\u00020&2\b\u0010+\u001a\u0004\u0018\u00010&2\b\u0010q\u001a\u0004\u0018\u00010&H\u0002JJ\u0010v\u001a\u00020=2\u0006\u0010d\u001a\u00020e2\u0006\u0010o\u001a\u00020&2\f\u0010s\u001a\b\u0012\u0004\u0012\u00020&0p2\u0006\u0010t\u001a\u00020H2\u0006\u0010w\u001a\u00020&2\b\u0010+\u001a\u0004\u0018\u00010&2\b\u0010q\u001a\u0004\u0018\u00010&H\u0002J>\u0010x\u001a\u00020=2\f\u0010s\u001a\b\u0012\u0004\u0012\u00020&0p2\u0006\u0010y\u001a\u00020&2\u0006\u0010D\u001a\u00020&2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010&2\n\b\u0002\u0010q\u001a\u0004\u0018\u00010&H\u0002J.\u0010z\u001a\u00020=2\f\u0010s\u001a\b\u0012\u0004\u0012\u00020&0p2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010&2\n\b\u0002\u0010q\u001a\u0004\u0018\u00010&H\u0002J\r\u0010{\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010|J\r\u0010}\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010|J\r\u0010~\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010|J\r\u0010\u007f\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010|J\u000e\u0010\u0080\u0001\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010|J\u000e\u0010\u0081\u0001\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010|J\u000e\u0010\u0082\u0001\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010|J\u000e\u0010\u0083\u0001\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010|J\u000e\u0010\u0084\u0001\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010|J\u000e\u0010\u0085\u0001\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010|J\u000e\u0010\u0086\u0001\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010|J\u000e\u0010\u0087\u0001\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010|J\u000f\u0010\u0088\u0001\u001a\b\u0012\u0004\u0012\u00020\u00050#H\u0016J\t\u0010\u0089\u0001\u001a\u00020=H\u0002J#\u0010\u008a\u0001\u001a\u00020=2\b\u0010\u008b\u0001\u001a\u00030\u008c\u00012\u0006\u00109\u001a\u00020&2\u0006\u0010D\u001a\u00020&H\u0002J+\u0010\u008d\u0001\u001a\u00020=2\u0006\u00104\u001a\u0002052\u0006\u00101\u001a\u0002022\b\u0010L\u001a\u0004\u0018\u00010M2\u0006\u0010@\u001a\u00020&H\u0016J\u001a\u0010\u008d\u0001\u001a\u00020=2\u0006\u00101\u001a\u0002022\u0007\u0010\u008e\u0001\u001a\u00020\u0005H\u0016J\u001b\u0010\u008d\u0001\u001a\u00020=2\u0007\u0010\u008f\u0001\u001a\u00020&2\u0007\u0010\u008e\u0001\u001a\u00020\u0005H\u0016J\u001b\u0010\u0090\u0001\u001a\u00020=2\u0006\u00101\u001a\u0002022\b\u0010i\u001a\u0004\u0018\u00010VH\u0016J\t\u0010\u0091\u0001\u001a\u00020=H\u0016J\t\u0010\u0092\u0001\u001a\u00020=H\u0016J>\u0010\u0099\u0001\u001a\u00020=2\u0007\u0010P\u001a\u00030\u009a\u00012\b\u0010\u009b\u0001\u001a\u00030\u009c\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010W\u001a\u00020X2\u000e\u0010\u009d\u0001\u001a\t\u0012\u0004\u0012\u00020&0\u009e\u0001H\u0016JS\u0010\u0099\u0001\u001a\u00020=2\u0007\u0010P\u001a\u00030\u009a\u00012\b\u0010\u009b\u0001\u001a\u00030\u009c\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010W\u001a\u00020X2\u0013\u0010\u009f\u0001\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0%2\u000e\u0010\u009d\u0001\u001a\t\u0012\u0004\u0012\u00020&0\u009e\u0001H\u0002J\t\u0010\u00a0\u0001\u001a\u00020&H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0012\u0010\u0017\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0012\u0010\u0018\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0012\u0010\u0019\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0012\u0010\u001a\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0012\u0010\u001b\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0012\u0010\u001c\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0012\u0010\u001d\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0012\u0010\u001e\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0012\u0010\u001f\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0012\u0010 \u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0012\u0010!\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0016\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010$\u001a\u0010\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010(\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0)0#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010*\u001a\u001c\u0012\u0004\u0012\u00020&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0%\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0093\u0001\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\u0094\u0001\u001a\u0004\u0018\u00010\u00052\b\u0010D\u001a\u0004\u0018\u00010\u00058V@VX\u0096\u000e\u00a2\u0006\u000f\u001a\u0005\b\u0095\u0001\u0010\u000f\"\u0006\b\u0096\u0001\u0010\u0097\u0001R\u000f\u0010\u0098\u0001\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a3\u0001"}, d2={"Lcom/android/tools/lint/client/api/LintXmlConfiguration;", "Lcom/android/tools/lint/client/api/Configuration;", "configurations", "Lcom/android/tools/lint/client/api/ConfigurationHierarchy;", "configFile", "Ljava/io/File;", "dir", "fileLevel", "", "<init>", "(Lcom/android/tools/lint/client/api/ConfigurationHierarchy;Ljava/io/File;Ljava/io/File;Z)V", "project", "Lcom/android/tools/lint/detector/api/Project;", "(Lcom/android/tools/lint/client/api/ConfigurationHierarchy;Lcom/android/tools/lint/detector/api/Project;)V", "getConfigFile", "()Ljava/io/File;", "getFileLevel", "()Z", "setFileLevel", "(Z)V", "bulkEditing", "checkAllWarnings", "Ljava/lang/Boolean;", "ignoreWarnings", "warningsAsErrors", "fatalOnly", "checkTestSources", "ignoreTestSources", "checkGeneratedSources", "checkDependencies", "explainIssues", "applySuggestions", "removeFixedBaselineIssues", "abortOnError", "lintJars", "", "issueMap", "", "", "Lcom/android/tools/lint/client/api/LintXmlConfiguration$IssueData;", "issueMaps", "", "clientIssueMaps", "fileClients", "checkIgnored", "id", "checker", "Lkotlin/Function1;", "isIncludeInTests", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "isIgnored", "context", "Lcom/android/tools/lint/detector/api/Context;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "getLocalOption", "name", "default", "getOption", "reportOptionValidationError", "", "option", "Lcom/android/tools/lint/detector/api/Option;", "message", "", "getOptionAsFile", "setOption", "value", "setBooleanOption", "(Lcom/android/tools/lint/detector/api/Issue;Ljava/lang/String;Ljava/lang/Boolean;)V", "setIntOption", "", "(Lcom/android/tools/lint/detector/api/Issue;Ljava/lang/String;Ljava/lang/Integer;)V", "setFileOption", "isPathIgnored", "location", "Lcom/android/tools/lint/detector/api/Location;", "issueData", "getOrCreateIssueMap", "client", "getIssueMaps", "getPrimaryIssueMap", "isPatternIgnored", "addConfiguredIssues", "targetMap", "Lcom/android/tools/lint/detector/api/Severity;", "registry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "specificOnly", "getLocalIssueConfigLocation", "severityOnly", "source", "getDefinedSeverity", "visibleDefault", "ensureInitialized", "getConfigLocation", "getLocation", "filter", "Lorg/w3c/dom/Element;", "parser", "Lorg/xmlpull/v1/XmlPullParser;", "exception", "Lorg/xmlpull/v1/XmlPullParserException;", "reportError", "severity", "readConfig", "isApplicableClient", "checkEquals", "checkOther", "addSeverity", "idList", "", "issueClients", "addPaths", "ids", "n", "path", "addRegexp", "regexp", "addOption", "key", "addAppliesToTests", "getCheckAllWarnings", "()Ljava/lang/Boolean;", "getIgnoreWarnings", "getWarningsAsErrors", "getFatalOnly", "getCheckTestSources", "getIgnoreTestSources", "getCheckGeneratedSources", "getCheckDependencies", "getExplainIssues", "getApplySuggestions", "getRemoveFixedBaselineIssues", "getAbortOnError", "getLintJars", "writeConfig", "writeAttribute", "writer", "Ljava/io/Writer;", "ignore", "file", "issueId", "setSeverity", "startBulkEditing", "finishBulkEditing", "_baselineFile", "baselineFile", "getBaselineFile", "setBaselineFile", "(Ljava/io/File;)V", "validated", "validateIssueIds", "Lcom/android/tools/lint/client/api/LintClient;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "allowed", "", "map", "toString", "IssueData", "Companion", "lint-api"})
@SourceDebugExtension(value={"SMAP\nLintXmlConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintXmlConfiguration.kt\ncom/android/tools/lint/client/api/LintXmlConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1652:1\n1#2:1653\n1563#3:1654\n1634#3,3:1655\n295#3,2:1658\n*S KotlinDebug\n*F\n+ 1 LintXmlConfiguration.kt\ncom/android/tools/lint/client/api/LintXmlConfiguration\n*L\n861#1:1654\n861#1:1655,3\n1341#1:1658,2\n*E\n"})
public class LintXmlConfiguration
extends Configuration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File configFile;
    private boolean fileLevel;
    private boolean bulkEditing;
    @Nullable
    private Boolean checkAllWarnings;
    @Nullable
    private Boolean ignoreWarnings;
    @Nullable
    private Boolean warningsAsErrors;
    @Nullable
    private Boolean fatalOnly;
    @Nullable
    private Boolean checkTestSources;
    @Nullable
    private Boolean ignoreTestSources;
    @Nullable
    private Boolean checkGeneratedSources;
    @Nullable
    private Boolean checkDependencies;
    @Nullable
    private Boolean explainIssues;
    @Nullable
    private Boolean applySuggestions;
    @Nullable
    private Boolean removeFixedBaselineIssues;
    @Nullable
    private Boolean abortOnError;
    @Nullable
    private List<? extends File> lintJars;
    @Nullable
    private Map<String, IssueData> issueMap;
    @NotNull
    private List<? extends Map<String, IssueData>> issueMaps;
    @Nullable
    private Map<String, Map<String, IssueData>> clientIssueMaps;
    @Nullable
    private String fileClients;
    @Nullable
    private File _baselineFile;
    private boolean validated;
    @NotNull
    public static final String CONFIG_FILE_NAME = "lint.xml";
    @NotNull
    public static final String TAG_LINT = "lint";
    @NotNull
    private static final String TAG_ISSUE = "issue";
    @NotNull
    private static final String TAG_IGNORE = "ignore";
    @NotNull
    private static final String TAG_OPTION = "option";
    @NotNull
    private static final String ATTR_ID = "id";
    @NotNull
    private static final String ATTR_IN = "in";
    @NotNull
    private static final String ATTR_SEVERITY = "severity";
    @NotNull
    private static final String ATTR_PATH = "path";
    @NotNull
    private static final String ATTR_REGEXP = "regexp";
    @NotNull
    private static final String ATTR_NAME = "name";
    @NotNull
    private static final String ATTR_VALUE = "value";
    @NotNull
    private static final String ATTR_TESTS = "tests";
    @NotNull
    public static final String VALUE_ALL = "all";
    @NotNull
    private static final String ATTR_BASELINE = "baseline";
    @NotNull
    private static final String RES_PATH_START = "res" + File.separatorChar;
    private static final int RES_PATH_START_LEN = RES_PATH_START.length();
    @Nullable
    private static Set<Option> warnedOptions;

    protected LintXmlConfiguration(@NotNull ConfigurationHierarchy configurations, @NotNull File configFile, @Nullable File dir, boolean fileLevel) {
        Intrinsics.checkNotNullParameter((Object)configurations, (String)"configurations");
        Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
        super(configurations);
        this.configFile = configFile;
        this.fileLevel = fileLevel;
        this.setDir(dir);
        this.issueMaps = CollectionsKt.emptyList();
    }

    public /* synthetic */ LintXmlConfiguration(ConfigurationHierarchy configurationHierarchy, File file, File file2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            file2 = file.getParentFile();
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        this(configurationHierarchy, file, file2, bl);
    }

    @NotNull
    public final File getConfigFile() {
        return this.configFile;
    }

    @Override
    public boolean getFileLevel() {
        return this.fileLevel;
    }

    @Override
    public void setFileLevel(boolean bl) {
        this.fileLevel = bl;
    }

    protected LintXmlConfiguration(@NotNull ConfigurationHierarchy configurations, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)configurations, (String)"configurations");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        File file = project.getDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getDir(...)");
        this(configurations, ConfigurationHierarchy.Companion.getLintXmlFile(file), project.getDir(), true);
    }

    private final boolean checkIgnored(String id, Function1<? super IssueData, Boolean> checker) {
        IssueData it;
        List<Map<String, IssueData>> issueMaps = this.getIssueMaps();
        for (Map<String, IssueData> issueMap : issueMaps) {
            if (issueMap.get(id) == null) continue;
            boolean bl = false;
            if (!((Boolean)checker.invoke((Object)it)).booleanValue()) continue;
            return true;
        }
        for (Map<String, IssueData> issueMap : issueMaps) {
            Object severity;
            Object object = issueMap.get(id);
            if (object == null) continue;
            if ((object = object.getSeverity()) == null || (severity = object) == Severity.IGNORE) continue;
            return false;
        }
        for (Map<String, IssueData> issueMap : issueMaps) {
            if (issueMap.get(VALUE_ALL) == null) continue;
            boolean bl = false;
            if (!((Boolean)checker.invoke((Object)it)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isIncludeInTests(@NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)TAG_ISSUE);
        String id = issue.getId();
        List<Map<String, IssueData>> issueMaps = this.getIssueMaps();
        for (Map<String, IssueData> issueMap : issueMaps) {
            IssueData issueData = issueMap.get(id);
            boolean bl = issueData != null ? issueData.getAppliesToTests() : false;
            if (!bl) continue;
            return true;
        }
        Configuration configuration = this.getParent();
        return configuration != null ? configuration.isIncludeInTests(issue) : false;
    }

    @Override
    public boolean isIgnored(@NotNull Context context2, @NotNull Incident incident) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Location location2 = incident.getLocation();
        if (Intrinsics.areEqual((Object)location2, (Object)Location.NONE)) {
            Configuration configuration = this.getParent();
            return configuration != null ? configuration.isIgnored(context2, incident) : false;
        }
        String id = incident.getIssue().getId();
        String message2 = incident.getMessage();
        if (this.isPathIgnored(id, location2, context2) || this.isPatternIgnored(id, message2, location2, context2)) {
            return true;
        }
        Configuration configuration = this.getParent();
        return configuration != null ? configuration.isIgnored(context2, incident) : false;
    }

    private final String getLocalOption(Issue issue, String name, String string) {
        String string2;
        Map<String, String> map;
        IssueData issueData;
        String id = issue.getId();
        List<Map<String, IssueData>> issueMaps = this.getIssueMaps();
        for (Map<String, IssueData> issueMap : issueMaps) {
            issueData = issueMap.get(id);
            if (issueData == null || (map = issueData.getOptions()) == null || (string2 = map.get(name)) == null) continue;
            String it = string2;
            boolean bl = false;
            return it;
        }
        for (Map<String, IssueData> issueMap : issueMaps) {
            issueData = issueMap.get(VALUE_ALL);
            if (issueData == null || (map = issueData.getOptions()) == null || (string2 = map.get(name)) == null) continue;
            String it = string2;
            boolean bl = false;
            return it;
        }
        return string;
    }

    @Override
    @Nullable
    public String getOption(@NotNull Issue issue, @NotNull String name, @Nullable String string) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)TAG_ISSUE);
        Intrinsics.checkNotNullParameter((Object)name, (String)ATTR_NAME);
        String string2 = this.getLocalOption(issue, name, string);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            return it;
        }
        Object object = this.getParent();
        if (object == null || (object = ((Configuration)object).getOption(issue, name, string)) == null) {
            object = string;
        }
        return object;
    }

    private final void reportOptionValidationError(Option option, String message2) {
        Set alreadyWarned;
        Set set = warnedOptions;
        if (set == null) {
            HashSet hashSet;
            HashSet it = hashSet = new HashSet();
            boolean bl = false;
            warnedOptions = it;
            set = hashSet;
        }
        if (!(alreadyWarned = set).add((Option)option)) {
            return;
        }
        Location location2 = this.getLocation((Function1<? super Element, Boolean>)((Function1)new Function1<Element, Boolean>(option){
            final /* synthetic */ Option $option;
            {
                this.$option = $option;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Boolean invoke(Element element) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (Intrinsics.areEqual((Object)element.getTagName(), (Object)"option") && Intrinsics.areEqual((Object)element.getAttribute("name"), (Object)this.$option.getName())) {
                    Node node = element.getParentNode();
                    Element element2 = node instanceof Element ? (Element)node : null;
                    if (Intrinsics.areEqual((Object)(element2 != null ? element2.getAttribute("id") : null), (Object)this.$option.getIssue().getId())) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }));
        LintClient.Companion.report$default(LintClient.Companion, this.getClient(), IssueRegistry.LINT_ERROR, message2, null, null, null, null, null, null, null, null, null, location2, 4088, null);
    }

    @Override
    @Nullable
    public Object getOption(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)TAG_OPTION);
        String string = this.getLocalOption(option.getIssue(), option.getName(), null);
        if (string != null) {
            Object object;
            String valueString = string;
            boolean bl = false;
            Option option2 = option;
            if (option2 instanceof StringOption) {
                object = valueString;
            } else if (option2 instanceof BooleanOption) {
                boolean bl2;
                if (StringsKt.equals((String)valueString, (String)"true", (boolean)true)) {
                    bl2 = true;
                } else if (StringsKt.equals((String)valueString, (String)"false", (boolean)true)) {
                    bl2 = false;
                } else {
                    this.reportOptionValidationError(option, "Option value must be `true` or `false` (was " + valueString + ")");
                    bl2 = ((BooleanOption)option).getDefaultValue();
                }
                object = bl2;
            } else if (option2 instanceof IntOption) {
                int value;
                try {
                    value = Integer.parseInt(valueString);
                    if (value < ((IntOption)option).getMin() || value >= ((IntOption)option).getMax()) {
                        this.reportOptionValidationError(option, option.getName() + ": " + ((IntOption)option).rangeAsString());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.reportOptionValidationError(option, option.getName() + " must be an integer (was " + valueString + ")");
                    value = ((IntOption)option).getDefaultValue();
                }
                object = value;
            } else if (option2 instanceof FloatOption) {
                float value;
                try {
                    value = Float.parseFloat(valueString);
                    if (value < ((FloatOption)option).getMin() || value >= ((FloatOption)option).getMax()) {
                        this.reportOptionValidationError(option, option.getName() + ": " + ((FloatOption)option).rangeAsString());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.reportOptionValidationError(option, option.getName() + " must be a float (was " + valueString + ")");
                    value = ((FloatOption)option).getDefaultValue();
                }
                object = Float.valueOf(value);
            } else if (option2 instanceof FileOption) {
                File file = new File(StringsKt.replace$default((String)valueString, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null));
                if (file.isAbsolute()) {
                    object = file;
                } else {
                    File file2 = this.configFile.getParentFile();
                    if (file2 == null) {
                        return file;
                    }
                    File parent = file2;
                    object = new File(parent, file.getPath());
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return object;
        }
        Configuration configuration = this.getParent();
        return configuration != null ? configuration.getOption(option) : null;
    }

    @Override
    @Nullable
    public File getOptionAsFile(@NotNull Issue issue, @NotNull String name, @Nullable File file) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)TAG_ISSUE);
        Intrinsics.checkNotNullParameter((Object)name, (String)ATTR_NAME);
        String string = this.getLocalOption(issue, name, null);
        if (string == null) {
            Object object = this.getParent();
            if (object == null || (object = ((Configuration)object).getOptionAsFile(issue, name, null)) == null) {
                object = file;
            }
            return object;
        }
        String value = string;
        File file2 = new File(StringsKt.replace$default((String)value, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null));
        if (file2.isAbsolute()) {
            return file2;
        }
        File file3 = this.configFile.getParentFile();
        if (file3 == null) {
            return file2;
        }
        File parent = file3;
        return new File(parent, file2.getPath());
    }

    public final void setOption(@NotNull Issue issue, @NotNull String name, @Nullable String value) {
        block1: {
            block0: {
                Intrinsics.checkNotNullParameter((Object)issue, (String)TAG_ISSUE);
                Intrinsics.checkNotNullParameter((Object)name, (String)ATTR_NAME);
                if (value == null) break block0;
                LintXmlConfiguration.addOption$default(this, CollectionsKt.listOf((Object)issue.getId()), name, value, null, null, 24, null);
                break block1;
            }
            Object object = this.getPrimaryIssueMap().get(issue.getId());
            if (object == null || (object = ((IssueData)object).getOptions()) == null) break block1;
            String cfr_ignored_0 = (String)object.remove(name);
        }
    }

    public final void setBooleanOption(@NotNull Issue issue, @NotNull String name, @Nullable Boolean value) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)TAG_ISSUE);
        Intrinsics.checkNotNullParameter((Object)name, (String)ATTR_NAME);
        Boolean bl = value;
        this.setOption(issue, name, bl != null ? String.valueOf(bl) : null);
    }

    public final void setIntOption(@NotNull Issue issue, @NotNull String name, @Nullable Integer value) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)TAG_ISSUE);
        Intrinsics.checkNotNullParameter((Object)name, (String)ATTR_NAME);
        Integer n = value;
        this.setOption(issue, name, n != null ? String.valueOf(n) : null);
    }

    public final void setFileOption(@NotNull Issue issue, @NotNull String name, @Nullable File value) {
        String relative;
        Intrinsics.checkNotNullParameter((Object)issue, (String)TAG_ISSUE);
        Intrinsics.checkNotNullParameter((Object)name, (String)ATTR_NAME);
        String string = relative = value != null && value.isAbsolute() ? this.getClient().getRelativePath(this.configFile.getParentFile(), value) : null;
        if (relative != null) {
            this.setOption(issue, name, StringsKt.replace$default((String)relative, (char)'\\', (char)'/', (boolean)false, (int)4, null));
        } else {
            Object object = value;
            this.setOption(issue, name, object != null && (object = ((File)object).toString()) != null ? StringsKt.replace$default((String)object, (char)'\\', (char)'/', (boolean)false, (int)4, null) : null);
        }
    }

    private final boolean isPathIgnored(String id, Location location2, Context context2) {
        return this.checkIgnored(id, (Function1<? super IssueData, Boolean>)((Function1)new Function1<IssueData, Boolean>(this, location2, context2){
            final /* synthetic */ LintXmlConfiguration this$0;
            final /* synthetic */ Location $location;
            final /* synthetic */ Context $context;
            {
                this.this$0 = $receiver;
                this.$location = $location;
                this.$context = $context;
                super(1);
            }

            public final Boolean invoke(IssueData data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return LintXmlConfiguration.access$isPathIgnored(this.this$0, data, this.$location, this.$context);
            }
        }));
    }

    private final boolean isPathIgnored(IssueData issueData, Location location2, Context context2) {
        String string;
        List<String> paths = issueData.getPaths();
        if (paths == null || paths.isEmpty()) {
            return false;
        }
        File file = location2.getFile();
        File parentFile = this.configFile.getParentFile();
        if (parentFile != null) {
            string = this.getClient().getRelativePath(parentFile, file);
            if (string == null) {
                return false;
            }
        } else {
            string = file.getPath();
        }
        String relativePath = string;
        for (String string2 : paths) {
            if (Intrinsics.areEqual((Object)string2, (Object)relativePath)) {
                return true;
            }
            Intrinsics.checkNotNull((Object)relativePath);
            if (!StringsKt.startsWith$default((String)relativePath, (String)string2, (boolean)false, (int)2, null)) continue;
            return true;
        }
        HashSet suppressedPathSet = null;
        for (String p : paths) {
            if (!StringsKt.startsWith$default((String)p, (String)RES_PATH_START, (boolean)false, (int)2, null)) continue;
            String string3 = p.substring(RES_PATH_START_LEN);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            Path path2 = Paths.get(string3, new String[0]);
            Set set = suppressedPathSet;
            if (set == null) {
                HashSet hashSet;
                HashSet it = hashSet = new HashSet();
                boolean bl = false;
                suppressedPathSet = it;
                set = hashSet;
            }
            Set set2 = set;
            Intrinsics.checkNotNull((Object)path2);
            set2.add(path2);
        }
        Set set = suppressedPathSet;
        if (set != null && !((Collection)set).isEmpty()) {
            Path toCheck = file.toPath();
            for (File resDir : context2.getProject().getResourceFolders()) {
                Path path3 = resDir.toPath();
                Path relative = path3.relativize(toCheck);
                if (set.contains(relative)) {
                    return true;
                }
                if (!set.stream().anyMatch(new Predicate(relative){
                    final /* synthetic */ Path $relative;
                    {
                        this.$relative = $relative;
                    }

                    public final boolean test(Path it) {
                        return this.$relative.startsWith(it);
                    }
                })) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, IssueData> getOrCreateIssueMap(String client) {
        Map<String, IssueData> map;
        this.ensureInitialized();
        if (client != null) {
            void var3_8;
            Map clientMap;
            Map map2;
            Map map3 = this.clientIssueMaps;
            if (map3 == null) {
                LinkedHashMap linkedHashMap;
                LinkedHashMap it = linkedHashMap = new LinkedHashMap();
                boolean bl = false;
                this.clientIssueMaps = it;
                map3 = linkedHashMap;
            }
            if ((map2 = (clientMap = map3).get(client)) == null) {
                HashMap hashMap;
                HashMap it = hashMap = new HashMap();
                boolean bl = false;
                clientMap.put(client, it);
                map2 = hashMap;
            }
            Map map4 = map2;
            map = var3_8;
        } else {
            Map<String, IssueData> map5 = this.issueMap;
            map = map5;
            Intrinsics.checkNotNull(map5);
        }
        return map;
    }

    private final List<Map<String, IssueData>> getIssueMaps() {
        this.ensureInitialized();
        return this.issueMaps;
    }

    private final Map<String, IssueData> getPrimaryIssueMap() {
        this.ensureInitialized();
        Map<String, IssueData> map = this.issueMap;
        Intrinsics.checkNotNull(map);
        return map;
    }

    private final boolean isPatternIgnored(String id, String message2, Location location2, Context context2) {
        return this.checkIgnored(id, (Function1<? super IssueData, Boolean>)((Function1)new Function1<IssueData, Boolean>(this, message2, location2, context2){
            final /* synthetic */ LintXmlConfiguration this$0;
            final /* synthetic */ String $message;
            final /* synthetic */ Location $location;
            final /* synthetic */ Context $context;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                this.$location = $location;
                this.$context = $context;
                super(1);
            }

            public final Boolean invoke(IssueData data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return LintXmlConfiguration.access$isPatternIgnored(this.this$0, data, this.$message, this.$location, this.$context);
            }
        }));
    }

    private final boolean isPatternIgnored(IssueData issueData, String message2, Location location2, Context context2) {
        Matcher matcher;
        List<Pattern> regexps = issueData.getPatterns();
        if (regexps == null || regexps.isEmpty()) {
            return false;
        }
        for (Pattern regexp : regexps) {
            Matcher matcher2 = regexp.matcher(message2);
            if (!matcher2.find()) continue;
            return true;
        }
        File file = location2.getFile();
        File file2 = this.configFile.getParentFile();
        if (file2 == null) {
            File file3 = context2.getProject().getDir();
            file2 = file3;
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getDir(...)");
        }
        File relativeTo = file2;
        String string = Project.getRelativePath(relativeTo, file);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRelativePath(...)");
        String relativePath = string;
        boolean checkUnixPath = false;
        for (Pattern regexp : regexps) {
            matcher = regexp.matcher(relativePath);
            if (matcher.find()) {
                return true;
            }
            String pattern = regexp.pattern();
            Intrinsics.checkNotNull((Object)pattern);
            if (StringsKt.indexOf$default((CharSequence)pattern, (char)'/', (int)0, (boolean)false, (int)6, null) == -1) continue;
            checkUnixPath = true;
            if (!StringsKt.startsWith$default((String)pattern, (String)".*/", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)pattern, (String)"^.*/", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)pattern, (String)"^.*?/", (boolean)false, (int)2, null) || !regexp.matcher("/" + relativePath).find()) continue;
            return true;
        }
        if (checkUnixPath && SdkConstants.CURRENT_PLATFORM == 2) {
            relativePath = StringsKt.replace$default((String)relativePath, (char)'\\', (char)'/', (boolean)false, (int)4, null);
            for (Pattern regexp : regexps) {
                matcher = regexp.matcher(relativePath);
                if (!matcher.find()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addConfiguredIssues(@NotNull Map<String, Severity> targetMap, @NotNull IssueRegistry registry, boolean specificOnly) {
        block5: {
            Intrinsics.checkNotNullParameter(targetMap, (String)"targetMap");
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            Configuration configuration = this.getParent();
            if (configuration != null) {
                configuration.addConfiguredIssues(targetMap, registry, specificOnly);
            }
            List<Map<String, IssueData>> issueMaps = this.getIssueMaps();
            for (Map<String, IssueData> issueMap : issueMaps) {
                IssueData issueData;
                if (issueMap.get(VALUE_ALL) == null || issueData.getSeverity() == null) continue;
                for (Issue issue : registry.getIssues()) {
                    Severity severity;
                    targetMap.put(issue.getId(), severity);
                }
            }
            for (Map<String, IssueData> issueMap : issueMaps) {
                for (Map.Entry<String, IssueData> entry : issueMap.entrySet()) {
                    Severity severity;
                    String id = entry.getKey();
                    IssueData issueData = entry.getValue();
                    if (issueData.getSeverity() == null) continue;
                    targetMap.put(id, severity);
                }
            }
            Configuration configuration2 = this.getOverrides();
            if (configuration2 == null) break block5;
            configuration2.addConfiguredIssues(targetMap, registry, specificOnly);
        }
    }

    @Override
    @Nullable
    public Location getLocalIssueConfigLocation(@NotNull String issue, boolean specificOnly, boolean severityOnly, @NotNull Configuration source) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)TAG_ISSUE);
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        List<Map<String, IssueData>> issueMaps = this.getIssueMaps();
        for (Map<String, IssueData> issueMap : issueMaps) {
            IssueData data = issueMap.get(issue);
            if (data == null) continue;
            return this.getConfigLocation(issue, severityOnly);
        }
        for (Map<String, IssueData> issueMap : issueMaps) {
            IssueData issueData = issueMap.get(VALUE_ALL);
            if (issueData == null) continue;
            IssueData it = issueData;
            boolean bl = false;
            if (!specificOnly) {
                return this.getConfigLocation(VALUE_ALL, severityOnly);
            }
            return null;
        }
        Configuration configuration = this.getParent();
        return configuration != null ? configuration.getLocalIssueConfigLocation(issue, specificOnly, severityOnly, source) : null;
    }

    @Override
    @Nullable
    public Severity getDefinedSeverity(@NotNull Issue issue, @NotNull Configuration source, @NotNull Severity visibleDefault) {
        Object severity;
        Intrinsics.checkNotNullParameter((Object)issue, (String)TAG_ISSUE);
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)((Object)visibleDefault), (String)"visibleDefault");
        if (issue.getSuppressNames() != null && !issue.getSuppressNames().contains(issue.getId())) {
            return this.getDefaultSeverity(issue, visibleDefault);
        }
        List<Map<String, IssueData>> issueMaps = this.getIssueMaps();
        for (Map<String, IssueData> issueMap : issueMaps) {
            Object object = issueMap.get(issue.getId());
            if (object == null || (object = object.getSeverity()) == null) {
                IssueData issueData = issueMap.get(issue.getCategory().getName());
                object = issueData != null ? issueData.getSeverity() : null;
                if (object == null) {
                    IssueData issueData2 = issueMap.get(issue.getCategory().getFullName());
                    object = issueData2 != null ? issueData2.getSeverity() : null;
                    if (object == null) {
                        LintXmlConfiguration $this$getDefinedSeverity_u24lambda_u240 = this;
                        boolean bl = false;
                        Severity s = null;
                        for (Category currentCategory = issue.getCategory().getParent(); currentCategory != null; currentCategory = currentCategory.getParent()) {
                            IssueData issueData3 = issueMap.get(currentCategory.getName());
                            Severity severity2 = s = issueData3 != null ? issueData3.getSeverity() : null;
                            if (s != null) break;
                        }
                        object = s;
                    }
                }
            }
            if ((severity = object) == null) continue;
            return severity;
        }
        for (Map<String, IssueData> issueMap : issueMaps) {
            IssueData issueData = issueMap.get(VALUE_ALL);
            severity = issueData != null ? issueData.getSeverity() : null;
            if (severity == null) continue;
            return severity;
        }
        Object object = this.getParent();
        if (object == null || (object = object.getDefinedSeverity(issue, source, visibleDefault)) == null) {
            object = super.getDefinedSeverity(issue, source, visibleDefault);
        }
        return object;
    }

    private final void ensureInitialized() {
        if (this.issueMap == null) {
            this.readConfig();
        }
    }

    private final Location getConfigLocation(String id, boolean severityOnly) {
        return this.getLocation((Function1<? super Element, Boolean>)((Function1)new Function1<Element, Boolean>(id, severityOnly){
            final /* synthetic */ String $id;
            final /* synthetic */ boolean $severityOnly;
            {
                this.$id = $id;
                this.$severityOnly = $severityOnly;
                super(1);
            }

            public final Boolean invoke(Element element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return Intrinsics.areEqual((Object)this.$id, (Object)element.getAttribute("id")) && (!this.$severityOnly || element.hasAttribute("severity"));
            }
        }));
    }

    private final Location getLocation(Function1<? super Element, Boolean> filter) {
        block3: {
            XmlParser parser = this.getClient().getXmlParser();
            Node node = parser.parseXml(this.configFile);
            if (node == null || (node = node.getDocumentElement()) == null) break block3;
            Node document = node;
            boolean bl = false;
            Iterator iterator = DomExtensions.iterator((Element)document);
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                if (((Boolean)filter.invoke((Object)element)).booleanValue()) {
                    return parser.getLocation(this.configFile, (Node)element);
                }
                Iterator iterator2 = DomExtensions.iterator((Element)element);
                while (iterator2.hasNext()) {
                    Element child = (Element)iterator2.next();
                    if (!((Boolean)filter.invoke((Object)child)).booleanValue()) continue;
                    return parser.getLocation(this.configFile, (Node)child);
                }
            }
        }
        return Location.Companion.create(this.configFile);
    }

    private final Location getLocation(XmlPullParser parser) {
        String contents = ((Object)this.getClient().readFile(this.configFile)).toString();
        return Location.Companion.create(this.configFile, contents, Math.max(0, parser.getLineNumber() - 1));
    }

    private final Location getLocation(XmlPullParserException exception) {
        String contents = ((Object)this.getClient().readFile(this.configFile)).toString();
        return Location.Companion.create(this.configFile, contents, Math.max(0, exception.getLineNumber() - 1));
    }

    private final void reportError(String message2, XmlPullParser parser, XmlPullParserException exception, Location location2, Severity severity) {
        LintClient.Companion companion = LintClient.Companion;
        LintClient lintClient = this.getClient();
        Issue issue = severity.isError() ? IssueRegistry.LINT_ERROR : IssueRegistry.LINT_WARNING;
        LintClient.Companion.report$default(companion, lintClient, issue, message2, null, null, null, null, null, null, null, null, null, location2, 2040, null);
    }

    static /* synthetic */ void reportError$default(LintXmlConfiguration lintXmlConfiguration, String string, XmlPullParser xmlPullParser, XmlPullParserException xmlPullParserException, Location location2, Severity severity, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reportError");
        }
        if ((n & 2) != 0) {
            xmlPullParser = null;
        }
        if ((n & 4) != 0) {
            xmlPullParserException = null;
        }
        if ((n & 8) != 0) {
            Location location3;
            XmlPullParser xmlPullParser2 = xmlPullParser;
            if (xmlPullParser2 != null) {
                location3 = lintXmlConfiguration.getLocation(xmlPullParser2);
            } else {
                XmlPullParserException xmlPullParserException2 = xmlPullParserException;
                location3 = location2 = xmlPullParserException2 != null ? lintXmlConfiguration.getLocation(xmlPullParserException2) : Location.Companion.create(lintXmlConfiguration.configFile);
            }
        }
        if ((n & 0x10) != 0) {
            severity = Severity.WARNING;
        }
        lintXmlConfiguration.reportError(string, xmlPullParser, xmlPullParserException, location2, severity);
    }

    private final void readConfig() {
        if (!LintClient.fileExists$default(this.getClient(), this.configFile, true, false, 4, null)) {
            Map issueMap;
            this.issueMap = issueMap = (Map)new LinkedHashMap();
            this.issueMaps = CollectionsKt.listOf((Object)issueMap);
            return;
        }
        PathString resourcePath = new PathString(this.configFile);
        XmlPullParser xmlPullParser = this.getClient().createXmlPullParser(resourcePath);
        if (xmlPullParser == null) {
            return;
        }
        XmlPullParser parser = xmlPullParser;
        parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
        this.readConfig(parser);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void readConfig(XmlPullParser parser) {
        it = var3_2 = new HashMap<K, V>();
        $i$a$-also-LintXmlConfiguration$readConfig$issueMap$1 = false;
        this.issueMap = it;
        issueMap = var3_2;
        try {
            splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
            idString = "";
            idList = CollectionsKt.emptyList();
            issueClients = null;
            while (parser.next() != 1) {
                eventType = parser.getEventType();
                switch (eventType) {
                    case 2: {
                        var8_14 = parser.getName();
                        if (var8_14 == null) ** GOTO lbl-1000
                        tmp = -1;
                        switch (var8_14.hashCode()) {
                            case 3321859: {
                                if (var8_14.equals("lint")) {
                                    tmp = 1;
                                }
                                break;
                            }
                            case 100509913: {
                                if (var8_14.equals("issue")) {
                                    tmp = 2;
                                }
                                break;
                            }
                            case -1190396462: {
                                if (var8_14.equals("ignore")) {
                                    tmp = 3;
                                }
                                break;
                            }
                            case -1010136971: {
                                if (var8_14.equals("option")) {
                                    tmp = 4;
                                }
                                break;
                            }
                        }
                        switch (tmp) {
                            case 1: {
                                n = parser.getAttributeCount();
                                block77: for (i = 0; i < n; ++i) {
                                    name = parser.getAttributeName(i);
                                    value = parser.getAttributeValue(i);
                                    var13_29 = name;
                                    if (var13_29 == null) ** GOTO lbl-1000
                                    tmp = -1;
                                    switch (var13_29.hashCode()) {
                                        case 16328217: {
                                            if (var13_29.equals("abortOnError")) {
                                                tmp = 1;
                                            }
                                            break;
                                        }
                                        case 3365: {
                                            if (var13_29.equals("in")) {
                                                tmp = 2;
                                            }
                                            break;
                                        }
                                        case -512969655: {
                                            if (var13_29.equals("ignoreWarnings")) {
                                                tmp = 3;
                                            }
                                            break;
                                        }
                                        case -279687535: {
                                            if (var13_29.equals("explainIssues")) {
                                                tmp = 4;
                                            }
                                            break;
                                        }
                                        case 544724126: {
                                            if (var13_29.equals("checkTestSources")) {
                                                tmp = 5;
                                            }
                                            break;
                                        }
                                        case 1975335316: {
                                            if (var13_29.equals("ignoreTestSources")) {
                                                tmp = 6;
                                            }
                                            break;
                                        }
                                        case -469185887: {
                                            if (var13_29.equals("applySuggestions")) {
                                                tmp = 7;
                                            }
                                            break;
                                        }
                                        case 177327896: {
                                            if (var13_29.equals("lintJar")) {
                                                tmp = 8;
                                            }
                                            break;
                                        }
                                        case -1720785339: {
                                            if (var13_29.equals("baseline")) {
                                                tmp = 9;
                                            }
                                            break;
                                        }
                                        case 2044652113: {
                                            if (var13_29.equals("checkDependencies")) {
                                                tmp = 10;
                                            }
                                            break;
                                        }
                                        case -1992186799: {
                                            if (var13_29.equals("checkGeneratedSources")) {
                                                tmp = 11;
                                            }
                                            break;
                                        }
                                        case -595677489: {
                                            if (var13_29.equals("removeFixedBaselineIssues")) {
                                                tmp = 12;
                                            }
                                            break;
                                        }
                                        case 1202197595: {
                                            if (var13_29.equals("lintJars")) {
                                                tmp = 8;
                                            }
                                            break;
                                        }
                                        case -1639883852: {
                                            if (var13_29.equals("warningsAsErrors")) {
                                                tmp = 13;
                                            }
                                            break;
                                        }
                                        case 327591632: {
                                            if (var13_29.equals("fatalOnly")) {
                                                tmp = 14;
                                            }
                                            break;
                                        }
                                        case -663830800: {
                                            if (var13_29.equals("checkAllWarnings")) {
                                                tmp = 15;
                                            }
                                            break;
                                        }
                                    }
                                    switch (tmp) {
                                        case 2: {
                                            this.fileClients = value;
                                            if (i > 0) {
                                                LintXmlConfiguration.reportError$default(this, "in for the whole file, if specified, must always be the first attribute in <lint>", parser, null, null, null, 28, null);
                                            } else if (Intrinsics.areEqual((Object)value, (Object)"all")) {
                                                LintXmlConfiguration.reportError$default(this, "all not supported for in", parser, null, null, null, 28, null);
                                            }
                                            v0 = Unit.INSTANCE;
                                            continue block77;
                                        }
                                        case 9: {
                                            if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkNotNull((Object)value);
                                                this.setBaselineFile(new File(StringsKt.replace$default((String)value, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null)));
                                            }
                                            v0 = Unit.INSTANCE;
                                            continue block77;
                                        }
                                        case 15: {
                                            if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkNotNull((Object)value);
                                                this.checkAllWarnings = LintXmlConfiguration.readConfig$asBoolean(value);
                                            }
                                            v0 = Unit.INSTANCE;
                                            continue block77;
                                        }
                                        case 3: {
                                            if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkNotNull((Object)value);
                                                this.ignoreWarnings = LintXmlConfiguration.readConfig$asBoolean(value);
                                            }
                                            v0 = Unit.INSTANCE;
                                            continue block77;
                                        }
                                        case 13: {
                                            if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkNotNull((Object)value);
                                                this.warningsAsErrors = LintXmlConfiguration.readConfig$asBoolean(value);
                                            }
                                            v0 = Unit.INSTANCE;
                                            continue block77;
                                        }
                                        case 14: {
                                            if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkNotNull((Object)value);
                                                this.fatalOnly = LintXmlConfiguration.readConfig$asBoolean(value);
                                            }
                                            v0 = Unit.INSTANCE;
                                            continue block77;
                                        }
                                        case 5: {
                                            if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkNotNull((Object)value);
                                                this.checkTestSources = LintXmlConfiguration.readConfig$asBoolean(value);
                                            }
                                            v0 = Unit.INSTANCE;
                                            continue block77;
                                        }
                                        case 6: {
                                            if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkNotNull((Object)value);
                                                this.ignoreTestSources = LintXmlConfiguration.readConfig$asBoolean(value);
                                            }
                                            v0 = Unit.INSTANCE;
                                            continue block77;
                                        }
                                        case 11: {
                                            if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkNotNull((Object)value);
                                                this.checkGeneratedSources = LintXmlConfiguration.readConfig$asBoolean(value);
                                            }
                                            v0 = Unit.INSTANCE;
                                            continue block77;
                                        }
                                        case 10: {
                                            if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkNotNull((Object)value);
                                                this.checkDependencies = LintXmlConfiguration.readConfig$asBoolean(value);
                                            }
                                            v0 = Unit.INSTANCE;
                                            continue block77;
                                        }
                                        case 4: {
                                            if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkNotNull((Object)value);
                                                this.explainIssues = LintXmlConfiguration.readConfig$asBoolean(value);
                                            }
                                            v0 = Unit.INSTANCE;
                                            continue block77;
                                        }
                                        case 7: {
                                            if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkNotNull((Object)value);
                                                this.applySuggestions = LintXmlConfiguration.readConfig$asBoolean(value);
                                            }
                                            v0 = Unit.INSTANCE;
                                            continue block77;
                                        }
                                        case 12: {
                                            if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkNotNull((Object)value);
                                                this.removeFixedBaselineIssues = LintXmlConfiguration.readConfig$asBoolean(value);
                                            }
                                            v0 = Unit.INSTANCE;
                                            continue block77;
                                        }
                                        case 1: {
                                            if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkNotNull((Object)value);
                                                this.abortOnError = LintXmlConfiguration.readConfig$asBoolean(value);
                                            }
                                            v0 = Unit.INSTANCE;
                                            continue block77;
                                        }
                                        case 8: {
                                            if (this.getFileLevel()) {
                                                LintXmlConfiguration.reportError$default(this, "`lintJar` can only be specified for lint.xml files at the module level or higher", parser, null, null, null, 28, null);
                                            } else if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkNotNull((Object)value);
                                                var14_30 /* !! */  = new char[]{';'};
                                                var14_30 /* !! */  = (char[])StringsKt.split$default((CharSequence)value, (char[])var14_30 /* !! */ , (boolean)false, (int)0, (int)6, null);
                                                var25_44 = this;
                                                $i$f$map = false;
                                                var16_35 = $this$map$iv;
                                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                                $i$f$mapTo = false;
                                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                                    var21_40 = (String)item$iv$iv;
                                                    var26_45 = destination$iv$iv;
                                                    $i$a$-map-LintXmlConfiguration$readConfig$1 = false;
                                                    file = new File((String)path);
                                                    v1 = absolute = file.isAbsolute() != false ? file : new File(this.configFile.getParentFile(), (String)path);
                                                    if (!absolute.exists()) {
                                                        LintXmlConfiguration.reportError$default(this, "lintJar " + absolute + " does not exist", null, null, null, null, 30, null);
                                                    }
                                                    var26_45.add(absolute);
                                                }
                                                var25_44.lintJars = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                                            }
                                            v0 = Unit.INSTANCE;
                                            continue block77;
                                        }
                                        default: lbl-1000:
                                        // 2 sources

                                        {
                                            LintXmlConfiguration.reportError$default(this, "Unexpected attribute `" + name + "`", parser, null, null, null, 28, null);
                                            v0 = Unit.INSTANCE;
                                        }
                                    }
                                }
                                v2 = Unit.INSTANCE;
                                break;
                            }
                            case 2: {
                                n = parser.getAttributeCount();
                                severityString = "";
                                appliesToTests = false;
                                block79: for (i = 0; i < n; ++i) {
                                    name = parser.getAttributeName(i);
                                    value = parser.getAttributeValue(i);
                                    var15_32 = name;
                                    if (var15_32 == null) ** GOTO lbl-1000
                                    tmp = -1;
                                    switch (var15_32.hashCode()) {
                                        case 1478300413: {
                                            if (var15_32.equals("severity")) {
                                                tmp = 1;
                                            }
                                            break;
                                        }
                                        case 110251553: {
                                            if (var15_32.equals("tests")) {
                                                tmp = 2;
                                            }
                                            break;
                                        }
                                        case 3365: {
                                            if (var15_32.equals("in")) {
                                                tmp = 3;
                                            }
                                            break;
                                        }
                                        case 3355: {
                                            if (var15_32.equals("id")) {
                                                tmp = 4;
                                            }
                                            break;
                                        }
                                    }
                                    switch (tmp) {
                                        case 3: {
                                            if (this.fileClients != null) {
                                                LintXmlConfiguration.reportError$default(this, "If you specify `in` on the root <lint> element you cannot specify it anywhere else", parser, null, null, null, 28, null);
                                            } else if (Intrinsics.areEqual((Object)value, (Object)"all")) {
                                                LintXmlConfiguration.reportError$default(this, "all not supported for in", parser, null, null, null, 28, null);
                                            }
                                            issueClients = value;
                                            v3 = Unit.INSTANCE;
                                            continue block79;
                                        }
                                        case 4: {
                                            Intrinsics.checkNotNull((Object)value);
                                            idString = value;
                                            Intrinsics.checkNotNullExpressionValue((Object)splitter.split((CharSequence)idString), (String)"split(...)");
                                            v3 = Unit.INSTANCE;
                                            continue block79;
                                        }
                                        case 1: {
                                            Intrinsics.checkNotNull((Object)value);
                                            severityString = value;
                                            v3 = Unit.INSTANCE;
                                            continue block79;
                                        }
                                        case 2: {
                                            appliesToTests = Boolean.parseBoolean(value);
                                            if (this.getFileLevel()) {
                                                LintXmlConfiguration.reportError$default(this, "The `tests` attribute can only be specified for lint.xml files at the module level or higher", parser, null, null, Severity.WARNING, 12, null);
                                            }
                                            v3 = Unit.INSTANCE;
                                            continue block79;
                                        }
                                        default: lbl-1000:
                                        // 2 sources

                                        {
                                            LintXmlConfiguration.reportError$default(this, "Unexpected attribute `" + name + "`, expected `id`, `in` or `severity`", parser, null, null, null, 28, null);
                                            v3 = Unit.INSTANCE;
                                        }
                                    }
                                }
                                if (!(((CharSequence)idString).length() == 0)) ** GOTO lbl318
                                LintXmlConfiguration.reportError$default(this, "Missing required issue `id` attribute", parser, null, null, null, 28, null);
                                ** GOTO lbl357
lbl318:
                                // 1 sources

                                if (!(((CharSequence)severityString).length() > 0)) ** GOTO lbl357
                                v4 = Severity.Companion.fromName(severityString);
                                if (v4 != null) ** GOTO lbl353
                                tmp = -1;
                                switch (severityString.hashCode()) {
                                    case 3202370: {
                                        if (severityString.equals("hide")) {
                                            tmp = 1;
                                        }
                                        break;
                                    }
                                    case -1217487446: {
                                        if (severityString.equals("hidden")) {
                                            tmp = 1;
                                        }
                                        break;
                                    }
                                    case 1968600364: {
                                        if (severityString.equals("information")) {
                                            tmp = 2;
                                        }
                                        break;
                                    }
                                    case 3237038: {
                                        if (severityString.equals("info")) {
                                            tmp = 2;
                                        }
                                        break;
                                    }
                                }
                                switch (tmp) {
                                    case 1: {
                                        v4 = Severity.IGNORE;
                                        break;
                                    }
                                    case 2: {
                                        v4 = Severity.INFORMATIONAL;
                                        break;
                                    }
                                    default: {
                                        v4 = null;
                                    }
                                }
lbl353:
                                // 4 sources

                                if ((severity = v4) != null) {
                                    this.addSeverity(idList, severity, this.fileClients, issueClients);
                                } else {
                                    LintXmlConfiguration.reportError$default(this, "Unknown severity `" + severityString + "`", parser, null, null, null, 28, null);
                                }
lbl357:
                                // 4 sources

                                if (appliesToTests) {
                                    this.addAppliesToTests(idList, this.fileClients, issueClients);
                                }
                                v2 = Unit.INSTANCE;
                                break;
                            }
                            case 3: {
                                n = parser.getAttributeCount();
                                if (parser.getDepth() < 3) {
                                    LintXmlConfiguration.reportError$default(this, "`<ignore>` tag should be nested within `<issue>`", parser, null, null, null, 28, null);
                                } else {
                                    path = "";
                                    regexp = "";
                                    for (i = 0; i < n; ++i) {
                                        name = parser.getAttributeName(i);
                                        value = parser.getAttributeValue(i);
                                        var15_33 = name;
                                        if (Intrinsics.areEqual((Object)var15_33, (Object)"path")) {
                                            Intrinsics.checkNotNull((Object)value);
                                            path = value;
                                            continue;
                                        }
                                        if (Intrinsics.areEqual((Object)var15_33, (Object)"regexp")) {
                                            Intrinsics.checkNotNull((Object)value);
                                            regexp = value;
                                            continue;
                                        }
                                        LintXmlConfiguration.reportError$default(this, "Unexpected attribute `" + name + "`, expected `path` or `regexp`", parser, null, null, null, 28, null);
                                    }
                                    if (((CharSequence)path).length() == 0) {
                                        if (((CharSequence)regexp).length() == 0) {
                                            LintXmlConfiguration.reportError$default(this, "Missing required attribute `path` or `regexp`", parser, null, null, null, 28, null);
                                        } else {
                                            this.addRegexp(parser, idString, idList, n, regexp, this.fileClients, issueClients);
                                        }
                                    } else {
                                        v5 = path = File.separatorChar == '/' ? StringsKt.replace$default((String)path, (char)'\\', (char)'/', (boolean)false, (int)4, null) : StringsKt.replace$default((String)path, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null);
                                        if (StringsKt.indexOf$default((CharSequence)path, (char)'*', (int)0, (boolean)false, (int)6, null) != -1) {
                                            v6 = SdkUtils.globToRegexp((String)path);
                                            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"globToRegexp(...)");
                                            this.addRegexp(parser, idString, idList, n, v6, this.fileClients, issueClients);
                                        } else {
                                            this.addPaths(idList, n, path, this.fileClients, issueClients);
                                        }
                                    }
                                }
                                v2 = Unit.INSTANCE;
                                break;
                            }
                            case 4: {
                                n = parser.getAttributeCount();
                                if (parser.getDepth() < 3) {
                                    LintXmlConfiguration.reportError$default(this, "`<option>` tag should be nested within `<issue>`", parser, null, null, null, 28, null);
                                } else {
                                    optionKey = "";
                                    optionValue = "";
                                    for (i = 0; i < n; ++i) {
                                        name = parser.getAttributeName(i);
                                        value = parser.getAttributeValue(i);
                                        var15_34 = name;
                                        if (Intrinsics.areEqual((Object)var15_34, (Object)"name")) {
                                            Intrinsics.checkNotNull((Object)value);
                                            optionKey = value;
                                            continue;
                                        }
                                        if (Intrinsics.areEqual((Object)var15_34, (Object)"value")) {
                                            Intrinsics.checkNotNull((Object)value);
                                            optionValue = value;
                                            continue;
                                        }
                                        LintXmlConfiguration.reportError$default(this, "Unexpected attribute `" + name + "`, expected `name` or `value`", parser, null, null, null, 28, null);
                                    }
                                    if (((CharSequence)optionKey).length() == 0 || ((CharSequence)optionValue).length() == 0) {
                                        LintXmlConfiguration.reportError$default(this, "Must specify both name and value in <option>", parser, null, null, null, 28, null);
                                    } else {
                                        this.addOption(idList, optionKey, optionValue, this.fileClients, issueClients);
                                    }
                                }
                                v2 = Unit.INSTANCE;
                                break;
                            }
                            default: lbl-1000:
                            // 2 sources

                            {
                                LintXmlConfiguration.reportError$default(this, "Unsupported tag <`" + parser.getName() + "`>, expected one of `lint`, `issue`, `ignore` or `option`", parser, null, null, null, 28, null);
                                v2 = Unit.INSTANCE;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (!Intrinsics.areEqual((Object)parser.getName(), (Object)"issue")) break;
                        issueClients = null;
                        idString = "";
                        idList = CollectionsKt.emptyList();
                    }
                }
            }
        }
        catch (IOException e) {
            this.getClient().log(e, null, new Object[0]);
        }
        catch (XmlPullParserException e) {
            v7 = e.getMessage();
            if (v7 == null) {
                v7 = "";
            }
            detail = v7;
            index = StringsKt.indexOf$default((CharSequence)detail, (String)" (position:", (int)0, (boolean)false, (int)6, null);
            v8 = this.configFile.getName();
            if (index != -1) {
                v9 = detail.substring(0, index);
                v10 = v9;
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"substring(...)");
            } else {
                v10 = detail;
            }
            message = "Failed parsing " + v8 + ": " + v10;
            LintXmlConfiguration.reportError$default(this, message, null, e, null, null, 26, null);
        }
        if ((clientMaps = this.clientIssueMaps) != null) {
            list = new ArrayList<E>();
            for (Map.Entry<String, Map<String, IssueData>> var6_10 : clientMaps.entrySet()) {
                key = var6_10.getKey();
                map = var6_10.getValue();
                if (!this.isApplicableClient(key, true, false)) continue;
                list.add(map);
            }
            list.add(issueMap);
            for (Map.Entry<String, Map<String, IssueData>> var6_10 : clientMaps.entrySet()) {
                key = var6_10.getKey();
                map = var6_10.getValue();
                if (!this.isApplicableClient(key, false, true)) continue;
                list.add(map);
            }
            this.issueMaps = list;
        } else {
            this.issueMaps = CollectionsKt.listOf((Object)issueMap);
        }
    }

    private final boolean isApplicableClient(String client, boolean checkEquals, boolean checkOther) {
        if (client == null) {
            return true;
        }
        if (StringsKt.contains$default((CharSequence)client, (char)',', (boolean)false, (int)2, null)) {
            String[] stringArray = new String[]{","};
            for (String c : StringsKt.splitToSequence$default((CharSequence)client, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) {
                if (!this.isApplicableClient(((Object)StringsKt.trim((CharSequence)c)).toString(), checkEquals, checkOther)) continue;
                return true;
            }
        }
        String host = LintClient.Companion.getClientName();
        if (checkEquals && StringsKt.equals((String)client, (String)host, (boolean)true)) {
            return true;
        }
        return checkOther && StringsKt.startsWith$default((String)client, (String)"!", (boolean)false, (int)2, null) && !StringsKt.regionMatches((String)client, (int)1, (String)host, (int)0, (int)host.length(), (boolean)true);
    }

    static /* synthetic */ boolean isApplicableClient$default(LintXmlConfiguration lintXmlConfiguration, String string, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isApplicableClient");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return lintXmlConfiguration.isApplicableClient(string, bl, bl2);
    }

    private final void addSeverity(Iterable<String> idList, Severity severity, String fileClients, String issueClients) {
        String string = issueClients;
        if (string == null) {
            string = fileClients;
        }
        Map<String, IssueData> issueMap = this.getOrCreateIssueMap(string);
        for (String id : idList) {
            IssueData issueData = issueMap.get(id);
            if (issueData == null) {
                IssueData issueData2;
                IssueData it = issueData2 = new IssueData(null, null, null, null, false, 31, null);
                boolean bl = false;
                issueMap.put(id, it);
                issueData = issueData2;
            }
            IssueData data = issueData;
            data.setSeverity(severity);
        }
    }

    private final void addPaths(Iterable<String> ids, int n, String path2, String fileClients, String issueClients) {
        String string = issueClients;
        if (string == null) {
            string = fileClients;
        }
        Map<String, IssueData> issueMap = this.getOrCreateIssueMap(string);
        for (String id : ids) {
            IssueData data;
            List list;
            IssueData issueData = issueMap.get(id);
            if (issueData == null) {
                IssueData issueData2;
                IssueData it = issueData2 = new IssueData(null, null, null, null, false, 31, null);
                boolean bl = false;
                issueMap.put(id, it);
                issueData = issueData2;
            }
            if ((list = (data = issueData).getPaths()) == null) {
                ArrayList arrayList;
                ArrayList it = arrayList = new ArrayList(n / 2 + 1);
                boolean bl = false;
                data.setPaths(it);
                list = arrayList;
            }
            List paths = list;
            paths.add((String)path2);
        }
    }

    private final void addRegexp(XmlPullParser parser, String idList, Iterable<String> ids, int n, String regexp, String fileClients, String issueClients) {
        try {
            String string = issueClients;
            if (string == null) {
                string = fileClients;
            }
            Map<String, IssueData> issueMap = this.getOrCreateIssueMap(string);
            Pattern pattern = Pattern.compile(regexp);
            for (String id : ids) {
                IssueData data;
                List list;
                IssueData issueData = issueMap.get(id);
                if (issueData == null) {
                    IssueData issueData2;
                    IssueData it = issueData2 = new IssueData(null, null, null, null, false, 31, null);
                    boolean bl = false;
                    issueMap.put(id, it);
                    issueData = issueData2;
                }
                if ((list = (data = issueData).getPatterns()) == null) {
                    ArrayList arrayList;
                    ArrayList it = arrayList = new ArrayList(n / 2 + 1);
                    boolean bl = false;
                    data.setPatterns(it);
                    list = arrayList;
                }
                List paths = list;
                Intrinsics.checkNotNull((Object)pattern);
                paths.add((Pattern)pattern);
            }
        }
        catch (PatternSyntaxException e) {
            LintXmlConfiguration.reportError$default(this, "Invalid pattern `" + regexp + "` under `" + idList + "`: " + e.getDescription(), parser, null, null, null, 28, null);
        }
    }

    private final void addOption(Iterable<String> ids, String key, String value, String fileClients, String issueClients) {
        String string = issueClients;
        if (string == null) {
            string = fileClients;
        }
        Map<String, IssueData> issueMap = this.getOrCreateIssueMap(string);
        for (String id : ids) {
            IssueData data;
            Map map;
            IssueData issueData = issueMap.get(id);
            if (issueData == null) {
                IssueData issueData2;
                IssueData it = issueData2 = new IssueData(null, null, null, null, false, 31, null);
                boolean bl = false;
                issueMap.put(id, it);
                issueData = issueData2;
            }
            if ((map = (data = issueData).getOptions()) == null) {
                LinkedHashMap linkedHashMap;
                LinkedHashMap it = linkedHashMap = new LinkedHashMap();
                boolean bl = false;
                data.setOptions(it);
                map = linkedHashMap;
            }
            Map options = map;
            options.put((String)key, (String)value);
        }
    }

    static /* synthetic */ void addOption$default(LintXmlConfiguration lintXmlConfiguration, Iterable iterable, String string, String string2, String string3, String string4, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addOption");
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        if ((n & 0x10) != 0) {
            string4 = null;
        }
        lintXmlConfiguration.addOption(iterable, string, string2, string3, string4);
    }

    private final void addAppliesToTests(Iterable<String> ids, String fileClients, String issueClients) {
        String string = issueClients;
        if (string == null) {
            string = fileClients;
        }
        Map<String, IssueData> issueMap = this.getOrCreateIssueMap(string);
        for (String id : ids) {
            IssueData issueData = issueMap.get(id);
            if (issueData == null) {
                IssueData issueData2;
                IssueData it = issueData2 = new IssueData(null, null, null, null, false, 31, null);
                boolean bl = false;
                issueMap.put(id, it);
                issueData = issueData2;
            }
            IssueData data = issueData;
            data.setAppliesToTests(true);
        }
    }

    static /* synthetic */ void addAppliesToTests$default(LintXmlConfiguration lintXmlConfiguration, Iterable iterable, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addAppliesToTests");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        lintXmlConfiguration.addAppliesToTests(iterable, string, string2);
    }

    @Nullable
    public final Boolean getCheckAllWarnings() {
        this.ensureInitialized();
        return this.checkAllWarnings;
    }

    @Nullable
    public final Boolean getIgnoreWarnings() {
        this.ensureInitialized();
        return this.ignoreWarnings;
    }

    @Nullable
    public final Boolean getWarningsAsErrors() {
        this.ensureInitialized();
        return this.warningsAsErrors;
    }

    @Nullable
    public final Boolean getFatalOnly() {
        this.ensureInitialized();
        return this.fatalOnly;
    }

    @Nullable
    public final Boolean getCheckTestSources() {
        this.ensureInitialized();
        return this.checkTestSources;
    }

    @Nullable
    public final Boolean getIgnoreTestSources() {
        this.ensureInitialized();
        return this.ignoreTestSources;
    }

    @Nullable
    public final Boolean getCheckGeneratedSources() {
        this.ensureInitialized();
        return this.checkGeneratedSources;
    }

    @Nullable
    public final Boolean getCheckDependencies() {
        this.ensureInitialized();
        return this.checkDependencies;
    }

    @Nullable
    public final Boolean getExplainIssues() {
        this.ensureInitialized();
        return this.explainIssues;
    }

    @Nullable
    public final Boolean getApplySuggestions() {
        this.ensureInitialized();
        return this.applySuggestions;
    }

    @Nullable
    public final Boolean getRemoveFixedBaselineIssues() {
        this.ensureInitialized();
        return this.removeFixedBaselineIssues;
    }

    @Nullable
    public final Boolean getAbortOnError() {
        this.ensureInitialized();
        return this.abortOnError;
    }

    @Override
    @NotNull
    public List<File> getLintJars() {
        this.ensureInitialized();
        Object object = this.getParent();
        if (object == null || (object = ((Configuration)object).getLintJars()) == null) {
            List list = this.lintJars;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }
        Object inheritedJars = object;
        List<? extends File> list = this.lintJars;
        if (list == null) {
            return inheritedJars;
        }
        List<? extends File> jars = list;
        return CollectionsKt.plus((Collection)jars, (Iterable)((Iterable)inheritedJars));
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final void writeConfig() {
        try {
            this.ensureInitialized();
            file = new File(this.configFile.getParentFile(), this.configFile.getName() + ".new");
            var3_3 = file;
            var4_4 = Charsets.UTF_8;
            var5_6 = 8192;
            var6_23 = var3_3;
            var6_23 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)var6_23), var4_4);
            writer = var6_23 instanceof BufferedWriter != false ? (BufferedWriter)var6_23 : new BufferedWriter((Writer)var6_23, var5_6);
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<");
            writer.write("lint");
            v0 = this.fileClients;
            if (v0 != null) {
                it = v0;
                $i$a$-let-LintXmlConfiguration$writeConfig$1 = false;
                this.writeAttribute(writer, "in", it);
            }
            v1 = this.getBaselineFile();
            if (v1 != null) {
                baselineFile = v1;
                $i$a$-let-LintXmlConfiguration$writeConfig$2 = false;
                writer.write(" baseline=\"");
                v2 = Project.getRelativePath(this.configFile.getParentFile(), baselineFile);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getRelativePath(...)");
                path = v2;
                this.writeAttribute(writer, "baseline", StringsKt.replace$default((String)path, (char)'\\', (char)'/', (boolean)false, (int)4, null));
            }
            v3 = this.checkAllWarnings;
            if (v3 != null) {
                it = v3;
                $i$a$-let-LintXmlConfiguration$writeConfig$3 = false;
                this.writeAttribute(writer, "checkAllWarnings", String.valueOf(it));
            }
            v4 = this.ignoreWarnings;
            if (v4 != null) {
                it = v4;
                $i$a$-let-LintXmlConfiguration$writeConfig$4 = false;
                this.writeAttribute(writer, "ignoreWarnings", String.valueOf(it));
            }
            v5 = this.warningsAsErrors;
            if (v5 != null) {
                it = v5;
                $i$a$-let-LintXmlConfiguration$writeConfig$5 = false;
                this.writeAttribute(writer, "warningsAsErrors", String.valueOf(it));
            }
            v6 = this.fatalOnly;
            if (v6 != null) {
                it = v6;
                $i$a$-let-LintXmlConfiguration$writeConfig$6 = false;
                this.writeAttribute(writer, "fatalOnly", String.valueOf(it));
            }
            v7 = this.checkTestSources;
            if (v7 != null) {
                it = v7;
                $i$a$-let-LintXmlConfiguration$writeConfig$7 = false;
                this.writeAttribute(writer, "checkTestSources", String.valueOf(it));
            }
            v8 = this.ignoreTestSources;
            if (v8 != null) {
                it = v8;
                $i$a$-let-LintXmlConfiguration$writeConfig$8 = false;
                this.writeAttribute(writer, "ignoreTestSources", String.valueOf(it));
            }
            v9 = this.checkGeneratedSources;
            if (v9 != null) {
                it = v9;
                $i$a$-let-LintXmlConfiguration$writeConfig$9 = false;
                this.writeAttribute(writer, "checkGeneratedSources", String.valueOf(it));
            }
            v10 = this.checkDependencies;
            if (v10 != null) {
                it = v10;
                $i$a$-let-LintXmlConfiguration$writeConfig$10 = false;
                this.writeAttribute(writer, "checkDependencies", String.valueOf(it));
            }
            v11 = this.explainIssues;
            if (v11 != null) {
                it = v11;
                $i$a$-let-LintXmlConfiguration$writeConfig$11 = false;
                this.writeAttribute(writer, "explainIssues", String.valueOf(it));
            }
            v12 = this.applySuggestions;
            if (v12 != null) {
                it = v12;
                $i$a$-let-LintXmlConfiguration$writeConfig$12 = false;
                this.writeAttribute(writer, "applySuggestions", String.valueOf(it));
            }
            v13 = this.removeFixedBaselineIssues;
            if (v13 != null) {
                it = v13;
                $i$a$-let-LintXmlConfiguration$writeConfig$13 = false;
                this.writeAttribute(writer, "removeFixedBaselineIssues", String.valueOf(it));
            }
            v14 = this.abortOnError;
            if (v14 != null) {
                it = v14;
                $i$a$-let-LintXmlConfiguration$writeConfig$14 = false;
                this.writeAttribute(writer, "abortOnError", String.valueOf(it));
            }
            v15 = this.lintJars;
            if (v15 != null) {
                it = v15;
                $i$a$-let-LintXmlConfiguration$writeConfig$15 = false;
                this.writeAttribute(writer, "lintJars", CollectionsKt.joinToString$default((Iterable)it, (CharSequence)";", null, null, (int)0, null, (Function1)((Function1)new Function1<File, CharSequence>(this){
                    final /* synthetic */ LintXmlConfiguration this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final CharSequence invoke(File f) {
                        CharSequence charSequence;
                        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
                        String lintPath = f.getPath();
                        Object object = this.this$0.getConfigFile().getParentFile();
                        if (object == null || (object = ((File)object).getPath()) == null) {
                            object = "";
                        }
                        Object xmlPath = object;
                        Intrinsics.checkNotNull((Object)lintPath);
                        if (StringsKt.startsWith$default((String)lintPath, (String)xmlPath, (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)lintPath, (Object)xmlPath) && lintPath.charAt(((String)xmlPath).length()) == File.separatorChar) {
                            String string = lintPath.substring(((String)xmlPath).length() + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            charSequence = StringsKt.replace$default((String)string, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
                        } else {
                            charSequence = StringsKt.replace$default((String)lintPath, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
                        }
                        return charSequence;
                    }
                }), (int)30, null));
            }
            writer.write(">\n");
            for (Map issueMap : this.getIssueMaps()) {
                block34: {
                    if (issueMap.isEmpty()) continue;
                    v16 = this.clientIssueMaps;
                    if (v16 == null || (v16 = v16.entrySet()) == null) ** GOTO lbl-1000
                    $this$firstOrNull$iv = (Iterable)v16;
                    $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        var13_48 = (Map.Entry)element$iv;
                        $i$a$-firstOrNull-LintXmlConfiguration$writeConfig$client$1 = false;
                        v = (Map)var13_48.getValue();
                        if (!Intrinsics.areEqual((Object)v, (Object)issueMap)) continue;
                        v17 = element$iv;
                        break block34;
                    }
                    v17 = null;
                }
                if ((v16 = (Map.Entry)v17) != null) {
                    v18 = (String)v16.getKey();
                } else lbl-1000:
                // 2 sources

                {
                    v18 = null;
                }
                client = v18;
                ids = SequencesKt.sorted((Sequence)CollectionsKt.asSequence((Iterable)issueMap.keySet()));
                for (String id : ids) {
                    if ((IssueData)issueMap.get(id) == null || data.isEmpty()) continue;
                    writer.write("    <");
                    writer.write("issue");
                    if (client != null) {
                        this.writeAttribute(writer, "in", client);
                    }
                    this.writeAttribute(writer, "id", id);
                    severity = data.getSeverity();
                    if (severity != null) {
                        var11_46 = severity.name();
                        v19 = Locale.ROOT;
                        Intrinsics.checkNotNullExpressionValue((Object)v19, (String)"ROOT");
                        v20 = var11_46.toLowerCase(v19);
                        Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"toLowerCase(...)");
                        this.writeAttribute(writer, "severity", v20);
                    }
                    regexps = data.getPatterns();
                    paths = data.getPaths();
                    options = data.getOptions();
                    if (paths != null && ((Collection)paths).isEmpty() == false != false || regexps != null && ((Collection)regexps).isEmpty() == false != false || options != null && options.isEmpty() == false) {
                        writer.write(">\n");
                        if (options != null) {
                            for (Map.Entry<String, String> option : options.entrySet()) {
                                writer.write("        <");
                                writer.write("option");
                                this.writeAttribute(writer, "name", option.getKey());
                                this.writeAttribute(writer, "value", option.getValue());
                                writer.write(" />\n");
                            }
                        }
                        if (paths != null) {
                            for (String path : paths) {
                                writer.write("        <");
                                writer.write("ignore");
                                this.writeAttribute(writer, "path", StringsKt.replace$default((String)path, (char)'\\', (char)'/', (boolean)false, (int)4, null));
                                writer.write(" />\n");
                            }
                        }
                        if (regexps != null) {
                            for (Pattern regexp : regexps) {
                                writer.write("        <");
                                writer.write("ignore");
                                v21 = regexp.pattern();
                                Intrinsics.checkNotNullExpressionValue((Object)v21, (String)"pattern(...)");
                                this.writeAttribute(writer, "regexp", v21);
                                writer.write(" />\n");
                            }
                        }
                        writer.write("    </");
                        writer.write("issue");
                        writer.write(">\n");
                        continue;
                    }
                    writer.write(" />\n");
                }
            }
            writer.write("</lint>");
            writer.close();
            oldFile = new File(this.configFile.getParentFile(), this.configFile.getName() + "~");
            if (oldFile.exists()) {
                oldFile.delete();
            }
            if (this.configFile.exists()) {
                this.configFile.renameTo(oldFile);
            }
            if ((ok = file.renameTo(this.configFile)) && oldFile.exists()) {
                oldFile.delete();
            }
        }
        catch (Exception e) {
            this.getClient().log(e, null, new Object[0]);
        }
    }

    private final void writeAttribute(Writer writer, String name, String value) {
        writer.write(" ");
        writer.write(name);
        writer.write("=\"");
        writer.write(value);
        writer.write("\"");
    }

    @Override
    public void ignore(@NotNull Context context2, @NotNull Issue issue, @Nullable Location location2, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)issue, (String)TAG_ISSUE);
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        if (location2 != null) {
            this.ignore(issue, location2.getFile());
        }
    }

    @Override
    public void ignore(@NotNull Issue issue, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)TAG_ISSUE);
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.ignore(issue.getId(), file);
    }

    @Override
    public void ignore(@NotNull String issueId, @NotNull File file) {
        IssueData data;
        List list;
        Intrinsics.checkNotNullParameter((Object)issueId, (String)"issueId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Map<String, IssueData> issueMap = this.getPrimaryIssueMap();
        String string = Project.getRelativePath(this.configFile.getParentFile(), file);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRelativePath(...)");
        String path2 = string;
        IssueData issueData = issueMap.get(issueId);
        if (issueData == null) {
            IssueData issueData2;
            IssueData it = issueData2 = new IssueData(null, null, null, null, false, 31, null);
            boolean bl = false;
            issueMap.put(issueId, it);
            issueData = issueData2;
        }
        if ((list = (data = issueData).getPaths()) == null) {
            ArrayList arrayList;
            ArrayList it = arrayList = new ArrayList();
            boolean bl = false;
            data.setPaths(it);
            list = arrayList;
        }
        List paths = list;
        paths.add((String)path2);
        CollectionsKt.sort(paths);
        if (!this.bulkEditing) {
            this.writeConfig();
        }
    }

    @Override
    public void setSeverity(@NotNull Issue issue, @Nullable Severity severity) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)TAG_ISSUE);
        Map<String, IssueData> issueMap = this.getPrimaryIssueMap();
        String id = issue.getId();
        IssueData issueData = issueMap.get(id);
        if (issueData == null) {
            IssueData issueData2;
            IssueData it = issueData2 = new IssueData(null, null, null, null, false, 31, null);
            boolean bl = false;
            issueMap.put(id, it);
            issueData = issueData2;
        }
        IssueData data = issueData;
        data.setSeverity(severity);
        if (!this.bulkEditing) {
            this.writeConfig();
        }
    }

    @Override
    public void startBulkEditing() {
        this.bulkEditing = true;
    }

    @Override
    public void finishBulkEditing() {
        this.bulkEditing = false;
        this.writeConfig();
    }

    @Override
    @Nullable
    public File getBaselineFile() {
        return this._baselineFile;
    }

    @Override
    public void setBaselineFile(@Nullable File value) {
        File dir;
        this._baselineFile = value != null && !value.isAbsolute() ? ((dir = this.configFile.getParentFile()) != null ? new File(dir, value.getPath()) : value) : value;
    }

    @Override
    public void validateIssueIds(@NotNull LintClient client, @NotNull LintDriver driver, @Nullable Project project, @NotNull IssueRegistry registry, @NotNull Set<String> allowed) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter(allowed, (String)"allowed");
        Configuration configuration = this.getParent();
        if (configuration != null) {
            configuration.validateIssueIds(client, driver, project, registry, allowed);
        }
        if (this.validated) {
            return;
        }
        this.validated = true;
        for (Map<String, IssueData> map : this.getIssueMaps()) {
            if (!(!map.isEmpty()) || (TypeIntrinsics.isMutableMap(map) ? map : null) == null) continue;
            this.validateIssueIds(client, driver, project, registry, map, allowed);
        }
    }

    private final void validateIssueIds(LintClient client, LintDriver driver, Project project, IssueRegistry registry, Map<String, IssueData> map, Set<String> allowed) {
        block3: {
            for (String id : CollectionsKt.toList((Iterable)map.keySet())) {
                IssueData data;
                if (Intrinsics.areEqual((Object)id, (Object)VALUE_ALL)) continue;
                Issue issue = registry.getIssue(id);
                if (issue == null) {
                    if (registry.isCategoryName(id)) continue;
                    Project project2 = project;
                    File dir = project2 != null ? project2.getDir() : null;
                    File configDir = this.configFile.getParentFile();
                    if (dir != null && configDir != null && FileUtil.isAncestor((File)configDir, (File)dir, (boolean)true) || allowed.contains(id)) continue;
                    this.reportNonExistingIssueId(client, driver, registry, project, id);
                    continue;
                }
                if (Intrinsics.areEqual((Object)issue.getId(), (Object)id) || map.get(id) == null) continue;
                IssueData merge = map.get(issue.getId());
                if (merge == null) {
                    map.put(issue.getId(), data);
                    map.remove(id);
                    continue;
                }
                merge.plusAssign(data);
            }
            Configuration configuration = this.getParent();
            if (configuration == null) break block3;
            configuration.validateIssueIds(client, driver, project, registry, allowed);
        }
    }

    @NotNull
    public String toString() {
        String path2 = PathVariables.toPathString$default((PathVariables)this.getConfigurations().getClient().getPathVariables(), (File)this.configFile, null, (boolean)false, (int)6, null);
        return this.getClass().getSimpleName() + "(" + path2 + ")";
    }

    private static final Boolean readConfig$asBoolean(String $this$readConfig_u24asBoolean) {
        return Intrinsics.areEqual((Object)$this$readConfig_u24asBoolean, (Object)"true") ? Boolean.valueOf(true) : (Intrinsics.areEqual((Object)$this$readConfig_u24asBoolean, (Object)"false") ? Boolean.valueOf(false) : null);
    }

    private static final boolean readConfig$applies(LintXmlConfiguration this$0) {
        return LintXmlConfiguration.isApplicableClient$default(this$0, this$0.fileClients, false, false, 6, null);
    }

    @JvmStatic
    @NotNull
    public static final LintXmlConfiguration create(@NotNull ConfigurationHierarchy configurations, @NotNull File lintFile) {
        return Companion.create(configurations, lintFile);
    }

    @JvmStatic
    @NotNull
    public static final LintXmlConfiguration create(@NotNull ConfigurationHierarchy configurations, @NotNull File lintFile, @NotNull CharSequence contents) {
        return Companion.create(configurations, lintFile, contents);
    }

    public static final /* synthetic */ boolean access$isPathIgnored(LintXmlConfiguration $this, IssueData issueData, Location location2, Context context2) {
        return $this.isPathIgnored(issueData, location2, context2);
    }

    public static final /* synthetic */ boolean access$isPatternIgnored(LintXmlConfiguration $this, IssueData issueData, String message2, Location location2, Context context2) {
        return $this.isPatternIgnored(issueData, message2, location2, context2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0007J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006&"}, d2={"Lcom/android/tools/lint/client/api/LintXmlConfiguration$Companion;", "", "<init>", "()V", "CONFIG_FILE_NAME", "", "TAG_LINT", "TAG_ISSUE", "TAG_IGNORE", "TAG_OPTION", "ATTR_ID", "ATTR_IN", "ATTR_SEVERITY", "ATTR_PATH", "ATTR_REGEXP", "ATTR_NAME", "ATTR_VALUE", "ATTR_TESTS", "VALUE_ALL", "ATTR_BASELINE", "RES_PATH_START", "RES_PATH_START_LEN", "", "warnedOptions", "", "Lcom/android/tools/lint/detector/api/Option;", "getWarnedOptions", "()Ljava/util/Set;", "setWarnedOptions", "(Ljava/util/Set;)V", "create", "Lcom/android/tools/lint/client/api/LintXmlConfiguration;", "configurations", "Lcom/android/tools/lint/client/api/ConfigurationHierarchy;", "lintFile", "Ljava/io/File;", "contents", "", "lint-api"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Set<Option> getWarnedOptions() {
            return warnedOptions;
        }

        public final void setWarnedOptions(@Nullable Set<Option> set) {
            warnedOptions = set;
        }

        @JvmStatic
        @NotNull
        public final LintXmlConfiguration create(@NotNull ConfigurationHierarchy configurations, @NotNull File lintFile) {
            Intrinsics.checkNotNullParameter((Object)configurations, (String)"configurations");
            Intrinsics.checkNotNullParameter((Object)lintFile, (String)"lintFile");
            return new LintXmlConfiguration(configurations, lintFile, null, false, 12, null);
        }

        @JvmStatic
        @NotNull
        public final LintXmlConfiguration create(@NotNull ConfigurationHierarchy configurations, @NotNull File lintFile, @NotNull CharSequence contents) {
            Intrinsics.checkNotNullParameter((Object)configurations, (String)"configurations");
            Intrinsics.checkNotNullParameter((Object)lintFile, (String)"lintFile");
            Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
            LintXmlConfiguration config = new LintXmlConfiguration(configurations, lintFile, null, false, 12, null);
            KXmlParser parser = new KXmlParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput((Reader)new CharSequenceReader(contents));
            config.readConfig((XmlPullParser)parser);
            return config;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BY\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005\u0012\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010!\u001a\u00020\fJ\b\u0010\"\u001a\u00020\u0006H\u0016J\u0011\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0000H\u0086\u0002J\u000b\u0010&\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010'\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u0011\u0010(\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005H\u00c6\u0003J\u0017\u0010)\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\nH\u00c6\u0003J\t\u0010*\u001a\u00020\fH\u00c6\u0003J[\u0010+\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00052\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010,\u001a\u00020\f2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010-\u001a\u00020.H\u00d6\u0001R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\"\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\"\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0014\"\u0004\b\u0018\u0010\u0016R(\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006/"}, d2={"Lcom/android/tools/lint/client/api/LintXmlConfiguration$IssueData;", "", "severity", "Lcom/android/tools/lint/detector/api/Severity;", "paths", "", "", "patterns", "Ljava/util/regex/Pattern;", "options", "", "appliesToTests", "", "<init>", "(Lcom/android/tools/lint/detector/api/Severity;Ljava/util/List;Ljava/util/List;Ljava/util/Map;Z)V", "getSeverity", "()Lcom/android/tools/lint/detector/api/Severity;", "setSeverity", "(Lcom/android/tools/lint/detector/api/Severity;)V", "getPaths", "()Ljava/util/List;", "setPaths", "(Ljava/util/List;)V", "getPatterns", "setPatterns", "getOptions", "()Ljava/util/Map;", "setOptions", "(Ljava/util/Map;)V", "getAppliesToTests", "()Z", "setAppliesToTests", "(Z)V", "isEmpty", "toString", "plusAssign", "", "other", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "hashCode", "", "lint-api"})
    @SourceDebugExtension(value={"SMAP\nLintXmlConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintXmlConfiguration.kt\ncom/android/tools/lint/client/api/LintXmlConfiguration$IssueData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1652:1\n1#2:1653\n*E\n"})
    public static final class IssueData {
        @Nullable
        private Severity severity;
        @Nullable
        private List<String> paths;
        @Nullable
        private List<Pattern> patterns;
        @Nullable
        private Map<String, String> options;
        private boolean appliesToTests;

        public IssueData(@Nullable Severity severity, @Nullable List<String> paths, @Nullable List<Pattern> patterns, @Nullable Map<String, String> options, boolean appliesToTests) {
            this.severity = severity;
            this.paths = paths;
            this.patterns = patterns;
            this.options = options;
            this.appliesToTests = appliesToTests;
        }

        public /* synthetic */ IssueData(Severity severity, List list, List list2, Map map, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                severity = null;
            }
            if ((n & 2) != 0) {
                list = null;
            }
            if ((n & 4) != 0) {
                list2 = null;
            }
            if ((n & 8) != 0) {
                map = null;
            }
            if ((n & 0x10) != 0) {
                bl = false;
            }
            this(severity, list, list2, map, bl);
        }

        @Nullable
        public final Severity getSeverity() {
            return this.severity;
        }

        public final void setSeverity(@Nullable Severity severity) {
            this.severity = severity;
        }

        @Nullable
        public final List<String> getPaths() {
            return this.paths;
        }

        public final void setPaths(@Nullable List<String> list) {
            this.paths = list;
        }

        @Nullable
        public final List<Pattern> getPatterns() {
            return this.patterns;
        }

        public final void setPatterns(@Nullable List<Pattern> list) {
            this.patterns = list;
        }

        @Nullable
        public final Map<String, String> getOptions() {
            return this.options;
        }

        public final void setOptions(@Nullable Map<String, String> map) {
            this.options = map;
        }

        public final boolean getAppliesToTests() {
            return this.appliesToTests;
        }

        public final void setAppliesToTests(boolean bl) {
            this.appliesToTests = bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isEmpty() {
            if (this.severity != null) return false;
            if (this.paths != null) {
                List<String> list = this.paths;
                Intrinsics.checkNotNull(list);
                if (!list.isEmpty()) return false;
            }
            if (this.patterns != null) {
                List<Pattern> list = this.patterns;
                Intrinsics.checkNotNull(list);
                if (!list.isEmpty()) return false;
            }
            if (this.options == null) return true;
            Map<String, String> map = this.options;
            Intrinsics.checkNotNull(map);
            if (!map.isEmpty()) return false;
            return true;
        }

        @NotNull
        public String toString() {
            return "IssueData(severity=" + this.severity + ", paths=" + this.paths + ", patterns=" + this.patterns + ", options=" + this.options + ", tests=" + this.appliesToTests + ")";
        }

        public final void plusAssign(@NotNull IssueData other) {
            block9: {
                Map<String, String> options;
                Object it;
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                Severity severity = other.severity;
                if (severity != null) {
                    it = severity;
                    boolean bl = false;
                    this.severity = it;
                }
                List<String> list = other.paths;
                if (list != null) {
                    List<String> paths;
                    it = list;
                    boolean bl = false;
                    List<String> list2 = paths = this.paths;
                    if (list2 == null) {
                        this.paths = other.paths;
                    } else {
                        list2.addAll((Collection)it);
                    }
                }
                List<Pattern> list3 = other.patterns;
                if (list3 != null) {
                    List<Pattern> patterns;
                    it = list3;
                    boolean bl = false;
                    List<Pattern> list4 = patterns = this.patterns;
                    if (list4 == null) {
                        this.patterns = other.patterns;
                    } else {
                        list4.addAll((Collection)it);
                    }
                }
                Map<String, String> map = other.options;
                if (map == null) break block9;
                it = map;
                boolean bl = false;
                Map<String, String> map2 = options = this.options;
                if (map2 == null) {
                    this.options = other.options;
                } else {
                    map2.putAll((Map<String, String>)it);
                }
            }
        }

        @Nullable
        public final Severity component1() {
            return this.severity;
        }

        @Nullable
        public final List<String> component2() {
            return this.paths;
        }

        @Nullable
        public final List<Pattern> component3() {
            return this.patterns;
        }

        @Nullable
        public final Map<String, String> component4() {
            return this.options;
        }

        public final boolean component5() {
            return this.appliesToTests;
        }

        @NotNull
        public final IssueData copy(@Nullable Severity severity, @Nullable List<String> paths, @Nullable List<Pattern> patterns, @Nullable Map<String, String> options, boolean appliesToTests) {
            return new IssueData(severity, paths, patterns, options, appliesToTests);
        }

        public static /* synthetic */ IssueData copy$default(IssueData issueData, Severity severity, List list, List list2, Map map, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                severity = issueData.severity;
            }
            if ((n & 2) != 0) {
                list = issueData.paths;
            }
            if ((n & 4) != 0) {
                list2 = issueData.patterns;
            }
            if ((n & 8) != 0) {
                map = issueData.options;
            }
            if ((n & 0x10) != 0) {
                bl = issueData.appliesToTests;
            }
            return issueData.copy(severity, list, list2, map, bl);
        }

        public int hashCode() {
            int result = this.severity == null ? 0 : this.severity.hashCode();
            result = result * 31 + (this.paths == null ? 0 : ((Object)this.paths).hashCode());
            result = result * 31 + (this.patterns == null ? 0 : ((Object)this.patterns).hashCode());
            result = result * 31 + (this.options == null ? 0 : ((Object)this.options).hashCode());
            result = result * 31 + Boolean.hashCode(this.appliesToTests);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IssueData)) {
                return false;
            }
            IssueData issueData = (IssueData)other;
            if (this.severity != issueData.severity) {
                return false;
            }
            if (!Intrinsics.areEqual(this.paths, issueData.paths)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.patterns, issueData.patterns)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.options, issueData.options)) {
                return false;
            }
            return this.appliesToTests == issueData.appliesToTests;
        }

        public IssueData() {
            this(null, null, null, null, false, 31, null);
        }
    }
}

