/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.AnnotationHandler;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.ResourceContext;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.tools.lint.detector.api.XmlScannerConstants;
import com.intellij.psi.PsiClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\f\u0010\u0017\u001a\u00020\u0018*\u00020\rH\u0002J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010 \u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020!R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/lint/client/api/ResourceVisitor;", "", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "allDetectors", "", "Lcom/android/tools/lint/detector/api/XmlScanner;", "binaryDetectors", "Lcom/android/tools/lint/detector/api/Detector;", "<init>", "(Lcom/android/tools/lint/client/api/LintDriver;Ljava/util/List;Ljava/util/List;)V", "elementToCheck", "", "", "attributeToCheck", "allElementDetectors", "allAttributeDetectors", "annotationHandler", "Lcom/android/tools/lint/client/api/AnnotationHandler;", "visitFile", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "isLikelyClassName", "", "visitElement", "element", "Lorg/w3c/dom/Element;", "visitClassReference", "fqn", "reference", "Lorg/w3c/dom/Node;", "visitBinaryResource", "Lcom/android/tools/lint/detector/api/ResourceContext;", "lint-api"})
@SourceDebugExtension(value={"SMAP\nResourceVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceVisitor.kt\ncom/android/tools/lint/client/api/ResourceVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,246:1\n1869#2:247\n1870#2:255\n1869#2:256\n1870#2:264\n1869#2,2:273\n1869#2,2:275\n1869#2,2:277\n1869#2,2:279\n1869#2,2:281\n1869#2,2:283\n382#3,7:248\n382#3,7:257\n382#3,7:265\n1#4:272\n*S KotlinDebug\n*F\n+ 1 ResourceVisitor.kt\ncom/android/tools/lint/client/api/ResourceVisitor\n*L\n74#1:247\n74#1:255\n82#1:256\n82#1:264\n170#1:273,2\n171#1:275,2\n179#1:277,2\n180#1:279,2\n226#1:281,2\n227#1:283,2\n75#1:248,7\n83#1:257,7\n94#1:265,7\n*E\n"})
public final class ResourceVisitor {
    @NotNull
    private final List<XmlScanner> allDetectors;
    @Nullable
    private final List<Detector> binaryDetectors;
    @NotNull
    private final Map<String, List<XmlScanner>> elementToCheck;
    @NotNull
    private final Map<String, List<XmlScanner>> attributeToCheck;
    @NotNull
    private final List<XmlScanner> allElementDetectors;
    @NotNull
    private final List<XmlScanner> allAttributeDetectors;
    @Nullable
    private final AnnotationHandler annotationHandler;

    /*
     * WARNING - void declaration
     */
    public ResourceVisitor(@NotNull LintDriver driver, @NotNull List<? extends XmlScanner> allDetectors, @Nullable List<? extends Detector> binaryDetectors) {
        AnnotationHandler annotationHandler;
        Collection<String> attributes;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter(allDetectors, (String)"allDetectors");
        this.allDetectors = allDetectors;
        this.binaryDetectors = binaryDetectors;
        HashMap elementToCheck = new HashMap();
        HashMap attributeToCheck = new HashMap();
        ArrayList<XmlScanner> allElementDetectors = new ArrayList<XmlScanner>();
        ArrayList<XmlScanner> allAttributeDetectors = new ArrayList<XmlScanner>();
        Map annotationsMap = null;
        for (XmlScanner detector : this.allDetectors) {
            List<String> annotations;
            Object element$iv;
            Object key$iv;
            attributes = detector.getApplicableAttributes();
            if (attributes == XmlScannerConstants.ALL) {
                allAttributeDetectors.add(detector);
            } else {
                Collection<String> collection = attributes;
                if (collection != null) {
                    Iterable $this$forEach$iv = collection;
                    boolean $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        Object object;
                        void $this$getOrPut$iv;
                        String attribute = (String)element$iv2;
                        boolean bl = false;
                        Map map = attributeToCheck;
                        key$iv = attribute;
                        boolean $i$f$getOrPut = false;
                        Object value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl2 = false;
                            List answer$iv = new ArrayList();
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        ((List)object).add(detector);
                    }
                }
            }
            Collection<String> elements = detector.getApplicableElements();
            if (elements == XmlScannerConstants.ALL) {
                allElementDetectors.add(detector);
            } else {
                Collection<String> collection = elements;
                if (collection != null) {
                    Object element$iv2;
                    Iterable $this$forEach$iv = collection;
                    boolean $i$f$forEach = false;
                    element$iv2 = $this$forEach$iv.iterator();
                    while (element$iv2.hasNext()) {
                        Object object;
                        void $this$getOrPut$iv;
                        element$iv = element$iv2.next();
                        String element = (String)element$iv;
                        boolean bl = false;
                        key$iv = elementToCheck;
                        String key$iv2 = element;
                        boolean $i$f$getOrPut = false;
                        Object value$iv = $this$getOrPut$iv.get(key$iv2);
                        if (value$iv == null) {
                            boolean bl3 = false;
                            List answer$iv = new ArrayList();
                            $this$getOrPut$iv.put(key$iv2, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        ((List)object).add(detector);
                    }
                }
            }
            if (!(detector instanceof SourceCodeScanner) || (annotations = ((SourceCodeScanner)((Object)detector)).applicableAnnotations()) == null) continue;
            if (annotationsMap == null) {
                annotationsMap = new HashMap();
            }
            for (String annotation : annotations) {
                Object object;
                void $this$getOrPut$iv;
                element$iv = annotationsMap;
                String key$iv3 = annotation;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv3);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv3, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(detector);
            }
        }
        this.elementToCheck = elementToCheck;
        this.attributeToCheck = attributeToCheck;
        this.allElementDetectors = allElementDetectors;
        this.allAttributeDetectors = allAttributeDetectors;
        ResourceVisitor resourceVisitor = this;
        Map map = annotationsMap;
        if (map != null) {
            void it;
            attributes = map;
            ResourceVisitor resourceVisitor2 = resourceVisitor;
            boolean bl = false;
            annotationHandler = new AnnotationHandler(driver, (Map<String, ? extends Collection<? extends SourceCodeScanner>>)it);
            resourceVisitor = resourceVisitor2;
        } else {
            annotationHandler = null;
        }
        resourceVisitor.annotationHandler = annotationHandler;
    }

    public final void visitFile(@NotNull XmlContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        try {
            for (XmlScanner check : this.allDetectors) {
                check.beforeCheckFile(context2);
                check.visitDocument(context2, context2.document);
            }
            if (!this.elementToCheck.isEmpty() || !this.attributeToCheck.isEmpty() || !((Collection)this.allAttributeDetectors).isEmpty() || !((Collection)this.allElementDetectors).isEmpty()) {
                Element element = context2.document.getDocumentElement();
                Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getDocumentElement(...)");
                this.visitElement(context2, element);
            }
            for (XmlScanner check : this.allDetectors) {
                check.afterCheckFile(context2);
            }
        }
        catch (Throwable e) {
            LintDriver.Companion.handleDetectorError(context2, context2.getDriver(), e);
        }
    }

    private final boolean isLikelyClassName(String $this$isLikelyClassName) {
        boolean inPackage;
        boolean bl = inPackage = StringsKt.indexOf$default((CharSequence)$this$isLikelyClassName, (char)'.', (int)0, (boolean)false, (int)6, null) != -1;
        if (inPackage && $this$isLikelyClassName.length() >= 2) {
            int prev = 46;
            int n = $this$isLikelyClassName.length();
            for (int i = 0; i < n; ++i) {
                char c = $this$isLikelyClassName.charAt(i);
                if (!(c == '.' && prev != 46 || prev == 46 && Character.isJavaIdentifierStart(c) || prev != 46 && Character.isJavaIdentifierPart(c))) {
                    return false;
                }
                prev = c;
            }
            return prev != 46 && prev != 36;
        }
        if (!inPackage && ((CharSequence)$this$isLikelyClassName).length() > 0) {
            int prev = 36;
            int n = $this$isLikelyClassName.length();
            for (int i = 0; i < n; ++i) {
                char c = $this$isLikelyClassName.charAt(i);
                if (!(prev == 36 && Character.isJavaIdentifierStart(c) || Character.isJavaIdentifierPart(c))) {
                    return false;
                }
                prev = c;
            }
            return prev != 36;
        }
        return false;
    }

    private final void visitElement(XmlContext context2, Element element) {
        XmlScanner check;
        int i;
        XmlScanner check2;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        List<XmlScanner> elementChecks;
        AnnotationHandler annotationHandler = this.annotationHandler;
        List<XmlScanner> list = elementChecks = this.elementToCheck.get(element.getLocalName());
        if (list != null) {
            $this$forEach$iv = list;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                check2 = (XmlScanner)element$iv;
                boolean bl = false;
                check2.visitElement(context2, element);
            }
        }
        $this$forEach$iv = this.allElementDetectors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            check2 = (XmlScanner)element$iv;
            boolean bl = false;
            check2.visitElement(context2, element);
        }
        if (!this.attributeToCheck.isEmpty() || !((Collection)this.allAttributeDetectors).isEmpty()) {
            NamedNodeMap attributes = element.getAttributes();
            int n = attributes.getLength();
            for (i = 0; i < n; ++i) {
                String className;
                Node node = attributes.item(i);
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Attr");
                Attr attribute = (Attr)node;
                String localName = attribute.getLocalName();
                String string = localName;
                if (string == null) {
                    string = attribute.getName();
                }
                String name = string;
                List<XmlScanner> list2 = this.attributeToCheck.get(name);
                if (list2 != null) {
                    Iterable $this$forEach$iv2 = list2;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        XmlScanner check3 = (XmlScanner)element$iv;
                        boolean bl = false;
                        check3.visitAttribute(context2, attribute);
                    }
                }
                Iterable $this$forEach$iv3 = this.allAttributeDetectors;
                boolean $i$f$forEach22 = false;
                for (Object element$iv : $this$forEach$iv3) {
                    XmlScanner check4 = (XmlScanner)element$iv;
                    boolean bl = false;
                    check4.visitAttribute(context2, attribute);
                }
                if (annotationHandler == null) continue;
                String $i$f$forEach22 = className = attribute.getValue();
                Intrinsics.checkNotNull((Object)$i$f$forEach22);
                if (StringsKt.startsWith$default((String)$i$f$forEach22, (String)".", (boolean)false, (int)2, null)) {
                    String string2 = context2.file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                    if (StringsKt.endsWith$default((String)string2, (String)"AndroidManifest.xml", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)localName, (Object)"name") && Intrinsics.areEqual((Object)attribute.getNamespaceURI(), (Object)"http://schemas.android.com/apk/res/android")) {
                        className = Lint.resolveManifestName(element, context2.getProject());
                    }
                }
                if (Intrinsics.areEqual((Object)localName, (Object)"text") || Intrinsics.areEqual((Object)localName, (Object)"hint") || Intrinsics.areEqual((Object)localName, (Object)"contentDescription")) continue;
                $i$f$forEach22 = className;
                Intrinsics.checkNotNull((Object)$i$f$forEach22);
                if (!this.isLikelyClassName($i$f$forEach22)) continue;
                $i$f$forEach22 = className;
                Intrinsics.checkNotNull((Object)$i$f$forEach22);
                this.visitClassReference($i$f$forEach22, context2, attribute);
            }
        }
        NodeList childNodes = element.getChildNodes();
        int n = childNodes.getLength();
        for (i = 0; i < n; ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1) continue;
            Intrinsics.checkNotNull((Object)child, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
            this.visitElement(context2, (Element)child);
        }
        String tagName = element.getTagName();
        if (annotationHandler != null) {
            Intrinsics.checkNotNull((Object)tagName);
            if (this.isLikelyClassName(tagName)) {
                this.visitClassReference(tagName, context2, element);
            }
        }
        List<XmlScanner> list3 = elementChecks;
        if (list3 != null) {
            Iterable $this$forEach$iv4 = list3;
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv4) {
                check = (XmlScanner)element$iv;
                boolean bl = false;
                check.visitElementAfter(context2, element);
            }
        }
        Iterable $this$forEach$iv5 = this.allElementDetectors;
        boolean $i$f$forEach4 = false;
        for (Object element$iv : $this$forEach$iv5) {
            check = (XmlScanner)element$iv;
            boolean bl = false;
            check.visitElementAfter(context2, element);
        }
    }

    private final void visitClassReference(String fqn, XmlContext context2, Node reference) {
        block1: {
            UastParser parser = context2.getClient().getUastParser(context2.getProject());
            PsiClass psiClass = parser.getEvaluator().findClass(StringsKt.replace$default((String)fqn, (char)'$', (char)'.', (boolean)false, (int)4, null));
            if (psiClass == null) break block1;
            AnnotationHandler annotationHandler = this.annotationHandler;
            if (annotationHandler != null) {
                annotationHandler.visitXmlClassReference(context2, reference, psiClass);
            }
        }
    }

    public final void visitBinaryResource(@NotNull ResourceContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        List<Detector> list = this.binaryDetectors;
        if (list == null) {
            return;
        }
        for (Detector check : list) {
            check.beforeCheckFile(context2);
            check.checkBinaryResource(context2);
            check.afterCheckFile(context2);
        }
    }
}

