/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.editorActions.SmartBackspaceMode;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.ide.ui.UINumericRange;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.Disposer;
import com.intellij.serialization.SerializationException;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="CodeInsightSettings", storages={@Storage(value="editor.xml")}, category=SettingsCategory.CODE, perClient=true)
public class CodeInsightSettings
implements PersistentStateComponent<Element>,
Cloneable {
    private static final Logger LOG = Logger.getInstance(CodeInsightSettings.class);
    private final List<PropertyChangeListener> myListeners = new CopyOnWriteArrayList<PropertyChangeListener>();
    public static final UINumericRange JAVADOC_INFO_DELAY_RANGE = new UINumericRange(500, 0, 5000);
    public static final UINumericRange PARAMETER_INFO_DELAY_RANGE = new UINumericRange(1000, 0, 5000);
    public boolean SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION;
    public boolean AUTO_POPUP_PARAMETER_INFO = true;
    public int PARAMETER_INFO_DELAY;
    public boolean AUTO_POPUP_JAVADOC_INFO;
    public int JAVADOC_INFO_DELAY;
    public boolean AUTO_POPUP_COMPLETION_LOOKUP;
    @Deprecated
    public int COMPLETION_CASE_SENSITIVE;
    public static final int ALL = 1;
    public static final int NONE = 2;
    public static final int FIRST_LETTER = 3;
    @Deprecated(forRemoval=true)
    public boolean SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS;
    public boolean AUTOCOMPLETE_ON_CODE_COMPLETION;
    public boolean AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION;
    public boolean SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO;
    @OptionTag(value="SMART_BACKSPACE")
    private int SMART_BACKSPACE;
    public boolean SMART_INDENT_ON_ENTER;
    public boolean INSERT_BRACE_ON_ENTER;
    public boolean INSERT_SCRIPTLET_END_ON_ENTER;
    public boolean CLOSE_COMMENT_ON_ENTER;
    public boolean JAVADOC_STUB_ON_ENTER;
    public boolean SMART_END_ACTION;
    public boolean JAVADOC_GENERATE_CLOSING_TAG;
    public boolean SURROUND_SELECTION_ON_QUOTE_TYPED;
    public boolean AUTOINSERT_PAIR_BRACKET;
    public boolean AUTOINSERT_PAIR_QUOTE;
    public boolean REFORMAT_BLOCK_ON_RBRACE;
    public int REFORMAT_ON_PASTE;
    public static final int NO_REFORMAT = 1;
    public static final int INDENT_BLOCK = 2;
    public static final int INDENT_EACH_LINE = 3;
    public static final int REFORMAT_BLOCK = 4;
    public boolean ENABLE_SECOND_REFORMAT;
    public boolean INDENT_TO_CARET_ON_PASTE;
    public int ADD_IMPORTS_ON_PASTE;
    public static final int YES = 1;
    public static final int NO = 2;
    public static final int ASK = 3;
    public boolean HIGHLIGHT_BRACES;
    public boolean HIGHLIGHT_SCOPE;
    public boolean USE_INSTANCEOF_ON_EQUALS_PARAMETER;
    public boolean USE_ACCESSORS_IN_EQUALS_HASHCODE;
    public boolean HIGHLIGHT_IDENTIFIER_UNDER_CARET;
    public boolean OPTIMIZE_IMPORTS_ON_THE_FLY;
    public boolean ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY;
    public boolean ADD_MEMBER_IMPORTS_ON_THE_FLY;
    public boolean JSP_ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY;
    public boolean TAB_EXITS_BRACKETS_AND_QUOTES;
    @Property(surroundWithTag=false)
    @XCollection(elementName="EXCLUDED_PACKAGE", valueAttributeName="NAME")
    public String @NotNull [] EXCLUDED_PACKAGES;

    public CodeInsightSettings() {
        this.PARAMETER_INFO_DELAY = CodeInsightSettings.PARAMETER_INFO_DELAY_RANGE.initial;
        this.JAVADOC_INFO_DELAY = CodeInsightSettings.JAVADOC_INFO_DELAY_RANGE.initial;
        this.AUTO_POPUP_COMPLETION_LOOKUP = true;
        this.COMPLETION_CASE_SENSITIVE = 3;
        this.AUTOCOMPLETE_ON_CODE_COMPLETION = true;
        this.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION = true;
        this.SMART_BACKSPACE = SmartBackspaceMode.AUTOINDENT.ordinal();
        this.SMART_INDENT_ON_ENTER = true;
        this.INSERT_BRACE_ON_ENTER = true;
        this.INSERT_SCRIPTLET_END_ON_ENTER = true;
        this.CLOSE_COMMENT_ON_ENTER = true;
        this.JAVADOC_STUB_ON_ENTER = true;
        this.SMART_END_ACTION = true;
        this.JAVADOC_GENERATE_CLOSING_TAG = true;
        this.SURROUND_SELECTION_ON_QUOTE_TYPED = true;
        this.AUTOINSERT_PAIR_BRACKET = true;
        this.AUTOINSERT_PAIR_QUOTE = true;
        this.REFORMAT_BLOCK_ON_RBRACE = true;
        this.REFORMAT_ON_PASTE = 3;
        this.ADD_IMPORTS_ON_PASTE = 1;
        this.HIGHLIGHT_BRACES = true;
        this.HIGHLIGHT_IDENTIFIER_UNDER_CARET = true;
        this.ADD_MEMBER_IMPORTS_ON_THE_FLY = true;
        this.TAB_EXITS_BRACKETS_AND_QUOTES = true;
        this.EXCLUDED_PACKAGES = ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public static CodeInsightSettings getInstance() {
        return ApplicationManager.getApplication().getService(CodeInsightSettings.class);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener2, Disposable parentDisposable) {
        this.myListeners.add(listener2);
        Disposer.register(parentDisposable, () -> this.myListeners.remove(listener2));
    }

    @Nullable
    public CodeInsightSettings clone() {
        try {
            return (CodeInsightSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int getCompletionCaseSensitive() {
        return this.COMPLETION_CASE_SENSITIVE;
    }

    public void setCompletionCaseSensitive(int value) {
        this.COMPLETION_CASE_SENSITIVE = value;
    }

    public boolean isSelectAutopopupSuggestionsByChars() {
        return this.SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS;
    }

    public void setSelectAutopopupSuggestionsByChars(boolean value) {
        boolean oldValue = this.SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS;
        if (oldValue != value) {
            this.SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS = value;
            for (PropertyChangeListener listener2 : this.myListeners) {
                listener2.propertyChange(new PropertyChangeEvent(this, "SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS", oldValue, value));
            }
        }
    }

    @Transient
    @NotNull
    public SmartBackspaceMode getBackspaceMode() {
        SmartBackspaceMode[] values2 = SmartBackspaceMode.values();
        SmartBackspaceMode smartBackspaceMode = this.SMART_BACKSPACE >= 0 && this.SMART_BACKSPACE < values2.length ? values2[this.SMART_BACKSPACE] : SmartBackspaceMode.OFF;
        if (smartBackspaceMode == null) {
            CodeInsightSettings.$$$reportNull$$$0(0);
        }
        return smartBackspaceMode;
    }

    @Transient
    public void setBackspaceMode(@NotNull SmartBackspaceMode mode) {
        if (mode == null) {
            CodeInsightSettings.$$$reportNull$$$0(1);
        }
        this.SMART_BACKSPACE = mode.ordinal();
    }

    @Override
    public void loadState(@NotNull Element state2) {
        if (state2 == null) {
            CodeInsightSettings.$$$reportNull$$$0(2);
        }
        this.setDefaults();
        try {
            XmlSerializer.deserializeInto(state2, this);
        }
        catch (SerializationException e) {
            LOG.info(e);
        }
    }

    @Override
    public void noStateLoaded() {
        this.setDefaults();
    }

    private void setDefaults() {
        try {
            ReflectionUtil.copyFields(CodeInsightSettings.class.getDeclaredFields(), new CodeInsightSettings(), this, new DifferenceFilter<Object>(null, null){

                @Override
                public boolean test(@NotNull Field field) {
                    if (field == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return !field.getName().equals("EXCLUDED_PACKAGES");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/CodeInsightSettings$1", "test"));
                }
            });
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        this.EXCLUDED_PACKAGES = ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @Override
    @NotNull
    public Element getState() {
        Element element = new Element("state");
        this.writeExternal(element);
        Element element2 = element;
        if (element2 == null) {
            CodeInsightSettings.$$$reportNull$$$0(3);
        }
        return element2;
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            CodeInsightSettings.$$$reportNull$$$0(4);
        }
        try {
            XmlSerializer.serializeObjectInto(this, element);
        }
        catch (SerializationException e) {
            LOG.info(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return ReflectionUtil.comparePublicNonFinalFields(this, o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static <T, E extends Throwable> T runWithTemporarySettings(@NotNull ThrowableConvertor<? super CodeInsightSettings, ? extends T, E> consumer) throws E {
        if (consumer == null) {
            CodeInsightSettings.$$$reportNull$$$0(5);
        }
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        Element temp = settings.getState();
        try {
            T t = consumer.convert(settings);
            return t;
        }
        finally {
            settings.loadState(temp);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/CodeInsightSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackspaceMode";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/CodeInsightSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setBackspaceMode";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runWithTemporarySettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

