/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExternalAnnotationsManager {
    public static final String ANNOTATIONS_XML = "annotations.xml";

    public static ExternalAnnotationsManager getInstance(@NotNull Project project) {
        if (project == null) {
            ExternalAnnotationsManager.$$$reportNull$$$0(0);
        }
        return project.getService(ExternalAnnotationsManager.class);
    }

    public abstract boolean hasAnnotationRootsForFile(@NotNull VirtualFile var1);

    public abstract boolean isExternalAnnotation(@NotNull PsiAnnotation var1);

    @Nullable
    public abstract PsiAnnotation findExternalAnnotation(@NotNull PsiModifierListOwner var1, @NotNull String var2);

    @NotNull
    public abstract List<PsiAnnotation> findExternalAnnotations(@NotNull PsiModifierListOwner var1, @NotNull String var2);

    @NotNull
    public List<PsiAnnotation> findExternalAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotationFQNs) {
        PsiAnnotation[] annotations;
        if (listOwner == null) {
            ExternalAnnotationsManager.$$$reportNull$$$0(1);
        }
        if (annotationFQNs == null) {
            ExternalAnnotationsManager.$$$reportNull$$$0(2);
        }
        List<PsiAnnotation> list = (annotations = this.findExternalAnnotations(listOwner)) == null ? Collections.emptyList() : ContainerUtil.filter(annotations, annotation -> annotationFQNs.contains(annotation.getQualifiedName()));
        if (list == null) {
            ExternalAnnotationsManager.$$$reportNull$$$0(3);
        }
        return list;
    }

    public abstract boolean isExternalAnnotationWritable(@NotNull PsiModifierListOwner var1, @NotNull String var2);

    @NotNull
    public abstract @NotNull PsiAnnotation @NotNull [] findExternalAnnotations(@NotNull PsiModifierListOwner var1);

    @NotNull
    public @NotNull PsiAnnotation @NotNull [] findExternalTypeAnnotations(@NotNull PsiModifierListOwner parent, @NotNull String typePath) {
        if (parent == null) {
            ExternalAnnotationsManager.$$$reportNull$$$0(4);
        }
        if (typePath == null) {
            ExternalAnnotationsManager.$$$reportNull$$$0(5);
        }
        if (PsiAnnotation.EMPTY_ARRAY == null) {
            ExternalAnnotationsManager.$$$reportNull$$$0(6);
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    @Nullable
    public abstract List<PsiAnnotation> findDefaultConstructorExternalAnnotations(@NotNull PsiClass var1);

    @Nullable
    public abstract List<PsiAnnotation> findDefaultConstructorExternalAnnotations(@NotNull PsiClass var1, @NotNull String var2);

    public abstract void annotateExternally(@NotNull PsiModifierListOwner var1, @NotNull String var2, @NotNull PsiFile var3, PsiNameValuePair @Nullable [] var4) throws CanceledConfigurationException;

    public abstract boolean deannotate(@NotNull PsiModifierListOwner var1, @NotNull String var2);

    public void elementRenamedOrMoved(@NotNull PsiModifierListOwner element, @NotNull String oldExternalName) {
        if (element == null) {
            ExternalAnnotationsManager.$$$reportNull$$$0(7);
        }
        if (oldExternalName == null) {
            ExternalAnnotationsManager.$$$reportNull$$$0(8);
        }
    }

    public abstract boolean editExternalAnnotation(@NotNull PsiModifierListOwner var1, @NotNull String var2, PsiNameValuePair @Nullable [] var3);

    @NotNull
    public abstract AnnotationPlace chooseAnnotationsPlaceNoUi(@NotNull PsiElement var1);

    @NotNull
    public abstract AnnotationPlace chooseAnnotationsPlace(@NotNull PsiElement var1);

    @Nullable
    public abstract List<PsiFile> findExternalAnnotationsFiles(@NotNull PsiModifierListOwner var1);

    public abstract boolean hasConfiguredAnnotationRoot(@NotNull PsiModifierListOwner var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQNs";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/ExternalAnnotationsManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldExternalName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/ExternalAnnotationsManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findExternalAnnotations";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findExternalTypeAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findExternalAnnotations";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findExternalTypeAnnotations";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "elementRenamedOrMoved";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CanceledConfigurationException
    extends RuntimeException {
    }

    public static enum AnnotationPlace {
        IN_CODE,
        EXTERNAL,
        NEED_ASK_USER,
        NOWHERE;

    }
}

