/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.completion.impl.LiftShorterItemsClassifier;
import com.intellij.codeInsight.completion.impl.PreferStartMatching;
import com.intellij.codeInsight.completion.impl.RealPrefixMatchingWeigher;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.ClassifierFactory;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.Weigher;
import com.intellij.psi.WeighingService;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseCompletionService
extends CompletionService {
    private static final Logger LOG = Logger.getInstance(BaseCompletionService.class);
    @Nullable
    protected CompletionProcess apiCompletionProcess;
    @ApiStatus.Internal
    public static final Key<CompletionContributor> LOOKUP_ELEMENT_CONTRIBUTOR = Key.create("lookup element contributor");
    public static final Key<Long> LOOKUP_ELEMENT_RESULT_ADD_TIMESTAMP_MILLIS = Key.create("lookup element add time");
    public static final Key<Integer> LOOKUP_ELEMENT_RESULT_SET_ORDER = Key.create("lookup element result set order");
    public static final Key<Boolean> FORBID_WORD_COMPLETION = new Key("ForbidWordCompletion");

    @Override
    public void performCompletion(@NotNull CompletionParameters parameters, @NotNull Consumer<? super CompletionResult> consumer) {
        if (parameters == null) {
            BaseCompletionService.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            BaseCompletionService.$$$reportNull$$$0(1);
        }
        this.apiCompletionProcess = parameters.getProcess();
        try {
            super.performCompletion(parameters, consumer);
        }
        finally {
            this.apiCompletionProcess = null;
        }
    }

    @Override
    public void setAdvertisementText(@NlsContexts.PopupAdvertisement @Nullable String text) {
        if (text == null) {
            return;
        }
        CompletionProcess completionProcess = this.apiCompletionProcess;
        if (completionProcess instanceof CompletionProcessEx) {
            CompletionProcessEx processEx = (CompletionProcessEx)completionProcess;
            processEx.addAdvertisement(text, null);
        }
    }

    @Override
    protected String suggestPrefix(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            BaseCompletionService.$$$reportNull$$$0(2);
        }
        PsiElement position = parameters.getPosition();
        int offset = parameters.getOffset();
        TextRange range = position.getTextRange();
        assert (range.containsOffset(offset)) : String.valueOf(position) + "; " + offset + " not in " + String.valueOf(range);
        return CompletionData.findPrefixStatic(position, offset);
    }

    @Override
    @NotNull
    protected PrefixMatcher createMatcher(String prefix, boolean typoTolerant) {
        return BaseCompletionService.createMatcher(prefix, true, typoTolerant);
    }

    @NotNull
    private static CamelHumpMatcher createMatcher(String prefix, boolean caseSensitive, boolean typoTolerant) {
        return new CamelHumpMatcher(prefix, caseSensitive, typoTolerant);
    }

    @Override
    @ApiStatus.Internal
    public CompletionResultSet createResultSet(CompletionParameters parameters, Consumer<? super CompletionResult> consumer, @NotNull CompletionContributor contributor, PrefixMatcher matcher) {
        if (contributor == null) {
            BaseCompletionService.$$$reportNull$$$0(3);
        }
        return new BaseCompletionResultSet(consumer, matcher, contributor, parameters, null, null);
    }

    @Override
    @Nullable
    public CompletionProcess getCurrentCompletion() {
        return this.apiCompletionProcess;
    }

    @NotNull
    protected CompletionSorterImpl addWeighersBefore(@NotNull CompletionSorterImpl sorter) {
        if (sorter == null) {
            BaseCompletionService.$$$reportNull$$$0(4);
        }
        CompletionSorterImpl completionSorterImpl = sorter;
        if (completionSorterImpl == null) {
            BaseCompletionService.$$$reportNull$$$0(5);
        }
        return completionSorterImpl;
    }

    @NotNull
    protected CompletionSorterImpl processStatsWeigher(@NotNull CompletionSorterImpl sorter, @NotNull Weigher weigher, @NotNull CompletionLocation location) {
        if (sorter == null) {
            BaseCompletionService.$$$reportNull$$$0(6);
        }
        if (weigher == null) {
            BaseCompletionService.$$$reportNull$$$0(7);
        }
        if (location == null) {
            BaseCompletionService.$$$reportNull$$$0(8);
        }
        CompletionSorterImpl completionSorterImpl = sorter;
        if (completionSorterImpl == null) {
            BaseCompletionService.$$$reportNull$$$0(9);
        }
        return completionSorterImpl;
    }

    @Override
    public CompletionSorter defaultSorter(CompletionParameters parameters, PrefixMatcher matcher) {
        final CompletionLocation location = new CompletionLocation(parameters);
        CompletionSorterImpl sorter = this.emptySorter();
        sorter = this.addWeighersBefore(sorter);
        sorter = sorter.withClassifier(CompletionSorterImpl.weighingFactory(new PreferStartMatching()));
        for (final Weigher weigher : WeighingService.getWeighers(RELEVANCE_KEY)) {
            String id = weigher.toString();
            if ("prefix".equals(id)) {
                sorter = sorter.withClassifier(CompletionSorterImpl.weighingFactory(new RealPrefixMatchingWeigher()));
                continue;
            }
            if ("stats".equals(id)) {
                sorter = this.processStatsWeigher(sorter, weigher, location);
                continue;
            }
            sorter = sorter.weigh(new LookupElementWeigher(id, true, false){

                @Override
                @Nullable
                public Comparable weigh(@NotNull LookupElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return weigher.weigh(element, location);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/BaseCompletionService$1", "weigh"));
                }
            });
        }
        return sorter.withClassifier("priority", true, new ClassifierFactory<LookupElement>("liftShorter"){

            @Override
            public Classifier<LookupElement> createClassifier(Classifier<LookupElement> next) {
                return new LiftShorterItemsClassifier("liftShorter", next, new LiftShorterItemsClassifier.LiftingCondition(), false);
            }
        });
    }

    @Override
    public CompletionSorterImpl emptySorter() {
        return new CompletionSorterImpl(new ArrayList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sorter";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/BaseCompletionService";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "weigher";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/BaseCompletionService";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "addWeighersBefore";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "processStatsWeigher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "performCompletion";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "suggestPrefix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createResultSet";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addWeighersBefore";
                break;
            }
            case 5: 
            case 9: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processStatsWeigher";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 9 -> new IllegalStateException(string);
        };
    }

    protected static class BaseCompletionResultSet
    extends CompletionResultSet {
        protected final CompletionParameters parameters;
        protected CompletionSorter sorter;
        @Nullable
        protected final BaseCompletionResultSet myOriginal;
        private int itemCounter = 0;

        protected BaseCompletionResultSet(java.util.function.Consumer<? super CompletionResult> consumer, PrefixMatcher prefixMatcher, CompletionContributor contributor, CompletionParameters parameters, @Nullable CompletionSorter sorter, @Nullable BaseCompletionResultSet original) {
            super(prefixMatcher, consumer, contributor);
            this.parameters = parameters;
            this.sorter = sorter;
            this.myOriginal = original;
        }

        @Override
        public void addElement(@NotNull LookupElement element) {
            if (element == null) {
                BaseCompletionResultSet.$$$reportNull$$$0(0);
            }
            ProgressManager.checkCanceled();
            if (!element.isValid()) {
                LOG.error("Invalid lookup element: " + String.valueOf(element) + " of " + String.valueOf(element.getClass()) + " in " + String.valueOf(this.parameters.getOriginalFile()) + " of " + String.valueOf(this.parameters.getOriginalFile().getClass()));
                return;
            }
            this.sorter = this.sorter == null ? CompletionService.getCompletionService().defaultSorter(this.parameters, this.getPrefixMatcher()) : this.sorter;
            CompletionResult matched = CompletionResult.wrap(element, this.getPrefixMatcher(), this.sorter);
            if (matched != null) {
                this.passResult(matched);
            }
        }

        @Override
        public void passResult(@NotNull CompletionResult result) {
            LookupElement element;
            if (result == null) {
                BaseCompletionResultSet.$$$reportNull$$$0(1);
            }
            if ((element = result.getLookupElement()) != null) {
                element.putUserDataIfAbsent(LOOKUP_ELEMENT_CONTRIBUTOR, this.contributor);
                element.putUserData(LOOKUP_ELEMENT_RESULT_ADD_TIMESTAMP_MILLIS, System.currentTimeMillis());
                element.putUserData(LOOKUP_ELEMENT_RESULT_SET_ORDER, this.itemCounter);
                ++this.itemCounter;
            }
            super.passResult(result);
        }

        @Override
        @NotNull
        public CompletionResultSet withPrefixMatcher(@NotNull PrefixMatcher matcher) {
            if (matcher == null) {
                BaseCompletionResultSet.$$$reportNull$$$0(2);
            }
            if (matcher.equals(this.getPrefixMatcher())) {
                BaseCompletionResultSet baseCompletionResultSet = this;
                if (baseCompletionResultSet == null) {
                    BaseCompletionResultSet.$$$reportNull$$$0(3);
                }
                return baseCompletionResultSet;
            }
            return new BaseCompletionResultSet(this.getConsumer(), matcher, this.contributor, this.parameters, this.sorter, this);
        }

        @Override
        @NotNull
        public CompletionResultSet withPrefixMatcher(@NotNull String prefix) {
            if (prefix == null) {
                BaseCompletionResultSet.$$$reportNull$$$0(4);
            }
            CompletionResultSet completionResultSet = this.withPrefixMatcher(this.getPrefixMatcher().cloneWithPrefix(prefix));
            if (completionResultSet == null) {
                BaseCompletionResultSet.$$$reportNull$$$0(5);
            }
            return completionResultSet;
        }

        @Override
        public void stopHere() {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Completion stopped\n" + DebugUtil.currentStackTrace());
            }
            super.stopHere();
            if (this.myOriginal != null) {
                this.myOriginal.stopHere();
            }
        }

        @Override
        @NotNull
        public CompletionResultSet withRelevanceSorter(@NotNull CompletionSorter sorter) {
            if (sorter == null) {
                BaseCompletionResultSet.$$$reportNull$$$0(6);
            }
            return new BaseCompletionResultSet(this.getConsumer(), this.getPrefixMatcher(), this.contributor, this.parameters, sorter, this);
        }

        @Override
        public void addLookupAdvertisement(@NlsContexts.PopupAdvertisement @NotNull String text) {
            if (text == null) {
                BaseCompletionResultSet.$$$reportNull$$$0(7);
            }
            CompletionService.getCompletionService().setAdvertisementText(text);
        }

        @Override
        @NotNull
        public CompletionResultSet caseInsensitive() {
            CamelHumpMatcher camelHumpMatcher;
            PrefixMatcher matcher = this.getPrefixMatcher();
            boolean typoTolerant = matcher instanceof CamelHumpMatcher && (camelHumpMatcher = (CamelHumpMatcher)matcher).isTypoTolerant();
            CompletionResultSet completionResultSet = this.withPrefixMatcher(BaseCompletionService.createMatcher(matcher.getPrefix(), false, typoTolerant));
            if (completionResultSet == null) {
                BaseCompletionResultSet.$$$reportNull$$$0(8);
            }
            return completionResultSet;
        }

        @Override
        public void restartCompletionOnPrefixChange(ElementPattern<String> prefixCondition) {
        }

        @Override
        public void restartCompletionWhenNothingMatches() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 5, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/BaseCompletionService$BaseCompletionResultSet";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sorter";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/BaseCompletionService$BaseCompletionResultSet";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withPrefixMatcher";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "caseInsensitive";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "passResult";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "withPrefixMatcher";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "withRelevanceSorter";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addLookupAdvertisement";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 5, 8 -> new IllegalStateException(string);
            };
        }
    }
}

