/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.BatchConsumer;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionStatistician;
import com.intellij.codeInsight.completion.CompletionWeigher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.Consumer;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompletionService {
    public static final Key<CompletionStatistician> STATISTICS_KEY = Key.create("completion");
    public static final Key<CompletionWeigher> RELEVANCE_KEY = Key.create("completion");

    public static CompletionService getCompletionService() {
        return ApplicationManager.getApplication().getService(CompletionService.class);
    }

    @Deprecated(forRemoval=true)
    public abstract void setAdvertisementText(@NlsContexts.PopupAdvertisement @Nullable String var1);

    public void getVariantsFromContributors(CompletionParameters parameters, @Nullable CompletionContributor from, Consumer<? super CompletionResult> consumer) {
        this.getVariantsFromContributors(parameters, from, this.createMatcher(this.suggestPrefix(parameters), false), consumer);
    }

    protected void getVariantsFromContributors(CompletionParameters parameters, @Nullable CompletionContributor from, PrefixMatcher matcher, Consumer<? super CompletionResult> consumer) {
        this.getVariantsFromContributors(parameters, from, matcher, consumer, null);
    }

    protected void getVariantsFromContributors(CompletionParameters parameters, @Nullable CompletionContributor from, PrefixMatcher matcher, Consumer<? super CompletionResult> consumer, CompletionSorter customSorter) {
        List<CompletionContributor> contributors = CompletionContributor.forParameters(parameters);
        for (int i = contributors.indexOf(from) + 1; i < contributors.size(); ++i) {
            ProgressManager.checkCanceled();
            CompletionContributor contributor = contributors.get(i);
            CompletionResultSet result = this.createResultSet(parameters, consumer, contributor, matcher);
            if (customSorter != null) {
                result = result.withRelevanceSorter(customSorter);
            }
            try {
                this.getVariantsFromContributor(parameters, contributor, result);
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            if (!result.isStopped()) continue;
            return;
        }
    }

    @ApiStatus.Internal
    public void getVariantsFromContributor(CompletionParameters params, CompletionContributor contributor, CompletionResultSet result) {
        contributor.fillCompletionVariants(params, result);
    }

    @ApiStatus.Internal
    public abstract CompletionResultSet createResultSet(CompletionParameters var1, Consumer<? super CompletionResult> var2, @NotNull CompletionContributor var3, PrefixMatcher var4);

    protected abstract String suggestPrefix(CompletionParameters var1);

    @NotNull
    protected abstract PrefixMatcher createMatcher(String var1, boolean var2);

    @Nullable
    public abstract CompletionProcess getCurrentCompletion();

    public void performCompletion(@NotNull CompletionParameters parameters, final @NotNull Consumer<? super CompletionResult> consumer) {
        if (parameters == null) {
            CompletionService.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            CompletionService.$$$reportNull$$$0(1);
        }
        final ConcurrentHashMap.KeySetView lookupSet = ConcurrentHashMap.newKeySet();
        final AtomicBoolean typoTolerant = new AtomicBoolean();
        BatchConsumer<CompletionResult> batchConsumer = new BatchConsumer<CompletionResult>(){

            @Override
            public void startBatch() {
                if (consumer instanceof BatchConsumer) {
                    BatchConsumer c = (BatchConsumer)consumer;
                    c.startBatch();
                }
            }

            @Override
            public void endBatch() {
                if (consumer instanceof BatchConsumer) {
                    BatchConsumer c = (BatchConsumer)consumer;
                    c.endBatch();
                }
            }

            @Override
            public void consume(CompletionResult result) {
                if (typoTolerant.get() && result.getLookupElement().getAutoCompletionPolicy() != AutoCompletionPolicy.NEVER_AUTOCOMPLETE) {
                    result = result.withLookupElement(AutoCompletionPolicy.NEVER_AUTOCOMPLETE.applyPolicy(result.getLookupElement()));
                }
                if (lookupSet.add(result.getLookupElement())) {
                    consumer.consume(result);
                }
            }
        };
        String prefix = this.suggestPrefix(parameters);
        this.getVariantsFromContributors(parameters, null, this.createMatcher(prefix, false), (Consumer<? super CompletionResult>)batchConsumer);
        if (lookupSet.isEmpty() && prefix.length() > 2) {
            typoTolerant.set(true);
            this.getVariantsFromContributors(parameters, null, this.createMatcher(prefix, true), (Consumer<? super CompletionResult>)batchConsumer);
        }
    }

    public abstract CompletionSorter defaultSorter(CompletionParameters var1, PrefixMatcher var2);

    public abstract CompletionSorter emptySorter();

    @ApiStatus.Internal
    public static boolean isStartMatch(LookupElement element, WeighingContext context) {
        return CompletionService.getItemMatcher(element, context).isStartMatch(element);
    }

    @ApiStatus.Internal
    public static PrefixMatcher getItemMatcher(LookupElement element, WeighingContext context) {
        PrefixMatcher itemMatcher = context.itemMatcher(element);
        String pattern = context.itemPattern(element);
        if (!pattern.equals(itemMatcher.getPrefix())) {
            return itemMatcher.cloneWithPrefix(pattern);
        }
        return itemMatcher;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/completion/CompletionService";
        objectArray[2] = "performCompletion";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

