/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class OffsetTranslator
implements Disposable {
    static final Key<OffsetTranslator> RANGE_TRANSLATION = Key.create("completion.rangeTranslation");
    private final PsiFile myOriginalFile;
    private final Document myCopyDocument;
    private final List<DocumentEvent> myTranslation;

    public OffsetTranslator(final @NotNull Document originalDocument, final @NotNull PsiFile originalFile, @NotNull Document copyDocument, int start, int end, @NotNull String replacement) {
        if (originalDocument == null) {
            OffsetTranslator.$$$reportNull$$$0(0);
        }
        if (originalFile == null) {
            OffsetTranslator.$$$reportNull$$$0(1);
        }
        if (copyDocument == null) {
            OffsetTranslator.$$$reportNull$$$0(2);
        }
        if (replacement == null) {
            OffsetTranslator.$$$reportNull$$$0(3);
        }
        this.myTranslation = new ArrayList<DocumentEvent>();
        this.myOriginalFile = originalFile;
        this.myCopyDocument = copyDocument;
        this.myCopyDocument.putUserData(RANGE_TRANSLATION, this);
        this.myTranslation.add(new DocumentEventImpl(copyDocument, start, originalDocument.getImmutableCharSequence().subSequence(start, end), replacement, 0L, false, start, end - start, start));
        Disposer.register(originalFile.getProject(), this);
        final ArrayList sinceCommit = new ArrayList();
        originalDocument.addDocumentListener(new DocumentListener(){

            @Override
            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (OffsetTranslator.this.isUpToDate()) {
                    DocumentEventImpl inverse = new DocumentEventImpl(originalDocument, e.getOffset(), e.getNewFragment(), e.getOldFragment(), 0L, false, e.getOffset(), e.getNewFragment().length(), e.getOffset());
                    sinceCommit.add(inverse);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/completion/OffsetTranslator$1", "documentChanged"));
            }
        }, this);
        originalFile.getProject().getMessageBus().connect(this).subscribe(PsiModificationTracker.TOPIC, new PsiModificationTracker.Listener(){
            final long lastModCount;
            {
                this.lastModCount = originalFile.getViewProvider().getModificationStamp();
            }

            @Override
            public void modificationCountChanged() {
                if (OffsetTranslator.this.isUpToDate() && this.lastModCount != originalFile.getViewProvider().getModificationStamp()) {
                    OffsetTranslator.this.myTranslation.addAll(sinceCommit);
                    sinceCommit.clear();
                }
            }
        });
    }

    private boolean isUpToDate() {
        return this == this.myCopyDocument.getUserData(RANGE_TRANSLATION) && this.myOriginalFile.isValid();
    }

    @Override
    public void dispose() {
        if (this.isUpToDate()) {
            this.myCopyDocument.putUserData(RANGE_TRANSLATION, null);
        }
    }

    @Nullable
    Integer translateOffset(Integer offset) {
        for (DocumentEvent event : this.myTranslation) {
            if ((offset = OffsetTranslator.translateOffset(offset, event)) != null) continue;
            return null;
        }
        return offset;
    }

    @Nullable
    private static Integer translateOffset(int offset, DocumentEvent event) {
        if (event.getOffset() < offset && offset < event.getOffset() + event.getNewLength()) {
            if (event.getOldLength() == 0) {
                return event.getOffset();
            }
            return null;
        }
        return offset <= event.getOffset() ? offset : offset - event.getNewLength() + event.getOldLength();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "originalDocument";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "originalFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "copyDocument";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "replacement";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/completion/OffsetTranslator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

