/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoB;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInsight.multiverse.CodeInsightContextHighlightingUtil;
import com.intellij.codeInsight.multiverse.CodeInsightContexts;
import com.intellij.codeInsight.multiverse.EditorContextManager;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DaemonCodeAnalyzerEx
extends DaemonCodeAnalyzer {
    private static final Logger LOG = Logger.getInstance(DaemonCodeAnalyzerEx.class);
    @ApiStatus.Internal
    protected static final int ANY_GROUP = -409423948;
    @ApiStatus.Internal
    protected static final int FILE_LEVEL_FAKE_LAYER = -4094;

    public static DaemonCodeAnalyzerEx getInstanceEx(Project project) {
        return (DaemonCodeAnalyzerEx)DaemonCodeAnalyzerEx.getInstance(project);
    }

    @ApiStatus.Internal
    public abstract void restart(@NotNull Object var1);

    public static boolean processHighlights(@NotNull Document document, @NotNull Project project, @Nullable(value="null means all") @Nullable(value="null means all") HighlightSeverity minSeverity, int startOffset, int endOffset, @NotNull Processor<? super HighlightInfo> processor) {
        if (document == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(2);
        }
        return DaemonCodeAnalyzerEx.processHighlights(document, project, minSeverity, startOffset, endOffset, CodeInsightContexts.anyContext(), processor);
    }

    @ApiStatus.Internal
    public static boolean processHighlights(@NotNull Document document, @NotNull Project project, @Nullable(value="null means all") @Nullable(value="null means all") HighlightSeverity minSeverity, int startOffset, int endOffset, @NotNull CodeInsightContext context, @NotNull Processor<? super HighlightInfo> processor) {
        if (document == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(3);
        }
        if (project == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(4);
        }
        if (context == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(6);
        }
        MarkupModelEx model = (MarkupModelEx)DocumentMarkupModel.forDocument((Document)document, (Project)project, (boolean)true);
        return DaemonCodeAnalyzerEx.processHighlights(model, project, minSeverity, startOffset, endOffset, context, processor);
    }

    @ApiStatus.Internal
    public static boolean processHighlights(@NotNull MarkupModelEx model, @NotNull Project project, @Nullable(value="null means all") @Nullable(value="null means all") HighlightSeverity minSeverity, int startOffset, int endOffset, @NotNull CodeInsightContext context, @NotNull Processor<? super HighlightInfo> processor) {
        if (model == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(7);
        }
        if (project == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(8);
        }
        if (context == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(10);
        }
        LOG.assertTrue(ApplicationManager.getApplication().isReadAccessAllowed());
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project);
        return model.processRangeHighlightersOverlappingWith(startOffset, endOffset, marker -> {
            ProgressManager.checkCanceled();
            HighlightInfo info = HighlightInfo.fromRangeHighlighter((RangeHighlighter)marker);
            if (info == null) {
                return true;
            }
            return minSeverity != null && severityRegistrar.compare(info.getSeverity(), minSeverity) < 0 || info.getHighlighter() == null || !CodeInsightContextHighlightingUtil.acceptRangeHighlighter(context, (RangeHighlighter)marker) || processor.process(info);
        });
    }

    public static boolean processHighlights(@NotNull MarkupModelEx model, @NotNull Project project, @Nullable(value="null means all") @Nullable(value="null means all") HighlightSeverity minSeverity, int startOffset, int endOffset, @NotNull Processor<? super HighlightInfo> processor) {
        if (model == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(11);
        }
        if (project == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(13);
        }
        return DaemonCodeAnalyzerEx.processHighlights(model, project, minSeverity, startOffset, endOffset, CodeInsightContexts.anyContext(), processor);
    }

    static boolean processHighlightsOverlappingOutside(MarkupModelEx model, int startOffset, int endOffset, @NotNull CodeInsightContext context, @NotNull Processor<? super HighlightInfo> processor) {
        if (context == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(15);
        }
        LOG.assertTrue(ApplicationManager.getApplication().isReadAccessAllowed());
        return model.processRangeHighlightersOutside(startOffset, endOffset, marker -> {
            HighlightInfo info = HighlightInfo.fromRangeHighlighter((RangeHighlighter)marker);
            return info == null || info.getHighlighter() == null || !CodeInsightContextHighlightingUtil.acceptRangeHighlighter(context, (RangeHighlighter)marker) || processor.process(info);
        });
    }

    public abstract boolean hasVisibleLightBulbOrPopup();

    @ApiStatus.Internal
    @NotNull
    public abstract List<HighlightInfo> runMainPasses(@NotNull PsiFile var1, @NotNull Document var2, @NotNull ProgressIndicator var3);

    public abstract boolean isErrorAnalyzingFinished(@NotNull PsiFile var1);

    @NotNull
    public abstract FileStatusMap getFileStatusMap();

    @ApiStatus.Internal
    public abstract void cleanFileLevelHighlights(int var1, @NotNull PsiFile var2);

    @ApiStatus.Internal
    public abstract boolean hasFileLevelHighlights(int var1, @NotNull PsiFile var2);

    @ApiStatus.Internal
    public abstract void addFileLevelHighlight(int var1, @NotNull HighlightInfo var2, @NotNull PsiFile var3, @Nullable RangeHighlighter var4);

    @ApiStatus.Internal
    public abstract void replaceFileLevelHighlight(@NotNull HighlightInfo var1, @NotNull HighlightInfo var2, @NotNull PsiFile var3, @Nullable RangeHighlighter var4);

    @ApiStatus.Internal
    public abstract void removeFileLevelHighlight(@NotNull PsiFile var1, @NotNull HighlightInfo var2);

    public void markDocumentDirty(@NotNull Document document, @NotNull Object reason) {
        if (document == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(16);
        }
        if (reason == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(17);
        }
        this.getFileStatusMap().markWholeFileScopeDirty(document, reason);
    }

    public static boolean isHighlightingCompleted(@NotNull FileEditor fileEditor, @NotNull Project project) {
        if (fileEditor == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(18);
        }
        if (project == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(19);
        }
        if (!(fileEditor instanceof TextEditor)) {
            return false;
        }
        TextEditor textEditor = (TextEditor)fileEditor;
        Document document = textEditor.getEditor().getDocument();
        CodeInsightContext context = EditorContextManager.getEditorContext((Editor)textEditor.getEditor(), (Project)project);
        return DaemonCodeAnalyzerEx.getInstanceEx(project).getFileStatusMap().allDirtyScopesAreNull(document, context);
    }

    @ApiStatus.Internal
    public abstract boolean cutOperationJustHappened();

    @ApiStatus.Internal
    public abstract boolean isEscapeJustPressed();

    protected abstract void progressIsAdvanced(@NotNull HighlightingSession var1, Editor var2, double var3);

    @ApiStatus.Internal
    @RequiresBackgroundThread
    public void rescheduleShowIntentionsPass(@NotNull PsiFile psiFile, @NotNull HighlightInfo.Builder builder) {
        if (psiFile == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(20);
        }
        if (builder == null) {
            DaemonCodeAnalyzerEx.$$$reportNull$$$0(21);
        }
        ThreadingAssertions.assertBackgroundThread();
        this.rescheduleShowIntentionsPass(psiFile, ((HighlightInfoB)builder).getRangeSoFar());
    }

    @ApiStatus.Internal
    @RequiresBackgroundThread
    protected abstract void rescheduleShowIntentionsPass(@NotNull PsiFile var1, @NotNull TextRange var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerEx";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processHighlights";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "processHighlightsOverlappingOutside";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "markDocumentDirty";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "isHighlightingCompleted";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "rescheduleShowIntentionsPass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

