/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.diagnostic.telemetry.Scope;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableRunnable;
import io.opentelemetry.api.trace.Span;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DaemonProgressIndicator
extends AbstractProgressIndicatorBase
implements StandardProgressIndicator {
    private static final Logger LOG = Logger.getInstance(DaemonProgressIndicator.class);
    @ApiStatus.Internal
    public static final String CANCEL_WAS_CALLED_REASON = "cancel() was called";
    private static final AtomicInteger debug = new AtomicInteger();
    private final TraceableDisposable myTraceableDisposable = new TraceableDisposable(debug.get() > 0);
    private volatile Throwable myCancellationCause;
    private volatile Span mySpan;
    private final IJTracer myTraceManager = TelemetryManager.Companion.getInstance().getTracer(new Scope("daemon", null));

    @Override
    public final void stop() {
        if (this.mySpan != null) {
            this.mySpan.end();
        }
        if (this.tryStop()) {
            this.onStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryStop() {
        boolean wasRunning;
        Object object = this.getLock();
        synchronized (object) {
            wasRunning = this.isRunning();
            if (wasRunning) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("stop(" + String.valueOf(this) + ")");
                }
                super.stop();
            }
            this.tryCancel(null);
        }
        return wasRunning;
    }

    private boolean tryCancel(@Nullable Throwable cause) {
        if (!this.isCanceled()) {
            if (cause == null) {
                this.myTraceableDisposable.kill("Daemon Progress Canceled");
            } else {
                this.myTraceableDisposable.killExceptionally(cause);
            }
            this.myCancellationCause = cause;
            super.cancel();
            return true;
        }
        return false;
    }

    protected void onCancelled(@NotNull String reason) {
        if (reason == null) {
            DaemonProgressIndicator.$$$reportNull$$$0(0);
        }
    }

    protected void onStop() {
    }

    @Override
    public final void cancel() {
        Throwable cause = LOG.isDebugEnabled() ? new Throwable(CANCEL_WAS_CALLED_REASON) : null;
        this.doCancel(cause, CANCEL_WAS_CALLED_REASON);
    }

    public final void cancel(@NotNull String reason) {
        if (reason == null) {
            DaemonProgressIndicator.$$$reportNull$$$0(1);
        }
        this.doCancel(null, reason);
    }

    public final void cancel(@NotNull Throwable cause, @NotNull String reason) {
        if (cause == null) {
            DaemonProgressIndicator.$$$reportNull$$$0(2);
        }
        if (reason == null) {
            DaemonProgressIndicator.$$$reportNull$$$0(3);
        }
        this.doCancel(cause, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCancel(@Nullable Throwable cause, @NotNull String reason) {
        boolean wasCanceled;
        if (reason == null) {
            DaemonProgressIndicator.$$$reportNull$$$0(4);
        }
        Object object = this.getLock();
        synchronized (object) {
            wasCanceled = this.tryCancel(cause);
        }
        if (wasCanceled) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("doCancel(" + String.valueOf(this) + (String)(reason.isEmpty() ? "" : ", reason: '" + reason + "'") + (String)(cause == null ? "" : ", cause: " + ExceptionUtil.getThrowableText(cause)) + ")");
            }
            ProgressManager.getInstance().executeNonCancelableSection(() -> this.onCancelled(reason));
        }
    }

    @Override
    public final boolean isCanceled() {
        return super.isCanceled();
    }

    @Override
    public final void checkCanceled() {
        super.checkCanceled();
    }

    @Override
    @ApiStatus.Internal
    @Nullable
    public Throwable getCancellationTrace() {
        Throwable cause = this.myCancellationCause;
        return cause != null ? cause : super.getCancellationTrace();
    }

    @Override
    public final void start() {
        this.checkCanceled();
        assert (!this.isRunning()) : "running";
        this.mySpan = this.myTraceManager.spanBuilder("run daemon").startSpan();
        super.start();
    }

    @TestOnly
    @ApiStatus.Internal
    public static void setDebug(boolean debug) {
        DaemonProgressIndicator.debug.set(debug ? 1 : 0);
    }

    @TestOnly
    @ApiStatus.Internal
    public static <E extends Throwable> void runInDebugMode(@NotNull ThrowableRunnable<E> runnable) throws E {
        if (runnable == null) {
            DaemonProgressIndicator.$$$reportNull$$$0(5);
        }
        try {
            debug.incrementAndGet();
            runnable.run();
        }
        finally {
            debug.decrementAndGet();
        }
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return System.identityHashCode(this) + (this.isCanceled() ? (this.isRunning() ? "X" : "S") : "V");
    }

    @Override
    public boolean isIndeterminate() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonProgressIndicator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onCancelled";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "cancel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doCancel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "runInDebugMode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

