/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.codeInsight.daemon.impl.WholeFileDirtyMarker;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.text.StringUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FileStatus {
    static final TextRange WHOLE_FILE_TEXT_RANGE = new UnfairTextRange(-1, -1);
    private boolean defensivelyMarked;
    private boolean wolfPassFinished;
    private final Int2ObjectMap<RangeMarker> dirtyScopes;
    private boolean errorFound;

    FileStatus(@NotNull Project project) {
        if (project == null) {
            FileStatus.$$$reportNull$$$0(0);
        }
        this.dirtyScopes = new Int2ObjectOpenHashMap<RangeMarker>();
        this.markWholeFileDirty(project);
    }

    void markWholeFileDirty(@NotNull Project project) {
        if (project == null) {
            FileStatus.$$$reportNull$$$0(1);
        }
        this.setDirtyScope(4, WholeFileDirtyMarker.INSTANCE);
        this.setDirtyScope(8, WholeFileDirtyMarker.INSTANCE);
        this.setDirtyScope(7, WholeFileDirtyMarker.INSTANCE);
        this.setDirtyScope(11, WholeFileDirtyMarker.INSTANCE);
        this.setDirtyScope(13, WholeFileDirtyMarker.INSTANCE);
        this.setDirtyScope(14, WholeFileDirtyMarker.INSTANCE);
        TextEditorHighlightingPassRegistrarEx registrar = (TextEditorHighlightingPassRegistrarEx)TextEditorHighlightingPassRegistrar.getInstance(project);
        for (DirtyScopeTrackingHighlightingPassFactory factory : registrar.getDirtyScopeTrackingFactories()) {
            this.setDirtyScope(factory.getPassId(), WholeFileDirtyMarker.INSTANCE);
        }
    }

    boolean isErrorFound() {
        return this.errorFound;
    }

    void setErrorFound(boolean errorFound) {
        this.errorFound = errorFound;
    }

    boolean isDefensivelyMarked() {
        return this.defensivelyMarked;
    }

    void setDefensivelyMarked(boolean defensivelyMarked) {
        this.defensivelyMarked = defensivelyMarked;
    }

    boolean allDirtyScopesAreNull() {
        for (RangeMarker o : this.getAllDirtyScopes()) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    void combineScopesWith(@NotNull TextRange scope, @NotNull Document document) {
        if (scope == null) {
            FileStatus.$$$reportNull$$$0(2);
        }
        if (document == null) {
            FileStatus.$$$reportNull$$$0(3);
        }
        this.dirtyScopes.replaceAll((__, oldScope) -> FileStatus.combineScopes(oldScope, scope, document));
    }

    @Nullable
    RangeMarker getDirtyScope(int passId) {
        return (RangeMarker)this.dirtyScopes.get(passId);
    }

    void setWolfPassFinished() {
        this.wolfPassFinished = true;
    }

    boolean isWolfPassFinished() {
        return this.wolfPassFinished;
    }

    Iterable<RangeMarker> getAllDirtyScopes() {
        return this.dirtyScopes.values();
    }

    boolean containsDirtyScope(int passId) {
        return this.dirtyScopes.containsKey(passId);
    }

    @NotNull
    static RangeMarker combineScopes(@Nullable RangeMarker old, @NotNull TextRange scope, @NotNull Document document) {
        TextRange result;
        if (scope == null) {
            FileStatus.$$$reportNull$$$0(4);
        }
        if (document == null) {
            FileStatus.$$$reportNull$$$0(5);
        }
        if (scope == WHOLE_FILE_TEXT_RANGE || old == WholeFileDirtyMarker.INSTANCE) {
            RangeMarker rangeMarker = WholeFileDirtyMarker.INSTANCE;
            if (rangeMarker == null) {
                FileStatus.$$$reportNull$$$0(6);
            }
            return rangeMarker;
        }
        TextRange oldRange = old == null ? null : old.getTextRange();
        TextRange textRange = result = oldRange == null ? scope : scope.union(oldRange);
        if (old != null && old.isValid() && result.equals(oldRange)) {
            RangeMarker rangeMarker = old;
            if (rangeMarker == null) {
                FileStatus.$$$reportNull$$$0(7);
            }
            return rangeMarker;
        }
        if (result.getEndOffset() > document.getTextLength()) {
            if (result.getStartOffset() == 0) {
                RangeMarker rangeMarker = WholeFileDirtyMarker.INSTANCE;
                if (rangeMarker == null) {
                    FileStatus.$$$reportNull$$$0(8);
                }
                return rangeMarker;
            }
            result = result.intersection(new TextRange(0, document.getTextLength()));
        }
        assert (result != null);
        if (old != null) {
            old.dispose();
        }
        RangeMarker rangeMarker = document.createRangeMarker(result);
        if (rangeMarker == null) {
            FileStatus.$$$reportNull$$$0(9);
        }
        return rangeMarker;
    }

    @NonNls
    public String toString() {
        return (String)(this.defensivelyMarked ? "defensivelyMarked = " + this.defensivelyMarked : "") + (String)(this.wolfPassFinished ? "" : "; wolfPassFinished = " + this.wolfPassFinished) + (String)(this.errorFound ? "; errorFound = " + this.errorFound : "") + (String)(this.dirtyScopes.isEmpty() ? "" : "; dirtyScopes: (" + StringUtil.join(this.dirtyScopes.int2ObjectEntrySet(), e -> " pass: " + e.getIntKey() + " -> " + String.valueOf(e.getValue() == WholeFileDirtyMarker.INSTANCE ? "Whole file" : e.getValue()), ";") + ")");
    }

    void setDirtyScope(int passId, @Nullable RangeMarker scope) {
        RangeMarker marker = (RangeMarker)this.dirtyScopes.get(passId);
        if (marker != scope) {
            if (marker != null) {
                marker.dispose();
            }
            this.dirtyScopes.put(passId, scope);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/FileStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/FileStatus";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "combineScopes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "markWholeFileDirty";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "combineScopesWith";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "combineScopes";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

